/*
 * flash_tests.hpp
 *
 *  Created on: 13 февр. 2019 г.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 * --------------------------------------------------------------------------
 * Здесь соберу тесты флеш-памяти
 * - flash_inspect - выяснияет основные параметры флеши flash_props_t
 *                   так же тестирует корректность записи больших блоков
 */

#ifndef HAL_FLASH_FLASH_TESTS_HPP_
#define HAL_FLASH_FLASH_TESTS_HPP_

#include <OsSync.h>
#include <flash_hal.hpp>



struct flash_props_t{
    typedef SPIFlash_WritableDevice    mem_t;
    mem_t*          mem;
    unsigned long   size;
    unsigned long   sec_size;
    unsigned long   page_size;
    unsigned long   write_size;
    unsigned        erase_all_ticks;
    unsigned        erase_sec_ticks;
    unsigned        burn_ticks;

    void clear(){
        size = sec_size = page_size = 0;
        write_size = 0;
        erase_all_ticks = erase_sec_ticks = 0;
        burn_ticks = 0;
    };
};

// дескриптор протонитки тестов.
//  нужен для управления - запуск/ресет тестов
extern  pt  flash_test_pt;

// тест отпределяет параметры флеши.
//  Тестирует качество записи блоков большого размера
// \arg descr.mem - флешка для исследования
// \return - ptNOK - исследование не получилось
PTResult    flash_inspect(flash_props_t& descr);



#endif /* HAL_FLASH_FLASH_TESTS_HPP_ */
