/*
 * Copyright (c) 2017, George Oikonomou - http://www.spd.gr
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*---------------------------------------------------------------------------*/
/**
 * \addtogroup arm
 * @{
 *
 * \file
 *  Compiler and data type definitions for all ARM-based CPUs
 */
/*---------------------------------------------------------------------------*/
#ifndef ARM_DEF_
#define ARM_DEF_
/*---------------------------------------------------------------------------*/
#include <stdint.h>
/*---------------------------------------------------------------------------*/
/**
 * \name Macros and typedefs
 *
 * Those values are not meant to be modified by the user
 * @{
 */

#ifndef CLOCK_CONF_SECOND
#define CLOCK_CONF_SECOND 128
#endif

/* Clock (time) comparison macro */
#define CLOCK_LT(a, b)  ((signed long)((a) - (b)) < 0)

/* Platform typedefs */
typedef uint32_t clock_time_t;
typedef uint32_t uip_stats_t;

/** @} */

/*
 * The stdio.h that ships with the arm-gcc toolchain does this:
 *
 * int  _EXFUN(putchar, (int));
 * [...]
 * #define  putchar(x)  putc(x, stdout)
 *
 * This causes us a lot of trouble: For platforms using this toolchain, every
 * time we use putchar we need to first #undef putchar. What we do here is to
 * #undef putchar across the board. The resulting code will cause the linker
 * to search for a symbol named putchar and this allows us to use the
 * implementation under os/lib/dbg-io.
 *
 * This will fail if stdio.h is included before contiki.h, but it is common
 * practice to include contiki.h first
 */
#include <stdio.h>
#undef putchar
/*---------------------------------------------------------------------------*/
#endif /* ARM_DEF_ */
/*---------------------------------------------------------------------------*/
/** @} */
