/*
 * mcu_usart.h
 *
 *  Created on: 3/06/2021 г.
 *      Author: alexraynepe196@gmail.com
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 */

#ifndef HAL_RENESAS_RA_MCU_SSP_H_
#define HAL_RENESAS_RA_MCU_SSP_H_

#include <mcu-chip.h>

#if !defined(RA_H)
#warning "uncknown HAL, expects renesas RA"
#endif

#include <c_compat.h>
#include "mcu_rcc.h"

#ifdef __cplusplus
extern "C" {
#endif



#define __SSP_CAT2(a, b) a##b
#define _SSP_CAT3(a,b,c)  a##b##c

#define SPIn(n)  __SSP_CAT2(R_SPI, n)



#define SPI_PORT_IDXSTEP   (R_SPI1_BASE - R_SPI0_BASE)
#define SPI_PORT_NO(port)  ( ( ((uint8_t*)(port)) - R_SPI0_BASE )/SPI_PORT_IDXSTEP)
#define SPI_PORTn(n)       ( (R_SPI0_Type *)( R_SPI0_BASE + ((n)*SPI_PORT_IDXSTEP) ) )



typedef R_SPI0_Type SPI_TypeDef;
typedef SPI_TypeDef SSP_TypeDef;


__STATIC_INLINE
void SPI_Enable(SPI_TypeDef* port){
    port->SPCR_b.SPE = 1;
}

__STATIC_INLINE
bool SPI_is_enabled(SPI_TypeDef* port){
    return port->SPCR_b.SPE != 0;
}

__STATIC_INLINE
void SPI_Disable(SPI_TypeDef* port){
    port->SPCR_b.SPE = 0;
}

#define SPI_ReceiveData8(port)  port->SPDR_BY
#define SPI_ReceiveData16(port) port->SPDR_HA

#define SPI_TransmitData8(port, data)  port->SPDR_BY = (data)
#define SPI_TransmitData16(port, data) port->SPDR_HA = (data)

#define SPI_Is_TXE(port)  (port->SPSR_b.SPTEF != 0)
#define SPI_Is_RXNE(...)  (port->SPSR_b.SPRF  != 0)
#define SPI_Is_BSY(...)   (port->SPSR_b.IDLNF != 0)


enum {
    SPI_LSB_FIRST  = R_SPI0_SPCMD_LSBF_Msk ,
    SPI_MSB_FIRST  = 0 ,
};

__STATIC_INLINE
void SPI_SetTransferBitOrder(SPI_TypeDef* port, unsigned mode){
    if (mode == SPI_MSB_FIRST)
        port->SPCMD_b[0].LSBF = 0;
    else
        port->SPCMD_b[0].LSBF = 1;
}

enum SPIBitWidthID{
    SPI_DATAWIDTH_8BIT       = 7,
    SPI_DATAWIDTH_9BIT       = 8 ,
    SPI_DATAWIDTH_10BIT      = 9 ,
    SPI_DATAWIDTH_11BIT      = 10 ,
    SPI_DATAWIDTH_12BIT      = 11 ,
    SPI_DATAWIDTH_13BIT      = 12 ,
    SPI_DATAWIDTH_14BIT      = 13 ,
    SPI_DATAWIDTH_15BIT      = 14 ,
    SPI_DATAWIDTH_16BIT      = 15 ,

    SPI_DATAWIDTH_20BIT      = 0 ,
    SPI_DATAWIDTH_24BIT      = 1 ,
    SPI_DATAWIDTH_32BIT      = 2 ,
    //SPI_DATAWIDTH_32BIT      = 3 ,
};
typedef enum SPIBitWidthID SPIBitWidthID;

__STATIC_INLINE
void SPI_SetDataWidth(SPI_TypeDef* port, SPIBitWidthID bw) {
    port->SPCMD_b[0].SPB = bw;
}

enum {
    SPI_CPHA        = R_SPI0_SPCMD_CPHA_Msk,
    SPI_PHASE_1EDGE = 0,
    SPI_PHASE_2EDGE = SPI_CPHA,

    SPI_POLARITY        = R_SPI0_SPCMD_CPOL_Msk,
    SPI_CPOL            = SPI_POLARITY,
    SPI_POLARITY_LOW    = 0,
    SPI_POLARITY_HIGH   = SPI_POLARITY,

    SPI_MODE_Msk        = SPI_CPHA | SPI_CPOL,
    SPI_DATAWIDTH_Msk   = R_SPI0_SPCMD_SPB_Msk ,
    SPI_DATAWIDTH_Pos   = R_SPI0_SPCMD_SPB_Pos ,
};

#define SPI_DATA_MODE0           (SPI_PHASE_1EDGE |SPI_POLARITY_LOW)
#define SPI_DATA_MODE1           (SPI_PHASE_2EDGE |SPI_POLARITY_LOW)
#define SPI_DATA_MODE2           (SPI_PHASE_1EDGE |SPI_POLARITY_HIGH)
#define SPI_DATA_MODE3           (SPI_PHASE_2EDGE |SPI_POLARITY_HIGH)



__STATIC_INLINE
void SPI_SetDataMode(SPI_TypeDef *SPIx, uint32_t mode){
    SPIx->SPCMD[0] = (SPIx->SPCMD[0] & ~SPI_MODE_Msk) | (mode /* & SPI_MODE_Msk*/) ;
}


#define RCC_EnableClock_SPI( port )     RCC_EnableClock_SPIn( SPI_PORT_NO(port) )
#define RCC_DisableClock_SPI( port )    RCC_DisableClock_SPIn( SPI_PORT_NO(port) )



#ifdef __cplusplus
}
#endif

#endif /* HAL_MDR32F9QX_MCU_USART_H_ */
