/*
 * rtimer-arch.h
 *
 *  Created on: 15/04/2021
 *      Author: alexraynepe196@gmail.com
 * -----------------------------------------------------------------------
 *  rtimer arch for RA2L wrapper
 */
#ifndef RTIMER_ARCH_H
#define RTIMER_ARCH_H



// clock based on SysTick, declare it's clock rate
#if 1
#include "bsp_api.h"
#include <system.h>
#else
extern uint32_t SystemCoreClock
#endif

//#define FSYSTICK_HZ                 SystemCoreClock
#define FSYSTICK_HZ                 BSP_STARTUP_ICLK_HZ
#define RTIMER_CONF_ARCH_SECOND     FSYSTICK_HZ

#include "arch/cpu/arm/common/dev/rtimer-arch-systick.h"



// 8MHz core clock divide to 32k well
#define AGT_DIV                     8
#define AGT_CLOCK                   8000000u
#define RTIMER_CONF_AGT_SECOND      (AGT_CLOCK/AGT_DIV)

#include "dev/rtimer-arch-agt.h"

#ifndef RTIMER_CONF_MINIMAL_SAFE_SCHEDULE
#define RTIMER_CONF_MINIMAL_SAFE_SCHEDULE RTIMER_MINIMAL_SAFE_AGT_SCHEDULE
//#define RTIMER_CONF_MINIMAL_SAFE_SCHEDULE RTIMER_MINIMAL_SAFE_SYSTICK_SCHEDULE
#endif



#endif //RTIMER_ARCH_H

