/*
 * memoryx.h
 *
 *  Created on: 13/08/2021.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
      memory operations, extends stdlib memory.h
 */

#ifndef LIB_MEMORYX_H_
#define LIB_MEMORYX_H_

#include <c_compat.h>
#include <memory.h>
#include <stdbool.h>



void memseti(int* x, int value, size_t cnt);

INLINE
void memsetu(unsigned* x, int value, size_t cnt){
    memseti((int*)x, value, cnt);
}



/// @return == 0 same
///         > 0 len of same array, when a[len-1] > b[len-1]
///         < 0 -len of same array, when a[len-1] < b[len-1]
int  memcmp_l( const long * a, const long* b, unsigned cnt);

/// @brief compares arrays[cnt] a==b
/// @return true is same
INLINE
bool is_same_l( const long*a, const long* b, unsigned cnt){
    return memcmp_l(a, b, cnt) == 0;
}



#endif /* LIB_MEMORYX_H_ */
