﻿using System;
using System.Text;
using System.Text.RegularExpressions;
using System.Diagnostics;
using System.Collections.Generic;
using System.IO;

namespace Static
{
	class Utility
	{
		public static bool matching(string target, string pattern, out GroupCollection g)
		{
			Match match = new Regex(pattern).Match(target);
			g = match.Groups;
			return match.Success;
		}
		public static bool matching(string target, string pattern)
		{
			Match match = new Regex(pattern).Match(target);
			return match.Success;
		}
		public static string string_forward(string r, int num)
		{
			return r.Substring(num, r.Length - num);
		}
		public static bool text_load(string filename, out string[] ret)
		{
			try{
				List<string> q = new List<string>();
				FileInfo info = new FileInfo(filename);
				StreamReader f = info.OpenText();
				do{
					string t = f.ReadLine();
					if(t == null){
						break;
					}
					q.Add(t);
				}while(q.Count < 1000);
				f.Close();
				ret = q.ToArray();
				return true;
			}catch{
				ret = null;
				return false;
			}
		}
		public static bool text_save(string filename, string[] data)
		{
			try{
				StreamWriter f = new StreamWriter(filename, false);
				foreach(string t in data){
					f.WriteLine(t);
				}
				f.Close();
				return true;
			}catch{
				return false;
			}
		}
		public static bool binary_load(string name, out byte [] image)
		{
			image = null;
			try{
				Stream f = File.OpenRead(name);
				if(f.Length >= imagefile.Fds.MAX_SIZE){
					return false;
				}
				image = new byte [f.Length];
				f.Read(image, 0, (int) f.Length);
				f.Close();
				return true;
			}catch {
				return false;
			}
		}
		public static bool binary_save(string name, byte [] image)
		{
			try{
				File.WriteAllBytes(name, image);
				return true;
			}catch {
				return false;
			}
		}
		public static byte [] memory_new_fill(int size, byte data)
		{
			byte [] ret = new byte[size];
			for(int i = 0; i < size; i++){
				ret[i] = data;
			}
			return ret;
		}
	}
}
namespace mdc5
{
	class DiskInfomation
	{
		string m_savefilename = "";
		Interface.ImageHash m_hash; // = new Interface.ImageHash();

		bool m_set = false;
		public bool Valid{
			get{ return m_set;}
		}
		public string Savefilename
		{
			get { return m_savefilename; }
			set { m_savefilename = value; }
		}
		public Interface.ImageHash Hash
		{
			get { return m_hash; }
		}
		public void HashSet(byte [] d)
		{
			m_hash = new Interface.ImageHash(d);
			m_set = true;
		}
	}
	abstract class Script
	{
		//---- script version 0.01 member ----
		string m_scriptversion = "";
		string m_gamename, m_gamecode;
		string m_biosname;
		protected Interface.ImageHash m_hash;
		protected RomRecoard.MotorolaSRecoard[] m_patch;
		//---- script version 0.02 member ----
		public enum imagetype{
			undef, disk, rom
		};
		imagetype m_imagetype = imagetype.undef;
		readonly imagetype m_loadtype;
		string m_gameversion;
		//----制御用----
		//const string HASH_PATTERN = @"^(([0-9A-Fa-f]{2}){20})";
		protected readonly string HASH_PATTERN;
		protected enum status{
			OPEN, CLOSE
		};
		protected enum baseload{
			Continue, Error, Through, ContinuePatchAppend
		};
		protected const string PATCH_PREFIX = "patch.";
		//---- property ----
		public RomRecoard.MotorolaSRecoard[] PatchData{
			get { return m_patch;}
		}
		public string BiosName{
			get {return m_biosname;}
		}
		public string GameName{
			get {return m_gamename;}
		}
		public string GameCode{
			get {return m_gamecode;}
		}
		public string Hash{
			get {return m_hash.ToString();}
		}
		public string ImageFilename{
			get; set;
		}
		public imagetype ImageType{
			get {return m_imagetype;}
		}
		public string GameVersion{
			get {return m_gameversion;}
		}
		//---- methods ----
		public Script(imagetype type, string gameversion)
		{
			HASH_PATTERN = "^";
			for(int i = 0; i < Interface.ImageHash.SIZE; i++){
				HASH_PATTERN += "([0-9A-Fa-f]{2})";
			}
			HASH_PATTERN += "$";
			m_loadtype = type;
			m_gameversion = gameversion;
		}
		public bool Load(string[] text, out string log)
		{
			if(text.Length == 0){
				log = "script is empty";
				return false;
			}
			return load(text, out log);
		}
		public bool Load(string filename, out string log)
		{
			string [] text;
			if(Static.Utility.text_load(filename, out text) == false){
				log = "scriptfile load error";
				return false;
			}
			if(text.Length == 0){
				log = "script is empty";
				return false;
			}
			return load(text, out log);
		}
		abstract protected bool load(string[] text, out string log);
		protected byte [] strtobyte(GroupCollection g)
		{
			byte[] hash = new byte[Interface.ImageHash.SIZE];
			for (int i = 0; i < hash.Length; i++){
				int j = i + 1;
				hash[i] = Convert.ToByte(g[j].Value, 16);
			}
			return hash;
		}
		protected bool field_value_get(string t, out string field, out string value)
		{
			GroupCollection g;
			string pattern = @"^([^\s]+)\s*=\s*([^#]+)";
			field = null;
			value = null;
			if(Static.Utility.matching(t, pattern, out g) == true){
				field = g[1].Value;
				value = g[2].Value.TrimEnd();
				return true;
			}
			return false;
		}
		const string PATTERN_DAKUON = ( //ヴを除く. ヴ-1 は ウにならない
			"^[" + 
			"がぎぐげござじずぜぞ" +
			"だぢづでどばびぶべぼ" +
			"ガギグゲゴザジズゼゾ" +
			"ダヂヅデドバビブベボ" +
			"]$"
		);
		const string PATTERN_HANDAKUON = (
			"^[" + 
			"ぱぴぷぺぽパピプペポ" +
			"]$"
		);
		string dakuon(string t)
		{
			if(Static.Utility.matching(t, PATTERN_DAKUON) == true){
				int code = (int) Convert.ToChar(t);
				code -= 1;
				return Convert.ToChar(code).ToString() + "゛";
			}
			if(t == "ヴ"){
				return "ウ゛";
			}
			if(Static.Utility.matching(t, PATTERN_HANDAKUON) == true){
				int code = (int) Convert.ToChar(t);
				code -= 2;
				return Convert.ToChar(code).ToString() + "゜";
			}
			return t;
		}
		const int BIOSNAME_LINE_LENGTH = 20;
		const int BIOSNAME_INPUT_MAX = BIOSNAME_LINE_LENGTH * 2 + 1;
		readonly string PATTERN_BIOSNAME = (
			@"^[0-9A-Z\.,\x20@" +
			"あいうえおか-ろわをん" + //小さいあ行は抜く
			"ァ-ロワヲンヴ" +
			@"「」\-ー\?!！]" +
			"{1," +
			BIOSNAME_INPUT_MAX.ToString() +
			"}$"
		);
		bool biosname_set(ref string name)
		{
			if(Static.Utility.matching(name, PATTERN_BIOSNAME) == false){
				return false;
			}
			string line = "";
			for(int i = 0; (i < BIOSNAME_LINE_LENGTH * 2) && (i < name.Length); i++){
				string tt = name.Substring(i, 1);
				if(tt == "@"){
					for(int j = line.Length; j < BIOSNAME_LINE_LENGTH; j++){
						line += " ";
					}
				}else if((tt == " ") && (line.Length == BIOSNAME_LINE_LENGTH)){
					//nop
				}else{
					line += dakuon(tt);
				}
				if(line.Length >= (BIOSNAME_LINE_LENGTH * 2)){
					break;
				}
			}
			name = line;
			return true;
		}
		protected baseload load_field(string t)
		{
			string pattern = @"^\s*#"; //コメントはskip
			if(Static.Utility.matching(t, pattern) == true){
				return baseload.Continue;
			}
			pattern = @"^\s*$"; //空行もskip
			if(Static.Utility.matching(t, pattern) == true){
				return baseload.Continue;
			}
			string field, val;
			if(field_value_get(t, out field, out val) == true){
				switch(field){
				case "scriptversion":
					if(m_scriptversion != ""){ //途中での変更をとめる
						return baseload.Error;
					}
					m_scriptversion = val;
					if(val != "0.02"){
						return baseload.Error;
					}
					return baseload.Continue;
				case "gamename":
					if(val.Length > 20 * 2){
						return baseload.Error;
					}
					m_gamename = val;
					return baseload.Continue;
				case "gamecode":
					m_gamecode = val;
					return baseload.Continue;
				case "biosname":
					if(biosname_set(ref val) == false){
						return baseload.Error;
					}
					m_biosname = val;
					return baseload.Continue;
				case "gameversion":
					m_gameversion = val;
					return baseload.Continue;
				case "imagetype":
					switch(val){
					case "DISK":
						m_imagetype = imagetype.disk;
						return baseload.Continue;
					case "ROM":
						m_imagetype = imagetype.rom;
						return baseload.Continue;
					//default:
					//	return baseload.Error;
					}
					//break;
					return baseload.Error;
				}
			}
			return baseload.Through;
		}
		protected baseload load_patch(string t, ref status patch, List<RomRecoard.MotorolaSRecoard> patchQueue)
		{
			switch (t){
			case PATCH_PREFIX + "start":
				if(patch != status.CLOSE){
					return baseload.Error;
				}
				patch = status.OPEN;
				return baseload.Continue;
			case PATCH_PREFIX + "end":
				if(patch != status.OPEN){
					return baseload.Error;
				}
				patch = status.CLOSE;
				return baseload.Continue;
			default:
				if(patch != status.OPEN){
					//未定義 field なので error を返す
					return baseload.Error;
				}
				RomRecoard.MotorolaSRecoard r = new RomRecoard.MotorolaSRecoard(t);
				if(r.Error == true){
					return baseload.Error;
				}
				patchQueue.Add(r);
				break;
			}
			return baseload.ContinuePatchAppend;
		}
		protected bool strtovalue(string t, ref int val)
		{
			if(Static.Utility.matching(t, "^[0-9]+$") == true){
				val = Convert.ToInt32(t, 10);
				return true;
			}
			GroupCollection g;
			if(Static.Utility.matching(t, @"^(0x|\$)([0-9A-Fa-f]+)$", out g) == true){
				val = Convert.ToInt32(g[2].Value, 16);
				return true;
			}
			if(Static.Utility.matching(t, "^(0b|%)([01]+)$", out g) == true){
				val = Convert.ToInt32(g[2].Value, 2);
				return true;
			}
			return false;
		}
		protected string errorlog(int line, string data)
		{
			return String.Format("{0} syntax error {1}: {2}", m_loadtype, line, data);
		}
		protected bool imagetype_check()
		{
			if(m_imagetype == imagetype.undef){
				return true;
			}
			if(m_imagetype == m_loadtype){
				return true;
			}
			return false;
		}
	}
	
	class DiskScript : Script{
		DiskInfomation[] m_side;
		public DiskScript() : base(imagetype.disk, "0")
		{
		}
		public string SavefileNameGet(int side)
		{
			Debug.Assert(side < m_side.Length);
			return m_side[side].Savefilename;
		}
		baseload load_diskparam(string t, ref int sidenum, ref DiskInfomation[] disk)
		{
			if(ImageType != imagetype.disk){
				return baseload.Error;
			}
			string field, value;
			if(field_value_get(t, out field, out value) == false){
				return baseload.Through;
			}

			switch(field){
			case "sidenum":
				if(sidenum != 0){
					return baseload.Error;
				}
				if(Static.Utility.matching(value, @"^\d+$") == false){
					return baseload.Error;
				}
				int num = Convert.ToInt32(value, 10);
				if(num == 0 || num >= 9){
					return baseload.Error;
				}
				sidenum = num;
				disk = new DiskInfomation[num];
				for(int i = 0; i < num; i++){
					disk[i] = new DiskInfomation();
				}
				return baseload.Continue;
			}

			GroupCollection g;
			string pattern = @"^disk(\d)\.side([AB])\.([^\s]+)$";
			if(Static.Utility.matching(field, pattern, out g) == true){
				int side = Convert.ToInt32(g[1].Value, 10) - 1;
				side *= 2;
				if(g[2].Value == "B"){
					side += 1;
				}
				if(sidenum < side || sidenum == 0){
					return baseload.Error;
				}
				switch (g[3].Value){
				case "hash":
					if(Static.Utility.matching(value, HASH_PATTERN, out g) == false){
						return baseload.Error;
					}
					disk[side].HashSet(strtobyte(g));
					return baseload.Continue;
				case "savefilename":
					disk[side].Savefilename = value;
					return baseload.Continue;
				}
			}
			return baseload.Through;
		}
		override protected bool load(string[] text, out string log)
		{
			List<RomRecoard.MotorolaSRecoard> patchList
				= new List<RomRecoard.MotorolaSRecoard>();
			int sidenum = 0;
			int line = 0;
			status patch = status.CLOSE;
			string patch_target = imagefile.Fds.PATCHFILE_AUTO;
			//このloopで必要な情報を得られたら continue を使用する.
			foreach (string t in text){
				line += 1;
				if(imagetype_check() == false){
					log = errorlog(line, "imagetype is inconnect");
					return false;
				}
				switch(load_field(t)){
				case baseload.Through:
					break;
				case baseload.Continue:
					continue;
				case baseload.Error:
					log = errorlog(line, t);
					return false;
				}
				switch(load_diskparam(t, ref sidenum, ref m_side)){
				case baseload.Through:
					break;
				case baseload.Continue:
					continue;
				case baseload.Error:
					log = errorlog(line, t);
					return false;
				}
				string field, value;
				if(field_value_get(t, out field, out value) == true){
					switch(field){
					case PATCH_PREFIX + "file":
						patch_target = value;
						break;
					}
					continue;
				}
				switch(load_patch(t, ref patch, patchList)){
				case baseload.Through:
					break;
				case baseload.Continue:
					continue;
				case baseload.ContinuePatchAppend:
					patchList[patchList.Count - 1].TargetFilename = patch_target;
					continue;
				case baseload.Error:
					log = errorlog(line, t);
					return false;
				}
			}
			m_patch = patchList.ToArray();
			m_hash = new Interface.ImageHash();
			foreach(DiskInfomation t in m_side){
				if(t.Valid == false){
					log = log = errorlog(line, "disk hash calculate error");
					return false;
				}
				m_hash.Transform(t.Hash.Hash);
			}
			m_hash.Final();
			log = null;
			return true;
		}
	}
	class RomScript : Script{
		public RomScript() : base(imagetype.rom, "nonRev?")
		{
		}
		bool hash_set(string value, out Interface.ImageHash hash)
		{
			GroupCollection g;
			if(Static.Utility.matching(value, HASH_PATTERN, out g) == false){
				hash = null;
				return false;
			}
			hash = new Interface.ImageHash(strtobyte(g));
			return true;
		}
		baseload load_romparam(string t, ref Interface.ImageHash cpu, ref Interface.ImageHash ppu)
		{
			if(ImageType != imagetype.rom){
				return baseload.Error;
			}

			string field, value;
			if(field_value_get(t, out field, out value) == false){
				return baseload.Through;
			}

			GroupCollection g;
			string pattern = @"^board\.(cpu|ppu)\.(rom|charcterram|w\-ram)\.([^\s]+)$";
			if(Static.Utility.matching(field, pattern, out g) == false){
				return baseload.Through;
			}
			switch(g[1].Value){
			case "cpu":
				switch(g[2].Value){
				case "rom":
					switch(g[3].Value){
					case "hash":
						if(hash_set(value, out cpu)==false){
							return baseload.Error;
						}
						return baseload.Continue;
					}
					break;
				case "w-ram":
					break;
				default:
					return baseload.Error;
				}
				break;
			case "ppu":
				switch(g[2].Value){
				case "rom":
					switch(g[3].Value){
					case "hash":
						if(hash_set(value, out ppu)==false){
							return baseload.Error;
						}
						return baseload.Continue;
					}
					break;
				case "charcterram":
					break;
				default:
					return baseload.Error;
				}
				break;
			}
			//前段でtrapできるはずなのでここまできたら assert
			Debug.Assert(false);
			return baseload.Error;
		}
		override protected bool load(string[] text, out string log)
		{
			Interface.ImageHash cpu = null, ppu = null;
			List<RomRecoard.MotorolaSRecoard> patchList
				= new List<RomRecoard.MotorolaSRecoard>();
			int line = 0;
			int patch_rom_offset = 0;
			int patch_cpu_address = 0;
			status patch = status.CLOSE;
			foreach (string t in text){
				line += 1;
				if(imagetype_check() == false){
					log = errorlog(line, "imagetype is inconnect");
					return false;
				}
				switch(load_field(t)){
				case baseload.Through:
					break;
				case baseload.Continue:
					continue;
				case baseload.Error:
					log = errorlog(line, t);
					return false;
				}
				switch(load_romparam(t, ref cpu, ref ppu)){
				case baseload.Through:
					break;
				case baseload.Continue:
					continue;
				case baseload.Error:
					log = errorlog(line, t);
					return false;
				}
				string field, value;
				if(field_value_get(t, out field, out value) == true){
					switch(field){
					case PATCH_PREFIX + "rom.offset":
						if(strtovalue(value, ref patch_rom_offset) == false){
						log = errorlog(line, t);
							return false;
						}
						break;
					case PATCH_PREFIX + "cpu.address":
						if(strtovalue(value, ref patch_cpu_address) == false){
							log = errorlog(line, t);
							return false;
						}
						break;
					}
					continue;
				}
				switch(load_patch(t, ref patch, patchList)){
				case baseload.Through:
					break;
				case baseload.Continue:
					continue;
				case baseload.ContinuePatchAppend:{
					RomRecoard.MotorolaSRecoard au = patchList[patchList.Count - 1];
					if(patch_rom_offset == 0 && patch_cpu_address == 0){
						log = errorlog(line, "patch offset is undefined");
						return false;
					}
					au.TargetOffset = (uint) (patch_cpu_address - patch_rom_offset);
					patchList[patchList.Count - 1] = au;
					}continue;
				case baseload.Error:
					log = errorlog(line, t);
					return false;
				}
			}
			m_patch = patchList.ToArray();
			if(ppu == null){
				m_hash = cpu;
			}else{
				m_hash = new Interface.ImageHash();
				m_hash.Transform(cpu.Hash);
				m_hash.Transform(ppu.Hash);
				m_hash.Final();
			}
			log = null;
			return true;
		}
	}
}
