package net.wasamon.mics.data;

import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mjlib.util.DataUtil;

/**
 * Byteデータを格納する．データはBig Endianであることに注意
 */
public class ByteVector implements MicsDataPacket{

  public byte[] data;

  public ByteVector(int width){
    data = new byte[width];
  }

  public ByteVector(byte[] d){
  	data = d;
  }

  public ByteVector(byte[] d, int width){
  	int len = width/8;
  	data = DataUtil.subArray(d, d.length - len, len);
  }

  public String toBitString(){
    StringBuffer buf = new StringBuffer();
    for(byte d: data){
      for(int i = 0; i < 8; i++){
	buf.append( ((d >> (7-i)) & 0x01) == 0x01 ? "1" : "0");
      }
    }
    return buf.toString();
  }

  public String toHexString(){
    String s = "0x";
    for(byte d: data){
      s += String.format("%02x", d);
    }
    return s;
  }

  public static void main(String[] args){
    ByteVector bv = new ByteVector(2);
    bv.data[0] = Byte.parseByte(args[0]);
    bv.data[1] = Byte.parseByte(args[1]);
    System.out.println(bv.toHexString());
    System.out.println(bv.toBitString());
  }

}
