/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * MICSを使用する上でのツール群
 */
package net.wasamon.mics.tools;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;

/**
 * 一行に一つ数字があるアスキーファイルをバイナリファイルにする
 * ただし数字は16bitずつ扱われる
 */
public class AsciiToBinary {

	public AsciiToBinary() {

	}

	public void parse(String f) throws IOException, NumberFormatException,
			FileNotFoundException {
		File file = new File(f);
		File dest = parser(file);
		System.out.println(f + " -> " + file.getParent() + "/" + dest.getName());
	}

	public File parser(File file) throws IOException, NumberFormatException,
			FileNotFoundException {
		BufferedReader reader = new BufferedReader(new FileReader(file));
		ByteArrayOutputStream hex = new ByteArrayOutputStream();
		String line = "";
		while ((line = reader.readLine()) != null) {
			int v = Integer.parseInt(line);
			hex.write((byte) ((v >> 8) & 0x00ff));
			hex.write((byte) ((v >> 0) & 0x00ff));
		}
		int i = file.getName().lastIndexOf('.');
		File dest = new File(file.getParent(), file.getName().substring(0, i)
				+ ".bin");
		FileOutputStream fos = new FileOutputStream(dest);
		hex.writeTo(fos);
		fos.flush();
		fos.close();
		hex.close();
		return dest;
	}

	public static void main(String[] args) {
		if (args.length < 1) {
			System.out.println("net.wasamon.mics.tools.AsciiToBinary file");
			System.exit(0);
		}
		AsciiToBinary a2b = new AsciiToBinary();
		for (int i = 0; i < args.length; i++) {
			try {
				a2b.parse(args[i]);
			} catch (FileNotFoundException e) {
				System.out.println("no such file: " + args[i]);
			} catch (IOException e) {
				System.out.println("error while parsing: " + args[i]);
			} catch (NumberFormatException e) {
				System.out.println("error while parsing: " + args[i]);
			}
		}
	}

}
