/*
 * Decompiled with CFR 0.152.
 */
package coins;

import coins.FatalError;
import coins.IoRoot;
import coins.driver.CoinsOptions;

public class Message {
    IoRoot fIoRoot;
    String fHeader;
    int fMessageCountOfThisClass;

    public Message(IoRoot pIoRoot) {
        this.fIoRoot = pIoRoot;
    }

    public Message(IoRoot pIoRoot, String pHeader) {
        this.fIoRoot = pIoRoot;
        this.fHeader = pHeader;
    }

    public void initiate() {
        this.fIoRoot.msgNote = new Message(this.fIoRoot, "Note");
        class WarningMessage
        extends Message {
            public WarningMessage(IoRoot pIoRoot, String pHeader) {
                super(pIoRoot, pHeader);
            }

            private void checkCount() {
                String lArg;
                int lMax;
                CoinsOptions lCoinsOptions = this.fIoRoot.getCompileSpecification().getCoinsOptions();
                if (lCoinsOptions.isSet("max-warnings") && (lMax = new Integer(lArg = lCoinsOptions.getArg("max-warnings")).intValue()) > 0 && this.fMessageCountOfThisClass == lMax + 1) {
                    this.fIoRoot.msgError.put(this.fIoRoot.getSourceFile().getName() + ": Too many warnings");
                }
            }

            public synchronized void put(String pMessage) {
                super.put(pMessage);
                this.checkCount();
            }

            public synchronized void put(int pMessageNumber, String pMessage) {
                super.put(pMessageNumber, pMessage);
                this.checkCount();
            }
        }
        this.fIoRoot.msgWarning = new WarningMessage(this.fIoRoot, "Warning");
        class RecoveredErrorMessage
        extends Message {
            public RecoveredErrorMessage(IoRoot pIoRoot, String pHeader) {
                super(pIoRoot, pHeader);
            }

            private void checkCount() {
                String lArg;
                int lMax;
                CoinsOptions lCoinsOptions = this.fIoRoot.getCompileSpecification().getCoinsOptions();
                if (lCoinsOptions.isSet("max-recovered-errors") && (lMax = new Integer(lArg = lCoinsOptions.getArg("max-recovered-errors")).intValue()) > 0 && this.fMessageCountOfThisClass == lMax + 1) {
                    this.fIoRoot.msgError.put(this.fIoRoot.getSourceFile().getName() + ": Too many recovered errors");
                }
            }

            public synchronized void put(String pMessage) {
                super.put(pMessage);
                this.checkCount();
            }

            public synchronized void put(int pMessageNumber, String pMessage) {
                super.put(pMessageNumber, pMessage);
                this.checkCount();
            }
        }
        this.fIoRoot.msgRecovered = new RecoveredErrorMessage(this.fIoRoot, "Recovered error");
        this.fIoRoot.msgError = new Message(this.fIoRoot, "Compile error");
        class FatalMessage
        extends Message {
            public FatalMessage(IoRoot pIoRoot, String pHeader) {
                super(pIoRoot, pHeader);
            }

            public void put(String pMessage) {
                super.put(pMessage);
                throw new FatalError(pMessage);
            }

            public void put(int pMessageNumber, String pMessage) {
                super.put(pMessageNumber, pMessage);
                throw new FatalError("" + pMessageNumber + ":" + pMessage);
            }
        }
        this.fIoRoot.msgFatal = new FatalMessage(this.fIoRoot, "Fatal error");
    }

    public synchronized void put(String pMessage) {
        this.fIoRoot.msgOut.println("\n" + this.fHeader + " " + pMessage);
        if (this.fIoRoot.msgOut != this.fIoRoot.printOut && this.fIoRoot.dbgControl.getLevel() > 0) {
            this.fIoRoot.printOut.println("\n" + this.fHeader + " " + pMessage);
        }
        this.fIoRoot.incrementMessageCount();
        ++this.fMessageCountOfThisClass;
    }

    public synchronized void put(int pMessageNumber, String pMessage) {
        String lMessage = "\n" + this.fHeader + " " + pMessageNumber + ": " + pMessage;
        this.fIoRoot.msgOut.println(lMessage);
        if (this.fIoRoot.msgOut != this.fIoRoot.printOut && this.fIoRoot.dbgControl.getLevel() > 0) {
            this.fIoRoot.printOut.println(lMessage);
        }
        this.fIoRoot.incrementMessageCount();
        ++this.fMessageCountOfThisClass;
    }

    public synchronized int getMessageCountOfThisClass() {
        return this.fMessageCountOfThisClass;
    }

    public synchronized void resetMessageCountOfThisClass() {
        this.fMessageCountOfThisClass = 0;
    }
}

