/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.aflow.BBlock;
import coins.aflow.ExpVector;
import coins.aflow.ExpVectorImpl;
import coins.aflow.FlowAdapter;
import coins.aflow.FlowResults;
import coins.aflow.SetRefRepr;
import coins.aflow.SetRefReprList;
import coins.aflow.SubpFlow;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class FindAvailInAvailOut
extends FlowAdapter {
    public FindAvailInAvailOut(FlowResults pResults) {
        super(pResults);
    }

    public void find(SubpFlow pSubpFlow) {
        boolean lChanged;
        ExpVector lAvailIn;
        ExpVector lSurvived = pSubpFlow.expVector();
        ExpVector lPredAvailOut = pSubpFlow.expVector();
        ExpVector lZeroVect = pSubpFlow.expVector();
        this.ioRoot.dbgFlow.print(2, "FindAvailInAvailOut", pSubpFlow.getSubpSym().getName());
        for (BBlock lBBlock : pSubpFlow.getBBlocks()) {
            lAvailIn = pSubpFlow.expVector();
            if (!lBBlock.isEntryBBlock()) {
                lZeroVect.vectorNot(lAvailIn);
            }
            this.registerAvailIn(lBBlock, lAvailIn);
        }
        do {
            lChanged = false;
            Iterator lCFGIterator = pSubpFlow.getBBlocksFromEntry().iterator();
            while (lCFGIterator.hasNext()) {
                BBlock lBBlock;
                ExpVector lNewAvailIn = pSubpFlow.expVector();
                lBBlock = (BBlock)lCFGIterator.next();
                if (lBBlock.isEntryBBlock()) continue;
                List lPredList = lBBlock.getPredList();
                lZeroVect.vectorNot(lNewAvailIn);
                for (BBlock lPredBBlock : lPredList) {
                    ExpVector lPredEGen = this.getEGen(lPredBBlock);
                    ExpVector lPredEKill = this.getEKill(lPredBBlock);
                    ExpVector lPredAvailIn = this.getAvailIn(lPredBBlock);
                    lPredAvailIn.vectorSub(lPredEKill, lSurvived);
                    lPredEGen.vectorOr(lSurvived, lPredAvailOut);
                    lNewAvailIn.vectorAnd(lPredAvailOut, lNewAvailIn);
                }
                if (lNewAvailIn.vectorEqual(this.getAvailIn(lBBlock))) continue;
                lChanged = true;
                this.registerAvailIn(lBBlock, lNewAvailIn);
            }
        } while (lChanged);
        for (BBlock lBBlock : pSubpFlow.getBBlocks()) {
            this.ioRoot.dbgFlow.print(4, "Compute AvailOut of ", lBBlock.toString());
            ExpVector lEGen = this.getEGen(lBBlock);
            ExpVector lEKill = this.getEKill(lBBlock);
            lAvailIn = this.getAvailIn(lBBlock);
            this.ioRoot.dbgFlow.print(4, " EGen ", lEGen.toString());
            this.ioRoot.dbgFlow.print(4, " EKill ", lEKill.toString());
            this.ioRoot.dbgFlow.print(4, " AvailIn ", lAvailIn.toString());
            lAvailIn.vectorSub(lEKill, lSurvived);
            ExpVector lAvailOut = pSubpFlow.expVector();
            lEGen.vectorOr(lSurvived, lAvailOut);
            this.registerAvailOut(lBBlock, lAvailOut);
            this.ioRoot.dbgFlow.print(4, " AvailOut ", lAvailOut.toString());
        }
    }

    public void find(BBlock pBBlock) {
        this.find(pBBlock.getSubpFlow());
    }

    public void find(SetRefRepr pSetRefRepr) {
        BBlock lBBlock = pSetRefRepr.getBBlock();
        SetRefReprList lSetRefReprs = lBBlock.getSetRefReprs();
        SubpFlow lSubpFlow = lBBlock.getSubpFlow();
        ExpVector lAvailIn = lSubpFlow.expVector();
        if (lSetRefReprs.isEmpty()) {
            this.getAvailIn(lBBlock).vectorCopy(lAvailIn);
        } else if (lBBlock.getSetRefReprs().get(0) == pSetRefRepr) {
            this.getAvailIn(lBBlock).vectorCopy(lAvailIn);
        } else {
            SetRefRepr lPrevSetRefRepr = (SetRefRepr)lSetRefReprs.get(lSetRefReprs.indexOf(pSetRefRepr) - 1);
            ExpVector lPrevAvailIn = this.getAvailIn(lPrevSetRefRepr);
            lPrevAvailIn.vectorOr(ExpVectorImpl.forSet((Set)this.fResults.get("UseFlowExpIdsForSetRefRepr", lPrevSetRefRepr), lSubpFlow), lAvailIn);
            lAvailIn.vectorSub(this.getEKill(lPrevSetRefRepr), lAvailIn);
        }
        this.registerAvailIn(pSetRefRepr, lAvailIn);
    }

    protected abstract ExpVector getEKill(SetRefRepr var1);

    protected abstract ExpVector getAvailIn(SetRefRepr var1);

    protected abstract void registerAvailIn(SetRefRepr var1, ExpVector var2);

    protected abstract ExpVector getEGen(BBlock var1);

    protected abstract ExpVector getEKill(BBlock var1);

    protected abstract ExpVector getAvailIn(BBlock var1);

    protected abstract void registerAvailIn(BBlock var1, ExpVector var2);

    protected abstract void registerAvailOut(BBlock var1, ExpVector var2);
}

