/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow;

import coins.FlowRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.aflow.BBlock;
import coins.aflow.BBlockHir;
import coins.aflow.BBlockStmtIterator;
import coins.aflow.FlowResults;
import coins.aflow.SetRefRepr;
import coins.aflow.SubpFlow;
import coins.aflow.util.BitVector;
import coins.aflow.util.FAList;
import coins.aflow.util.FlowError;
import coins.ir.IR;
import coins.sym.FlowAnalSym;
import coins.sym.SymTable;
import coins.sym.Var;
import java.util.List;
import java.util.ListIterator;

public class ShowFlow {
    public final FlowRoot flowRoot;
    public final IoRoot ioRoot;
    public final SymRoot symRoot;
    final FlowResults fResults;

    public ShowFlow(FlowResults pResults) {
        this.fResults = pResults;
        this.flowRoot = pResults.flowRoot;
        this.ioRoot = this.flowRoot.ioRoot;
        this.symRoot = this.flowRoot.symRoot;
    }

    public void showControlFlow(SubpFlow pSubpFlow) {
        int maxBBlockNo = pSubpFlow.getNumberOfBBlocks();
        this.ioRoot.printOut.print("=====[Basic Block]=====\n");
        for (int i = 1; i <= maxBBlockNo; ++i) {
            BBlock edge;
            BBlock b = pSubpFlow.getBBlock(i);
            this.ioRoot.printOut.print("BlockNO =");
            this.ioRoot.printOut.print(b.getBBlockNumber() + "\n");
            if (b.isEntryBBlock()) {
                this.ioRoot.printOut.print("(ENTRY BLOCK)\n");
            }
            if (b.isExitBBlock()) {
                this.ioRoot.printOut.print("(EXIT BLOCK)\n");
            }
            this.ioRoot.printOut.print("\t ==Succ List==>(");
            List l = b.getSuccList();
            boolean first = true;
            ListIterator Ie = l.listIterator();
            while (Ie.hasNext()) {
                edge = (BBlock)Ie.next();
                if (first) {
                    first = false;
                } else {
                    this.ioRoot.printOut.print(",");
                }
                this.ioRoot.printOut.print(edge.getBBlockNumber());
            }
            this.ioRoot.printOut.print(")\n");
            this.ioRoot.printOut.print("\t ==Pred List==>(");
            l = b.getPredList();
            first = true;
            Ie = l.listIterator();
            while (Ie.hasNext()) {
                edge = (BBlock)Ie.next();
                if (first) {
                    first = false;
                } else {
                    this.ioRoot.printOut.print(",");
                }
                this.ioRoot.printOut.print(edge.getBBlockNumber());
            }
            this.ioRoot.printOut.print(")\n");
            if (this.flowRoot.isHirAnalysis()) {
                this.ioRoot.printOut.print("\t ==Stmt List==\n");
            } else {
                this.ioRoot.printOut.print("\t ==Instr List==\n");
            }
            if (b instanceof BBlockHir) {
                IR s;
                BBlockStmtIterator lIt = new BBlockStmtIterator((BBlockHir)b);
                while ((s = lIt.next()) != BBlockStmtIterator.EOB) {
                    this.ioRoot.printOut.print("\t ");
                    this.ioRoot.printOut.print(s + "\n");
                }
                continue;
            }
            throw new FlowError();
        }
    }

    public void showDominatorTree(SubpFlow pSubpFlow) {
        this.ioRoot.printOut.print("=====[ Dominators ]=====\n");
        for (BBlock lBBlock : pSubpFlow.getBBlocks()) {
            List lDom = lBBlock.getDomForSubpFlow();
            this.showDominator(lDom, lBBlock);
        }
    }

    public void showPostdominatorTree(SubpFlow pSubpFlow) {
        this.ioRoot.printOut.print("=====[ Postdominators ]=====\n");
        for (BBlock lBBlock : pSubpFlow.getBBlocks()) {
            List lPostdom = lBBlock.getPostdomForSubpFlow();
            this.showPostdominator(lPostdom, lBBlock);
        }
    }

    void showDominator(List pDom, BBlock pBBlock) {
        this.ioRoot.printOut.print(pBBlock + "\n");
        this.ioRoot.printOut.print(" " + pDom + "\n");
    }

    void showPostdominator(List pPostdom, BBlock pBBlock) {
        this.showDominator(pPostdom, pBBlock);
    }

    public void showImmediateDominators(SubpFlow pSubpFlow) {
        this.ioRoot.printOut.print("=====[ Immediate dominators ]=====\n");
        for (BBlock lBBlock : pSubpFlow.getReachableBBlocks()) {
            this.ioRoot.printOut.print(lBBlock + ": ");
            this.ioRoot.printOut.print(lBBlock.getImmediateDominatorForSubpFlow() + "\n");
        }
    }

    public void showImmediatePostdominators(SubpFlow pSubpFlow) {
        this.ioRoot.printOut.print("=====[ Immediate postdominators ]=====\n");
        for (BBlock lBBlock : pSubpFlow.getReachableBBlocks()) {
            this.ioRoot.printOut.print(lBBlock + ": ");
            this.ioRoot.printOut.print(lBBlock.getImmediatePostdominatorForSubpFlow() + "\n");
        }
    }

    public void showVector(BitVector pBitVector, String pComment) {
        this.ioRoot.printOut.print(pComment + "\n");
        ((Object)pBitVector).toString();
        this.ioRoot.printOut.print(pBitVector + "\n");
    }

    public void showDUseDef(SubpFlow pSubpFlow) {
        SymTable lSymTableCurrent = this.symRoot.symTableCurrent;
        this.ioRoot.printOut.print("=====[DUseDef]=====\n");
        for (FlowAnalSym lFlowAnalSym : (FAList)this.fResults.get("SymIndexTable", pSubpFlow)) {
            if (!(lFlowAnalSym instanceof Var)) continue;
            this.ioRoot.printOut.print(lFlowAnalSym + "\n");
            this.ioRoot.printOut.print(this.fResults.get("DUDList", lFlowAnalSym, pSubpFlow) + "\n");
        }
    }

    public void showPDefUse(SubpFlow pSubpFlow) {
        SymTable lSymTableCurrent = this.symRoot.symTableCurrent;
        this.ioRoot.printOut.print("=====[DefUse]=====\n");
        for (FlowAnalSym lFlowAnalSym : (FAList)this.fResults.get("SymIndexTable", pSubpFlow)) {
            if (!(lFlowAnalSym instanceof Var)) continue;
            this.ioRoot.printOut.print(lFlowAnalSym + "\n");
            Object o = this.fResults.get("DefUseList", lFlowAnalSym, pSubpFlow);
            this.ioRoot.printOut.print(this.fResults.get("DefUseList", lFlowAnalSym, pSubpFlow) + "\n");
        }
    }

    public void showPUseDef(SubpFlow pSubpFlow) {
        SymTable lSymTableCurrent = this.symRoot.symTableCurrent;
        this.ioRoot.printOut.print("=====[UseDef]=====\n");
        for (FlowAnalSym lFlowAnalSym : (FAList)this.fResults.get("SymIndexTable", pSubpFlow)) {
            if (!(lFlowAnalSym instanceof Var)) continue;
            this.ioRoot.printOut.print(lFlowAnalSym + "\n");
            this.ioRoot.printOut.print(this.fResults.get("UDList", lFlowAnalSym, pSubpFlow) + "\n");
        }
    }

    public void showVectorByName(BitVector pVect, String pComment) {
        this.ioRoot.printOut.print("(" + pComment + ")\n");
        if (pVect == null) {
            this.ioRoot.printOut.print("  is null\n");
        } else {
            this.ioRoot.printOut.print(pVect.toStringDescriptive() + "\n");
        }
    }

    public void showVectorsByName(String pAnalName, SubpFlow pSubpFlow) {
        this.ioRoot.printOut.print("=====[" + pAnalName + "(B)]=====\n");
        ListIterator Ie = pSubpFlow.getBBlocksFromEntry().listIterator();
        while (Ie.hasNext()) {
            BBlock b = (BBlock)Ie.next();
            BitVector lVect = (BitVector)this.fResults.get(pAnalName, b);
            this.showVectorByName(lVect, "BBlock " + b.getBBlockNumber());
        }
    }

    public void showVectorsByName(String pAnalName, BBlock pBBlock) {
        this.ioRoot.printOut.print("====[" + pAnalName + " for SetRefReprs in " + pBBlock + "]====\n");
        if (!this.fResults.containsKey(pAnalName)) {
            this.ioRoot.printOut.print(" showVectorsByName parameter error " + pAnalName + " not registered\n");
            return;
        }
        for (SetRefRepr lSetRefRepr : pBBlock.getSetRefReprs()) {
            if (!this.fResults.containsKey(pAnalName, lSetRefRepr)) {
                this.ioRoot.printOut.print(" showVectorsByName parameter error " + pAnalName + " not registered\n");
                break;
            }
            BitVector lBitVect = (BitVector)this.fResults.get(pAnalName, lSetRefRepr);
            this.showVectorByName(lBitVect, ((Object)lSetRefRepr).toString());
        }
    }
}

