/*
 * Decompiled with CFR 0.152.
 */
package coins.alias;

import coins.HirRoot;
import coins.alias.AliasError;
import coins.alias.AliasFactory;
import coins.alias.AliasUtil;
import coins.alias.MyExpId;
import coins.alias.Tag;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirVisitorModel2;
import coins.ir.hir.PointedExp;
import coins.ir.hir.QualifiedExp;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubpNode;
import coins.ir.hir.SubscriptedExp;
import coins.ir.hir.VarNode;
import coins.sym.Type;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TagTreeBuilder
extends HirVisitorModel2 {
    private SubpDefinition fSubpDef;
    private MyExpId[] fMyExpIds;
    int fTagBitCount = 0;
    private Map fHIRToTag = new HashMap(50);
    Map fHIRTomallocTag = new HashMap(5);
    List fParentlessTags = new ArrayList();
    private AliasFactory fFactory;
    private final boolean fIsOptimistic;

    TagTreeBuilder(SubpDefinition pSubpDef, MyExpId[] pMyExpIds, boolean pIsOptimistic, HirRoot pHirRoot) {
        super(pHirRoot);
        this.fSubpDef = pSubpDef;
        this.fMyExpIds = pMyExpIds;
        this.fFactory = new AliasFactory(this.hirRoot);
        this.fIsOptimistic = pIsOptimistic;
    }

    Map process() {
        this.visit(this.fSubpDef.getHirBody());
        ++this.fTagBitCount;
        this.fParentlessTags.add(this.fFactory.otherTag());
        return this.fHIRToTag;
    }

    public void atVarNode(VarNode pVarNode) {
        if (this.fMyExpIds[pVarNode.getIndex()].fTag == null) {
            int lKind = TagTreeBuilder.tagKind(pVarNode.getType());
            int lStorageClass = TagTreeBuilder.storageClass(pVarNode.getVar());
            Tag lTag = this.fMyExpIds[pVarNode.getIndex()].fTag = this.fFactory.tag(this.fMyExpIds[pVarNode.getIndex()], true, lKind, lStorageClass);
            lTag.fIsUnique = true;
            ++this.fTagBitCount;
            this.fParentlessTags.add(lTag);
        }
        this.fHIRToTag.put(pVarNode, this.fMyExpIds[pVarNode.getIndex()].fTag);
    }

    public void atSubscriptedExp(SubscriptedExp pExp) {
        Exp lArrayExp = pExp.getArrayExp();
        VectorType lArrayType = (VectorType)lArrayExp.getType();
        Exp lSubscriptExp = pExp.getSubscriptExp();
        this.visitChildren(pExp);
        if (lArrayExp.getOperator() == 5) {
            return;
        }
        Tag lParentTag = this.fMyExpIds[lArrayExp.getIndex()].fTag;
        if (lParentTag == null) {
            return;
        }
        Tag lTag = this.fMyExpIds[pExp.getIndex()].fTag;
        if (lTag == null) {
            if (!(this.fIsOptimistic || lSubscriptExp.getOperator() == 5 && AliasUtil.subscriptCheck(lArrayType, ((ConstNode)lSubscriptExp).getIntValue()))) {
                lTag = this.fFactory.tag(this.fMyExpIds[pExp.getIndex()], false, TagTreeBuilder.tagKind(pExp.getType()), lParentTag.fStorageClass);
            } else {
                if (lParentTag.fIsUnique && lSubscriptExp.getOperator() == 5 && !lParentTag.getFlag(1)) {
                    ++this.fTagBitCount;
                }
                lTag = this.fFactory.tag(this.fMyExpIds[pExp.getIndex()], lParentTag.isAnchored(), TagTreeBuilder.tagKind(pExp.getType()), lParentTag.fStorageClass);
                lTag.fParent = lParentTag;
                lParentTag.fChildren.add(lTag);
                lTag.inheritAttributes();
                lTag.fIsUnique = !lParentTag.getFlag(1) && lParentTag.fIsUnique && lSubscriptExp.getOperator() == 5;
            }
            this.fMyExpIds[pExp.getIndex()].fTag = lTag;
        }
        this.fHIRToTag.put(pExp, lTag);
    }

    public void atQualifiedExp(QualifiedExp pExp) {
        this.visit((Exp)pExp.getChild1());
        Tag lParentTag = this.fMyExpIds[pExp.getChild1().getIndex()].fTag;
        if (lParentTag == null) {
            return;
        }
        Tag lTag = this.fMyExpIds[pExp.getIndex()].fTag;
        if (lTag == null) {
            if (lParentTag.fIsUnique && !lParentTag.getFlag(1)) {
                ++this.fTagBitCount;
            }
            lTag = this.fFactory.tag(this.fMyExpIds[pExp.getIndex()], lParentTag.isAnchored(), TagTreeBuilder.tagKind(pExp.getType()), lParentTag.fStorageClass);
            lTag.fParent = lParentTag;
            lParentTag.fChildren.add(lTag);
            lTag.inheritAttributes();
            lTag.fIsUnique = !lParentTag.getFlag(1) && lParentTag.fIsUnique;
            this.fMyExpIds[pExp.getIndex()].fTag = lTag;
        }
        this.fHIRToTag.put(pExp, lTag);
    }

    public void atPointedExp(PointedExp pExp) {
        this.visit((Exp)pExp.getChild1());
        Tag lTag = this.fMyExpIds[pExp.getIndex()].fTag;
        if (lTag == null) {
            this.fMyExpIds[pExp.getIndex()].fTag = lTag = this.fFactory.tag(this.fMyExpIds[pExp.getIndex()], false, TagTreeBuilder.tagKind(pExp.getType()), 0);
        }
        this.fHIRToTag.put(pExp, lTag);
    }

    public void atExp(Exp pExp) {
        int lOpCode = pExp.getOperator();
        switch (lOpCode) {
            case 68: {
                if (pExp.getType().getTypeKind() != 27) {
                    if (this.fMyExpIds[pExp.getIndex()].fTag == null) {
                        this.fMyExpIds[pExp.getIndex()].fTag = this.fFactory.tag(this.fMyExpIds[pExp.getIndex()], false, TagTreeBuilder.tagKind(pExp.getType()), 0);
                    }
                    this.fHIRToTag.put(pExp, this.fMyExpIds[pExp.getIndex()].fTag);
                }
                this.visitChildren(pExp);
                break;
            }
            case 67: {
                if (this.fMyExpIds[pExp.getIndex()].fTag == null) {
                    Tag lTag = this.fMyExpIds[pExp.getIndex()].fTag = this.fFactory.tag(this.fMyExpIds[pExp.getIndex()], false, TagTreeBuilder.tagKind(pExp.getType()), 0);
                    lTag.fIsUnique = false;
                }
                this.fHIRToTag.put(pExp, this.fMyExpIds[pExp.getIndex()].fTag);
                this.visitChildren(pExp);
                break;
            }
            default: {
                this.visitChildren(pExp);
            }
        }
    }

    public void atFunctionExp(FunctionExp pExp) {
        HIR lSubpNode;
        Exp lFuncSpec = pExp.getFunctionSpec();
        if (lFuncSpec.getOperator() == 64 && (lSubpNode = (HIR)lFuncSpec.getChild1()).getOperator() == 9 && AliasUtil.ismalloc(((SubpNode)lSubpNode).getSubp())) {
            Tag lTag = this.fFactory.mallocTag(pExp);
            this.fHIRTomallocTag.put(pExp, lTag);
            ++this.fTagBitCount;
            this.fParentlessTags.add(lTag);
        }
        this.visitChildren(pExp);
    }

    private static int tagKind(Type pType) {
        switch (pType.getTypeKind()) {
            case 23: {
                return 5;
            }
            case 24: {
                return 6;
            }
            case 25: {
                return 7;
            }
        }
        return 8;
    }

    private static int storageClass(Var pVar) {
        switch (pVar.getStorageClass()) {
            case 7: 
            case 8: {
                return 1;
            }
            case 6: {
                return 2;
            }
        }
        throw new AliasError("Unexpected");
    }
}

