/*
 * Decompiled with CFR 0.152.
 */
package coins.ast.expr;

import coins.ast.Expr;
import coins.ast.TokenId;
import coins.ast.Visitor;
import coins.ast.expr.BinaryExpr;

public class ArithBinaryExpr
extends BinaryExpr
implements TokenId {
    private int operatorToken;
    private byte[] resultType;

    public ArithBinaryExpr(Expr expr1, int op, Expr expr2, byte[] type) {
        super(expr1, expr2);
        this.operatorToken = op;
        this.resultType = type;
    }

    public void accept(Visitor v) {
        v.atArithBinaryExpr(this);
    }

    public byte[] getType() {
        return this.resultType;
    }

    public int operatorId() {
        return this.operatorToken;
    }

    public String operatorName() {
        switch (this.operatorToken) {
            case 366: {
                return "<<";
            }
            case 367: {
                return ">>";
            }
            case 361: {
                return "<=";
            }
            case 362: {
                return ">=";
            }
            case 363: {
                return "==";
            }
            case 360: {
                return "!=";
            }
            case 369: {
                return "&&";
            }
            case 368: {
                return "||";
            }
        }
        return new StringBuffer().append((char)this.operatorToken).toString();
    }
}

