/*
 * Decompiled with CFR 0.152.
 */
package coins.backend;

import coins.backend.CantHappenException;
import coins.backend.Data;
import coins.backend.LocalAnalysis;
import coins.backend.LocalAnalyzer;
import coins.backend.LocalTransformer;
import coins.backend.Module;
import coins.backend.ModuleElement;
import coins.backend.SyntaxError;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.opt.JumpCanon;
import coins.backend.opt.JumpOpt;
import coins.backend.regalo.LiveRange;
import coins.backend.regalo.RegisterAllocation;
import coins.backend.sym.Label;
import coins.backend.sym.SymAuto;
import coins.backend.sym.SymTab;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.backend.util.QuotedString;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Function
extends ModuleElement {
    public final LirFactory newLir;
    public final SymTab localSymtab;
    private FlowGraph flowGraph;
    private BiList lirList;
    public final LirNode origPrologue;
    public final LirNode origEpilogue;
    private Map labelTable = new HashMap();
    private int labelVariantCounter = 1;
    private Map analyses = new HashMap();
    private int timeStamp = 0;
    public static final int FORM_NORMAL = 0;
    public static final int FORM_SSA = 1;
    public static final int FORM_SSA2 = 2;
    private int form = 0;
    public static ToCFG toCFG = new ToCFG();
    public static ToLinear toLinear = new ToLinear();
    private int tempCounter = 1;
    public static final LocalTransformer toMachineCodeTrig = new LocalTransformer(){

        public boolean doIt(Function func, ImList args) {
            func.toMachineCode();
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "ToMachineCode";
        }

        public String subject() {
            return "Machine Instruction Conversion";
        }
    };
    private static final int REGALOLIMIT = 7;
    private static final LocalAnalysis[] emptyAnares = new LocalAnalysis[0];

    public Function(Module module, ImList ptr) throws SyntaxError {
        super(module, ((QuotedString)ptr.elem2nd()).body);
        this.newLir = module.newLir;
        this.symbol.setBody(this);
        this.localSymtab = new SymTab(module);
        this.reload(ptr);
        LirNode inst = null;
        BiLink p = this.flowGraph().entryBlk().instrList().first();
        LirNode op = (LirNode)p.elem();
        if (op.opCode == 54) {
            inst = op;
        }
        this.origPrologue = inst;
        inst = null;
        p = this.flowGraph().exitBlk().instrList().first();
        while (!p.atEnd()) {
            op = (LirNode)p.elem();
            if (op.opCode == 55) {
                inst = op;
            }
            p = p.next();
        }
        this.origEpilogue = inst;
    }

    public BiList firstInstrList() {
        if (this.flowGraph != null) {
            return this.flowGraph.entryBlk().instrList();
        }
        return this.lirList;
    }

    public void reload(ImList ptr) throws SyntaxError {
        ptr = ptr.next();
        if (!this.symbol.name.equals(((QuotedString)ptr.elem()).body)) {
            throw new SyntaxError("Expecting function " + this.symbol.name + "but: " + (QuotedString)ptr.elem());
        }
        ptr = ptr.next();
        this.localSymtab.clear();
        ImList symp = (ImList)ptr.elem();
        if (symp.elem() == "SYMTAB") {
            symp = symp.next();
            while (!symp.atEnd()) {
                ImList def = (ImList)symp.elem();
                if (def.elem2nd() == "STATIC") {
                    this.module.globalSymtab.addSymbol(def);
                } else {
                    this.localSymtab.addSymbol(def);
                }
                symp = symp.next();
            }
            ptr = ptr.next();
        }
        this.lirList = new BiList();
        while (!ptr.atEnd()) {
            ImList stmt = (ImList)ptr.elem();
            if (stmt.elem() == "DATA") {
                this.module.doData(stmt);
            } else {
                try {
                    LirNode lir = this.newLir.decodeLir(stmt, this, this.module);
                    if (lir != null && (lir.opCode != 65 || this.root.sourceDebugInfo)) {
                        this.lirList.add(lir);
                    }
                }
                catch (SyntaxError e) {
                    throw new SyntaxError(e + ", at: " + stmt);
                }
                catch (Exception e) {
                    throw new CantHappenException(e + ", at: " + stmt);
                }
            }
            ptr = ptr.next();
        }
        this.flowGraph = null;
        if (this.root.traceOK("Load", 1)) {
            this.root.debOut.println();
            this.root.debOut.println("Function Just after read:");
            this.printIt(this.root.debOut);
        }
    }

    public FlowGraph flowGraph() {
        if (this.flowGraph == null) {
            this.clearLabels();
            this.flowGraph = new FlowGraph(this, this.lirList);
            this.renameLabels();
            this.purgeAnalysis();
            this.lirList = null;
        }
        return this.flowGraph;
    }

    public BiList lirList() {
        if (this.lirList == null) {
            this.lirList = new BiList();
            BiLink p = this.flowGraph.basicBlkList.first();
            while (!p.atEnd()) {
                BasicBlk blk = (BasicBlk)p.elem();
                this.lirList.add(this.newLir.node(52, 0, this.newLir.labelRef(blk.label())));
                this.lirList.concatenate(blk.instrList());
                p = p.next();
            }
            this.flowGraph = null;
        }
        return this.lirList;
    }

    public Label newLabel() {
        Label label = this.module.newLabel();
        this.labelTable.put(label.name(), label);
        return label;
    }

    public Label internLabel(String name) throws SyntaxError {
        Label label = (Label)this.labelTable.get(name);
        if (label == null) {
            label = this.module.lookupLabel(name);
            if (label != null) {
                throw new SyntaxError("Label " + name + " conflits");
            }
            label = new Label(name);
            this.labelTable.put(name, label);
        }
        return label;
    }

    private void renameLabels() {
        BiLink p = this.flowGraph.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            Label label = blk.label();
            String oldName = label.name();
            if (this.module.lookupLabel(oldName) == null) {
                this.module.renameLabelToFinal(label);
                this.labelTable.remove(oldName);
                this.labelTable.put(label.name(), label);
            }
            p = p.next();
        }
    }

    private void clearLabels() {
        Set set = this.labelTable.entrySet();
        for (Map.Entry e : set) {
            Label label = (Label)e.getValue();
            label.clear();
        }
    }

    public void reserveLabelVariantNo(int variant) {
        if (variant >= this.labelVariantCounter) {
            this.labelVariantCounter = variant + 1;
        }
    }

    public Symbol addSymbol(String name, int storage, int type, int boundary, int offset, ImList opt) {
        return this.localSymtab.addSymbol(name, storage, type, boundary, offset, opt);
    }

    public Symbol addSymbol(Symbol original, int type) {
        return this.localSymtab.addSymbol(original, type);
    }

    public Symbol getSymbol(String name) {
        Symbol sym = this.localSymtab.get(name);
        if (sym == null) {
            sym = this.module.globalSymtab.get(name);
        }
        return sym;
    }

    public Symbol[] symVector() {
        Symbol[] vec = new Symbol[this.localSymtab.idBound()];
        this.module.globalSymtab.makeReverseIndex(vec);
        this.localSymtab.makeReverseIndex(vec);
        return vec;
    }

    public int frameSize() {
        int loc = 0;
        BiLink p = this.localSymtab.symbols().first();
        while (!p.atEnd()) {
            int off;
            SymAuto var = (SymAuto)p.elem();
            if (var.storage == 1 && (off = var.offset()) != 0 && off < loc) {
                loc = off;
            }
            p = p.next();
        }
        return -loc;
    }

    public LirNode newTemp(int type) {
        Symbol newVar = this.addSymbol(".T" + this.tempCounter++ + "%", 2, type, 0, 0, null);
        return this.newLir.symRef(newVar);
    }

    public LirNode newReg(String name, int type) {
        Symbol newVar = this.addSymbol(name, 2, type, 0, 0, null);
        return this.newLir.symRef(newVar);
    }

    public LirNode newFrame(String name, int type) {
        Symbol var;
        if (name == null) {
            name = ".TF" + this.tempCounter++;
        }
        if ((var = this.localSymtab.get(name)) != null) {
            if (var.type != type) {
                throw new CantHappenException();
            }
        } else {
            var = this.addSymbol(name, 1, type, 0, 0, null);
        }
        return this.newLir.symRef(var);
    }

    public void setForm(int form) {
        this.form = form;
    }

    public int form() {
        return this.form;
    }

    public int timeStamp() {
        return this.timeStamp;
    }

    public void touch() {
        ++this.timeStamp;
    }

    public void purgeAnalysis() {
        this.analyses.clear();
    }

    public LocalAnalysis apply(LocalAnalyzer analyzer) {
        long start = 0L;
        if (this.root.GCflush) {
            this.root.timer.gcReport(this.root.debOut);
        }
        if (this.root.dispIntervalTime) {
            start = this.root.timer.getLaptime();
        }
        LocalAnalysis analysis = analyzer.doIt(this);
        this.analyses.put(analyzer, analysis);
        if (this.root.dispIntervalTime) {
            this.root.debOut.println("- Function " + this.symbol.name + ": " + analyzer.name() + ": " + this.root.timer.getIntervalTime(start) + " lap:" + this.module.elapsedTime());
        }
        if (this.root.traceOK(analyzer.name(), 1)) {
            this.root.debOut.println();
            this.root.debOut.println("Analysis " + analyzer.name() + ":");
            this.printIt(this.root.debOut, new LocalAnalysis[]{analysis});
        }
        return analysis;
    }

    public LocalAnalysis require(LocalAnalyzer analyzer) {
        LocalAnalysis ana = (LocalAnalysis)this.analyses.get(analyzer);
        if (ana == null || !ana.isUpToDate()) {
            ana = this.apply(analyzer);
        }
        return ana;
    }

    public boolean apply(Object trans) {
        if (trans instanceof ImList) {
            return this.apply((ImList)trans);
        }
        if (trans instanceof BiList) {
            return this.apply((BiList)trans);
        }
        if (trans instanceof Object[]) {
            return this.apply((Object[])trans);
        }
        if (trans instanceof LocalTransformer) {
            return this.apply((LocalTransformer)trans);
        }
        if (trans instanceof String) {
            return this.apply(this.root.getHook((String)trans));
        }
        throw new CantHappenException("Unexpected type: " + trans.getClass());
    }

    public boolean apply(String hook) {
        Object trans = this.root.getHook(hook);
        if (trans == null) {
            if (hook.charAt(0) != '+') {
                throw new CantHappenException("Undefined Hook: " + hook);
            }
            return true;
        }
        return this.apply(trans);
    }

    public boolean apply(ImList transList) {
        ImList p = transList;
        while (!p.atEnd()) {
            if (!this.apply(p.elem())) {
                return false;
            }
            p = p.next();
        }
        return true;
    }

    public boolean apply(BiList transList) {
        BiLink p = transList.first();
        while (!p.atEnd()) {
            if (!this.apply(p.elem())) {
                return false;
            }
            p = p.next();
        }
        return true;
    }

    public boolean apply(Object[] transVector) {
        for (int i = 0; i < transVector.length; ++i) {
            if (this.apply(transVector[i])) continue;
            return false;
        }
        return true;
    }

    public boolean apply(LocalTransformer xformer) {
        return this.apply(xformer, ImList.list());
    }

    public boolean apply(LocalTransformer xformer, ImList args) {
        if (this.root.traceOK(xformer.name(), 2)) {
            this.root.debOut.println();
            this.root.debOut.println("Before " + xformer.name() + " (" + xformer.subject() + "):");
            this.printIt(this.root.debOut);
        }
        if (this.root.GCflush) {
            this.root.timer.gcReport(this.root.debOut);
        }
        long start = this.root.timer.getLaptime();
        boolean ok = xformer.doIt(this, args);
        if (this.root.dispIntervalTime) {
            this.root.debOut.println("- Function " + this.symbol.name + ": " + xformer.name() + ": " + this.root.timer.getIntervalTime(start) + " lap:" + this.module.elapsedTime());
        }
        if (this.root.traceOK(xformer.name(), 1)) {
            this.root.debOut.println();
            this.root.debOut.println("After " + xformer.name() + " (" + xformer.subject() + "):");
            this.printIt(this.root.debOut);
        }
        return ok;
    }

    private void toMachineCode() {
        this.apply(LiveRange.trig);
        this.apply(JumpOpt.trig);
        this.apply(JumpCanon.trig);
        this.apply("+BeforeFirstInstSel");
        this.apply(this.module.targetMachine.instSelTrig);
        this.apply("+AfterFirstInstSel");
        int count = 0;
        while (true) {
            if (count++ >= 7) {
                throw new CantHappenException("Looks like an infinite loop during Register allocation");
            }
            if (this.apply(RegisterAllocation.trig)) break;
            this.apply("+BeforeSecondInstSel");
            this.apply(this.module.targetMachine.instSelTrig);
            this.apply("+AfterSecondInstSel");
        }
        this.postProcess();
    }

    private void postProcess() {
        BiLink next;
        BiLink p = this.flowGraph().basicBlkList.first();
        if (p.atEnd()) {
            return;
        }
        while (!(next = p.next()).atEnd()) {
            Label[] targets;
            BasicBlk blk = (BasicBlk)p.elem();
            BasicBlk nextBlk = (BasicBlk)next.elem();
            LirNode ins = (LirNode)blk.instrList().last().elem();
            if (ins.opCode == 49 && (targets = ins.getTargets())[0].basicBlk() == nextBlk) {
                blk.instrList().last().unlink();
            }
            p = next;
        }
    }

    public Object toSexp() {
        ImList list = ImList.Empty;
        list = new ImList("FUNCTION", list);
        list = new ImList(new QuotedString(this.symbol.name), list);
        list = new ImList(this.localSymtab.toSexp(), list);
        list = ((ImList)this.flowGraph().toSexp()).destructiveReverse(list);
        return list.destructiveReverse();
    }

    public void printStandardForm(PrintWriter out) {
        out.println("(FUNCTION \"" + this.symbol.name + "\"");
        this.localSymtab.printStandardForm(out, "  ");
        this.flowGraph().printStandardForm(out, "  ");
        out.println(")");
    }

    public void printIt(PrintWriter out) {
        this.printIt(out, emptyAnares);
    }

    public void printIt(PrintWriter out, LocalAnalyzer[] anals) {
        LocalAnalysis[] anares;
        if (anals != null) {
            anares = new LocalAnalysis[anals.length];
            for (int i = 0; i < anals.length; ++i) {
                anares[i] = this.require(anals[i]);
            }
        } else {
            anares = emptyAnares;
        }
        this.printIt(out, anares);
    }

    public void printIt(PrintWriter out, LocalAnalysis[] anals) {
        int i;
        out.println();
        out.println("Function \"" + this.symbol.name + "\":");
        for (i = 0; i < anals.length; ++i) {
            anals[i].printBeforeFunction(out);
        }
        out.print(" Local ");
        this.localSymtab.printIt(out);
        out.println();
        if (this.flowGraph != null) {
            out.println(" Control Flow Graph:");
            this.flowGraph().printIt(out, anals);
        } else {
            out.println(" L-expression List:");
            BiLink p = this.lirList().first();
            while (!p.atEnd()) {
                LirNode node = (LirNode)p.elem();
                if (node.opCode == 52) {
                    out.print("  ");
                } else {
                    out.print("   ");
                }
                out.println(node.toString());
                p = p.next();
            }
        }
        for (i = 0; i < anals.length; ++i) {
            anals[i].printAfterFunction(out);
        }
        out.println("End Function");
        out.println();
    }

    public String toString() {
        return "<Function " + this.symbol.name + ">";
    }

    private static class ToLinear
    implements LocalTransformer {
        private ToLinear() {
        }

        public boolean doIt(Function func, ImList args) {
            func.lirList();
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "ToLinear";
        }

        public String subject() {
            return "Conversion to Linear (non-CFG) Form";
        }
    }

    private static class ToCFG
    implements LocalTransformer {
        private ToCFG() {
        }

        public boolean doIt(Function func, ImList args) {
            func.flowGraph();
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "ToCFG";
        }

        public String subject() {
            return "Conversion to Control Flow Graph";
        }
    }
}

