/*
 * Decompiled with CFR 0.152.
 */
package coins.backend;

import coins.backend.CantHappenException;
import coins.backend.Module;
import coins.backend.Type;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.SymTab;
import coins.backend.sym.Symbol;
import coins.backend.util.BitMapSet;
import coins.backend.util.NumberSet;
import java.util.HashMap;
import java.util.Map;

public abstract class MachineParams {
    private int nRegisters;
    private int nRegsets;
    private Symbol[] regSymbol;
    private short[] symbolRegTbl;
    private short[][] overlapRegVec;
    private short[][] superRegVec;
    private short[][] subRegVec;
    private Map regsetTable = new HashMap();
    private BitMapSet[] bitMapVec;
    private short[] regsetNAvailVec;
    private int[] andTbl;
    private char[] weightTbl;
    private int[] regsetTypeTbl;
    private Module module;
    private SymTab symTab;

    public void addRequired(SymTab symtbl) {
    }

    public abstract int nRegisters();

    public abstract int nRegsets();

    public abstract int typeAddress();

    public abstract int typeBool();

    public abstract String[] getSymName();

    public abstract int[] getSymType();

    public abstract int[] getSymRegNumber();

    public abstract short[][] getOverlapReg();

    public abstract short[][] getSuperReg();

    public abstract short[][] getSubReg();

    public abstract String[] getRegsetName();

    public abstract int[] getRegsetNumber();

    public abstract short[][] getRegsetMap();

    public abstract short[] getRegsetNAvail();

    public abstract int[] getCompAndTbl();

    public abstract int[] getCompWeightTbl();

    public abstract int[] getRegsetTypeTbl();

    public void init(Module mod, SymTab symTab) {
        int i;
        int i2;
        int i3;
        this.module = mod;
        this.symTab = symTab;
        this.nRegisters = this.nRegisters();
        this.nRegsets = this.nRegsets();
        this.regSymbol = new Symbol[this.nRegisters];
        String[] symName = this.getSymName();
        int[] symType = this.getSymType();
        int[] symRegNumber = this.getSymRegNumber();
        int maxId = 0;
        for (i3 = 0; i3 < symName.length; ++i3) {
            Symbol s = symTab.addSymbol(symName[i3], 2, symType[i3], Type.bytes(symType[i3]), 0, null);
            if (symRegNumber[i3] != 0) {
                this.regSymbol[symRegNumber[i3]] = s;
            }
            if (s.id <= maxId) continue;
            maxId = s.id;
        }
        this.symbolRegTbl = new short[maxId + 1];
        for (i3 = 0; i3 < symName.length; ++i3) {
            if (symRegNumber[i3] == 0) continue;
            this.symbolRegTbl[this.regSymbol[symRegNumber[i3]].id] = (short)symRegNumber[i3];
        }
        this.overlapRegVec = this.getOverlapReg();
        this.superRegVec = this.getSuperReg();
        this.subRegVec = this.getSubReg();
        String[] regsetName = this.getRegsetName();
        int[] regsetNumber = this.getRegsetNumber();
        for (i2 = 0; i2 < regsetName.length; ++i2) {
            this.regsetTable.put(regsetName[i2], new Integer(regsetNumber[i2]));
        }
        this.regsetNAvailVec = this.getRegsetNAvail();
        this.bitMapVec = new BitMapSet[this.nRegsets];
        for (i2 = 0; i2 < this.nRegsets; ++i2) {
            this.bitMapVec[i2] = new BitMapSet();
        }
        for (i2 = 1; i2 < this.nRegisters; ++i2) {
            this.bitMapVec[i2].add(i2);
        }
        short[][] regsetMap = this.getRegsetMap();
        for (int i4 = this.nRegisters; i4 < this.nRegsets; ++i4) {
            for (int j = 0; j < regsetMap[i4 - this.nRegisters].length; ++j) {
                this.bitMapVec[i4].add(regsetMap[i4 - this.nRegisters][j]);
            }
        }
        int[] compAndTbl = this.getCompAndTbl();
        this.andTbl = new int[this.nRegsets * (this.nRegsets - 1) / 2];
        int k = 0;
        for (i = 0; i < compAndTbl.length; ++i) {
            if (compAndTbl[i] <= 0) {
                k = -compAndTbl[i];
                continue;
            }
            this.andTbl[k++] = compAndTbl[i];
        }
        int[] compWeightTbl = this.getCompWeightTbl();
        this.weightTbl = new char[this.nRegsets * this.nRegsets];
        for (i = 0; i < compWeightTbl.length; i += 2) {
            int k2 = compWeightTbl[i];
            int w = compWeightTbl[i + 1] % 64;
            for (int n = compWeightTbl[i + 1] / 64; n > 0; --n) {
                this.weightTbl[k2++] = (char)w;
            }
        }
        this.regsetTypeTbl = this.getRegsetTypeTbl();
        this.addRequired(symTab);
    }

    public int registerIndex(LirNode node) {
        Symbol sym;
        switch (node.opCode) {
            case 6: {
                sym = ((LirSymRef)node).symbol;
                break;
            }
            case 7: {
                int position = (int)((LirIconst)node.kid((int)1)).value;
                String parent = ((LirSymRef)node.kid((int)0)).symbol.name;
                String name = parent + "/" + Type.toString(node.type) + "/" + position;
                sym = this.symTab.get(name);
                if (sym != null) break;
                return this.registerIndex(node.kid(0));
            }
            default: {
                throw new CantHappenException("REG expected");
            }
        }
        return this.registerIndex(sym);
    }

    public int registerIndex(Symbol sym) {
        if (sym.id >= this.symbolRegTbl.length) {
            return 0;
        }
        return this.symbolRegTbl[sym.id];
    }

    public Symbol registerSymbol(int reg) {
        return this.regSymbol[reg];
    }

    public LirNode registerLir(int reg) {
        Symbol sym = this.regSymbol[reg];
        String name = sym.name;
        int p = name.indexOf(47);
        if (p >= 0) {
            Symbol parent = this.symTab.get(name.substring(0, p));
            int q = name.indexOf(47, p + 1);
            if (q >= 0) {
                int pos = Integer.parseInt(name.substring(q + 1));
                int type = sym.type;
                return this.module.newLir.node(7, type, this.module.newLir.symRef(parent), this.module.newLir.untaggedIconst(this.typeAddress(), pos));
            }
        }
        return this.module.newLir.symRef(sym);
    }

    public String registerToString(int reg) {
        if (reg == 0) {
            return "(nullreg)";
        }
        return this.regSymbol[reg].printName();
    }

    public int getRegSet(String name) {
        Integer n = (Integer)this.regsetTable.get(name);
        if (n == null) {
            throw new CantHappenException("Undefined regset: " + name);
        }
        return n;
    }

    public int regSetType(int set) {
        return this.regsetTypeTbl[set];
    }

    public int getRegSetType(String name) {
        if (name == null) {
            throw new Error("arg: null");
        }
        return this.regsetTypeTbl[this.getRegSet(name)];
    }

    public BitMapSet regSetMap(int set) {
        return this.bitMapVec[set];
    }

    public int nAvail(int set) {
        return this.regsetNAvailVec[set];
    }

    public int andSet(int setx, int sety) {
        if (setx == sety) {
            return setx;
        }
        if (setx < sety) {
            int w = setx;
            setx = sety;
            sety = w;
        }
        return this.andTbl[setx * (setx - 1) / 2 + sety];
    }

    public int igWeight(int setx, int sety) {
        return this.weightTbl[setx * this.nRegsets + sety];
    }

    public void removeRegister(BitMapSet set, int reg) {
        if (reg >= this.nRegisters) {
            return;
        }
        set.remove(reg);
        for (int i = 0; i < this.overlapRegVec[reg].length; ++i) {
            set.remove(this.overlapRegVec[reg][i]);
        }
    }

    public short[] overlapRegs(int reg) {
        return this.overlapRegVec[reg];
    }

    public boolean covered(int reg, NumberSet set) {
        if (reg >= this.nRegisters) {
            return false;
        }
        for (int i = 0; i < this.superRegVec[reg].length; ++i) {
            if (!set.contains(this.superRegVec[reg][i])) continue;
            return true;
        }
        return false;
    }

    public boolean isOverlapped(LirNode node1, LirNode node2) {
        int index1 = this.registerIndex(node1);
        int index2 = this.registerIndex(node2);
        if (index1 == 0 || index2 == 0) {
            if (node1.opCode != node2.opCode) {
                if (node1.opCode == 7) {
                    node1 = (LirSymRef)node1.kid(0);
                }
                if (node2.opCode == 7) {
                    node2 = (LirSymRef)node2.kid(0);
                }
            }
            return node1 == node2;
        }
        if (index1 == index2) {
            return true;
        }
        if (index1 >= this.nRegisters || index2 >= this.nRegisters) {
            return false;
        }
        for (int i = 0; i < this.overlapRegVec[index1].length; ++i) {
            if (this.overlapRegVec[index1][i] != index2) continue;
            return true;
        }
        return false;
    }

    public short[] subRegs(int reg) {
        return this.subRegVec[reg >= this.nRegisters ? 0 : reg];
    }
}

