/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.ana;

import coins.backend.Function;
import coins.backend.LocalAnalysis;
import coins.backend.LocalAnalyzer;
import coins.backend.ana.Postdominators;
import coins.backend.ana.ReverseDFST;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import java.io.PrintWriter;

public class ControlDependences
implements LocalAnalysis {
    public static final Analyzer analyzer = new Analyzer();
    public final BiList[] frontiers;
    private Function function;
    private FlowGraph flowGraph;
    private int timeStamp;

    private ControlDependences(Function func) {
        this.function = func;
        this.flowGraph = func.flowGraph();
        this.timeStamp = this.flowGraph.timeStamp();
        this.frontiers = new BiList[this.flowGraph.idBound()];
        this.addFrontiers(this.flowGraph.exitBlk(), (Postdominators)func.require(Postdominators.analyzer));
    }

    private void addFrontiers(BasicBlk blk, Postdominators d) {
        BasicBlk pred;
        BiLink p = d.kids[blk.id].first();
        while (!p.atEnd()) {
            this.addFrontiers((BasicBlk)p.elem(), d);
            p = p.next();
        }
        this.frontiers[blk.id] = new BiList();
        p = blk.predList().first();
        while (!p.atEnd()) {
            pred = (BasicBlk)p.elem();
            if (d.idom[pred.id] != blk) {
                this.frontiers[blk.id].add(pred);
            }
            p = p.next();
        }
        p = blk.dummyPredList().first();
        while (!p.atEnd()) {
            pred = (BasicBlk)p.elem();
            if (d.idom[pred.id] != blk) {
                this.frontiers[blk.id].add(pred);
            }
            p = p.next();
        }
        p = d.kids[blk.id].first();
        while (!p.atEnd()) {
            BasicBlk kid = (BasicBlk)p.elem();
            BiLink q = this.frontiers[kid.id].first();
            while (!q.atEnd()) {
                BasicBlk front = (BasicBlk)q.elem();
                if (d.idom[front.id] != blk) {
                    this.frontiers[blk.id].addNew(front);
                }
                q = q.next();
            }
            p = p.next();
        }
    }

    public boolean isUpToDate() {
        return this.timeStamp == this.flowGraph.timeStamp();
    }

    public void printIt(PrintWriter out) {
        this.printAfterFunction(out);
    }

    public void printBeforeFunction(PrintWriter output) {
    }

    public void printBeforeBlock(BasicBlk blk, PrintWriter output) {
    }

    public void printAfterBlock(BasicBlk blk, PrintWriter output) {
    }

    public void printBeforeStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterFunction(PrintWriter out) {
        ReverseDFST dfst = (ReverseDFST)this.function.require(ReverseDFST.analyzer);
        out.println();
        out.println("Control Dependences:");
        BiLink p = this.flowGraph.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            if (dfst.dfn[blk.id] != 0) {
                out.print("#" + blk.id + ": ");
                boolean top = true;
                BiLink f = this.frontiers[blk.id].first();
                while (!f.atEnd()) {
                    if (!top) {
                        out.print(",");
                    }
                    out.print("#" + ((BasicBlk)f.elem()).id);
                    top = false;
                    f = f.next();
                }
                out.println();
            }
            p = p.next();
        }
    }

    private static class Analyzer
    implements LocalAnalyzer {
        private Analyzer() {
        }

        public LocalAnalysis doIt(Function func) {
            return new ControlDependences(func);
        }

        public String name() {
            return "ControlDependences";
        }
    }
}

