/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.ana;

import coins.backend.Function;
import coins.backend.LocalAnalysis;
import coins.backend.LocalAnalyzer;
import coins.backend.Root;
import coins.backend.ana.EnumRegVars;
import coins.backend.ana.LiveVariableAnalysis;
import coins.backend.ana.LiveVariableSlotwise;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BitMapSet;
import coins.backend.util.HashNumberSet;
import coins.backend.util.Misc;
import coins.backend.util.NumberSet;
import coins.backend.util.VectorSet;
import java.io.PrintWriter;

public class InterferenceGraph
implements LocalAnalysis {
    public static final Analyzer analyzer = new Analyzer();
    public static final Analyzer2 analyzerCopyNotInterfere = new Analyzer2();
    private Root root;
    private Function function;
    private int timeStamp;
    private EnumRegVars rn;
    private LiveVariableAnalysis liveInfo;
    private NumberSet adjMatrix;
    private static final boolean UseAdjMatrix = false;
    private NumberSet[] interfereSets;
    private NumberSet[] disturbSets;

    private InterferenceGraph(Function func, boolean copyNotInterfere) {
        int i;
        this.function = func;
        this.root = func.root;
        this.timeStamp = func.timeStamp();
        this.rn = (EnumRegVars)func.require(EnumRegVars.analyzer);
        this.liveInfo = (LiveVariableAnalysis)func.require(LiveVariableSlotwise.analyzer);
        int nRegvars = this.rn.nRegvars();
        LirNode.Scanner scan = new LirNode.Scanner();
        this.interfereSets = new NumberSet[nRegvars];
        for (i = 0; i < nRegvars; ++i) {
            this.interfereSets[i] = new HashNumberSet(nRegvars);
        }
        this.disturbSets = new NumberSet[nRegvars];
        for (i = 0; i < nRegvars; ++i) {
            this.disturbSets[i] = new BitMapSet(nRegvars);
        }
        VectorSet live = new VectorSet(nRegvars);
        VectorSet work = new VectorSet(nRegvars);
        BiLink p = func.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            this.liveInfo.getLiveOutSet(live, blk);
            BiLink q = blk.instrList().last();
            while (!q.atEnd()) {
                Object it;
                int def;
                LirNode stmt = (LirNode)q.elem();
                if (stmt.opCode == 59) {
                    def = this.rn.index(stmt.kid(0));
                    NumberSet.Iterator it2 = live.iterator();
                    while (it2.hasNext()) {
                        int vliv = it2.next();
                        this.setInterfere(def, vliv);
                        this.setDisturb(def, vliv);
                    }
                    live.remove(def);
                } else if (copyNotInterfere && this.isCopyStatement(stmt)) {
                    int vliv;
                    def = this.rn.index(stmt.kid(0));
                    int use = this.rn.index(stmt.kid(1));
                    it = live.iterator();
                    while (it.hasNext()) {
                        vliv = it.next();
                        if (vliv == use) continue;
                        this.setInterfere(def, vliv);
                        this.setDisturb(def, vliv);
                    }
                    live.remove(def);
                    live.add(use);
                    it = live.iterator();
                    while (it.hasNext()) {
                        vliv = it.next();
                        this.setDisturb(use, vliv);
                    }
                } else {
                    int vliv;
                    int def2;
                    NumberSet.Iterator is;
                    int use;
                    boolean clobberAfterDef;
                    boolean useAfterDef = stmt.opt.locate("&use-after-def") != null;
                    boolean bl = clobberAfterDef = stmt.opt.locate("&clobber-after-def") != null;
                    if (useAfterDef) {
                        it = scan.forUses(stmt);
                        while (it.hasNext()) {
                            use = this.rn.index((LirNode)it.next());
                            if (use == 0) continue;
                            live.add(use);
                        }
                        it = scan.forUses(stmt);
                        while (it.hasNext()) {
                            use = this.rn.index((LirNode)it.next());
                            if (use == 0) continue;
                            is = live.iterator();
                            while (is.hasNext()) {
                                this.setDisturb(use, is.next());
                            }
                        }
                    }
                    if (clobberAfterDef) {
                        work.clear();
                        it = scan.forClobbers(stmt);
                        while (it.hasNext()) {
                            def2 = this.rn.index((LirNode)it.next());
                            if (def2 == 0) continue;
                            work.add(def2);
                            is = live.iterator();
                            while (is.hasNext()) {
                                vliv = is.next();
                                this.setInterfere(def2, vliv);
                                this.setDisturb(def2, vliv);
                            }
                        }
                        live.removeAll(work);
                    }
                    work.clear();
                    it = scan.forDefs(stmt);
                    while (it.hasNext()) {
                        def2 = this.rn.index((LirNode)it.next());
                        if (def2 == 0) continue;
                        work.add(def2);
                        is = live.iterator();
                        while (is.hasNext()) {
                            vliv = is.next();
                            this.setInterfere(def2, vliv);
                            this.setDisturb(def2, vliv);
                        }
                    }
                    live.removeAll(work);
                    if (!clobberAfterDef) {
                        work.clear();
                        it = scan.forClobbers(stmt);
                        while (it.hasNext()) {
                            def2 = this.rn.index((LirNode)it.next());
                            if (def2 == 0) continue;
                            work.add(def2);
                            is = live.iterator();
                            while (is.hasNext()) {
                                vliv = is.next();
                                this.setInterfere(def2, vliv);
                                this.setDisturb(def2, vliv);
                            }
                        }
                        live.removeAll(work);
                    }
                    if (!useAfterDef) {
                        it = scan.forUses(stmt);
                        while (it.hasNext()) {
                            use = this.rn.index((LirNode)it.next());
                            if (use == 0) continue;
                            live.add(use);
                        }
                        it = scan.forUses(stmt);
                        while (it.hasNext()) {
                            use = this.rn.index((LirNode)it.next());
                            if (use == 0) continue;
                            is = live.iterator();
                            while (is.hasNext()) {
                                this.setDisturb(use, is.next());
                            }
                        }
                    }
                }
                q = q.prev();
            }
            p = p.next();
        }
    }

    private boolean isCopyStatement(LirNode stmt) {
        return stmt.opCode == 48 && stmt.kid((int)0).opCode == 6 && stmt.kid((int)1).opCode == 6;
    }

    public boolean setInterfere(Symbol x, Symbol y) {
        return this.setInterfere(this.rn.index(x), this.rn.index(y));
    }

    public boolean setInterfere(int x, int y) {
        if (x >= 0 && y >= 0 && x != y && !this.interfereSets[x].contains(y)) {
            this.interfereSets[x].add(y);
            this.interfereSets[y].add(x);
            return true;
        }
        return false;
    }

    public boolean unsetInterfere(int x, int y) {
        if (x >= 0 && y >= 0 && x != y && this.interfereSets[x].contains(y)) {
            this.interfereSets[x].remove(y);
            this.interfereSets[y].remove(x);
            return true;
        }
        return false;
    }

    public void setDisturb(Symbol x, Symbol y) {
        this.setDisturb(this.rn.index(x), this.rn.index(y));
    }

    public void setDisturb(int x, int y) {
        if (x >= 0 && y >= 0 && x != y && !this.disturbSets[y].contains(x)) {
            this.disturbSets[y].add(x);
        }
    }

    public boolean interfere(int x, int y) {
        if (x == y) {
            return false;
        }
        return this.interfereSets[x].contains(y);
    }

    public boolean interfere(Symbol x, Symbol y) {
        return this.interfere(this.rn.index(x), this.rn.index(y));
    }

    public NumberSet interfereSet(int x) {
        return this.interfereSets[x];
    }

    public NumberSet interfereSet(Symbol x) {
        return this.interfereSets[this.rn.index(x)];
    }

    public NumberSet disturbSet(int x) {
        return this.disturbSets[x];
    }

    public NumberSet disturbSet(Symbol x) {
        return this.disturbSets[this.rn.index(x)];
    }

    public int disturbingFactor(int x) {
        int n = 0;
        for (int i = 0; i < this.disturbSets.length; ++i) {
            if (!this.disturbSets[i].contains(x)) continue;
            ++n;
        }
        return n;
    }

    public int disturbedFactor(int x) {
        return this.disturbSets[x].size();
    }

    public boolean isUpToDate() {
        return this.timeStamp == this.function.timeStamp();
    }

    public void printBeforeFunction(PrintWriter output) {
    }

    public void printBeforeBlock(BasicBlk blk, PrintWriter output) {
    }

    public void printAfterBlock(BasicBlk blk, PrintWriter output) {
    }

    public void printBeforeStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterFunction(PrintWriter output) {
        int j;
        int m;
        int i;
        int n = this.rn.nRegvars();
        int pn = this.rn.nPhyRegs();
        int[] v = new int[n];
        output.println();
        output.println("Interference Graph:");
        int popul = 0;
        for (i = 1; i < n; ++i) {
            m = this.interfereSets[i].size();
            if (i < pn && m == 0) continue;
            output.print(this.rn.toString(i) + ":");
            popul += m;
            this.interfereSets[i].toArray(v);
            Misc.sort(v, m);
            for (j = 0; j < m; ++j) {
                output.print(" " + this.rn.toString(v[j]));
            }
            output.println();
        }
        output.println("IG Total entry: " + popul + ", " + popul * 100 / (n * n) + "%");
        output.println();
        output.println("Disturbance Graph:");
        popul = 0;
        for (i = 1; i < n; ++i) {
            m = this.disturbSets[i].size();
            if (i < pn && m == 0) continue;
            output.print(this.rn.toString(i) + ":");
            popul += m;
            this.disturbSets[i].toArray(v);
            Misc.sort(v, m);
            for (j = 0; j < m; ++j) {
                output.print(" " + this.rn.toString(v[j]));
            }
            output.println();
        }
        output.println("DG Total entry: " + popul + ", " + popul * 100 / (n * n) + "%");
    }

    private static class Analyzer2
    implements LocalAnalyzer {
        private Analyzer2() {
        }

        public LocalAnalysis doIt(Function func) {
            return new InterferenceGraph(func, true);
        }

        public String name() {
            return "InterferenceGraph2";
        }
    }

    private static class Analyzer
    implements LocalAnalyzer {
        private Analyzer() {
        }

        public LocalAnalysis doIt(Function func) {
            return new InterferenceGraph(func, false);
        }

        public String name() {
            return "InterferenceGraph";
        }
    }
}

