/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.lir;

import coins.backend.Op;
import coins.backend.Type;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirVisitor;
import coins.backend.util.ImList;

public class LirFconst
extends LirNode {
    public final double value;

    public LirFconst(int id, int t, double v, ImList opt) {
        super(id, 3, t, opt);
        this.value = v;
    }

    public LirNode makeCopy(LirFactory fac) {
        return fac.fconst(this.type, this.value, this.opt);
    }

    public LirNode replaceOptions(LirFactory fac, ImList newOpt) {
        return fac.fconst(this.type, this.value, newOpt);
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >> 32 ^ (long)this.type);
    }

    public Object toSexp() {
        if (this.opt.locate("&untagged") != null) {
            return Double.toString(this.value).intern();
        }
        return ImList.list(Op.toName(this.opCode), Type.toString(this.type), this.value + "").append(this.opt.makeCopy());
    }

    public String toString() {
        if (this.opt.locate("&untagged") != null) {
            return Double.toString(this.value);
        }
        return "(" + Op.toName(this.opCode) + " " + Type.toString(this.type) + " " + this.value + "" + ")";
    }

    public boolean equals(Object x) {
        return x instanceof LirFconst && super.equals(x) && this.value == ((LirFconst)x).value;
    }

    public void accept(LirVisitor v) {
        v.visit(this);
    }
}

