/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.opt;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Root;
import coins.backend.ana.DominanceFrontiers;
import coins.backend.ana.Dominators;
import coins.backend.ana.EnumRegVars;
import coins.backend.ana.LiveVariableAnalysis;
import coins.backend.ana.LiveVariableSlotwise;
import coins.backend.ana.ScanVarReference;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;
import java.util.Stack;

public class Ssa {
    private Root root;
    private Function function;
    private Dominators dom;
    private boolean pruned;
    private EnumRegVars rn;
    private boolean[] dojob;
    private static final boolean keepOriginalSymbol = false;

    public static LocalTransformer trigger(String type) {
        return new SsaTrigger(type);
    }

    public Ssa(boolean pruned) {
        this.pruned = pruned;
    }

    public static Ssa minimal() {
        return new Ssa(false);
    }

    public static Ssa pruned() {
        return new Ssa(true);
    }

    public void doIt(Function f) {
        this.doIt(f, null);
    }

    public void doIt(Function f, ImList args) {
        this.function = f;
        this.root = f.root;
        FlowGraph flowGraph = f.flowGraph();
        DominanceFrontiers df = (DominanceFrontiers)f.require(DominanceFrontiers.analyzer);
        this.dom = (Dominators)f.require(Dominators.analyzer);
        this.rn = (EnumRegVars)f.require(EnumRegVars.analyzer);
        ScanVarReference sc = (ScanVarReference)f.require(ScanVarReference.analyzer);
        int nRegvars = this.rn.nRegvars();
        this.dojob = new boolean[nRegvars];
        if (args != null && !args.atEnd()) {
            ImList p = args;
            while (!p.atEnd()) {
                Symbol var = (Symbol)p.elem();
                this.dojob[this.rn.index((Symbol)var)] = true;
                p = p.next();
            }
        } else {
            for (int i = 1; i < nRegvars; ++i) {
                this.dojob[i] = true;
            }
        }
        LiveVariableAnalysis live = null;
        if (this.pruned) {
            live = (LiveVariableAnalysis)f.require(LiveVariableSlotwise.analyzer);
        }
        if (this.root.traceOK("Ssa", 2)) {
            this.dom.printIt(this.root.debOut);
        }
        int insBound = f.newLir.idBound();
        BasicBlk[] worklist = new BasicBlk[insBound];
        int[] inWork = new int[insBound];
        int[] hasAlready = new int[insBound];
        int nwork = 0;
        int iterCount = 0;
        for (int i = 1; i < nRegvars; ++i) {
            if (sc.useSites[i] == null || sc.defSites[i] == null || !this.dojob[i]) continue;
            ++iterCount;
            BiLink p = sc.defSites[i].first();
            while (!p.atEnd()) {
                BasicBlk blk = (BasicBlk)p.elem();
                inWork[blk.id] = iterCount;
                worklist[nwork++] = blk;
                p = p.next();
            }
            while (nwork > 0) {
                BasicBlk blk = worklist[--nwork];
                BiLink q = df.frontiers[blk.id].first();
                while (!q.atEnd()) {
                    BasicBlk front = (BasicBlk)q.elem();
                    if (hasAlready[front.id] < iterCount && (!this.pruned || live.isLiveAtEntry(i, front))) {
                        int nPreds = front.predList().length() + 1;
                        LirNode[] operand = new LirNode[nPreds];
                        operand[0] = this.function.newLir.symRef(this.rn.toSymbol(i));
                        for (int j = 1; j < nPreds; ++j) {
                            operand[j] = operand[0];
                        }
                        front.instrList().addFirst(f.newLir.operator(59, this.rn.toSymbol((int)i).type, operand, null));
                        hasAlready[front.id] = iterCount;
                        if (inWork[front.id] < iterCount) {
                            inWork[front.id] = iterCount;
                            worklist[nwork++] = front;
                        }
                    }
                    q = q.next();
                }
            }
        }
        if (this.root.traceOK("Ssa", 2)) {
            this.root.debOut.println("After PHI insertion:");
            flowGraph.printIt(this.root.debOut);
        }
        int[] nextVar = new int[nRegvars];
        LirNode[] curVar = new LirNode[nRegvars];
        for (int i = 1; i < nRegvars; ++i) {
            curVar[i] = this.function.newLir.symRef(this.rn.toSymbol(i));
        }
        this.renameInBlock(new Stack(), flowGraph.entryBlk(), nextVar, curVar);
        this.function.touch();
        this.function.setForm(1);
    }

    private void renameInBlock(Stack stack, BasicBlk blk, int[] nextVar, LirNode[] curVar) {
        int n;
        int level = stack.size();
        if (this.root.traceOK("Ssa", 2)) {
            this.root.debOut.println("** Entering block #" + blk.id);
        }
        BiLink q = blk.instrList().first();
        while (!q.atEnd()) {
            LirNode ins = (LirNode)q.elem();
            this.replaceRhs(ins, curVar);
            if (ins.opCode == 56) {
                n = ins.nKids();
                for (int i = 0; i < n; ++i) {
                    this.replaceLhs(stack, ins.kid(i), nextVar, curVar);
                }
            } else {
                this.replaceLhs(stack, ins, nextVar, curVar);
            }
            q = q.next();
        }
        BiLink s = blk.succList().first();
        while (!s.atEnd()) {
            BasicBlk succ = (BasicBlk)s.elem();
            n = succ.predList().whereIs(blk);
            BiLink q2 = succ.instrList().first();
            while (!q2.atEnd()) {
                LirNode ins = (LirNode)q2.elem();
                if (ins.opCode == 59) {
                    if (ins.kid((int)(1 + n)).opCode != 6) {
                        throw new IllegalArgumentException();
                    }
                    Symbol origVar = ((LirSymRef)ins.kid((int)(1 + n))).symbol;
                    if (this.root.traceOK("Ssa", 2)) {
                        this.root.debOut.println("** replace PHI: " + origVar.name + " to " + curVar[this.rn.index(origVar)]);
                    }
                    ins.setKid(1 + n, this.function.newLir.operator(61, 0, curVar[this.rn.index(origVar)], this.function.newLir.labelRef(blk.label()), null));
                }
                q2 = q2.next();
            }
            s = s.next();
        }
        Object p = this.dom.kids[blk.id].first();
        while (!((BiLink)p).atEnd()) {
            BasicBlk kid = (BasicBlk)((BiLink)p).elem();
            this.renameInBlock(stack, kid, nextVar, curVar);
            p = ((BiLink)p).next();
        }
        while (stack.size() > level) {
            p = (Pair)stack.pop();
            curVar[this.rn.index((Symbol)((Pair)p).orig)] = ((Pair)p).top;
        }
    }

    private LirNode replaceRhs(LirNode ins, LirNode[] curVar) {
        switch (ins.opCode) {
            case 6: {
                if (ins.isPhysicalRegister()) break;
                return curVar[this.rn.index(ins)];
            }
            case 54: 
            case 59: {
                break;
            }
            case 48: {
                this.replaceRhs(ins.kid(0), curVar);
                ins.setKid(1, this.replaceRhs(ins.kid(1), curVar));
                break;
            }
            case 53: {
                ins.setKid(0, this.replaceRhs(ins.kid(0), curVar));
                this.replaceRhs(ins.kid(1), curVar);
                break;
            }
            default: {
                int n = ins.nKids();
                for (int i = 0; i < n; ++i) {
                    ins.setKid(i, this.replaceRhs(ins.kid(i), curVar));
                }
            }
        }
        return ins;
    }

    private void replaceLhs(Stack stack, LirNode ins, int[] nextVar, LirNode[] curVar) {
        switch (ins.opCode) {
            case 48: 
            case 59: {
                Symbol origVar;
                LirNode lhs = ins.kid(0);
                if (lhs.opCode != 6 || lhs.isPhysicalRegister() || !this.dojob[this.rn.index(origVar = ((LirSymRef)lhs).symbol)]) break;
                stack.push(new Pair(origVar, curVar[this.rn.index(origVar)]));
                ins.setKid(0, this.createNewVar(origVar, nextVar, curVar));
                break;
            }
            case 54: {
                int n = ins.nKids();
                for (int i = 1; i < n; ++i) {
                    Symbol origVar;
                    LirNode lhs = ins.kid(i);
                    if (lhs.opCode != 6 || lhs.isPhysicalRegister() || !this.dojob[this.rn.index(origVar = ((LirSymRef)lhs).symbol)]) continue;
                    stack.push(new Pair(origVar, curVar[this.rn.index(origVar)]));
                    ins.setKid(i, this.createNewVar(origVar, nextVar, curVar));
                }
                break;
            }
            case 53: {
                int n = ins.kid(2).nKids();
                for (int i = 0; i < n; ++i) {
                    Symbol origVar;
                    LirNode lhs = ins.kid(2).kid(i);
                    if (lhs.opCode != 6 || lhs.isPhysicalRegister() || !this.dojob[this.rn.index(origVar = ((LirSymRef)lhs).symbol)]) continue;
                    stack.push(new Pair(origVar, curVar[this.rn.index(origVar)]));
                    ins.kid(2).setKid(i, this.createNewVar(origVar, nextVar, curVar));
                }
                break;
            }
            case 58: {
                int n = ins.nKids();
                for (int i = 0; i < n; ++i) {
                    Symbol origVar;
                    LirNode lhs = ins.kid(i);
                    if (lhs.opCode != 6 || lhs.isPhysicalRegister() || !this.dojob[this.rn.index(origVar = ((LirSymRef)lhs).symbol)]) continue;
                    stack.push(new Pair(origVar, curVar[this.rn.index(origVar)]));
                    ins.setKid(0, this.createNewVar(origVar, nextVar, curVar));
                }
                break;
            }
        }
    }

    private LirNode createNewVar(Symbol origVar, int[] nextVar, LirNode[] curVar) {
        String newName = origVar.name + (origVar.name.charAt(origVar.name.length() - 1) != '%' ? "%" : "") + nextVar[this.rn.index(origVar)];
        Symbol newVar = this.function.addSymbol(newName, 2, origVar.type, origVar.boundary, 0, origVar.opt());
        int n = this.rn.index(origVar);
        nextVar[n] = nextVar[n] + 1;
        if (this.root.traceOK("Ssa", 2)) {
            this.root.debOut.println("** replace LHS: " + origVar.name + " to " + newVar.name);
        }
        curVar[this.rn.index((Symbol)origVar)] = this.function.newLir.symRef(newVar);
        return curVar[this.rn.index(origVar)];
    }

    private static class Pair {
        Symbol orig;
        LirNode top;

        Pair(Symbol orig, LirNode top) {
            this.orig = orig;
            this.top = top;
        }
    }

    private static class SsaTrigger
    implements LocalTransformer {
        private String type;

        SsaTrigger(String type) {
            this.type = type;
        }

        public boolean doIt(Function func, ImList args) {
            new Ssa(this.type == "pruned").doIt(func, args);
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "Ssa(" + this.type + ")";
        }

        public String subject() {
            return "Conversion to " + this.type + " SSA Form";
        }
    }
}

