/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.util;

public class QuotedString {
    public final String body;

    public QuotedString(String str) {
        this.body = str.intern();
    }

    public String toString() {
        return QuotedString.quoteString(this.body);
    }

    public int hashCode() {
        return this.body.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof QuotedString && ((QuotedString)obj).body.equals(this.body);
    }

    public static String quoteString(String s) {
        StringBuffer buff = new StringBuffer();
        char[] a = s.toCharArray();
        buff.append('\"');
        block9: for (int i = 0; i < a.length; ++i) {
            switch (a[i]) {
                case '\"': {
                    buff.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buff.append("\\\\");
                    continue block9;
                }
                case '\n': {
                    buff.append("\\n");
                    continue block9;
                }
                case '\t': {
                    buff.append("\\t");
                    continue block9;
                }
                case '\r': {
                    buff.append("\\r");
                    continue block9;
                }
                case '\b': {
                    buff.append("\\b");
                    continue block9;
                }
                case '\f': {
                    buff.append("\\f");
                    continue block9;
                }
                default: {
                    if (Character.isISOControl(a[i])) {
                        buff.append('\\');
                        buff.append(QuotedString.lastNchars("00" + Integer.toOctalString(a[i]), 3));
                        continue block9;
                    }
                    buff.append(a[i]);
                }
            }
        }
        buff.append('\"');
        return buff.toString();
    }

    private static String lastNchars(String s, int n) {
        return s.substring(s.length() - n);
    }
}

