/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.util;

import coins.backend.util.BitMapSet;
import coins.backend.util.HashNumberSet;
import coins.backend.util.NumberSet;
import coins.backend.util.VectorSet;
import java.util.Random;

class SetTest {
    Random r = new Random();

    SetTest() {
    }

    void test1(String kind, BitMapSet s, BitMapSet t) {
        System.out.println("Test for " + kind);
        s.add(1);
        s.add(100);
        s.add(5);
        s.add(33);
        s.add(7);
        System.out.println("s = " + s);
        s.remove(5);
        System.out.println("s = " + s);
        t.add(5);
        t.add(100);
        System.out.println("t = " + t);
        BitMapSet a = (BitMapSet)s.clone();
        System.out.println("a = " + a);
        a.join(t);
        System.out.println("a + t = " + a);
        a = (BitMapSet)s.clone();
        System.out.println("a = " + a);
        a.meet(t);
        System.out.println("a & t = " + a);
        a = (BitMapSet)s.clone();
        System.out.println("a = " + a);
        a.subtract(t);
        System.out.println("a - t = " + a);
        a = (BitMapSet)s.clone();
        a.add(500);
        System.out.println("a = " + a);
        System.out.println("s = " + s);
        System.out.println("a==s? = " + a.equals(s));
        System.out.println("s==a? = " + s.equals(a));
        a.remove(500);
        System.out.println("a = " + a);
        System.out.println("a==s? = " + a.equals(s));
        System.out.println("s==a? = " + s.equals(a));
    }

    void setprint(NumberSet x) {
        NumberSet.Iterator it = x.iterator();
        while (it.hasNext()) {
            System.out.print(" " + it.next());
        }
    }

    void fillRandom(NumberSet x, int n, int max) {
        for (int i = 0; i < n; ++i) {
            int v = this.r.nextInt(max);
            x.add(v);
        }
    }

    void compare(NumberSet x, NumberSet y) {
        String xname = x.getClass().getName();
        String yname = y.getClass().getName();
        if (x.size() != y.size()) {
            System.out.println(xname + " size " + x.size() + ", " + yname + " size " + y.size());
        }
        boolean ok = true;
        NumberSet.Iterator it = x.iterator();
        while (it.hasNext()) {
            int val = it.next();
            if (y.contains(val)) continue;
            System.out.println(xname + " x has " + val + " but " + yname + " y doesn't.");
            ok = false;
        }
        if (ok) {
            System.out.println(xname + " x and " + yname + " y match.");
        }
    }

    public void run() {
        int n = 50;
        int m = 1000;
        HashNumberSet h = new HashNumberSet(m);
        this.r.setSeed(77611071L);
        this.fillRandom(h, n, m);
        BitMapSet b = new BitMapSet(m);
        this.r.setSeed(77611071L);
        this.fillRandom(b, n, m);
        VectorSet v = new VectorSet(m);
        this.r.setSeed(77611071L);
        this.fillRandom(v, n, m);
        this.compare(h, b);
        this.compare(b, v);
        this.compare(v, h);
        System.out.println("Hash size: " + h.tableSize());
        this.r.setSeed(19580330L);
        v.clear();
        this.fillRandom(v, 100, m);
        h.addAll(v);
        b.addAll(v);
        this.compare(h, b);
        System.out.println("Hash size: " + h.tableSize());
        this.r.setSeed(77611071L);
        b.clear();
        this.fillRandom(b, n, m);
        this.r.setSeed(77611071L);
        v.clear();
        this.fillRandom(v, n, m);
        this.r.setSeed(19580330L);
        h.clear();
        this.fillRandom(h, 100, m);
        b.addAll(h);
        v.addAll(h);
        this.compare(b, v);
        System.out.println("Hash size: " + h.tableSize());
        this.r.setSeed(77611071L);
        v.clear();
        this.fillRandom(v, n, m);
        this.r.setSeed(77611071L);
        h.clear();
        this.fillRandom(h, n, m);
        this.r.setSeed(19580330L);
        b.clear();
        this.fillRandom(b, 100, m);
        v.addAll(b);
        h.addAll(b);
        this.compare(v, h);
        System.out.println("Hash size: " + h.tableSize());
    }

    public static void main(String[] argv) {
        new SetTest().run();
    }
}

