/*
 * Decompiled with CFR 0.152.
 */
package coins.casttohir;

import coins.casttohir.ToHir;
import coins.sym.Subp;
import coins.sym.Var;
import java.util.LinkedList;

class ConditionalReporter {
    private final ToHir toHir;
    private LinkedList longDoubleList = new LinkedList();
    private LinkedList vaArgList = new LinkedList();
    private LinkedList wideCharList = new LinkedList();

    public ConditionalReporter(ToHir tohir) {
        this.toHir = tohir;
    }

    void isSupportedType(Var var) {
        switch (var.getSymType().getTypeKind()) {
            case 18: {
                if (this.longDoubleList.contains(var)) break;
                this.longDoubleList.addFirst(var);
                this.toHir.warning("long double is not supported: " + var.getName());
            }
        }
    }

    void isVaArg(Subp subp) {
        String name = subp.getName();
        if ((name.equals("__builtin_next_arg") || name.equals("__builtin_saveregs") || name.equals("__builtin_va_start") || name.equals("__builtin_va_arg") || name.equals("__builtin_va_end")) && !this.vaArgList.contains(this.toHir.symRoot.subpCurrent)) {
            this.vaArgList.addFirst(this.toHir.symRoot.subpCurrent);
        }
    }

    void isWideChar(boolean wchar) {
        if (wchar && !this.wideCharList.contains(this.toHir.symRoot.subpCurrent)) {
            this.wideCharList.addFirst(this.toHir.symRoot.subpCurrent);
            this.toHir.warning("wchar_t is not supported: in " + (this.toHir.symRoot.subpCurrent == null ? "global" : this.toHir.symRoot.subpCurrent.getName() + "()"));
        }
    }
}

