/*
 * Decompiled with CFR 0.152.
 */
package coins.casttohir;

import coins.Debug;
import coins.FatalError;
import coins.HirRoot;
import coins.IoRoot;
import coins.MachineParam;
import coins.SymRoot;
import coins.ir.IrList;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.IfStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.QualifiedExpImpl;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubscriptedExp;
import coins.ir.hir.SubscriptedExpImpl;
import coins.ir.hir.SymNode;
import coins.ir.hir.VarNode;
import coins.sym.Label;
import coins.sym.PointerType;
import coins.sym.SubpType;
import coins.sym.Sym;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.ListIterator;

public class ToHir {
    final HirRoot hirRoot;
    final SymRoot symRoot;
    final IoRoot ioRoot;
    final Debug debug;
    final HIR hir;
    final Sym sym;
    final Type typeVoidPtr;
    final MachineParam machineParam;
    String nowFile;
    int nowLine;
    final boolean useSubsForPtr;
    final boolean useArrayParameterSize;
    final boolean useOldLir;
    final boolean optHirFromC;
    public final int fDbgLevel;

    public ToHir(HirRoot pHirRoot, boolean oldlir, boolean fromc) {
        this.hirRoot = pHirRoot;
        this.useOldLir = oldlir;
        this.optHirFromC = fromc;
        this.symRoot = pHirRoot.symRoot;
        this.ioRoot = pHirRoot.ioRoot;
        this.debug = this.ioRoot.dbgToHir;
        this.hir = this.hirRoot.hir;
        this.sym = this.hirRoot.sym;
        this.typeVoidPtr = this.sym.pointerType(this.symRoot.typeVoid);
        this.machineParam = this.ioRoot.machineParam;
        this.fDbgLevel = this.debug.getLevel();
        this.useSubsForPtr = true;
        this.useArrayParameterSize = true;
        this.message(1, "ToHir\n");
    }

    void message(int level, String mes) {
        this.ioRoot.dbgToHir.print(level, "  ", mes);
    }

    void warning(String mes) {
        this.ioRoot.msgWarning.put(3333, this.nowFile + " " + this.nowLine + ": " + mes);
        this.message(2, "WARNING; " + this.nowFile + " " + this.nowLine + ": " + mes);
    }

    void warning(Sym s, String mes) {
        this.ioRoot.msgWarning.put(3333, s.getDefinedFile() + " " + s.getDefinedLine() + ": " + mes);
        this.message(2, "WARNING; " + s.getDefinedFile() + " " + s.getDefinedLine() + ": " + mes);
    }

    void error(String mes) {
        if (this.nowFile == null) {
            return;
        }
        if (this.symRoot.subpCurrent != null) {
            this.symRoot.subpCurrent.addToErrorCount(1);
        }
        this.ioRoot.addToTotalErrorCount(1);
        this.ioRoot.msgError.put(4444, "" + this.nowFile + " " + this.nowLine + ": " + mes);
        this.message(2, "ERROR; " + this.nowFile + " " + this.nowLine + ": " + mes);
    }

    void error(Sym s, String mes) {
        this.ioRoot.addToTotalErrorCount(1);
        this.ioRoot.msgError.put(4444, s.getDefinedFile() + " " + s.getDefinedLine() + ": " + mes);
        this.message(2, "ERROR; " + s.getDefinedFile() + " " + s.getDefinedLine() + ": " + mes);
    }

    void fatal(String mes) {
        if (this.symRoot.subpCurrent != null) {
            this.symRoot.subpCurrent.addToErrorCount(1);
        }
        this.ioRoot.addToTotalErrorCount(1);
        throw new FatalError(0, mes + " (" + this.nowFile + ":" + this.nowLine + ")");
    }

    String getOp(HIR h) {
        return HIR.OP_CODE_NAME_DENSE[h.getOperator()];
    }

    Sym createBlockSym() {
        return this.symRoot.symTableCurrent.generateSym(null, 1, this.symRoot.subpCurrent.getName(), this.symRoot.symTableCurrent.getOwner());
    }

    Label createLabel(String name) {
        Label label = (Label)this.symRoot.symTableCurrentSubp.search(name.intern(), 14);
        if (label == null) {
            SymTable bak = this.symRoot.symTableCurrent;
            this.symRoot.symTableCurrent = this.getSubpTable();
            label = this.sym.defineLabel(name.intern());
            this.symRoot.symTableCurrent = bak;
        }
        return label;
    }

    Label createLabel() {
        Label label = this.getSubpTable().generateLabel();
        label.setDefinedIn(this.symRoot.subpCurrent);
        return label;
    }

    SymTable getSubpTable() {
        return this.symRoot.symTableCurrentSubp != null ? this.symRoot.symTableCurrentSubp : this.symRoot.symTableRoot;
    }

    Sym searchGlobalOrdinaryId(String name) {
        Sym s = this.symRoot.symTableRoot.searchLocal(name = name.intern(), 8);
        if (s != null || (s = this.symRoot.symTableRoot.searchLocal(name, 9)) != null || (s = this.symRoot.symTableRoot.searchLocal(name, 12)) != null || (s = this.symRoot.symTableRoot.searchLocal(this.makeTypedefName(name), 13)) != null) {
            return s;
        }
        return null;
    }

    Sym searchLocalOrdinaryId(String name) {
        Sym s = this.symRoot.symTableCurrent.searchLocal(name = name.intern(), 8);
        if (s != null || (s = this.symRoot.symTableCurrent.searchLocal(name, 9)) != null || (s = this.symRoot.symTableCurrent.searchLocal(name, 12)) != null || (s = this.symRoot.symTableCurrent.searchLocal(this.makeTypedefName(name), 13)) != null) {
            return s;
        }
        return null;
    }

    Sym searchOrdinaryId(String name) {
        name = name.intern();
        for (SymTable table = this.symRoot.symTableCurrent; table != null; table = table.getParent()) {
            Sym s = table.searchLocal(name, 8);
            if (s == null && (s = table.searchLocal(name, 12)) == null && (s = table.searchLocal(name, 9)) == null && (s = table.searchLocal(this.makeTypedefName(name), 13)) == null) continue;
            return s;
        }
        return null;
    }

    private String makeTypedefName(String name) {
        return ("<TYPEDEF " + name + ">").intern();
    }

    VectorType vectorType(Type t, long n) {
        SymTable table = this.symRoot.symTableCurrent.searchTableHaving(t);
        if (table == null) {
            this.fatal("vectorType");
        }
        SymTable bak = this.symRoot.symTableCurrent;
        this.symRoot.symTableCurrent = table;
        VectorType r = this.sym.vectorType(t, n);
        this.symRoot.symTableCurrent = bak;
        if (this.ioRoot.dbgToHir.getLevel() > 3) {
            this.message(6, "VECTORTYPE=" + r);
        }
        return r;
    }

    boolean isCompatible(Type t1, Type t2, boolean checkqualifier) {
        if (t1.getTypeKind() != t2.getTypeKind()) {
            return false;
        }
        if (checkqualifier && (t1.isConst() != t2.isConst() || t1.isVolatile() != t2.isVolatile())) {
            return false;
        }
        switch (t1.getTypeKind()) {
            case 22: {
                return this.isCompatible(((PointerType)t1).getPointedType(), ((PointerType)t2).getPointedType(), true);
            }
            case 23: {
                if (((VectorType)t1).getElemCount() == ((VectorType)t2).getElemCount() || ((VectorType)t1).getElemCount() == 0L || ((VectorType)t2).getElemCount() == 0L) {
                    return this.isCompatible(((VectorType)t1).getElemType(), ((VectorType)t2).getElemType(), true);
                }
                return false;
            }
            case 27: {
                if (!this.isCompatible(((SubpType)t1).getReturnType(), ((SubpType)t2).getReturnType(), true)) {
                    return false;
                }
                IrList ptl1 = ((SubpType)t1).getParamTypeList();
                IrList ptl2 = ((SubpType)t2).getParamTypeList();
                boolean op1 = ((SubpType)t1).hasOptionalParam();
                boolean op2 = ((SubpType)t2).hasOptionalParam();
                boolean nps1 = ((SubpType)t1).hasNoParamSpec();
                boolean nps2 = ((SubpType)t2).hasNoParamSpec();
                if (nps1 && nps2) {
                    return true;
                }
                if (nps1 && !nps2 && !op2) {
                    ListIterator i = ptl2.iterator();
                    while (i.hasNext()) {
                        Type pt = ((Type)i.next()).getUnqualifiedType();
                        if (pt == this.daPromotedType(pt)) continue;
                        return false;
                    }
                    return true;
                }
                if (!nps1 && !op1 && nps2) {
                    ListIterator i = ptl1.iterator();
                    while (i.hasNext()) {
                        Type pt = ((Type)i.next()).getUnqualifiedType();
                        if (pt == this.daPromotedType(pt)) continue;
                        return false;
                    }
                    return true;
                }
                if (!nps1 && !nps2 && op1 == op2 && ptl1.size() == ptl2.size()) {
                    ListIterator i = ptl1.iterator();
                    ListIterator j = ptl2.iterator();
                    while (i.hasNext()) {
                        if (this.isCompatible((Type)i.next(), (Type)j.next(), true)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }
        return t1.getUnqualifiedType() == t2.getUnqualifiedType();
    }

    Type compositeType(Type t1, Type t2, boolean checkqualifier) {
        if (t1.getTypeKind() != t2.getTypeKind()) {
            return null;
        }
        if (checkqualifier && (t1.isConst() != t2.isConst() || t1.isVolatile() != t2.isVolatile())) {
            return null;
        }
        Type type = null;
        switch (t1.getTypeKind()) {
            case 22: {
                if (((PointerType)t1).getPointedType() == this.symRoot.typeVoid) {
                    type = t2;
                    break;
                }
                if (((PointerType)t2).getPointedType() == this.symRoot.typeVoid) {
                    type = t1;
                    break;
                }
                Type ptdt = this.compositeType(((PointerType)t1).getPointedType(), ((PointerType)t2).getPointedType(), true);
                if (ptdt == null) {
                    return null;
                }
                type = this.sym.pointerType(ptdt);
                break;
            }
            case 23: {
                Type elemt;
                long l1 = ((VectorType)t1).getElemCount();
                long l2 = ((VectorType)t2).getElemCount();
                if (l1 != l2) {
                    if (l1 == 0L || l2 == 0L) {
                        l1 |= l2;
                    } else {
                        return null;
                    }
                }
                if ((elemt = this.compositeType(((VectorType)t1).getElemType(), ((VectorType)t2).getElemType(), true)) == null) {
                    return null;
                }
                type = this.sym.vectorType(elemt, l1);
                break;
            }
            case 27: {
                Type rt = this.compositeType(((SubpType)t1).getReturnType(), ((SubpType)t2).getReturnType(), true);
                if (rt == null) {
                    return null;
                }
                IrList ptl1 = ((SubpType)t1).getParamTypeList();
                IrList ptl2 = ((SubpType)t2).getParamTypeList();
                boolean op1 = ((SubpType)t1).hasOptionalParam();
                boolean op2 = ((SubpType)t2).hasOptionalParam();
                boolean nps1 = ((SubpType)t1).hasNoParamSpec();
                boolean nps2 = ((SubpType)t2).hasNoParamSpec();
                if (nps1 && nps2) {
                    type = this.sym.subpType(rt, ptl1, false, true, null);
                    break;
                }
                if (nps1 && !nps2 && !op2) {
                    ListIterator i = ptl2.iterator();
                    while (i.hasNext()) {
                        Type pt = ((Type)i.next()).getUnqualifiedType();
                        if (pt == this.daPromotedType(pt)) continue;
                        return null;
                    }
                    type = this.sym.subpType(rt, ptl2, op2, nps2, null);
                    break;
                }
                if (!nps1 && !op1 && nps2) {
                    ListIterator i = ptl1.iterator();
                    while (i.hasNext()) {
                        Type pt = ((Type)i.next()).getUnqualifiedType();
                        if (pt == this.daPromotedType(pt)) continue;
                        return null;
                    }
                    type = this.sym.subpType(rt, ptl1, op1, nps1, null);
                    break;
                }
                if (!nps1 && !nps2 && op1 == op2 && ptl1.size() == ptl2.size()) {
                    IrList ptl = this.hir.irList();
                    ListIterator i = ptl1.iterator();
                    ListIterator j = ptl2.iterator();
                    while (i.hasNext()) {
                        Type pt = this.compositeType((Type)i.next(), (Type)j.next(), true);
                        if (pt == null) {
                            return null;
                        }
                        ptl.add(pt);
                    }
                    type = this.sym.subpType(rt, ptl, op1, false, null);
                    break;
                }
                return null;
            }
            default: {
                type = t1.getUnqualifiedType();
                if (type == t2.getUnqualifiedType()) break;
                return null;
            }
        }
        if (checkqualifier) {
            type = this.copyQualifier(type, t1);
        }
        return type;
    }

    Type daPromotedType(Type t) {
        if (this.isIntegral(t) && t.getTypeRank() < this.symRoot.typeInt.getTypeRank() && t.getTypeKind() != 21) {
            return this.copyQualifier(this.symRoot.typeInt, t);
        }
        if (t.getTypeKind() == 16) {
            return this.copyQualifier(this.symRoot.typeDouble, t);
        }
        return t;
    }

    private Type copyQualifier(Type dst, Type src) {
        if (src.isConst()) {
            dst = dst.makeConstType();
        }
        if (src.isVolatile()) {
            dst = dst.makeVolatileType();
        }
        return dst;
    }

    Type iPromotedType(Type t) {
        if (t.getTypeRank() < this.symRoot.typeInt.getTypeRank()) {
            if (t.getSizeValue() >= this.symRoot.typeInt.getSizeValue() && t.isUnsigned()) {
                return this.symRoot.typeU_Int;
            }
            return this.symRoot.typeInt;
        }
        return t.getUnqualifiedType();
    }

    boolean isIntegral(Type t) {
        return (t.getTypeRank() & 1) != 0;
    }

    boolean isArithmetic(Type t) {
        return t.getTypeRank() > 0;
    }

    boolean isScalar(Type t) {
        return t.getTypeRank() != 0 || t.getTypeKind() == 13 || t.getTypeKind() == 14;
    }

    boolean isModifierIncluded(Type t1, Type t2) {
        return !(!t1.isConst() && t2.isConst() || !t1.isVolatile() && t2.isVolatile());
    }

    void setFlagPointerOperation(Exp e) {
        switch (e.getOperator()) {
            case 7: 
            case 8: {
                Sym s = ((SymNode)e).getSymNodeSym();
                if (s == null) break;
                switch (s.getSymType().getTypeKind()) {
                    case 22: 
                    case 23: {
                        s.setFlag(7, true);
                    }
                }
            }
        }
    }

    void setFlagAddressTaken(Exp e) {
        switch (e.getOperator()) {
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                ((SymNode)e).getSymNodeSym().setFlag(6, true);
                break;
            }
            case 19: {
                this.setFlagAddressTaken(((QualifiedExpImpl)e).getQualifierExp());
                break;
            }
            case 17: {
                this.setFlagAddressTaken(((SubscriptedExp)e).getArrayExp());
            }
        }
    }

    void setFlagValueIsAssigned(Exp e) {
        switch (e.getOperator()) {
            case 7: 
            case 8: {
                ((SymNode)e).getSymNodeSym().setFlag(9, true);
                break;
            }
            case 19: {
                this.setFlagValueIsAssigned(((QualifiedExpImpl)e).getQualifierExp());
                break;
            }
            case 17: {
                this.setFlagValueIsAssigned(((SubscriptedExp)e).getArrayExp());
            }
        }
    }

    Exp decayExp(Exp e) {
        this.setFlagAddressTaken(e);
        Exp ne = this.hir.decayExp(e);
        return ne;
    }

    Exp addrExp(Exp e) {
        this.setFlagAddressTaken(e);
        return this.hir.exp(64, e);
    }

    Exp subsExp(Exp e1, Exp e2) {
        return new SubscriptedExpImpl(this.hirRoot, e1, e2);
    }

    VarNode newTempVarNode(Type t) {
        Var v = this.symRoot.symTableCurrent.generateVar(t, this.symRoot.subpCurrent);
        v.setSymType(t);
        return this.hir.varNode(v);
    }

    ConstNode new0Node() {
        return this.hir.constNode(this.symRoot.intConst0);
    }

    ConstNode new1Node() {
        return this.hir.constNode(this.symRoot.intConst1);
    }

    Exp newTrueNode() {
        return this.hir.constNode(this.symRoot.boolConstTrue);
    }

    Exp newFalseNode() {
        return this.hir.constNode(this.symRoot.boolConstFalse);
    }

    BlockStmt newBlockStmt(Stmt stmt) {
        BlockStmt blockstmt = this.hir.blockStmt(stmt);
        return blockstmt;
    }

    IfStmt newIfStmt(Exp condexp, Stmt thenstmt, Stmt elsestmt) {
        IfStmt ifstmt = this.hir.ifStmt(condexp, thenstmt, elsestmt);
        ifstmt.setFileName(this.nowFile);
        ifstmt.setLineNumber(this.nowLine);
        return ifstmt;
    }

    ExpStmt newExpStmt(Exp exp) {
        ExpStmt expstmt = this.hir.expStmt(exp);
        expstmt.setFileName(this.nowFile);
        expstmt.setLineNumber(this.nowLine);
        return expstmt;
    }

    AssignStmt newAssignStmt(Exp e1, Exp e2) {
        this.setFlagValueIsAssigned(e1);
        if (e1.getType().getUnqualifiedType() != e2.getType().getUnqualifiedType() && e1.getType().getTypeKind() != 23) {
            e2 = this.hir.convExp(e1.getType().getUnqualifiedType(), e2);
        }
        AssignStmt assignstmt = this.hir.assignStmt(e1, e2);
        assignstmt.setFileName(this.nowFile);
        assignstmt.setLineNumber(this.nowLine);
        return assignstmt;
    }

    LabeledStmt newLabeledStmt(Stmt stmt) {
        LabeledStmt labeledstmt = this.hir.labeledStmt(this.createLabel(), stmt);
        labeledstmt.setFileName(this.nowFile);
        labeledstmt.setLineNumber(this.nowLine);
        return labeledstmt;
    }
}

