/*
 * Decompiled with CFR 0.152.
 */
package coins.casttohir;

import coins.casttohir.ToC;
import coins.casttohir.ToHir;
import coins.casttohir.ToHirCast;
import coins.casttohir.ToHirVisit;
import coins.ir.IrList;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpListExp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.IfStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.SetDataStmt;
import coins.ir.hir.SubpNode;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.VarNode;
import coins.sym.Elem;
import coins.sym.PointerType;
import coins.sym.StructType;
import coins.sym.SubpType;
import coins.sym.Type;
import coins.sym.UnionType;
import coins.sym.VectorType;
import java.util.ListIterator;

public class ToHirC2
extends ToHirVisit {
    private final ToHirCast toCast;

    public ToHirC2(ToHir tohir) {
        super(tohir);
        this.message(1, "ToHirC2\n");
        this.toCast = new ToHirCast(tohir);
    }

    protected void message(int level, String mes) {
        this.toHir.debug.print(level, "C2", mes);
    }

    protected void atIf(IfStmt s) {
        s.setIfCondition(this.conditionCast(this.visitExp(s.getIfCondition())));
        this.visitStmt(s.getThenPart());
        this.visitStmt(s.getElsePart());
    }

    protected void atWhile(LoopStmt s) {
        s.setLoopStartCondition(this.conditionCast(this.visitExp(s.getLoopStartCondition())));
        this.visitStmt(s.getLoopBodyPart());
    }

    protected void atFor(LoopStmt s) {
        s.setLoopStartCondition(this.conditionCast(this.visitExp(s.getLoopStartCondition())));
        this.visitStmt(s.getLoopInitPart());
        this.visitStmt(s.getLoopBodyPart());
        this.visitStmt(s.getLoopStepPart());
    }

    protected void atUntil(LoopStmt s) {
        this.visitStmt(s.getLoopBodyPart());
        s.setLoopEndCondition(this.conditionCast(this.visitExp(s.getLoopEndCondition())));
    }

    protected void atSwitch(SwitchStmt s) {
        Exp cond = this.selectionCast(this.visitExp(s.getSelectionExp()));
        if (this.toHir.isIntegral(cond.getType())) {
            s.setSelectionExp(cond);
        } else {
            this.toHir.error("bad control expression");
        }
        this.visitStmt(s.getBodyStmt());
    }

    protected void atReturn(ReturnStmt s) {
        Exp retexp = this.selectionCast(this.visitExp(s.getReturnValue()));
        Type rettype = this.toHir.symRoot.subpCurrent.getReturnValueType();
        if (retexp != null) {
            if (rettype != this.toHir.symRoot.typeVoid) {
                if ((retexp = this.toCast.assignCast(rettype, retexp)) == null) {
                    this.toHir.error("incompatible type in return");
                }
            } else {
                if (retexp.getType().getTypeKind() != 15) {
                    this.toHir.warning("'return' with a value, in function returning void");
                }
                s.insertPreviousStmt(this.toHir.newExpStmt(retexp));
                retexp = null;
            }
        } else if (rettype != this.toHir.symRoot.typeVoid) {
            this.toHir.warning("'return' without value, in function returning value");
            retexp = rettype.isScalar() ? this.toCast.cast(rettype, this.toHir.new0Node()) : this.toHir.newTempVarNode(rettype);
        }
        s.setReturnValue(retexp);
    }

    protected void atExpStmt(ExpStmt s) {
        s.setExp(this.selectionCast(this.visitExp(s.getExp())));
    }

    protected void atSetDataStmt(SetDataStmt s) {
        s.setRightSide(this.atInitializer(s.getLeftSide().getType(), s.getRightSide()));
    }

    protected Exp atVar(VarNode e) {
        e.setType(e.getVar().getSymType());
        return e;
    }

    protected Exp atSubp(SubpNode e) {
        e.setType(e.getSubp().getSymType());
        return e;
    }

    protected Exp atSubs(Exp e) {
        Exp e1 = this.selectionCast(this.visitExp(e.getExp1()));
        Exp e2 = this.selectionCast(this.visitExp(e.getExp2()));
        int k1 = e1.getType().getTypeKind();
        if (k1 != 23 && k1 != 22) {
            Exp tmp = e1;
            e1 = e2;
            e2 = tmp;
            k1 = e1.getType().getTypeKind();
            if (k1 != 23 && k1 != 22) {
                this.toHir.error("[] requires array or pointer: " + ToC.tos(e));
                return e;
            }
        }
        if (!this.toHir.isIntegral(e2.getType())) {
            this.toHir.error("[] requires integer type: " + ToC.tos(e));
            return e;
        }
        if (k1 == 23) {
            return this.hir.contentsExp(this.hir.exp(38, this.toHir.decayExp(e1), e2));
        }
        return this.hir.contentsExp(this.hir.exp(38, e1.getExp1(), e2));
    }

    protected Exp atCall(FunctionExp e) {
        Exp newexp;
        Exp actualexp;
        Exp e1 = e.getFunctionSpec();
        e1 = this.visitExp(e1);
        e.setFunctionSpec(e1);
        Type t1 = e1.getType();
        while (t1.getTypeKind() == 22) {
            t1 = ((PointerType)t1).getPointedType();
        }
        if (t1.getTypeKind() != 27) {
            this.toHir.error("function call requires function or pointer to function");
            return e;
        }
        SubpType functype = (SubpType)t1;
        e.setType(functype.getReturnType());
        IrList actuallist = e.getParamList();
        IrList formallist = functype.getParamTypeList();
        if (!functype.hasNoParamSpec()) {
            if (actuallist.size() < formallist.size()) {
                this.toHir.error("too few function parameters: " + ToC.tos(e1));
                return e;
            }
            if (!functype.hasOptionalParam() && formallist.size() < actuallist.size()) {
                this.toHir.error("too much function parameters: " + ToC.tos(e1));
                return e;
            }
        }
        ListIterator actualiter = actuallist.iterator();
        ListIterator formaliter = formallist.iterator();
        while (formaliter.hasNext()) {
            actualexp = (Exp)actualiter.next();
            newexp = this.toCast.assignCast((Type)formaliter.next(), this.selectionCast(this.visitExp(actualexp)));
            if (newexp == null) {
                this.toHir.error("incompatible type for argument: " + ToC.tos(actualexp));
                continue;
            }
            if (newexp == actualexp) continue;
            actualiter.set(newexp);
            newexp.setParent(actuallist);
        }
        while (actualiter.hasNext()) {
            actualexp = (Exp)actualiter.next();
            newexp = this.toCast.daPromotion(this.selectionCast(this.visitExp(actualexp)));
            if (newexp == actualexp) continue;
            actualiter.set(newexp);
            newexp.setParent(actuallist);
        }
        return e;
    }

    protected Exp atAdd(Exp e) {
        Exp e1 = this.selectionCast(this.visitExp(e.getExp1()));
        Exp e2 = this.selectionCast(this.visitExp(e.getExp2()));
        Type t1 = e1.getType();
        Type t2 = e2.getType();
        e.setChildren(e1, e2);
        Type t = this.toCast.getPointerOpType(t1, t2);
        if (t != null) {
            e.setType(t);
            this.toHir.setFlagPointerOperation(e1);
            return e;
        }
        t = this.toCast.getUacType(t1, t2);
        if (t != null) {
            e.setType(t);
            return e;
        }
        this.toHir.error(this.toHir.getOp(e) + " requires arithmetic type or pointer and integer type: " + ToC.tos(e));
        e.setType(this.toHir.symRoot.typeInt);
        return e;
    }

    protected Exp atSub(Exp e) {
        return this.atAdd(e);
    }

    protected Exp atMul(Exp e) {
        Exp e1 = this.selectionCast(this.visitExp(e.getExp1()));
        Exp e2 = this.selectionCast(this.visitExp(e.getExp2()));
        Type t1 = e1.getType();
        Type t2 = e2.getType();
        e.setChildren(e1, e2);
        Type t = this.toCast.getUacType(t1, t2);
        if (t != null) {
            e.setType(t);
            if (e.getOperator() == 42 && e2 instanceof ConstNode && t2.isInteger() && ((ConstNode)e2).getLongValue() == 0L) {
                this.toHir.warning("Zero divide " + ToC.tos(e));
            }
        } else {
            this.toHir.error(this.toHir.getOp(e) + " requires arithmetic type: " + ToC.tos(e));
            e.setType(this.toHir.symRoot.typeInt);
        }
        return e;
    }

    protected Exp atDiv(Exp e) {
        return this.atMul(e);
    }

    protected Exp atMod(Exp e) {
        Type t;
        Exp e1 = this.selectionCast(this.visitExp(e.getExp1()));
        Exp e2 = this.selectionCast(this.visitExp(e.getExp2()));
        Type t1 = e1.getType();
        Type t2 = e2.getType();
        e.setChildren(e1, e2);
        if (this.toHir.isIntegral(t1) && this.toHir.isIntegral(t2) && (t = this.toCast.getUacType(t1, t2)) != null) {
            e.setType(t);
            if (e.getOperator() == 43 && e2 instanceof ConstNode && t2.isInteger() && ((ConstNode)e2).getLongValue() == 0L) {
                this.toHir.warning("Zero divide " + ToC.tos(e));
            }
        } else {
            this.toHir.error(this.toHir.getOp(e) + " requires integer type: " + ToC.tos(e));
            e.setType(this.toHir.symRoot.typeInt);
        }
        return e;
    }

    protected Exp atAnd(Exp e) {
        return this.atMod(e);
    }

    protected Exp atOr(Exp e) {
        return this.atMod(e);
    }

    protected Exp atXor(Exp e) {
        return this.atMod(e);
    }

    protected Exp atCmpEq(Exp e) {
        Exp e1 = this.selectionCast(this.visitExp(e.getExp1()));
        Exp e2 = this.selectionCast(this.visitExp(e.getExp2()));
        e.setChildren(e1, e2);
        Type t = this.toCast.getCompareType(e1.getType(), e2.getType());
        if (t != null) {
            e.setChildren(this.toCast.cast(t, e1), this.toCast.cast(t, e2));
        } else {
            this.toHir.error("comparision requires arithmetic types or pointers to compatible types");
        }
        e.setType(this.toHir.symRoot.typeBool);
        return e;
    }

    protected Exp atCmpNe(Exp e) {
        return this.atCmpEq(e);
    }

    protected Exp atCmpGt(Exp e) {
        return this.atCmpEq(e);
    }

    protected Exp atCmpGe(Exp e) {
        return this.atCmpEq(e);
    }

    protected Exp atCmpLt(Exp e) {
        return this.atCmpEq(e);
    }

    protected Exp atCmpLe(Exp e) {
        return this.atCmpEq(e);
    }

    protected Exp atLShift(Exp e) {
        Exp e1 = this.selectionCast(this.visitExp(e.getExp1()));
        Exp e2 = this.selectionCast(this.visitExp(e.getExp2()));
        e.setChildren(e1, e2);
        if (this.toHir.isIntegral(e1.getType()) && this.toHir.isIntegral(e2.getType())) {
            Type t1 = this.toHir.iPromotedType(e1.getType());
            e.setType(t1);
        } else {
            this.toHir.error("<< >> requires integer type");
            e.setType(this.toHir.symRoot.typeInt);
        }
        return e;
    }

    protected Exp atRShift(Exp e) {
        return this.atLShift(e);
    }

    protected Exp atNot(Exp e) {
        Exp e1 = this.selectionCast(this.visitExp(e.getExp1()));
        Type t1 = e1.getType();
        e.setChild1(e1);
        if (this.toHir.isIntegral(t1)) {
            e.setType(this.toHir.iPromotedType(t1));
        } else {
            this.toHir.error("~ requires integer type");
            e.setType(this.toHir.symRoot.typeInt);
        }
        return e;
    }

    protected Exp atNeg(Exp e) {
        Exp e1 = this.selectionCast(this.visitExp(e.getExp1()));
        Type t1 = e1.getType();
        e.setChild1(e1);
        if (this.toHir.isArithmetic(t1)) {
            e.setType(this.toHir.iPromotedType(t1));
        } else {
            this.toHir.error("unary - requires arithmetic type");
            e.setType(this.toHir.symRoot.typeInt);
        }
        return e;
    }

    protected Exp atAddr(Exp e) {
        Exp e1 = this.selectionCast(this.visitExp(e.getExp1()));
        e.setChild1(e1);
        this.isAddressAcquirableLvalue(e1);
        e.setType(this.sym.pointerType(e1.getType()));
        return e;
    }

    private void isAddressAcquirableLvalue(Exp e) {
        switch (e.getOperator()) {
            case 5: {
                if (e.getConstSym().getSymKind() != 6) {
                    this.toHir.error("invalid lvalue in unary '&'");
                }
                return;
            }
            case 7: {
                if (e.getVar().getStorageClass() == 8) {
                    this.toHir.error("cannot take address of register: " + e.getVar().getName());
                }
                return;
            }
            case 19: {
                Elem elem = e.getExp2().getElem();
                if (elem.isBitField()) {
                    this.toHir.error("cannot take address of bitfield: " + elem.getName());
                }
            }
            case 17: {
                this.isAddressAcquirableLvalue(e.getExp1());
                return;
            }
            case 20: {
                Elem elem = e.getExp2().getElem();
                if (elem.isBitField()) {
                    this.toHir.error("cannot take address of bitfield: " + elem.getName());
                }
            }
            case 9: 
            case 68: {
                return;
            }
        }
        this.toHir.error("invalid lvalue in unary '&'");
    }

    protected Exp atConv(Exp e) {
        Exp e1 = this.selectionCast(this.visitExp(e.getExp1()));
        e.setChild1(e1);
        if (e.getType() != this.toHir.symRoot.typeVoid) {
            if (this.toHir.isScalar(e1.getType())) {
                e = this.toCast.cast(e.getType(), e1);
            } else {
                this.toHir.error("cast requires scalar type: " + ToC.tos(e));
            }
        }
        return e;
    }

    protected Exp atContents(Exp e) {
        Exp e1 = this.selectionCast(this.visitExp(e.getExp1()));
        Type t1 = e1.getType();
        e.setChild1(e1);
        if (t1.getTypeKind() == 22) {
            e.setType(((PointerType)t1).getPointedType());
        } else {
            this.toHir.error("unary * requires pointer type: " + ToC.tos(e));
        }
        return e;
    }

    protected Exp atAssign(Exp e) {
        Exp e2tmp;
        Exp e1 = this.visitExp(e.getExp1());
        Type t1 = e1.getType();
        Exp e2 = this.selectionCast(this.visitExp(e.getExp2()));
        if (!this.inInitBlock()) {
            this.isModifiableLvalue(e1);
        }
        if ((e2tmp = this.toCast.assignCast(t1, e2)) == null) {
            this.toHir.error("incompatible types in assignment: " + ToC.tos(e));
        }
        e.setChildren(e1, e2);
        e.setType(t1);
        return e;
    }

    private void isModifiableLvalue(Exp e) {
        if (e.getType().getTypeKind() == 23) {
            this.toHir.error("lvalue has array type: " + ToC.tos(e));
        } else if (e.getType().getSizeExp() == null) {
            this.toHir.error("lvalue has incomplete type: " + ToC.tos(e));
        } else if (e.getType().isConst()) {
            this.toHir.error("assignment to read-only location: " + ToC.tos(e));
        }
    }

    protected Exp atOffset(Exp e) {
        Exp e1 = this.selectionCast(this.visitExp(e.getExp1()));
        Exp e2 = this.selectionCast(this.visitExp(e.getExp2()));
        Type t1 = e1.getType();
        Type t2 = e2.getType();
        e.setChildren(e1, e2);
        if (t1.getTypeKind() == 22 && t2.getTypeKind() == 22) {
            Type ptd1 = ((PointerType)t1).getPointedType();
            Type ptd2 = ((PointerType)t2).getPointedType();
            if (ptd1.getSizeValue() > 0L) {
                if (ptd2.getSizeValue() > 0L) {
                    if (!this.toHir.isCompatible(ptd1, ptd2, false)) {
                        this.toHir.error("- requires compatible pointer: " + ToC.tos(e));
                    }
                } else {
                    this.toHir.error("pointer is an incomplete type or size is 0: " + ToC.tos(e2));
                }
            } else {
                this.toHir.error("pointer is an incomplete type or size is 0: " + ToC.tos(e1));
            }
        } else {
            this.toHir.fatal("atOffset: " + ToC.tos(e));
        }
        e.setType(this.toHir.symRoot.typeInt);
        return e;
    }

    protected Exp atLgAnd(Exp e) {
        Exp e1 = this.conditionCast(this.visitExp(e.getExp1()));
        Exp e2 = this.conditionCast(this.visitExp(e.getExp2()));
        e.setChildren(e1, e2);
        e.setType(this.toHir.symRoot.typeBool);
        return e;
    }

    protected Exp atLgOr(Exp e) {
        return this.atLgAnd(e);
    }

    protected Exp atSelect(Exp e) {
        Exp e1 = this.conditionCast(this.visitExp(e.getExp1()));
        Exp e2 = this.selectionCast(this.visitExp(e.getExp2()));
        Exp e3 = this.selectionCast(this.visitExp((Exp)e.getChild(3)));
        e.setChildren(e1, e2, e3);
        Type t = this.toCast.getSelectType(e2.getType(), e3.getType());
        if (t != null) {
            e.setType(t);
        } else {
            this.toHir.error("?: requires compatible type: " + ToC.tos(e));
            e.setType(this.toHir.symRoot.typeInt);
        }
        return e;
    }

    protected Exp atComma(Exp e) {
        Exp e1 = this.selectionCast(this.visitExp(e.getExp1()));
        Exp e2 = this.selectionCast(this.visitExp(e.getExp2()));
        e.setChildren(e1, e2);
        e.setType(e2.getType());
        return e;
    }

    protected Exp atEqZero(Exp e) {
        Exp e1 = this.visitExp(e.getExp1());
        Type t1 = e1.getType();
        e.setChild1(this.conditionCast(e1));
        if (!this.toHir.isScalar(t1)) {
            this.toHir.error("! requires scalar type: " + ToC.tos(e));
        }
        e.setType(this.toHir.symRoot.typeBool);
        return e;
    }

    protected Exp atPre(int op, Exp e) {
        Exp e1 = this.selectionCast(this.visitExp(e.getExp1()));
        Type t1 = e1.getType();
        e.setChild1(e1);
        e.setType(t1);
        if (!this.toHir.isScalar(t1)) {
            this.toHir.error(this.toHir.getOp(e) + " requires scalar type: " + ToC.tos(e));
        }
        return e;
    }

    protected Exp atPost(int op, Exp e) {
        return this.atPre(op, e);
    }

    protected Exp atAddAssign(Exp e) {
        Exp e1 = this.visitExp(e.getExp1());
        Exp e2 = this.selectionCast(this.visitExp(e.getExp2()));
        Type t1 = e1.getType();
        Type t2 = e2.getType();
        e.setChildren(e1, e2);
        e.setType(t1);
        this.isModifiableLvalue(e1);
        if (this.toCast.getPointerOpType(t1, t2) != null) {
            this.toHir.setFlagPointerOperation(e1);
            return e;
        }
        if (this.toCast.getUacType(t1, t2) != null) {
            return e;
        }
        this.toHir.error(this.toHir.getOp(e) + " requires arithmetic type or pointer and integer type: " + ToC.tos(e));
        return e;
    }

    protected Exp atSubAssign(Exp e) {
        return this.atAddAssign(e);
    }

    protected Exp atMulAssign(Exp e) {
        Exp e1 = this.visitExp(e.getExp1());
        Exp e2 = this.selectionCast(this.visitExp(e.getExp2()));
        Type t1 = e1.getType();
        Type t2 = e2.getType();
        e.setChildren(e1, e2);
        e.setType(t1);
        this.isModifiableLvalue(e1);
        if (this.toCast.getUacType(t1, t2) != null) {
            return e;
        }
        this.toHir.error(this.toHir.getOp(e) + " requires arithmetic type: " + ToC.tos(e));
        return e;
    }

    protected Exp atDivAssign(Exp e) {
        return this.atMulAssign(e);
    }

    protected Exp atModAssign(Exp e) {
        Exp e1 = this.visitExp(e.getExp1());
        Exp e2 = this.selectionCast(this.visitExp(e.getExp2()));
        Type t1 = e1.getType();
        Type t2 = e2.getType();
        e.setChildren(e1, e2);
        e.setType(t1);
        this.isModifiableLvalue(e1);
        if (this.toHir.isIntegral(t1) && this.toHir.isIntegral(t2) && this.toCast.getUacType(t1, t2) != null) {
            return e;
        }
        this.toHir.error(this.toHir.getOp(e) + " requires integer types: " + ToC.tos(e));
        return e;
    }

    protected Exp atLShiftAssign(Exp e) {
        Exp e1 = this.visitExp(e.getExp1());
        Exp e2 = this.selectionCast(this.visitExp(e.getExp2()));
        Type t1 = e1.getType();
        Type t2 = e2.getType();
        e.setChildren(e1, e2);
        e.setType(t1);
        this.isModifiableLvalue(e1);
        if (this.toHir.isIntegral(e1.getType()) && this.toHir.isIntegral(e2.getType())) {
            return e;
        }
        this.toHir.error(this.toHir.getOp(e) + " requires integer types: " + ToC.tos(e));
        return e;
    }

    protected Exp atRShiftAssign(Exp e) {
        return this.atLShiftAssign(e);
    }

    protected Exp atAndAssign(Exp e) {
        return this.atModAssign(e);
    }

    protected Exp atOrAssign(Exp e) {
        return this.atModAssign(e);
    }

    protected Exp atXorAssign(Exp e) {
        return this.atModAssign(e);
    }

    protected Exp atExpList(ExpListExp e) {
        Type t = e.getType();
        switch (t.getTypeKind()) {
            case 23: {
                long size = e.size();
                Type elemtype = ((VectorType)t).getElemType();
                ExpListExp lNewList = (ExpListExp)this.hir.expList(null);
                ListIterator lIterator = e.iterator();
                while (lIterator.hasNext()) {
                    Exp ei = (Exp)lIterator.next();
                    if (ei.getOperator() == 97) {
                        lNewList.add(this.hir.exp(97, this.atInitializer(elemtype, ei.getExp1()), (Exp)ei.getExp2().copyWithOperands()));
                        break;
                    }
                    Exp ei2 = this.atInitializer(elemtype, ei);
                    if (ei2 != null) {
                        ei2.cutParentLink();
                    }
                    lNewList.add(this.atInitializer(elemtype, ei));
                }
                lNewList.setType(t);
                return lNewList;
            }
            case 24: {
                IrList il = ((StructType)t).getElemList();
                ExpListExp lStructList = (ExpListExp)this.hir.expList(null);
                ListIterator lValueIterator = e.iterator();
                ListIterator lElemIterator = il.iterator();
                while (lElemIterator.hasNext()) {
                    Elem lElem = (Elem)lElemIterator.next();
                    if (!lValueIterator.hasNext()) continue;
                    Exp lExp = this.atInitializer(lElem.getSymType(), (Exp)lValueIterator.next());
                    if (lExp != null) {
                        lExp.cutParentLink();
                    }
                    lStructList.add(lExp);
                }
                lStructList.setType(t);
                return lStructList;
            }
            case 25: {
                IrList il = ((UnionType)t).getElemList();
                if (e.size() <= 0) break;
                e.setExp(0, this.atInitializer(((Elem)il.get(0)).getSymType(), e.getExp(0)));
                break;
            }
            default: {
                this.toHir.fatal("atExpListExp  TYPE=" + t);
            }
        }
        return e;
    }

    private Exp atInitializer(Type t, Exp e) {
        if ((e = this.visitExp(e)).getOperator() == 96) {
            return e;
        }
        Exp etmp = this.toCast.assignCast(t, e);
        if (etmp != null) {
            return etmp;
        }
        this.toHir.error("invalid initializer of " + t + ": " + ToC.tos(e));
        return e;
    }

    private Exp conditionCast(Exp e) {
        if (e == null) {
            return this.toHir.newTrueNode();
        }
        switch (e.getOperator()) {
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 77: 
            case 78: 
            case 81: {
                return e;
            }
        }
        if (!this.toHir.isScalar(e.getType())) {
            this.toHir.error("bad conditional expression");
        }
        return this.hir.exp(52, e, this.toHir.new0Node());
    }

    private Exp selectionCast(Exp e) {
        if (e == null) {
            return null;
        }
        switch (e.getOperator()) {
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 77: 
            case 78: 
            case 81: {
                e = this.hir.exp(79, e, this.toHir.newTrueNode(), this.toHir.newFalseNode());
                e.setType(this.toHir.symRoot.typeBool);
                return e;
            }
        }
        return e;
    }
}

