/*
 * Decompiled with CFR 0.152.
 */
package coins.cfront;

import coins.Debug;
import coins.IoRoot;
import coins.SymRoot;
import coins.ast.ASTList;
import coins.ast.ASTree;
import coins.ast.Aggregate;
import coins.ast.Declarator;
import coins.ast.DeclaratorList;
import coins.ast.Enum;
import coins.ast.Expr;
import coins.ast.Function;
import coins.ast.Pragma;
import coins.ast.Stmnt;
import coins.ast.Struct;
import coins.ast.TokenId;
import coins.ast.TypeId;
import coins.ast.Union;
import coins.ast.expr.AddressExpr;
import coins.ast.expr.ArithBinaryExpr;
import coins.ast.expr.ArithUnaryExpr;
import coins.ast.expr.ArrayExpr;
import coins.ast.expr.ArrayInitializer;
import coins.ast.expr.AsmExpr;
import coins.ast.expr.AssignExpr;
import coins.ast.expr.CallExpr;
import coins.ast.expr.CastExpr;
import coins.ast.expr.CommaExpr;
import coins.ast.expr.ConditionalExpr;
import coins.ast.expr.ConstantExpr;
import coins.ast.expr.DereferenceExpr;
import coins.ast.expr.LvalueExpr;
import coins.ast.expr.MemberExpr;
import coins.ast.expr.PointerBinaryExpr;
import coins.ast.expr.PostfixExpr;
import coins.ast.expr.PrefixExpr;
import coins.ast.expr.SizeofExpr;
import coins.ast.expr.StringLiteral;
import coins.ast.expr.VariableExpr;
import coins.ast.expr.WcharLiteral;
import coins.ast.stmnt.BreakStmnt;
import coins.ast.stmnt.CaseLabel;
import coins.ast.stmnt.CompoundStmnt;
import coins.ast.stmnt.ContinueStmnt;
import coins.ast.stmnt.DefaultLabel;
import coins.ast.stmnt.DoStmnt;
import coins.ast.stmnt.ExpressionStmnt;
import coins.ast.stmnt.ForStmnt;
import coins.ast.stmnt.GotoStmnt;
import coins.ast.stmnt.IfStmnt;
import coins.ast.stmnt.NamedLabel;
import coins.ast.stmnt.NullStmnt;
import coins.ast.stmnt.ReturnStmnt;
import coins.ast.stmnt.SwitchStmnt;
import coins.ast.stmnt.WhileStmnt;
import coins.casttohir.ToHirC;
import coins.cfront.Backend;
import coins.cfront.EncodedType;
import coins.cfront.Evaluator;
import coins.cfront.Lex;
import coins.cfront.OldFuncArgs;
import coins.cfront.ParseError;
import coins.cfront.StopException;
import coins.cfront.SymbolTable;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.sym.Const;
import coins.sym.IntConst;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class Parser
implements TokenId,
TypeId {
    public static final String invalidCChar = "#";
    final Debug debug;
    final Lex lex;
    Evaluator evaluator;
    LinkedList pragmaList;
    private int uniqueId = 0;
    private int errorCounter;
    private SymbolTable symTable;
    private SymbolTable tagTable;
    private final ToHirC toHirC;
    private final SymRoot symRoot;
    public final int fDbgLevel;
    public static String cppCommand = "gcc -E";
    private static final byte[] intType = new byte[]{105};
    private static final int[] binaryOpPrecedence = new int[]{0, 0, 0, 0, 1, 6, 0, 0, 0, 1, 2, 0, 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 0};
    private static final byte[] defaultFunctionType = new byte[]{70, 101, 36, 105};

    public Parser(IoRoot ioroot, Lex lex, ToHirC tohirc) {
        this.symRoot = ioroot.symRoot;
        this.debug = ioroot.dbgParse;
        this.lex = lex;
        this.toHirC = tohirc;
        this.symTable = new SymbolTable();
        this.tagTable = new SymbolTable();
        this.errorCounter = 0;
        this.evaluator = new Evaluator(this.symRoot.machineParam);
        this.pragmaList = new LinkedList();
        lex.parser = this;
        this.fDbgLevel = ioroot.dbgParse.getLevel();
        if (this.fDbgLevel > 0) {
            this.debug.print(1, "\nParser ");
        }
    }

    public static InputStream runCpp(String source) throws IOException {
        Process p = Runtime.getRuntime().exec(cppCommand + " " + source);
        return p.getInputStream();
    }

    boolean isTypedefedType(String typename) {
        return this.symTable.get(typename.intern()) instanceof byte[];
    }

    public void parse(Backend backend, boolean verbose) throws IOException {
        try {
            if (this.fDbgLevel > 0) {
                this.debug.print(1, "\nparse ");
            }
            while (this.hasNext()) {
                ASTList tree = this.read();
                backend.compile(tree);
            }
        }
        catch (StopException stopException) {
            // empty catch block
        }
        backend.doEpilogue();
        if (verbose) {
            this.showEpilogue();
        }
    }

    public boolean hasNext() throws IOException {
        return this.lex.lookAhead() != -1;
    }

    protected Declarator makeDeclarator(String name, String fname, int line) {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " makeDeclarator " + name);
        }
        return new Declarator(name, fname, line);
    }

    protected Function makeFunction(Declarator decl, Stmnt body) {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "makeFunction ");
        }
        return new Function(decl, body);
    }

    protected Struct makeStruct(String name, DeclaratorList mems, String fname, int line) {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " makeStruct " + name);
        }
        return new Struct(name, mems, fname, line, this.toHirC);
    }

    protected Union makeUnion(String name, DeclaratorList mems, String fname, int line) {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " makeUnion " + name);
        }
        return new Union(name, mems, fname, line, this.toHirC);
    }

    protected void showErrorMessage(ParseError e) {
        ++this.errorCounter;
        System.err.println(e.getMessage());
    }

    public void showErrorMessage(Stmnt pos, String message) {
        ++this.errorCounter;
        System.err.print(pos.fileName());
        System.err.print(':');
        System.err.print(pos.lineNumber());
        System.err.print(' ');
        System.err.println(message);
    }

    public void showWarningMessage(String message) {
        System.err.print(this.lex.getFileName());
        System.err.print(':');
        System.err.print(this.lex.getLineNumber());
        System.err.print(" (Warning) ");
        System.err.println(message);
    }

    public void showEpilogue() {
        System.err.println(this.errorCounter + " error(s)");
    }

    public void recordSymbol(String name, Declarator d) {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " recordSymbol", name + d.toString());
        }
        this.symTable.put(name, d);
        if (name.charAt(0) == '_') {
            this.symRoot.conflictingSpecialSyms.add(name);
        }
    }

    private String uniqueName() {
        String name = "_#" + this.uniqueId++;
        return name.intern();
    }

    protected void enterNewEnvironment() {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "\n enterNewEnvironment ");
        }
        this.symRoot.symTableCurrent.pushSymTable(null);
        this.symTable = new SymbolTable(33, this.symTable);
        this.tagTable = new SymbolTable(33, this.tagTable);
    }

    protected void exitEnvironment() {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "\n exitEnvironment ");
        }
        this.symRoot.symTableCurrent.popSymTable();
        this.symTable = this.symTable.getParent();
        this.tagTable = this.tagTable.getParent();
    }

    protected Aggregate lookupEncodedTag(String tagName) {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " lookupEncodedTag " + tagName);
        }
        tagName = tagName.intern();
        Aggregate agg = null;
        Object found = null;
        SymbolTable st = this.tagTable;
        do {
            if (found instanceof Aggregate) {
                agg = (Aggregate)found;
            }
            found = st.get(tagName);
            st = st.getParent();
        } while (found != null && st != null);
        if (found instanceof Aggregate) {
            agg = (Aggregate)found;
        }
        return agg;
    }

    protected String toEncodedTag(String tagName) {
        Object found;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " toEncodedTag " + tagName);
        }
        if ((found = this.tagTable.get(tagName.intern())) == null) {
            return tagName;
        }
        if (found instanceof Aggregate) {
            return ((Aggregate)found).name();
        }
        return (String)found;
    }

    protected String decodeTagName(String tagName) {
        int index = tagName.indexOf(invalidCChar);
        if (index > 0) {
            return tagName.substring(0, index);
        }
        return tagName;
    }

    protected String getNewEncodedTag(String name) {
        SymbolTable parent = this.tagTable.getParent();
        if (parent == null) {
            return name;
        }
        while (parent.get(name.intern()) != null) {
            name = name + invalidCChar;
        }
        return name.intern();
    }

    protected String recordTag(String tagName) throws ParseError {
        String encodedName;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " recordTag " + tagName);
        }
        if (this.tagTable.get(encodedName = this.getNewEncodedTag(tagName = tagName.intern())) != null) {
            return encodedName;
        }
        if (this.tagTable.put(tagName, encodedName) != null) {
            throw new ParseError(this.lex, "fatal error (this should never happen)");
        }
        if (tagName.charAt(0) == '_') {
            this.symRoot.conflictingSpecialSyms.add(tagName);
        }
        return encodedName;
    }

    protected void recordTag(String tagName, Aggregate a) throws ParseError {
        String name2;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " recordTag " + tagName);
        }
        tagName = tagName.intern();
        Object found = this.tagTable.put(tagName, a);
        if (tagName.charAt(0) == '_') {
            this.symRoot.conflictingSpecialSyms.add(tagName);
        }
        if (found != null && found instanceof Aggregate) {
            this.showWarningMessage("struct/union tag " + tagName + " was redefined.");
        }
        if ((name2 = a.name().intern()) != tagName) {
            this.tagTable.put(name2, a);
        }
        if (name2.charAt(0) == '_') {
            this.symRoot.conflictingSpecialSyms.add(name2);
        }
    }

    public long sizeofStruct(String tagName) throws ParseError {
        Aggregate agg;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " sizeofStruct " + tagName);
        }
        if ((agg = this.lookupEncodedTag(tagName)) == null) {
            return -1L;
        }
        if (agg instanceof Struct) {
            long lSize = ((Struct)agg).getSize();
            if (this.fDbgLevel > 3) {
                this.debug.print(4, " sizeofStruct " + lSize);
            }
            return lSize;
        }
        if (agg instanceof Union) {
            long lSize = ((Union)agg).getSize();
            if (this.fDbgLevel > 3) {
                this.debug.print(4, " sizeofUnion " + lSize);
            }
            return lSize;
        }
        throw new ParseError(this.lex, "wrong tag name");
    }

    public long sizeofUnion(String tagName) throws ParseError {
        return this.sizeofStruct(tagName);
    }

    private void skipChar(char c) throws ParseError, IOException {
        if (this.lex.get() != c) {
            if (this.fDbgLevel > 3) {
                this.debug.print(4, " skipChar " + c);
            }
            throw new ParseError(this.lex, c);
        }
    }

    public ASTList read() throws IOException {
        try {
            if (this.fDbgLevel > 3) {
                this.debug.print(4, "read ", this.lex.lookAhead() + " " + (char)this.lex.lookAhead() + " " + this.lex.getString());
            }
            return CompoundStmnt.concat(this.pragmaList(), this.definition());
        }
        catch (ParseError err) {
            this.showErrorMessage(err);
            CompoundStmnt result = new CompoundStmnt(new NullStmnt(this.lex.getFileName(), this.lex.getLineNumber()));
            while (true) {
                int t;
                if ((t = this.lex.get()) == -1) {
                    return result;
                }
                if (t != 125) continue;
                try {
                    return this.definition();
                }
                catch (ParseError err2) {
                    continue;
                }
                break;
            }
        }
    }

    private CompoundStmnt pragmaList() throws IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " pragmaList ");
        }
        this.lex.lookAhead();
        CompoundStmnt list = null;
        while (this.pragmaList.size() > 0) {
            list = new CompoundStmnt((Pragma)this.pragmaList.removeLast(), list);
        }
        return list;
    }

    private CompoundStmnt definition() throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " definition");
        }
        int t = this.lex.lookAhead();
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "definition ", t + " " + (char)t);
        }
        if (t == 59) {
            this.lex.get();
            return new CompoundStmnt(new NullStmnt(this.lex.getFileName(), this.lex.getLineNumber()));
        }
        if (t == 315) {
            return this.typdefDeclaration();
        }
        return this.toplevelDeclaration();
    }

    private CompoundStmnt typdefDeclaration() throws ParseError, IOException {
        CompoundStmnt decls;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " typedefDeclaration ");
        }
        if (this.lex.get() != 315) {
            throw new ParseError(this.lex);
        }
        String filename = this.lex.getFileName();
        int lineNumber = this.lex.getLineNumber();
        EncodedType etype = new EncodedType();
        CompoundStmnt types = this.typeSpecifier(etype, null);
        for (CompoundStmnt list = decls = this.declaratorList(etype, false); list != null; list = list.next()) {
            Declarator d = (Declarator)list.head();
            if (d.getBitFieldSize() > 0) {
                throw new ParseError(this.lex, filename, lineNumber, "bad bit field");
            }
            d.setTypedefed(true);
            this.symTable.put(d.getName(), d.getType());
            if (d.getName().charAt(0) != '_') continue;
            this.symRoot.conflictingSpecialSyms.add(d.getName());
        }
        this.skipChar(';');
        return CompoundStmnt.concat(types, decls);
    }

    private CompoundStmnt typeSpecifier(EncodedType etype, CompoundStmnt typeDecls) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "typeSpecifier ", etype.toString());
        }
        typeDecls = this.typeNameOrStruct(etype, typeDecls);
        this.declaratorArray(etype, false);
        return typeDecls;
    }

    private void typeQualifier(EncodedType etype) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " typeQualifier ");
        }
        int constcount = 0;
        int volatilecount = 0;
        block4: while (true) {
            switch (this.lex.lookAhead()) {
                case 303: {
                    ++constcount;
                    this.lex.get();
                    continue block4;
                }
                case 319: {
                    ++volatilecount;
                    this.lex.get();
                    continue block4;
                }
            }
            break;
        }
        if (constcount > 1) {
            throw new ParseError(this.lex, "duplicate const");
        }
        if (volatilecount > 1) {
            throw new ParseError(this.lex, "duplicate volatile");
        }
        if (constcount > 0) {
            etype.insertCv(303);
        }
        if (volatilecount > 0) {
            etype.insertCv(319);
        }
    }

    private CompoundStmnt typeNameOrStruct(EncodedType etype, CompoundStmnt typeDecls) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "typeNameOrStruct ", etype.toString());
        }
        int externcount = 0;
        int staticcount = 0;
        int autocount = 0;
        int registercount = 0;
        int inlinecount = 0;
        int constcount = 0;
        int volatilecount = 0;
        int signedcount = 0;
        int unsignedcount = 0;
        int shortcount = 0;
        int longcount = 0;
        int type = 0;
        block26: while (true) {
            switch (this.lex.lookAhead()) {
                case 306: {
                    ++externcount;
                    this.lex.get();
                    continue block26;
                }
                case 313: {
                    ++staticcount;
                    this.lex.get();
                    continue block26;
                }
                case 301: {
                    ++autocount;
                    this.lex.get();
                    continue block26;
                }
                case 310: {
                    ++registercount;
                    this.lex.get();
                    continue block26;
                }
                case 334: {
                    ++inlinecount;
                    this.lex.get();
                    continue block26;
                }
                case 303: {
                    ++constcount;
                    this.lex.get();
                    continue block26;
                }
                case 319: {
                    ++volatilecount;
                    this.lex.get();
                    continue block26;
                }
                case 312: {
                    ++signedcount;
                    this.lex.get();
                    continue block26;
                }
                case 317: {
                    ++unsignedcount;
                    this.lex.get();
                    continue block26;
                }
                case 311: {
                    ++shortcount;
                    this.lex.get();
                    continue block26;
                }
                case 309: {
                    ++longcount;
                    this.lex.get();
                    continue block26;
                }
                case 302: 
                case 304: 
                case 307: 
                case 308: 
                case 318: {
                    if (type != 0) {
                        throw new ParseError(this.lex, "two or more data types");
                    }
                    type = this.lex.get();
                    continue block26;
                }
                case 409: {
                    if (type != 0 || signedcount + unsignedcount + shortcount + longcount > 0) break block26;
                    type = this.lex.get();
                    typeDecls = this.typedefName(etype, typeDecls);
                    continue block26;
                }
                case 314: {
                    if (type != 0) {
                        throw new ParseError(this.lex, "two or more data types");
                    }
                    type = this.lex.get();
                    typeDecls = this.structDecl(etype, false, typeDecls);
                    continue block26;
                }
                case 316: {
                    if (type != 0) {
                        throw new ParseError(this.lex, "two or more data types");
                    }
                    type = this.lex.get();
                    typeDecls = this.structDecl(etype, true, typeDecls);
                    continue block26;
                }
                case 305: {
                    if (type != 0) {
                        throw new ParseError(this.lex, "two or more data types");
                    }
                    type = this.lex.get();
                    typeDecls = this.enumDecl(etype, typeDecls);
                    continue block26;
                }
            }
            break;
        }
        if (externcount > 1) {
            throw new ParseError(this.lex, "duplicate extern");
        }
        if (staticcount > 1) {
            throw new ParseError(this.lex, "duplicate static");
        }
        if (autocount > 1) {
            throw new ParseError(this.lex, "duplicate auto");
        }
        if (registercount > 1) {
            throw new ParseError(this.lex, "duplicate register");
        }
        if (inlinecount > 1) {
            throw new ParseError(this.lex, "duplicate inline");
        }
        if (externcount + staticcount + autocount + registercount + inlinecount > 1) {
            throw new ParseError(this.lex, "multiple storage classes in declaration");
        }
        if (constcount > 1) {
            throw new ParseError(this.lex, "duplicate const");
        }
        if (volatilecount > 1) {
            throw new ParseError(this.lex, "duplicate volatile");
        }
        switch (type) {
            case 318: {
                if (signedcount > 0) {
                    throw new ParseError(this.lex, "signed specified with void");
                }
                if (unsignedcount > 0) {
                    throw new ParseError(this.lex, "unsigned specified with void");
                }
                if (shortcount > 0) {
                    throw new ParseError(this.lex, "short specified with void");
                }
                if (longcount > 0) {
                    throw new ParseError(this.lex, "long specified with void");
                }
                etype.insert('v');
                break;
            }
            case 0: 
            case 308: {
                if (signedcount > 1) {
                    throw new ParseError(this.lex, "duplicate signed");
                }
                if (unsignedcount > 1) {
                    throw new ParseError(this.lex, "duplicate unsigned");
                }
                if (signedcount + unsignedcount > 1) {
                    throw new ParseError(this.lex, "both signed and unsigned specified");
                }
                if (shortcount > 1) {
                    throw new ParseError(this.lex, "duplicate short");
                }
                if (longcount > 2) {
                    throw new ParseError(this.lex, "a lot of long specified");
                }
                if (shortcount > 0 && longcount > 0) {
                    throw new ParseError(this.lex, "both long and short specified");
                }
                etype.insert((char)(shortcount == 1 ? 115 : (longcount == 1 ? 108 : (longcount == 2 ? 106 : 105))));
                etype.insert(unsignedcount == 1 ? (char)'U' : 'S');
                break;
            }
            case 302: {
                if (signedcount > 1) {
                    throw new ParseError(this.lex, "duplicate signed");
                }
                if (unsignedcount > 1) {
                    throw new ParseError(this.lex, "duplicate unsigned");
                }
                if (signedcount + unsignedcount > 1) {
                    throw new ParseError(this.lex, "both signed and unsigned specified");
                }
                if (shortcount + longcount > 0) {
                    throw new ParseError(this.lex, "long or short specified with char");
                }
                etype.insert('c');
                etype.insert((char)(signedcount == 1 ? 83 : (unsignedcount == 1 ? 85 : (this.symRoot.getCharType() == this.symRoot.typeChar ? 83 : 85))));
                break;
            }
            case 307: {
                if (signedcount > 0) {
                    throw new ParseError(this.lex, "signed specified with float");
                }
                if (unsignedcount > 0) {
                    throw new ParseError(this.lex, "unsigned specified with float");
                }
                if (shortcount > 0) {
                    throw new ParseError(this.lex, "short specified with float");
                }
                if (longcount > 0) {
                    throw new ParseError(this.lex, "long specified with float");
                }
                etype.insert('f');
                break;
            }
            case 304: {
                if (signedcount > 0) {
                    throw new ParseError(this.lex, "signed specified with double");
                }
                if (unsignedcount > 0) {
                    throw new ParseError(this.lex, "unsigned specified with double");
                }
                if (shortcount > 0) {
                    throw new ParseError(this.lex, "short specified with double");
                }
                if (longcount > 1) {
                    throw new ParseError(this.lex, "a lot of long specified with double");
                }
                etype.insert(longcount == 1 ? (char)'r' : 'd');
                break;
            }
            case 305: 
            case 314: 
            case 316: 
            case 409: {
                if (signedcount > 0) {
                    throw new ParseError(this.lex, "signed is invalid");
                }
                if (unsignedcount > 0) {
                    throw new ParseError(this.lex, "unsigned is invalid");
                }
                if (shortcount > 0) {
                    throw new ParseError(this.lex, "short is invalid");
                }
                if (longcount <= 0) break;
                throw new ParseError(this.lex, "long is invalid");
            }
        }
        if (volatilecount > 0) {
            etype.insertCv(319);
        }
        if (constcount > 0) {
            etype.insertCv(303);
        }
        etype.setStorageClass(externcount > 0 ? 2 : (staticcount > 0 ? 1 : (autocount > 0 ? 4 : (registercount > 0 ? 16 : (inlinecount > 0 ? 8 : 0)))));
        return typeDecls;
    }

    private char signedOrUnsigend(char sign) throws ParseError, IOException {
        char sign2 = '\u0000';
        int t = this.lex.lookAhead();
        if (t == 312) {
            sign2 = 'S';
        } else if (t == 317) {
            sign2 = 'U';
        } else {
            return sign;
        }
        this.lex.get();
        if (sign != '\u0000' && sign != sign2) {
            throw new ParseError(this.lex);
        }
        return sign2;
    }

    private CompoundStmnt typedefName(EncodedType etype, CompoundStmnt typeDecls) throws ParseError, IOException {
        Object encoded;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " typedefName ");
        }
        if (!((encoded = this.symTable.get(this.lex.getString())) instanceof byte[])) {
            throw new ParseError(this.lex, "unknown type: " + this.lex.getString());
        }
        etype.insert((byte[])encoded);
        return typeDecls;
    }

    private CompoundStmnt structDecl(EncodedType etype, boolean isUnion, CompoundStmnt typeDecls) throws ParseError, IOException {
        Aggregate r;
        String name;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "structDecl ", etype.toString());
        }
        String fileName = this.lex.getFileName();
        int lineNumber = this.lex.getLineNumber();
        int t = this.lex.get();
        if (t == 400 || t == 409) {
            name = this.lex.getString();
            if (this.lex.lookAhead() != 123) {
                name = this.lex.lookAhead() == 59 ? this.recordTag(name) : this.toEncodedTag(name);
                if (isUnion) {
                    etype.insertUnion(name);
                } else {
                    etype.insertStruct(name);
                }
                return typeDecls;
            }
            t = this.lex.get();
        } else {
            name = this.uniqueName();
        }
        if (t != 123) {
            throw new ParseError(this.lex, '{');
        }
        DeclaratorList members = null;
        typeDecls = new CompoundStmnt(null, typeDecls);
        while (true) {
            if ((t = this.lex.lookAhead()) == 59) {
                this.lex.get();
                continue;
            }
            if (t == 125) break;
            members = DeclaratorList.concat(members, this.memberDeclarator(typeDecls));
        }
        this.lex.get();
        String encodedName = this.getNewEncodedTag(name);
        if (isUnion) {
            etype.insertUnion(encodedName);
            r = this.makeUnion(encodedName, members, fileName, lineNumber);
        } else {
            etype.insertStruct(encodedName);
            r = this.makeStruct(encodedName, members, fileName, lineNumber);
        }
        this.recordTag(name, r);
        return CompoundStmnt.append(typeDecls.next(), r);
    }

    private DeclaratorList memberDeclarator(CompoundStmnt typeDecls) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " memberDeclarator ");
        }
        EncodedType etype = new EncodedType();
        this.typeSpecifier(etype, typeDecls);
        CompoundStmnt dlist = this.declaratorList(etype, true);
        this.skipChar(';');
        return this.checkMemDecls(dlist);
    }

    private DeclaratorList checkMemDecls(ASTList list) throws ParseError {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " checkMemDecls ");
        }
        if (list == null) {
            return null;
        }
        Declarator d = (Declarator)list.head();
        int c = EncodedType.getTypeChar(d.getType(), 0);
        if (c == 70 || c == 118) {
            throw new ParseError(this.lex, "invalid member type: " + d.getName());
        }
        return new DeclaratorList(d, this.checkMemDecls(list.tail()));
    }

    private CompoundStmnt enumDecl(EncodedType etype, CompoundStmnt typeDecls) throws ParseError, IOException {
        String name;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " enumDecl ");
        }
        String fileName = this.lex.getFileName();
        int lineNumber = this.lex.getLineNumber();
        int t = this.lex.get();
        if (t == 400) {
            name = this.lex.getString();
            if (this.lex.lookAhead() != 123) {
                etype.insertEnum(name);
                return typeDecls;
            }
            t = this.lex.get();
        } else {
            name = this.uniqueName();
        }
        if (t != 123) {
            throw new ParseError(this.lex, '{');
        }
        etype.insertEnum(name);
        Enum e = new Enum(name, fileName, lineNumber);
        this.enumBody(e);
        return CompoundStmnt.append(typeDecls, e);
    }

    private void enumBody(Enum enumDecl) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " enumBody ");
        }
        long value = 0L;
        block4: while (true) {
            switch (this.lex.get()) {
                case 400: {
                    String name = this.lex.getString();
                    if (this.lex.lookAhead() == 61) {
                        this.lex.get();
                        value = this.constantExp();
                    }
                    ConstantExpr valueExpr = this.evaluator.make(value++);
                    enumDecl.add(name, valueExpr);
                    this.symTable.put(name, valueExpr);
                    if (name.charAt(0) == '_') {
                        this.symRoot.conflictingSpecialSyms.add(name);
                    }
                    if (this.lex.lookAhead() != 44) continue block4;
                    this.lex.get();
                    continue block4;
                }
                case 125: {
                    return;
                }
            }
            break;
        }
        throw new ParseError(this.lex, '}');
    }

    private CompoundStmnt declaratorList(EncodedType etype, boolean acceptBitfiled) throws ParseError, IOException {
        return this.declaratorList(etype, acceptBitfiled, false, false);
    }

    private CompoundStmnt declaratorList(EncodedType etype, boolean acceptBitfiled, boolean recordVar, boolean isArg) throws ParseError, IOException {
        CompoundStmnt decls = null;
        int p = etype.save();
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "declaratorList ", etype.toString());
        }
        if (this.lex.lookAhead() != 59) {
            while (true) {
                Declarator d;
                if (acceptBitfiled && this.lex.lookAhead() == 58) {
                    d = this.makeDeclarator(this.uniqueName(), this.lex);
                    d.setType(etype.get(), etype.computeSizeof(this));
                    d.setArrayParamSize(etype.getArrayParamSize());
                    d.setStorage(etype.getStorageClass());
                    this.lex.get();
                    this.setBitFieldSize(d, (int)this.constantExp());
                    d.setAsBitField();
                } else {
                    etype.restore(p);
                    d = this.declarator(etype, isArg);
                    if (d == null) break;
                    d.setType(etype.get(), etype.computeSizeof(this));
                    d.setArrayParamSize(etype.getArrayParamSize());
                    d.setStorage(etype.getStorageClass());
                    int t = this.lex.lookAhead();
                    if (t == 61) {
                        this.lex.get();
                        d.setInitializer(this.initializeExpr(etype, d));
                    } else if (acceptBitfiled && t == 58) {
                        this.lex.get();
                        this.setBitFieldSize(d, (int)this.constantExp());
                        d.setAsBitField();
                    }
                }
                if (recordVar) {
                    this.recordSymbol(d.getName(), d);
                }
                decls = CompoundStmnt.concat(this.pragmaList(), decls);
                decls = CompoundStmnt.append(decls, d);
                if (this.lex.lookAhead() != 44) break;
                this.lex.get();
            }
        }
        return decls;
    }

    private Declarator makeDeclarator(Lex lex) {
        return this.makeDeclarator(lex.getString(), lex);
    }

    private Declarator makeDeclarator(String name, Lex lex) {
        return this.makeDeclarator(name, lex.getFileName(), lex.getLineNumber());
    }

    private void setBitFieldSize(Declarator d, int s) throws ParseError {
        if (s < 1) {
            throw new ParseError(this.lex, "bad bit-field member size");
        }
        if (!EncodedType.isIndex(d.getType(), 0)) {
            throw new ParseError(this.lex, "bad bit-field member type");
        }
        d.setBitFieldSize(s);
    }

    private Declarator declarator(EncodedType etype, boolean isArg) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " declarator ", this.lex.getString() + " etype " + etype.toString() + " " + isArg);
        }
        if (this.lex.lookAhead() == 413) {
            this.lex.get();
            this.lex.get();
            Pragma lPragma = new Pragma(this.lex.getString(), this.lex.getFileName(), this.lex.getLineNumber());
            this.pragmaList.add(lPragma);
            return null;
        }
        while (this.lex.lookAhead() == 42) {
            this.lex.get();
            if (this.fDbgLevel > 3) {
                this.debug.print(4, " insert pointer ");
            }
            etype.insert('P');
            this.typeQualifier(etype);
        }
        int c = this.lex.lookAhead();
        if (c == 400 || c == 409) {
            this.lex.get();
            Declarator decl = this.makeDeclarator(this.lex);
            decl.setArgs(this.declaratorTail(etype, isArg));
            return decl;
        }
        if (c == 40 && !this.lex.isType(this.lex.lookAhead(1)) && this.lex.lookAhead(1) != 41) {
            if (this.fDbgLevel > 3) {
                this.debug.print(4, " within parenthesis ");
            }
            this.lex.get();
            EncodedType etype2 = new EncodedType();
            Declarator decl = this.declarator(etype2, isArg);
            this.skipChar(')');
            this.declaratorTail(etype, false);
            etype.insert(etype2);
            return decl;
        }
        if (isArg) {
            this.declaratorTail(etype, isArg);
            return null;
        }
        throw new ParseError(this.lex);
    }

    private Declarator declaratorOld(EncodedType etype, boolean isArg) throws ParseError, IOException {
        while (this.lex.lookAhead() == 42) {
            this.lex.get();
            etype.insert('P');
            this.typeQualifier(etype);
        }
        int c = this.lex.lookAhead();
        if (c == 400 || c == 409) {
            this.lex.get();
            Declarator decl = this.makeDeclarator(this.lex);
            decl.setArgs(this.declaratorTail(etype, isArg));
            decl.setType(etype.get(), etype.computeSizeof(this));
            decl.setArrayParamSize(etype.getArrayParamSize());
            return decl;
        }
        if (c == 40) {
            this.lex.get();
            EncodedType etype2 = new EncodedType();
            Declarator decl = this.declarator(etype2, isArg);
            this.skipChar(')');
            this.declaratorTail(etype, false);
            etype.insert(etype2);
            if (decl != null) {
                decl.setType(etype.get(), etype.computeSizeof(this));
                decl.setArrayParamSize(etype.getArrayParamSize());
            }
            return decl;
        }
        if (isArg) {
            this.declaratorTail(etype, isArg);
            return null;
        }
        throw new ParseError(this.lex);
    }

    private DeclaratorList declaratorTail(EncodedType etype, boolean isArg) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " declaratorTail ");
        }
        while (this.lex.lookAhead() == 42) {
            this.lex.get();
            etype.insert('P');
            this.typeQualifier(etype);
        }
        DeclaratorList args = null;
        this.declaratorArray(etype, isArg);
        if (this.lex.lookAhead() == 40) {
            this.lex.get();
            etype.insert('$');
            args = this.argTypeList(etype);
            etype.insert('F');
            if (this.fDbgLevel > 3) {
                this.debug.print(4, " insert function " + etype.toString());
            }
            this.skipChar(')');
        }
        this.typeQualifier(etype);
        return args;
    }

    private void declaratorArray(EncodedType etype, boolean isArg) throws ParseError, IOException {
        long size;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " declaratorArray " + etype.toString() + " isArg " + isArg);
        }
        if (this.lex.lookAhead() != 91) {
            return;
        }
        this.lex.get();
        if (this.lex.lookAhead() == 93) {
            size = -1L;
        } else {
            size = this.constantExp();
            if (size < 0L) {
                throw new ParseError(this.lex, "negative array size");
            }
        }
        this.skipChar(']');
        this.declaratorArray(etype, false);
        if (isArg) {
            etype.insert('P');
            etype.setArrayParamSize(size);
        } else {
            etype.insertDim(size);
        }
    }

    private DeclaratorList argTypeList(EncodedType etype) throws ParseError, IOException {
        int t;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " argTypeList ");
        }
        if ((t = this.lex.lookAhead()) == 41) {
            etype.insert('e');
            return null;
        }
        if (t == 318 && this.lex.lookAhead(1) == 41) {
            this.lex.get();
            etype.insert('v');
            return null;
        }
        if (t == 370) {
            this.lex.get();
            if (this.lex.lookAhead() != 41) {
                throw new ParseError(this.lex, ')');
            }
            etype.insert('e');
            return null;
        }
        return this.argTypeList2(etype);
    }

    private DeclaratorList argTypeList2(EncodedType etype) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " argTypeList2 ");
        }
        DeclaratorList args = null;
        EncodedType etype2 = new EncodedType();
        Declarator a = this.argType(etype2);
        int c = this.lex.lookAhead();
        if (c == 370) {
            this.lex.get();
            etype.insert('e');
        } else if (c == 44) {
            this.lex.get();
            c = this.lex.lookAhead();
            if (c == 41 || c == 370) {
                if (c == 370) {
                    this.lex.get();
                }
                etype.insert('e');
            } else {
                args = this.argTypeList2(etype);
            }
        }
        etype.insert(etype2);
        return new DeclaratorList(a, args);
    }

    private Declarator argType(EncodedType etype) throws ParseError, IOException {
        int t;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " argType " + etype.toString());
        }
        if ((t = this.lex.lookAhead()) == 310) {
            this.lex.get();
        }
        if (this.typeSpecifier(etype, null) != null) {
            throw new ParseError(this.lex, "cannot declare a struct/union here");
        }
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " argType " + etype.toString());
        }
        Declarator decl = this.declarator(etype, true);
        if (etype.isFunction()) {
            etype.insert('P');
        }
        if (decl == null) {
            decl = this.makeDeclarator(this.uniqueName(), this.lex);
        }
        decl.setType(etype.get(), etype.computeSizeof(this));
        decl.setArrayParamSize(etype.getArrayParamSize());
        return decl;
    }

    private CompoundStmnt toplevelDeclaration() throws IOException, ParseError {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " toplevelDeclaration " + this.lex.getString() + " lookAhead " + this.lex.lookAhead());
        }
        if (this.lex.lookAhead() == 413) {
            this.debug.print(1, "\npragma in toplevelDeclaration ");
            this.lex.get();
            Pragma lPragma = new Pragma(this.lex.getString(), this.lex.getFileName(), this.lex.getLineNumber());
            return new CompoundStmnt(lPragma);
        }
        CompoundStmnt types = null;
        EncodedType etype = new EncodedType();
        if (this.lex.lookAhead() == 400) {
            etype.insert('i');
        } else {
            types = this.typeSpecifier(etype, null);
            if (this.lex.lookAhead() == 59) {
                this.lex.get();
                return types;
            }
        }
        int starcount = 0;
        while (this.lex.lookAhead(starcount) == 42) {
            ++starcount;
        }
        if (this.lex.lookAhead(starcount) == 400 && this.lex.lookAhead(starcount + 1) == 40 && this.lex.lookAhead(starcount + 2) == 400) {
            return this.oldFuncDecl(etype, types);
        }
        CompoundStmnt decls = types;
        EncodedType etype2 = new EncodedType();
        etype2.copy(etype);
        int p = etype.save();
        int loopCount = 0;
        while (true) {
            if (1000 <= loopCount) {
                throw new ParseError(this.lex, "unexpected symbol");
            }
            etype.restore(p);
            etype.copy(etype2);
            Declarator d = this.declarator(etype, false);
            if (this.lex.lookAhead() == 123) {
                etype.ellipsisToVoid();
            }
            if (d == null) {
                if (this.fDbgLevel > 3) {
                    this.debug.print(4, "\n pragma may have appeared ");
                }
            } else {
                d.setType(etype.get(), etype.computeSizeof(this));
                d.setArrayParamSize(etype.getArrayParamSize());
                d.setStorage(etype.getStorageClass());
                int t = this.lex.lookAhead();
                if (loopCount == 0 && t == 123) {
                    return this.topFuncDecl(etype, d, types);
                }
                this.recordSymbol(d.getName(), d);
                if (t == 61) {
                    this.lex.get();
                    d.setInitializer(this.initializeExpr(etype, d));
                }
                decls = CompoundStmnt.append(decls, d);
                if (this.lex.lookAhead() == 44) {
                    this.lex.get();
                } else if (this.lex.lookAhead() == 59) break;
            }
            ++loopCount;
        }
        this.skipChar(';');
        return decls;
    }

    private Expr initializeExpr(EncodedType etype, Declarator decl) throws ParseError, IOException {
        if (this.fDbgLevel > 2) {
            this.debug.print(3, "initializeExpr", etype.toString());
        }
        if (decl.isTypedef()) {
            throw new ParseError(this.lex, "typedef '" + decl.getName() + "' is initialized like a variable");
        }
        if (etype.isFunction()) {
            throw new ParseError(this.lex, "function '" + decl.getName() + "' is initialized like a variable");
        }
        if (etype.computeSizeof(this) <= 0L && !etype.hasIncompleteArray()) {
            throw new ParseError(this.lex, "variable '" + decl.getName() + "' has initializer but incomplete type");
        }
        if (this.lex.lookAhead() != 123 && this.lex.lookAhead() != 408 && this.lex.lookAhead() != 410) {
            EncodedType etype2 = new EncodedType();
            Expr expr = this.expression(etype2);
            decl.setType(etype.get(), etype.computeSizeof(this));
            decl.setArrayParamSize(etype2.getArrayParamSize());
            return expr;
        }
        Expr expr = this.initializeExprBrace(etype);
        if (etype.hasIncompleteArray()) {
            throw new ParseError(this.lex, "elements of array have incomplete type");
        }
        if (decl != null) {
            decl.setType(etype.get(), etype.computeSizeof(this));
            decl.setArrayParamSize(etype.getArrayParamSize());
        }
        return expr;
    }

    private Expr initializeExprBrace(EncodedType etype) throws ParseError, IOException {
        boolean hasBrace;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " initializerExprBrace ");
        }
        boolean bl = hasBrace = this.lex.lookAhead() == 123;
        if (hasBrace) {
            this.lex.get();
        }
        Expr expr = null;
        switch (etype.getTypeChar()) {
            case 65: {
                EncodedType elemtype = etype.getArrayElemType();
                if (elemtype.getTypeChar() == 99 && (this.lex.lookAhead() == 408 || this.lex.lookAhead() == 410)) {
                    EncodedType etype2 = new EncodedType();
                    expr = this.expression(etype2);
                    etype.setArraySizeIfCharArray(etype2.getArraySize(), this.lex);
                    break;
                }
                int arraysize = etype.getArraySize();
                int n = 0;
                if (!this.isEndOfAggregateInitializer()) {
                    expr = ArrayInitializer.append((ArrayInitializer)expr, this.initializeExprBrace(elemtype), elemtype.get());
                    ++n;
                    while (!(this.isEndOfAggregateInitializer() || arraysize != 0 && n >= arraysize)) {
                        this.skipChar(',');
                        expr = ArrayInitializer.append((ArrayInitializer)expr, this.initializeExprBrace(elemtype), elemtype.get());
                        ++n;
                    }
                }
                if (arraysize != 0) break;
                etype.setArraySize(n, this.lex);
                break;
            }
            case 60: {
                Aggregate aggregate = this.lookupEncodedTag(etype.getTagName());
                DeclaratorList memberlist = aggregate.getMembers();
                if (this.isEndOfAggregateInitializer()) break;
                EncodedType membertype = etype.getDeclaratorType(memberlist.get());
                expr = ArrayInitializer.append((ArrayInitializer)expr, this.initializeExprBrace(membertype), membertype.get());
                for (memberlist = memberlist.next(); !this.isEndOfAggregateInitializer() && memberlist != null; memberlist = memberlist.next()) {
                    if (memberlist.get().getName().indexOf(invalidCChar) < 0) {
                        this.skipChar(',');
                        membertype = etype.getDeclaratorType(memberlist.get());
                        expr = ArrayInitializer.append((ArrayInitializer)expr, this.initializeExprBrace(membertype), membertype.get());
                        continue;
                    }
                    expr = ArrayInitializer.append((ArrayInitializer)expr, this.evaluator.make(0L, membertype.get()), membertype.get());
                }
                break;
            }
            case 40: {
                Aggregate aggregate = this.lookupEncodedTag(etype.getTagName());
                DeclaratorList memberlist = aggregate.getMembers();
                if (this.isEndOfAggregateInitializer() || memberlist == null) break;
                EncodedType membertype = etype.getDeclaratorType(memberlist.get());
                expr = ArrayInitializer.append((ArrayInitializer)expr, this.initializeExprBrace(membertype), membertype.get());
                break;
            }
            default: {
                EncodedType etype2 = new EncodedType();
                expr = this.expression(etype2);
            }
        }
        if (hasBrace) {
            if (this.lex.lookAhead() == 44) {
                this.lex.get();
            }
            if (this.lex.lookAhead() == 125) {
                this.lex.get();
            } else {
                this.lex.warning.put("excess initializer at " + this.lex.getFileName() + ":" + this.lex.getLineNumber());
                while (this.lex.lookAhead() != 125 && this.lex.lookAhead() != 59) {
                    this.lex.get();
                }
                if (this.lex.lookAhead() == 125) {
                    this.lex.get();
                }
            }
        }
        if (this.fDbgLevel > 2) {
            this.debug.print(3, "initializeExprBrace  " + etype + "=" + expr);
        }
        return expr;
    }

    private boolean isEndOfAggregateInitializer() throws IOException {
        return this.lex.lookAhead() == 125 || this.lex.lookAhead() == 44 && this.lex.lookAhead(1) == 125;
    }

    private Expr initializeExpr2(EncodedType etype, Declarator decl) throws ParseError, IOException {
        Expr expr;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " initializeExpr2 ");
        }
        EncodedType etype2 = new EncodedType();
        boolean lWithinBrace = false;
        if (this.fDbgLevel > 2) {
            this.debug.print(3, "initializeExpr2", etype.toString());
        }
        if (this.lex.lookAhead() == 44) {
            this.lex.get();
        }
        if (etype.isArray()) {
            return this.initializeArray(etype, decl);
        }
        if (etype.isStruct()) {
            return this.initializeStruct(etype, decl);
        }
        if (this.lex.lookAhead() == 123) {
            this.lex.get();
            lWithinBrace = true;
        }
        if ((expr = this.expression(etype2)) instanceof StringLiteral) {
            etype.setArraySizeIfCharArray(etype2.getArraySize(), this.lex);
            if (decl != null) {
                decl.setType(etype.get(), etype.computeSizeof(this));
                decl.setArrayParamSize(etype.getArrayParamSize());
            }
        }
        if (this.fDbgLevel > 2) {
            this.debug.print(3, " scalar " + expr.toString());
        }
        if (lWithinBrace && this.lex.lookAhead() == 125) {
            this.lex.get();
        }
        return expr;
    }

    private ArrayInitializer initializeArray(EncodedType etype, Declarator decl) throws ParseError, IOException {
        EncodedType etype2 = new EncodedType();
        EncodedType etype3 = new EncodedType();
        boolean lWithinBrace = false;
        if (this.fDbgLevel > 2) {
            this.debug.print(3, "initializeArray", etype.toString());
        }
        ArrayInitializer init = null;
        etype2.copy(etype);
        int lArraySize = etype.getArraySize();
        EncodedType lElemType = etype.getArrayElemType();
        lArraySize = etype.getArraySize();
        if (this.fDbgLevel > 2) {
            this.debug.print(3, " elem " + lElemType.toString() + " array size " + lArraySize);
        }
        if (this.lex.lookAhead() == 125) {
            if (this.fDbgLevel > 2) {
                this.debug.print(3, " no data ");
            }
            return ArrayInitializer.append(init, null, lElemType.get());
        }
        if (this.lex.lookAhead() != 123 && lElemType.isChar()) {
            Expr expr = this.expression(etype2);
            if (expr instanceof StringLiteral) {
                etype.setArraySizeIfCharArray(etype2.getArraySize(), this.lex);
                if (decl != null) {
                    decl.setType(etype.get(), etype.computeSizeof(this));
                    decl.setArrayParamSize(etype.getArrayParamSize());
                }
                init = ArrayInitializer.append(init, expr, lElemType.get());
            } else {
                init = ArrayInitializer.append(init, expr, lElemType.get());
                for (int lIndex = 1; lIndex < lArraySize && this.lex.lookAhead() != 125; ++lIndex) {
                    etype3.copy(lElemType);
                    Expr expr3 = this.initializeExpr2(etype3, null);
                    if (!(expr3 instanceof ConstantExpr || expr3 instanceof StringLiteral || expr3 instanceof ArrayInitializer || expr3 instanceof VariableExpr)) {
                        throw new ParseError(this.lex, "invalid initializer");
                    }
                    init = ArrayInitializer.append(init, expr3, etype3.get());
                    if (this.lex.lookAhead() != 44) continue;
                    this.lex.get();
                }
            }
            if (this.fDbgLevel > 2) {
                this.debug.print(3, " without brace " + init.toString());
            }
            return init;
        }
        if (lArraySize == 0 && this.lex.lookAhead() == 123) {
            if (this.fDbgLevel > 2) {
                this.debug.print(3, " with brace ");
            }
            this.lex.get();
            int n = 0;
            while (this.lex.lookAhead() != 125) {
                etype3.copy(lElemType);
                Expr expr = this.initializeExpr2(etype3, null);
                if (!(expr instanceof ConstantExpr || expr instanceof StringLiteral || expr instanceof ArrayInitializer || expr instanceof VariableExpr || expr instanceof AddressExpr)) {
                    throw new ParseError(this.lex, "invalid initializer");
                }
                init = ArrayInitializer.append(init, expr, etype3.get());
                ++n;
                if (this.lex.lookAhead() != 44) continue;
                this.lex.get();
            }
            this.lex.get();
            if (init == null) {
                throw new ParseError(this.lex, "an empty initializer");
            }
            etype.setArraySize(n, this.lex);
            if (decl != null) {
                decl.setType(etype.get(), etype.computeSizeof(this));
                decl.setArrayParamSize(etype.getArrayParamSize());
            }
            return init;
        }
        if (this.lex.lookAhead() == 123) {
            this.lex.get();
            lWithinBrace = true;
        }
        for (int lIndex = 0; lIndex < lArraySize && this.lex.lookAhead() != 125; ++lIndex) {
            etype3.copy(lElemType);
            Expr expr3 = this.initializeExpr2(etype3, null);
            if (!(expr3 instanceof ConstantExpr || expr3 instanceof StringLiteral || expr3 instanceof ArrayInitializer || expr3 instanceof VariableExpr || expr3 instanceof AddressExpr)) {
                throw new ParseError(this.lex, "invalid initializer");
            }
            init = ArrayInitializer.append(init, expr3, etype3.get());
            if (this.lex.lookAhead() != 44) continue;
            this.lex.get();
        }
        if (lWithinBrace && this.lex.lookAhead() == 125) {
            this.lex.get();
        }
        if (init == null) {
            throw new ParseError(this.lex, "an empty initializer");
        }
        if (this.fDbgLevel > 2) {
            this.debug.print(3, "  init " + init.toString());
        }
        return init;
    }

    private ArrayInitializer initializeStruct(EncodedType etype, Declarator decl) throws ParseError, IOException {
        DeclaratorList memberList;
        EncodedType etype2 = new EncodedType();
        EncodedType etype3 = new EncodedType();
        String tagName = etype.getTagName();
        ASTree init = null;
        if (this.fDbgLevel > 2) {
            this.debug.print(3, "initializeStruct", etype.toString() + " tag " + tagName);
        }
        Aggregate agg = this.lookupEncodedTag(tagName);
        if (this.lex.lookAhead() == 125) {
            if (this.fDbgLevel > 2) {
                this.debug.print(3, " no data ");
            }
            return ArrayInitializer.append(init, null, null);
        }
        if (this.lex.lookAhead() == 123) {
            this.lex.get();
            boolean n = false;
            for (memberList = agg.getMembers(); memberList != null && this.lex.lookAhead() != 125; memberList = memberList.next()) {
                Declarator lD = memberList.get();
                EncodedType lMemberType = etype.getDeclaratorType(lD);
                etype3.copy(lMemberType);
                Expr expr3 = this.initializeExpr2(etype3, null);
                if (this.fDbgLevel > 2) {
                    this.debug.print(3, " member " + lD.toString() + " " + etype3.toString() + " " + expr3.toString());
                }
                if (!(expr3 instanceof ConstantExpr || expr3 instanceof StringLiteral || expr3 instanceof ArrayInitializer || expr3 instanceof VariableExpr || expr3 instanceof AddressExpr)) {
                    throw new ParseError(this.lex, "invalid initializer");
                }
                init = ArrayInitializer.append((ArrayInitializer)init, expr3, etype3.get());
                if (this.lex.lookAhead() != 44) continue;
                this.lex.get();
            }
            this.lex.get();
            if (init == null) {
                throw new ParseError(this.lex, "an empty initializer");
            }
            if (decl != null) {
                decl.setType(etype.get(), etype.computeSizeof(this));
                decl.setArrayParamSize(etype.getArrayParamSize());
            }
            if (this.fDbgLevel > 2) {
                this.debug.print(3, "  init " + init.toString());
            }
            return init;
        }
        if (memberList != null) {
            if (this.fDbgLevel > 2) {
                this.debug.print(3, "struct init without brace");
            }
            while (memberList != null && this.lex.lookAhead() != 125) {
                Declarator lD = memberList.get();
                EncodedType lMemberType = etype.getDeclaratorType(lD);
                etype3.copy(lMemberType);
                Expr expr3 = this.initializeExpr2(etype3, null);
                if (this.fDbgLevel > 2) {
                    this.debug.print(3, " member " + etype3.toString() + " " + expr3.toString());
                }
                if (!(expr3 instanceof ConstantExpr || expr3 instanceof StringLiteral || expr3 instanceof ArrayInitializer || expr3 instanceof VariableExpr)) {
                    throw new ParseError(this.lex, "invalid initializer");
                }
                init = ArrayInitializer.append((ArrayInitializer)init, expr3, etype3.get());
                if (this.lex.lookAhead() == 44) {
                    this.lex.get();
                }
                memberList = memberList.next();
            }
            return init;
        }
        return null;
    }

    private CompoundStmnt oldFuncDecl(EncodedType etype, CompoundStmnt types) throws IOException, ParseError {
        int t;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "oldFuncDecl etype " + etype.toString());
        }
        while (this.lex.lookAhead() == 42) {
            this.lex.get();
            etype.insert('P');
            this.typeQualifier(etype);
        }
        if (this.lex.get() != 400) {
            throw new ParseError(this.lex);
        }
        Declarator decl = this.makeDeclarator(this.lex);
        decl.setStorage(etype.getStorageClass());
        this.skipChar('(');
        OldFuncArgs args = null;
        do {
            if ((t = this.lex.get()) != 400) {
                throw new ParseError(this.lex);
            }
            args = new OldFuncArgs(this.lex.getString(), args);
        } while ((t = this.lex.get()) == 44);
        if (t != 41) {
            throw new ParseError(this.lex, ')');
        }
        EncodedType etype2 = new EncodedType();
        while (this.lex.lookAhead() != 123) {
            if (this.lex.lookAhead() == 310) {
                this.lex.get();
            }
            etype2.clear();
            types = this.typeSpecifier(etype2, types);
            this.skipChar(';');
            for (CompoundStmnt dlist = this.declaratorList(etype2, false, false, true); dlist != null; dlist = dlist.next()) {
                Declarator d = (Declarator)dlist.head();
                if (d.getInitializer() != null || d.getArgs() != null) {
                    throw new ParseError(this.lex, "bad parameter");
                }
                if (args.subst(d, d.getName())) continue;
                throw new ParseError(this.lex, "bad parameter name");
            }
        }
        decl.setArgs(OldFuncArgs.toDeclList(args, this.lex));
        etype.insert('$');
        etype.insert(args == null ? (char)'v' : 'e');
        etype.insert('F');
        decl.setType(etype.get(), etype.computeSizeof(this));
        decl.setArrayParamSize(etype.getArrayParamSize());
        return this.topFuncDecl(etype, decl, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompoundStmnt topFuncDecl(EncodedType etype, Declarator decl, CompoundStmnt types) throws IOException, ParseError {
        Function f;
        String fname;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "topFuncDecl etype " + etype.toString() + " name " + decl.getName());
        }
        if (this.symTable.get(fname = decl.getName()) == null) {
            this.recordSymbol(fname, decl);
        }
        this.enterNewEnvironment();
        try {
            for (DeclaratorList args = decl.getArgs(); args != null; args = args.next()) {
                Declarator d = args.get();
                this.recordSymbol(d.getName(), d);
            }
            byte[] lbuf = etype.get();
            decl.setType(lbuf, EncodedType.FUNCTION_TYPE_SIZE);
            f = this.makeFunction(decl, this.statement(false));
        }
        finally {
            this.exitEnvironment();
        }
        return CompoundStmnt.append(types, f);
    }

    private CompoundStmnt statement(boolean inSwitch) throws ParseError, IOException {
        CompoundStmnt r;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "statement", "lex " + this.lex.getString() + " ahead " + this.lex.lookAhead() + " " + (char)this.lex.lookAhead());
        }
        switch (this.lex.lookAhead()) {
            case 123: {
                r = this.compoundStatement(inSwitch);
                break;
            }
            case 329: {
                r = this.ifStatement(inSwitch);
                break;
            }
            case 333: {
                r = this.whileStatement(inSwitch);
                break;
            }
            case 325: {
                r = this.doStatement(inSwitch);
                break;
            }
            case 327: {
                r = this.forStatement(inSwitch);
                break;
            }
            case 332: {
                r = this.switchStatement(inSwitch);
                break;
            }
            case 321: {
                this.lex.get();
                r = this.statement0(new BreakStmnt(this.lex.getFileName(), this.lex.getLineNumber()));
                break;
            }
            case 323: {
                this.lex.get();
                r = this.statement0(new ContinueStmnt(this.lex.getFileName(), this.lex.getLineNumber()));
                break;
            }
            case 330: {
                this.lex.get();
                ReturnStmnt t = new ReturnStmnt(null, this.lex.getFileName(), this.lex.getLineNumber());
                if (this.lex.lookAhead() != 59) {
                    t.setLeft((ASTree)((Object)this.commaExpr(new EncodedType())));
                }
                r = this.statement0(t);
                break;
            }
            case 315: {
                r = this.typdefDeclaration();
                break;
            }
            case 328: {
                this.lex.get();
                GotoStmnt gs = new GotoStmnt(this.lex.getFileName(), this.lex.getLineNumber());
                if (this.lex.get() != 400) {
                    throw new ParseError(this.lex);
                }
                gs.setLabel(this.lex.getString());
                r = this.statement0(gs);
                break;
            }
            case 322: {
                this.lex.get();
                CaseLabel s = new CaseLabel(this.constantExp(), this.lex.getFileName(), this.lex.getLineNumber());
                r = this.statement1(s, inSwitch);
                break;
            }
            case 324: {
                this.lex.get();
                DefaultLabel s = new DefaultLabel(this.lex.getFileName(), this.lex.getLineNumber());
                r = this.statement1(s, inSwitch);
                break;
            }
            case 413: {
                String lPragmaString = this.lex.getString();
                this.lex.get();
                Pragma lPragma = new Pragma(lPragmaString, this.lex.getFileName(), this.lex.getLineNumber());
                r = new CompoundStmnt(lPragma);
                break;
            }
            case 400: {
                if (this.lex.lookAhead(1) == 58) {
                    this.lex.get();
                    NamedLabel s = new NamedLabel(this.lex.getString(), this.lex.getFileName(), this.lex.getLineNumber());
                    if (this.lex.getString().charAt(0) == '_') {
                        this.symRoot.conflictingSpecialSyms.add(this.lex.getString());
                    }
                    r = this.statement1(s, inSwitch);
                    if (this.fDbgLevel <= 3) break;
                    this.debug.print(4, "label", "lex " + this.lex.getString() + " ahead " + this.lex.lookAhead() + " " + (char)this.lex.lookAhead());
                    break;
                }
            }
            default: {
                r = this.exprStatement();
            }
        }
        return CompoundStmnt.concat(this.pragmaList(), r);
    }

    private CompoundStmnt statement0(Stmnt s) throws ParseError, IOException {
        this.skipChar(';');
        return new CompoundStmnt(s);
    }

    private CompoundStmnt statement1(Stmnt s, boolean inSwitch) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " statement1 ");
        }
        this.skipChar(':');
        if (this.lex.lookAhead() != 125) {
            int lHead = this.lex.lookAhead();
            CompoundStmnt lStmnt = this.statement(inSwitch);
            if (lHead == 123) {
                return new CompoundStmnt(s, new CompoundStmnt(lStmnt));
            }
            return new CompoundStmnt(s, lStmnt);
        }
        return new CompoundStmnt(s, new CompoundStmnt(new NullStmnt(this.lex.getFileName(), this.lex.getLineNumber())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompoundStmnt compoundStatement(boolean inSwitch) throws IOException, ParseError {
        this.skipChar('{');
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "compoundStatement", "lex " + this.lex.getString() + " lookAhead " + (char)this.lex.lookAhead());
        }
        if (this.lex.lookAhead() == 125) {
            this.lex.get();
            return new CompoundStmnt(new NullStmnt(this.lex.getFileName(), this.lex.getLineNumber()));
        }
        CompoundStmnt s = null;
        this.enterNewEnvironment();
        try {
            do {
                int t1 = this.lex.lookAhead();
                if (this.fDbgLevel > 3) {
                    this.debug.print(4, " within compound ", "lex " + this.lex.getString() + " ahead " + t1);
                }
                if (t1 == 413) {
                    Pragma lPragma = new Pragma(this.lex.getString(), this.lex.getFileName(), this.lex.getLineNumber());
                    this.lex.get();
                    CompoundStmnt cs = new CompoundStmnt(lPragma);
                    s = CompoundStmnt.concat(s, cs);
                    this.debug.print(4, "concat pragma ", s.toString());
                    continue;
                }
                CompoundStmnt cs = this.statement(inSwitch);
                if (t1 == 123) {
                    if (this.fDbgLevel > 3) {
                        this.debug.print(4, " nested compound ", "lex " + this.lex.getString() + " ahead " + t1);
                    }
                    cs = new CompoundStmnt(cs);
                }
                s = CompoundStmnt.concat(s, cs);
                this.debug.print(4, "concat stmt ", s.toString());
            } while (this.lex.lookAhead() != 125);
            if (this.fDbgLevel > 3) {
                this.debug.print(4, "compoundStatement result ", s.toString());
            }
        }
        finally {
            this.exitEnvironment();
        }
        if (!(s instanceof CompoundStmnt)) {
            s = new CompoundStmnt(s);
        }
        if (this.lex.lookAhead() == 125) {
            this.lex.get();
        }
        if (this.fDbgLevel > 3) {
            this.debug.print(5, " compoundStatement", "result " + s);
        }
        return s;
    }

    private CompoundStmnt ifStatement(boolean inSwitch) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " ifStatement ");
        }
        this.lex.get();
        IfStmnt s = new IfStmnt(this.lex.getFileName(), this.lex.getLineNumber());
        this.skipChar('(');
        Expr cond = this.commaExpr(new EncodedType());
        this.skipChar(')');
        CompoundStmnt thenp = this.statement(inSwitch);
        CompoundStmnt elsep = null;
        if (this.lex.lookAhead() == 326) {
            this.lex.get();
            elsep = this.statement(inSwitch);
        }
        return new CompoundStmnt(s.set(cond, thenp, elsep));
    }

    private CompoundStmnt whileStatement(boolean inSwitch) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " whileStatement ");
        }
        this.lex.get();
        WhileStmnt s = new WhileStmnt(this.lex.getFileName(), this.lex.getLineNumber());
        this.skipChar('(');
        Expr cond = this.commaExpr(new EncodedType());
        this.skipChar(')');
        CompoundStmnt body = this.statement(inSwitch);
        return new CompoundStmnt(s.set(cond, body));
    }

    private CompoundStmnt doStatement(boolean inSwitch) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " doStatement ");
        }
        this.lex.get();
        DoStmnt s = new DoStmnt(this.lex.getFileName(), this.lex.getLineNumber());
        CompoundStmnt body = this.statement(inSwitch);
        if (this.lex.get() != 333) {
            throw new ParseError(this.lex);
        }
        this.skipChar('(');
        Expr cond = this.commaExpr(new EncodedType());
        this.skipChar(')');
        this.skipChar(';');
        return new CompoundStmnt(s.set(body, cond));
    }

    private CompoundStmnt forStatement(boolean inSwitch) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " forStatement ");
        }
        this.lex.get();
        ForStmnt s = new ForStmnt(this.lex.getFileName(), this.lex.getLineNumber());
        this.skipChar('(');
        Expr init = this.lex.lookAhead() == 59 ? null : this.commaExpr(new EncodedType());
        this.skipChar(';');
        Expr cond = this.lex.lookAhead() == 59 ? null : this.commaExpr(new EncodedType());
        this.skipChar(';');
        Expr iterate = this.lex.lookAhead() == 41 ? null : this.commaExpr(new EncodedType());
        this.skipChar(')');
        CompoundStmnt body = this.statement(inSwitch);
        return new CompoundStmnt(s.set(init, cond, iterate, body));
    }

    private CompoundStmnt switchStatement(boolean inSwitch) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " switchStatement ");
        }
        this.lex.get();
        SwitchStmnt s = new SwitchStmnt(this.lex.getFileName(), this.lex.getLineNumber());
        this.skipChar('(');
        Expr cond = this.commaExpr(new EncodedType());
        this.skipChar(')');
        CompoundStmnt body = this.statement(true);
        return new CompoundStmnt(s.set(cond, body));
    }

    private CompoundStmnt exprStatement() throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "exprStatement ", "lex " + this.lex.getString());
        }
        if (this.lex.lookAhead() == 59) {
            this.lex.get();
            return new CompoundStmnt(new NullStmnt(this.lex.getFileName(), this.lex.getLineNumber()));
        }
        if (this.isExpression(0)) {
            if (this.fDbgLevel > 3) {
                this.debug.print(4, "ExpressionStmnt ");
            }
            ExpressionStmnt s = new ExpressionStmnt(this.lex.getFileName(), this.lex.getLineNumber());
            s.setExpr(this.commaExpr(new EncodedType()));
            this.skipChar(';');
            return new CompoundStmnt(s);
        }
        if (this.lex.lookAhead() == 300) {
            if (this.fDbgLevel > 3) {
                this.debug.print(4, "asm as a statement ");
            }
            ExpressionStmnt s = new ExpressionStmnt(this.lex.getFileName(), this.lex.getLineNumber());
            s.setExpr(this.commaExpr(new EncodedType()));
            this.skipChar(';');
            return new CompoundStmnt(s);
        }
        return this.declarationStatement();
    }

    private boolean isExpression(int pos) throws IOException {
        int t = this.lex.lookAhead(pos);
        return t == 400 || t == 364 || t == 365 || t == 401 || t == 402 || t == 403 || t == 404 || t == 405 || t == 411 || t == 412 || t == 406 || t == 407 || t == 408 || t == 410 || t == 43 || t == 45 || t == 33 || t == 126 || t == 46 || t == 331 || t == 40 || t == 42 || t == 38;
    }

    private CompoundStmnt declarationStatement() throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "declarationStatement ", "lex " + this.lex.getString());
        }
        if (this.lex.lookAhead() == 413) {
            this.lex.get();
            this.lex.get();
            Pragma lPragma = new Pragma(this.lex.getString(), this.lex.getFileName(), this.lex.getLineNumber());
            return new CompoundStmnt(lPragma);
        }
        EncodedType etype = new EncodedType();
        CompoundStmnt typeDecls = this.typeSpecifier(etype, null);
        if (this.lex.lookAhead() == 59) {
            this.lex.get();
            if (typeDecls == null) {
                typeDecls = new CompoundStmnt(new NullStmnt(this.lex.getFileName(), this.lex.getLineNumber()));
            }
            return typeDecls;
        }
        CompoundStmnt dlist = this.declaratorList(etype, false, true, false);
        this.skipChar(';');
        return CompoundStmnt.concat(typeDecls, dlist);
    }

    private long constantExp() throws ParseError, IOException {
        Const c;
        HIR h;
        Expr expr;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " constantExp ");
        }
        if ((expr = this.expression(new EncodedType())) instanceof ASTree && (h = this.toHirC.visit((ASTree)((Object)expr))) instanceof Exp && (c = ((Exp)h).evaluate()) instanceof IntConst) {
            return ((IntConst)c).longValue();
        }
        throw new ParseError(this.lex, "bad integer constant (This error occurs when the constant expression contains floating point operation. In this case, if you specify the compile option '-coins:hirOpt=evalFloat', you can evade this error. However, the operation result on JavaVM has a possibility not correct because it depends floating point operation on the target machine.)");
    }

    private Expr commaExpr(EncodedType etype) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " commaExpr ");
        }
        Expr expr = this.expression(etype);
        if (this.lex.lookAhead() != 44) {
            return expr;
        }
        do {
            this.lex.get();
            etype.clear();
            Expr expr2 = this.expression(etype);
            expr = expr instanceof ConstantExpr ? expr2 : new CommaExpr(expr, expr2);
        } while (this.lex.lookAhead() == 44);
        return expr;
    }

    private Expr expression(EncodedType etype) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "expression ", "lex " + this.lex.getString());
        }
        Expr lvalue = this.conditionalExpr(etype);
        if (!this.nextIsAssignOp()) {
            return lvalue;
        }
        if (!(lvalue instanceof LvalueExpr) || !((LvalueExpr)lvalue).isLvalue()) {
            throw new ParseError(this.lex, "invalid lvalue in assignment");
        }
        int op = this.lex.get();
        EncodedType etype2 = new EncodedType();
        Expr expr = this.expression(etype2);
        return new AssignExpr(lvalue, op, expr);
    }

    private boolean nextIsAssignOp() throws IOException {
        int t = this.lex.lookAhead();
        return t == 61 || 350 <= t && t <= 359;
    }

    private Expr conditionalExpr(EncodedType etype) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " conditionalExpr ");
        }
        Expr expr = this.binaryExpr(etype);
        if (this.lex.lookAhead() != 63) {
            return expr;
        }
        this.lex.get();
        etype.clear();
        Expr thenExpr = this.commaExpr(etype);
        etype.clear();
        if (this.lex.get() != 58) {
            throw new ParseError(this.lex);
        }
        Expr elseExpr = this.conditionalExpr(etype);
        if (elseExpr instanceof ConstantExpr && ((ConstantExpr)elseExpr).longValue() == 0L) {
            etype.clear();
            etype.insert(thenExpr.getType());
        }
        if (expr instanceof ConstantExpr) {
            if (((ConstantExpr)expr).doubleValue() != 0.0) {
                return thenExpr;
            }
            return elseExpr;
        }
        return new ConditionalExpr(expr, thenExpr, elseExpr);
    }

    private Expr binaryExpr(EncodedType etype) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " binaryExpr ");
        }
        Expr expr = this.castExpr(etype);
        int t;
        int p;
        while ((p = this.getOpPrecedence(t = this.lex.lookAhead())) != 0) {
            expr = this.binaryExpr2(etype, expr, p);
        }
        return expr;
    }

    private Expr binaryExpr2(EncodedType etype, Expr expr, int prec) throws ParseError, IOException {
        int t2;
        int p2;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " binaryExpr2 ");
        }
        int t = this.lex.get();
        EncodedType etype2 = new EncodedType();
        Expr expr2 = this.castExpr(etype2);
        while ((p2 = this.getOpPrecedence(t2 = this.lex.lookAhead())) != 0 && prec > p2) {
            expr2 = this.binaryExpr2(etype2, expr2, p2);
        }
        if (!etype.isValueOrFunction() || !etype2.isValueOrFunction()) {
            throw new ParseError(this.lex, "bad operands");
        }
        boolean leftIs = etype.isLongDoubleType();
        boolean rightIs = etype2.isLongDoubleType();
        if (leftIs || rightIs) {
            return this.floatingBinaryExpr(t, leftIs, expr, etype, rightIs, expr2, etype2);
        }
        leftIs = etype.isDoubleType();
        rightIs = etype2.isDoubleType();
        if (leftIs || rightIs) {
            return this.floatingBinaryExpr(t, leftIs, expr, etype, rightIs, expr2, etype2);
        }
        leftIs = etype.isFloatType();
        rightIs = etype2.isFloatType();
        if (leftIs || rightIs) {
            return this.floatingBinaryExpr(t, leftIs, expr, etype, rightIs, expr2, etype2);
        }
        if (t == 43 || t == 45) {
            leftIs = etype.isPointer();
            rightIs = etype2.isPointer();
            if (leftIs || rightIs) {
                return this.pointerBinaryExpr(t, leftIs, expr, etype, rightIs, expr2, etype2);
            }
        }
        return this.intBinaryExpr(t, expr, etype, expr2, etype2);
    }

    private Expr intBinaryExpr(int op, Expr expr1, EncodedType etype1, Expr expr2, EncodedType etype2) throws ParseError, IOException {
        boolean leftIs = etype1.isLongLong();
        boolean rightIs = etype2.isLongLong();
        boolean longlong = leftIs || rightIs;
        boolean s = etype1.isSigned() && etype2.isSigned();
        byte[] type1 = etype1.get();
        etype1.clear();
        etype1.insert(longlong ? (char)'j' : 'i');
        if (s) {
            etype1.insert('S');
        }
        byte[] destType = etype1.get();
        return new ArithBinaryExpr(expr1, op, expr2, destType);
    }

    private Expr castToLLong(boolean dontCast, Expr expr, byte[] stype, byte[] dtype) {
        if (dontCast) {
            return expr;
        }
        return new CastExpr(expr, stype, dtype);
    }

    private Expr floatingBinaryExpr(int op, boolean leftIsFloating, Expr expr, EncodedType etype, boolean rightIsFloating, Expr expr2, EncodedType etype2) throws ParseError, IOException {
        byte[] rtype;
        switch (op) {
            case 60: 
            case 62: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 368: 
            case 369: {
                etype.clear();
                etype.insert('i');
                return new ArithBinaryExpr(expr, op, expr2, intType);
            }
            case 37: 
            case 38: 
            case 94: 
            case 124: 
            case 366: 
            case 367: {
                throw new ParseError(this.lex, "invalid operator applied to floating type");
            }
        }
        byte[] type1 = expr.getType();
        byte[] type2 = expr2.getType();
        if (leftIsFloating) {
            rtype = type1;
        } else {
            etype.copy(etype2);
            rtype = type2;
        }
        return new ArithBinaryExpr(expr, op, expr2, rtype);
    }

    private Expr pointerBinaryExpr(int op, boolean leftIsPointer, Expr expr, EncodedType etype, boolean rightIsPointer, Expr expr2, EncodedType etype2) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " pointerBinaryExpr ");
        }
        if (leftIsPointer && rightIsPointer) {
            if (op == 45) {
                etype.clear();
                etype.insert('i');
                return new PointerBinaryExpr(expr, op, expr2);
            }
            throw new ParseError(this.lex, "invalid pointer arithmetic");
        }
        if (leftIsPointer) {
            if (!etype2.isIndex()) {
                throw new ParseError(this.lex, "bad pointer arithmetic");
            }
            etype.bePointer();
            return new PointerBinaryExpr(expr, op, expr2);
        }
        if (op == 45 || !etype.isIndex()) {
            throw new ParseError(this.lex, "bad pointer arithmetic");
        }
        etype.copy(etype2);
        etype.bePointer();
        return new PointerBinaryExpr(expr2, op, expr);
    }

    private int getOpPrecedence(int c) {
        if (33 <= c && c <= 63) {
            return binaryOpPrecedence[c - 33];
        }
        if (c == 94) {
            return 7;
        }
        if (c == 124) {
            return 8;
        }
        if (c == 369) {
            return 9;
        }
        if (c == 368) {
            return 10;
        }
        if (c == 363 || c == 360) {
            return 5;
        }
        if (c == 361 || c == 362) {
            return 4;
        }
        if (c == 366 || c == 367) {
            return 3;
        }
        return 0;
    }

    private Expr castExpr(EncodedType etype) throws ParseError, IOException {
        if (this.lex.lookAhead() == 40 && !this.isExpression(1)) {
            if (this.fDbgLevel > 3) {
                this.debug.print(4, "castExpr ", "lex " + this.lex.getString());
            }
            this.lex.get();
            if (this.lex.lookAhead() == 123) {
                // empty if block
            }
            this.argType(etype);
            this.skipChar(')');
            EncodedType etype2 = new EncodedType();
            Expr expr = this.castExpr(etype2);
            if (etype.isVoid() || etype.isValue() && etype2.isValueOrFunction()) {
                return new CastExpr(expr, etype2.get(), etype.get());
            }
            throw new ParseError(this.lex, "invalid cast expression");
        }
        return this.unaryExpr(etype);
    }

    private Expr unaryExpr(EncodedType etype) throws ParseError, IOException {
        int t = this.lex.lookAhead();
        if (this.fDbgLevel > 3) {
            this.debug.print(6, " unaryExpr " + t);
        }
        if (t == 364 || t == 365) {
            this.lex.get();
            Expr expr = this.castExpr(etype);
            if (expr instanceof LvalueExpr) {
                LvalueExpr lexpr = (LvalueExpr)expr;
                return new PrefixExpr(lexpr, t == 364);
            }
            throw new ParseError(this.lex).badLvalue(t == 364 ? "++" : "--");
        }
        if (t == 42) {
            this.lex.get();
            Expr expr = this.castExpr(etype);
            if (etype.isFunction()) {
                return expr;
            }
            if (!etype.dereference()) {
                throw new ParseError(this.lex, "non pointer value in *");
            }
            return new DereferenceExpr(expr, etype.get());
        }
        if (t == 38) {
            LvalueExpr lexpr;
            this.lex.get();
            Expr expr = this.castExpr(etype);
            etype.insert('P');
            if (expr instanceof LvalueExpr && (lexpr = (LvalueExpr)expr).hasAddress()) {
                return new AddressExpr(lexpr, etype.get());
            }
            throw new ParseError(this.lex).badLvalue("&");
        }
        if (t == 331) {
            return this.sizeofExpr(etype);
        }
        if (t == 43 || t == 45 || t == 33 || t == 126) {
            return this.arithUnaryExpr(etype);
        }
        return this.postfixExpr(etype);
    }

    private Expr sizeofExpr2(EncodedType etype) throws ParseError, IOException {
        ASTree lSizeExpr;
        this.lex.get();
        if (this.fDbgLevel > 3) {
            this.debug.print(4, "sizeofExpr2 lex " + this.lex.getString() + " lookAhead " + (char)this.lex.lookAhead());
        }
        if (this.lex.lookAhead() == 40 && !this.isExpression(1)) {
            this.lex.get();
            int lLookAhead1 = this.lex.lookAhead();
            if (this.lex.isType(lLookAhead1)) {
                this.argType(etype);
                if (this.lex.lookAhead() == 41) {
                    this.skipChar(')');
                }
                long lSize = etype.computeSizeof(this);
                if (this.fDbgLevel > 3) {
                    this.debug.print(4, " compute type size as const " + lSize);
                }
                lSizeExpr = this.evaluator.make(lSize);
            } else {
                if (this.fDbgLevel > 3) {
                    this.debug.print(4, " compute type size as Expr ");
                }
                this.declarator(etype, false);
                this.skipChar(')');
                lSizeExpr = new SizeofExpr(etype.get());
            }
        } else {
            int lLookAhead1 = this.lex.lookAhead(0);
            if (lLookAhead1 == 40 && this.lex.lookAhead(1) == 400 && this.lex.lookAhead(2) == 41) {
                this.unaryExpr(etype);
                long lSize = etype.computeSizeof(this);
                if (this.fDbgLevel > 3) {
                    this.debug.print(4, " compute object size as const " + lSize);
                }
                lSizeExpr = this.evaluator.make(lSize);
            } else {
                if (this.fDbgLevel > 3) {
                    this.debug.print(4, " compute object size as Expr ");
                }
                Expr e = this.unaryExpr(new EncodedType());
                lSizeExpr = new SizeofExpr(e);
            }
        }
        etype.clear();
        etype.insert('i');
        return lSizeExpr;
    }

    private Expr sizeofExpr(EncodedType etype) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " sizeofExpr ");
        }
        Expr lExpr = null;
        this.lex.get();
        if (this.lex.lookAhead() == 40 && !this.isExpression(1)) {
            this.lex.get();
            this.argType(etype);
            this.skipChar(')');
        } else {
            lExpr = this.unaryExpr(etype);
        }
        long size = etype.computeSizeof(this);
        if (lExpr instanceof ArithUnaryExpr) {
            size = this.evaluator.toSize[105];
        }
        if (size < 0L) {
            if (etype.isFunction()) {
                size = 1L;
            } else {
                throw new ParseError(this.lex, "cannot compute sizeof");
            }
        }
        if (size == 0L) {
            throw new ParseError(this.lex, "sizeof applied to an incomplete type");
        }
        ConstantExpr expr = this.evaluator.make(size);
        etype.clear();
        etype.insert('i');
        return expr;
    }

    private Expr arithUnaryExpr(EncodedType etype) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " arithUnaryExpr ");
        }
        int t = this.lex.get();
        Expr expr = this.castExpr(etype);
        switch (t) {
            case 43: 
            case 45: {
                if (!etype.isNumber()) break;
                if (this.fDbgLevel >= 4) {
                    this.debug.print(4, " return ArithUnaryExpr " + (char)t);
                }
                return new ArithUnaryExpr(expr, t);
            }
            case 33: {
                if (!etype.isPointer() && !etype.isNumber()) break;
                etype.clear();
                etype.insert('i');
                return new ArithUnaryExpr(expr, t);
            }
            case 126: {
                if (!etype.isInteger()) break;
                return new ArithUnaryExpr(expr, t);
            }
        }
        throw new ParseError(this.lex, "invalid operand in " + (char)t);
    }

    private Expr postfixExpr(EncodedType etype) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(6, " postfixExpr ");
        }
        if (this.lex.lookAhead() == 300) {
            this.lex.get();
            if (this.lex.lookAhead() != 40) {
                Object expr = null;
                throw new ParseError(this.lex, "invalid asm operand " + this.lex.getString());
            }
            ASTList args = this.funcArguments();
            AsmExpr expr = new AsmExpr(args);
            return expr;
        }
        Expr expr = this.primaryExpr(etype);
        while (true) {
            int t;
            if ((t = this.lex.lookAhead()) == 91) {
                expr = this.arrayExpr(etype, expr);
                continue;
            }
            if (t == 40) {
                expr = this.callExpr(etype, expr);
                continue;
            }
            if (t == 46) {
                expr = this.memberExpr(etype, expr, false);
                continue;
            }
            if (t == 371) {
                expr = this.memberExpr(etype, expr, true);
                continue;
            }
            if (t != 364 && t != 365) break;
            expr = this.postIncExpr(etype, expr, t == 364);
        }
        return expr;
    }

    private Expr arrayExpr(EncodedType etype, Expr expr) throws ParseError, IOException {
        this.lex.get();
        boolean reversed = etype.isIndex();
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " arrayExpr ");
        }
        if (!reversed && !etype.dereference()) {
            throw new ParseError(this.lex, "not array value with an index");
        }
        EncodedType etype2 = new EncodedType();
        Expr index = this.commaExpr(etype2);
        if (reversed) {
            if (!etype2.dereference()) {
                throw new ParseError(this.lex, "not array value with an index");
            }
        } else if (!etype2.isIndex()) {
            throw new ParseError(this.lex, "bad index type: " + etype2 + "=" + index);
        }
        if (this.lex.get() != 93) {
            throw new ParseError(this.lex, ']');
        }
        if (reversed) {
            Expr tmp = expr;
            expr = index;
            index = tmp;
            etype.copy(etype2);
        }
        return new ArrayExpr(expr, index, etype.get());
    }

    private Expr callExpr(EncodedType etype, Expr expr) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " callExpr ");
        }
        if (!(etype.isFunction() || etype.dereference() && etype.isFunction())) {
            throw new ParseError(this.lex, "called object is not a function");
        }
        byte[] type = etype.get();
        etype.toReturnType();
        ASTList args = this.funcArguments();
        return new CallExpr(expr, args, type, etype.get());
    }

    private ASTList funcArguments() throws ParseError, IOException {
        int t;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " funcArguments ");
        }
        this.skipChar('(');
        if (this.lex.lookAhead() == 41) {
            this.lex.get();
            return null;
        }
        ASTList args = null;
        EncodedType etype = new EncodedType();
        do {
            etype.clear();
            args = ASTList.append(args, (ASTree)((Object)this.expression(etype)));
        } while ((t = this.lex.get()) == 44);
        if (t == 41) {
            return args;
        }
        throw new ParseError(this.lex, "");
    }

    private Expr memberExpr(EncodedType etype, Expr expr, boolean arrow) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " memberExpr ");
        }
        this.lex.get();
        int c = this.lex.get();
        if (c != 400 && c != 409) {
            throw new ParseError(this.lex);
        }
        String member = this.lex.getString();
        if (arrow && !etype.dereference()) {
            throw new ParseError(this.lex, "non pointer value given to ->");
        }
        int tag = etype.getTypeChar();
        if (tag != 60 && tag != 40) {
            throw new ParseError(this.lex, "non aggregate type for " + member);
        }
        String tagName = etype.getTagName();
        Aggregate agg = this.lookupEncodedTag(tagName);
        if (agg == null) {
            throw new ParseError(this.lex, "undefined aggregate type: " + this.decodeTagName(tagName));
        }
        if (tag == 60 && agg instanceof Union || tag == 40 && agg instanceof Struct) {
            throw new ParseError(this.lex, "wrong tag name");
        }
        Declarator memberDecl = agg.getMember(member);
        if (memberDecl == null) {
            throw new ParseError(this.lex, "undefined member: " + member);
        }
        etype.clear();
        etype.insert(memberDecl.getType());
        return new MemberExpr(expr, arrow, member, agg, memberDecl);
    }

    private Expr postIncExpr(EncodedType etype, Expr expr, boolean plus) throws ParseError, IOException {
        LvalueExpr lexpr;
        if (this.fDbgLevel > 3) {
            this.debug.print(4, " postIncExpr ");
        }
        this.lex.get();
        if (expr instanceof LvalueExpr && (lexpr = (LvalueExpr)expr).isLvalue()) {
            return new PostfixExpr(lexpr, plus);
        }
        throw new ParseError(this.lex).badLvalue(plus ? "++" : "--");
    }

    /*
     * Enabled aggressive block sorting
     */
    private Expr primaryExpr(EncodedType etype) throws ParseError, IOException {
        int t = this.lex.get();
        if (this.fDbgLevel > 3) {
            this.debug.print(6, "primaryExpr lex " + t + " " + this.lex.getString());
        }
        if (t == 400 || t == 409) {
            Declarator d;
            block23: {
                String identifier = this.lex.getString();
                Object obj = this.symTable.get(identifier);
                if (obj != null) {
                    if (obj instanceof Declarator) {
                        d = (Declarator)obj;
                        break block23;
                    } else {
                        if (obj instanceof ConstantExpr) {
                            etype.insert('i');
                            return (ConstantExpr)obj;
                        }
                        throw new ParseError(this.lex, "fatal error (illegal symbol=" + obj + ")");
                    }
                }
                if (this.lex.lookAhead() != 40) {
                    throw new ParseError(this.lex, "undeclared variable: " + identifier);
                }
                if (identifier.equals("__builtin_next_arg") || identifier.equals("__builtin_saveregs") || identifier.equals("__builtin_va_start") || identifier.equals("__builtin_va_arg") || identifier.equals("__builtin_va_end")) {
                    this.showWarningMessage("va_start,va_arg,va_end are not supported");
                } else {
                    this.showWarningMessage("function call without declaration: " + identifier + "()");
                }
                d = this.makeDeclarator(identifier, this.lex);
                d.setType(defaultFunctionType, EncodedType.FUNCTION_TYPE_SIZE);
                this.recordSymbol(identifier, d);
            }
            etype.clear();
            etype.insert(d.getType());
            return new VariableExpr(d);
        }
        if (t == 40) {
            Expr expr = this.commaExpr(etype);
            if (this.lex.get() == 41) {
                return expr;
            }
            throw new ParseError(this.lex, ')');
        }
        if (t == 408) {
            String s = this.lex.getString();
            etype.insert('c');
            etype.insertDim(s.length() + 1);
            return new StringLiteral(s);
        }
        if (t == 410) {
            String s = this.lex.getString();
            etype.insert('c');
            etype.insertDim(s.length() + 1);
            return new WcharLiteral(s);
        }
        if (t == 402) {
            etype.insert('i');
            return this.evaluator.make(this.lex.getLong(), etype);
        }
        if (t == 401) {
            ConstantExpr charconst = this.evaluator.make(this.lex.getLong(), this.symRoot.getCharType() == this.symRoot.typeChar ? (char)'S' : 'U', 'c');
            etype.insert('i');
            return this.evaluator.cast(this.lex, charconst, etype);
        }
        if (t == 403) {
            etype.insert('i');
            etype.insert('U');
            return this.evaluator.make(this.lex.getLong(), etype);
        }
        if (t == 404) {
            etype.insert('l');
            return this.evaluator.make(this.lex.getLong(), etype);
        }
        if (t == 405) {
            etype.insert('l');
            etype.insert('U');
            return this.evaluator.make(this.lex.getLong(), etype);
        }
        if (t == 411) {
            etype.insert('j');
            return this.evaluator.make(this.lex.getLong(), etype);
        }
        if (t == 412) {
            etype.insert('j');
            etype.insert('U');
            return this.evaluator.make(this.lex.getLong(), etype);
        }
        if (t == 407) {
            etype.insert('d');
            return this.evaluator.make(this.lex.getDouble(), etype);
        }
        if (t == 406) {
            etype.insert('f');
            return this.evaluator.make(this.lex.getDouble(), etype);
        }
        if (t == 123) {
            return this.structExpr(etype);
        }
        throw new ParseError(this.lex);
    }

    private Expr structExpr(EncodedType etype) throws ParseError, IOException {
        if (this.fDbgLevel > 3) {
            this.debug.print(5, "structExpr", this.lex.getString());
        }
        do {
            this.lex.get();
        } while (this.lex.get() != 125);
        return this.evaluator.make(0L);
    }

    public SymbolTable getCurrentSymbolTable() {
        return this.symTable;
    }
}

