/*
 * Decompiled with CFR 0.152.
 */
package coins.driver;

import coins.IoRoot;
import coins.Registry;
import coins.driver.CoinsOptions;
import coins.driver.CommandLine;
import coins.driver.CompileSpecification;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CheckOptions {
    public final IoRoot ioRoot;
    private static final char OPTION_DELIMITER = ',';
    private static final char VALUE_DELIMITER = '=';
    protected CompileSpecification fCompileSpecification;
    protected CoinsOptions fCoinsOptions;
    protected List fCompilerOptions;
    protected List fPreprocessorOptions;
    protected List fAssemblerOptions;
    protected List fLinkerOptions;
    protected int fDbgLevel;

    public CheckOptions(CompileSpecification pCompileSpecification, IoRoot pIoRoot) {
        this.ioRoot = pIoRoot;
        this.fCompileSpecification = pCompileSpecification;
        this.fCoinsOptions = this.fCompileSpecification.getCoinsOptions();
        this.fDbgLevel = this.ioRoot.dbgControl.getLevel();
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgControl.print(2, "\nCheckoptions " + pCompileSpecification);
        }
    }

    public boolean isOptionsAreCorrect() {
        boolean lIsCorrect = false;
        Map lCommandLineOptions = ((CommandLine)this.fCompileSpecification).commandLineOptions();
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgControl.print(2, "\n command line option " + lCommandLineOptions + "\n");
        }
        Set lKeySet = lCommandLineOptions.keySet();
        for (String lOptionName : lKeySet) {
            if (this.fDbgLevel > 0) {
                this.ioRoot.dbgControl.print(2, "\noption " + lOptionName);
            }
            if (lOptionName.charAt(0) == '-') {
                lOptionName = lOptionName.substring(1);
            }
            if (this.isPrefixListed(lOptionName, Registry.OPTION)) continue;
            lIsCorrect = false;
            this.ioRoot.msgWarning.put("Undefined option " + lOptionName);
        }
        if (!this.isCoinsOptionsAreCorrect()) {
            lIsCorrect = false;
        }
        return lIsCorrect;
    }

    public boolean isCoinsOptionsAreCorrect() {
        boolean lIsCorrect = true;
        Set lKeySet = this.fCoinsOptions.getOptionKeys();
        Iterator lIt = lKeySet.iterator();
        while (lIt.hasNext()) {
            String lOptionName = ((String)lIt.next()).intern();
            if (this.fDbgLevel > 0) {
                this.ioRoot.dbgControl.print(2, "\noptionName=" + lOptionName);
            }
            if (lOptionName == "item_key_list" || this.isListed(lOptionName, Registry.COINS)) continue;
            lIsCorrect = false;
            this.ioRoot.msgWarning.put("Undefined option name " + lOptionName);
        }
        lIsCorrect &= this.checkCoinsOptions("trace", Registry.TRACE);
        lIsCorrect &= this.checkCoinsOptions("hirOpt", Registry.HIR_OPT);
        lIsCorrect &= this.checkCoinsOptions("ssa-opt", Registry.SSA_OPT);
        lIsCorrect &= this.checkCoinsOptions("simulate", Registry.SIMULATE_OPT);
        lIsCorrect &= this.checkOptions("attach", Registry.ATTACH, ',', '=');
        lIsCorrect &= this.checkOptions("target", Registry.ARCH, ',', '=');
        lIsCorrect &= this.checkOptions("hir2c", Registry.HIR2C, ',', '=');
        return lIsCorrect &= this.checkOptions("lir2c", Registry.LIR2C, ',', '=');
    }

    protected boolean checkCoinsOptions(String pItemName, String[] pValueList) {
        boolean lIsCorrect = false;
        if (pItemName != null) {
            String lListOfItemValues = this.fCoinsOptions.getArg(pItemName);
            if (lListOfItemValues == null) {
                return true;
            }
            Map lItemValue = this.fCoinsOptions.parseArgument(lListOfItemValues, '/', '.');
            List lItemKeyList = (List)lItemValue.get("item_key_list");
            if (this.fDbgLevel > 0) {
                this.ioRoot.dbgControl.print(2, "\nitemKeyList= " + pItemName + " " + lItemKeyList);
            }
            for (String lValueName : lItemKeyList) {
                if (this.isListed(lValueName, pValueList)) continue;
                lIsCorrect = false;
                this.ioRoot.msgWarning.put("Undefined option item " + lValueName);
            }
        }
        return lIsCorrect;
    }

    protected boolean checkOptions(String pItemName, String[] pValueList, char pOptionDelimiter, char pValueDelimiter) {
        boolean lIsCorrect = false;
        if (pItemName != null) {
            String lListOfItemValues = this.fCoinsOptions.getArg(pItemName);
            if (lListOfItemValues == null) {
                return true;
            }
            Map lItemValue = this.fCoinsOptions.parseArgument(lListOfItemValues, pOptionDelimiter, pValueDelimiter);
            List lItemKeyList = (List)lItemValue.get("item_key_list");
            if (this.fDbgLevel > 0) {
                this.ioRoot.dbgControl.print(2, "\nlistOfItemValues " + pItemName + " " + lListOfItemValues + " itemValue " + lItemValue);
                this.ioRoot.dbgControl.print(2, "\n itemKeyList= " + lItemKeyList);
            }
            if (pItemName.intern() == "attach") {
                lItemKeyList = this.separateByDelimiter((String)lItemKeyList.get(0), "/");
            }
            for (String lValueName : lItemKeyList) {
                if (this.isListed(lValueName, pValueList)) continue;
                lIsCorrect = false;
                this.ioRoot.msgWarning.put("Undefined option item " + lValueName);
            }
        }
        return lIsCorrect;
    }

    public boolean isListed(String pItemValue, String[] pItemValueList) {
        if (pItemValue != null && pItemValueList != null) {
            String lItemValue = pItemValue.intern();
            if (this.fDbgLevel > 0) {
                this.ioRoot.dbgControl.print(3, "itemValue= " + lItemValue);
            }
            for (int i = 0; i < pItemValueList.length; ++i) {
                if (lItemValue != pItemValueList[i]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPrefixListed(String pItemValue, String[] pItemValueList) {
        if (pItemValue != null && pItemValueList != null) {
            for (int i = 0; i < pItemValueList.length; ++i) {
                if (!pItemValue.startsWith(pItemValueList[i])) continue;
                return true;
            }
        }
        return false;
    }

    public List separateByDelimiter(String pText, String pDelimiter) {
        ArrayList<String> lList = new ArrayList<String>();
        int lHeadIndex = 0;
        if (pText != null) {
            int lLength = pText.length();
            while (lHeadIndex < lLength) {
                int lTailIndex = pText.indexOf(pDelimiter, lHeadIndex);
                if (lTailIndex <= 0) {
                    lTailIndex = lLength;
                }
                String lSubstring = pText.substring(lHeadIndex, lTailIndex);
                lList.add(lSubstring);
                lHeadIndex = lTailIndex + pDelimiter.length();
            }
        }
        this.ioRoot.dbgControl.print(2, "\nseparateByDelimiter " + pText + "=" + lList);
        return lList;
    }
}

