/*
 * Decompiled with CFR 0.152.
 */
package coins.driver;

import coins.driver.CoinsOptions;
import coins.driver.CompileSpecification;
import coins.driver.CompilerImplementation;
import coins.driver.Trace;
import coins.driver.Warning;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CommandLine
implements CompileSpecification,
Serializable {
    public static final String COINS_TARGET_OPTION = "target";
    public static final String COINS_DEFAULT_TARGET_NAME = "sparc";
    public static final String COINS_TARGET_NAME_OPTION = "target-arch";
    public static final String COINS_TARGET_CONVENTION_OPTION = "target-convention";
    public static final String COINS_DEFAULT_TARGET_CONVENTION = "standard";
    private CoinsOptions fCoinsOptions;
    private Trace fTrace;
    private Warning fWarning;
    private Map fOptions = new Hashtable();
    private List fSourceFiles = new ArrayList();
    private String[] fArgs;
    private List fLinkerOptions;

    private boolean isSimpleFlag(String pOptionString) {
        if (pOptionString.equals("-E")) {
            return true;
        }
        if (pOptionString.equals("-S")) {
            return true;
        }
        if (pOptionString.equals("-c")) {
            return true;
        }
        if (pOptionString.equals("-help")) {
            return true;
        }
        if (pOptionString.equals("-pipe")) {
            return true;
        }
        if (pOptionString.equals("-C")) {
            return true;
        }
        if (pOptionString.equals("-P")) {
            return true;
        }
        if (pOptionString.equals("-g")) {
            return true;
        }
        if (pOptionString.equals("-p")) {
            return true;
        }
        if (pOptionString.equals("-dynamic")) {
            return true;
        }
        if (pOptionString.equals("-static")) {
            return true;
        }
        return pOptionString.equals("-v");
    }

    private boolean isSingleArgOption(String pOptionString) {
        if (pOptionString.equals("-o")) {
            return true;
        }
        return pOptionString.equals("-b");
    }

    private boolean isTrailingArgOption(String pOptionString) {
        return pOptionString.startsWith("-b");
    }

    private boolean isDuplicableOption(String pOptionString) {
        if (pOptionString.startsWith("-W")) {
            return true;
        }
        if (pOptionString.startsWith("-D")) {
            return true;
        }
        if (pOptionString.startsWith("-I")) {
            return true;
        }
        if (pOptionString.startsWith("-U")) {
            return true;
        }
        if (pOptionString.startsWith("-O")) {
            return true;
        }
        if (pOptionString.startsWith("-L")) {
            return true;
        }
        return pOptionString.startsWith("-l");
    }

    private boolean isCoins(String pOptionString) {
        return pOptionString.startsWith("-coins");
    }

    private Warning createWarning(Map pOptions) {
        if (pOptions.containsKey("-W")) {
            return new Warning((List)pOptions.get("-W"));
        }
        return new Warning();
    }

    private void resolveTargetArchitectureOptions(Map pOptions, CoinsOptions pCoinsOptions, List pDuplicatedOptions, boolean oneway) {
        if (!oneway && this.fOptions.containsKey("-b")) {
            String lbconv;
            String lbname;
            String lbopt = (String)this.fOptions.get("-b");
            int lbdi = lbopt.indexOf(45);
            if (lbdi == -1) {
                lbname = lbopt;
                lbconv = COINS_DEFAULT_TARGET_CONVENTION;
            } else {
                lbname = lbopt.substring(0, lbdi);
                lbconv = lbopt.substring(lbdi + 1);
            }
            if (this.fCoinsOptions.isSet(COINS_TARGET_OPTION)) {
                String lcopt = this.fCoinsOptions.getArg(COINS_TARGET_OPTION);
                if (!lcopt.equals(lbopt)) {
                    pDuplicatedOptions.add("-coins:target" + lcopt);
                }
            } else if (this.fCoinsOptions.isSet(COINS_TARGET_NAME_OPTION)) {
                String lcname = this.fCoinsOptions.getArg(COINS_TARGET_NAME_OPTION);
                if (!lcname.equals(lbname)) {
                    pDuplicatedOptions.add("-coins:target-arch=" + lcname);
                }
            } else if (this.fCoinsOptions.isSet(COINS_TARGET_CONVENTION_OPTION)) {
                String lcconv = this.fCoinsOptions.getArg(COINS_TARGET_CONVENTION_OPTION);
                if (!lcconv.equals(lbconv)) {
                    pDuplicatedOptions.add("-coins:target-arch=" + lcconv);
                }
            } else {
                this.fCoinsOptions.set(COINS_TARGET_OPTION, lbopt);
                this.fCoinsOptions.set(COINS_TARGET_NAME_OPTION, lbname);
                this.fCoinsOptions.set(COINS_TARGET_CONVENTION_OPTION, lbconv);
            }
        } else if (this.fCoinsOptions.isSet(COINS_TARGET_OPTION)) {
            String lbconv;
            String lbname;
            String lbopt = this.fCoinsOptions.getArg(COINS_TARGET_OPTION);
            int lbdi = lbopt.indexOf(45);
            if (lbdi == -1) {
                lbname = lbopt;
                lbconv = COINS_DEFAULT_TARGET_CONVENTION;
            } else {
                lbname = lbopt.substring(0, lbdi);
                lbconv = lbopt.substring(lbdi + 1);
            }
            if (this.fCoinsOptions.isSet(COINS_TARGET_NAME_OPTION)) {
                String lcname = this.fCoinsOptions.getArg(COINS_TARGET_NAME_OPTION);
                if (!lcname.equals(lbname)) {
                    pDuplicatedOptions.add("-coins:target-arch=" + lcname);
                }
            } else if (this.fCoinsOptions.isSet(COINS_TARGET_CONVENTION_OPTION)) {
                String lcconv = this.fCoinsOptions.getArg(COINS_TARGET_CONVENTION_OPTION);
                if (!lcconv.equals(lbconv)) {
                    pDuplicatedOptions.add("-coins:target-convention=" + lcconv);
                }
            } else {
                this.fOptions.put("-b", lbopt);
                this.fCoinsOptions.set(COINS_TARGET_NAME_OPTION, lbname);
                this.fCoinsOptions.set(COINS_TARGET_CONVENTION_OPTION, lbconv);
            }
        } else if (this.fCoinsOptions.isSet(COINS_TARGET_NAME_OPTION)) {
            String lcname = this.fCoinsOptions.getArg(COINS_TARGET_NAME_OPTION);
            String lcconv = this.fCoinsOptions.isSet(COINS_TARGET_CONVENTION_OPTION) ? this.fCoinsOptions.getArg(COINS_TARGET_CONVENTION_OPTION) : COINS_DEFAULT_TARGET_CONVENTION;
            String lcopt = lcname + "-" + lcconv;
            this.fCoinsOptions.set(COINS_TARGET_OPTION, lcopt);
            this.fOptions.put("-b", lcopt);
        }
    }

    private void setTargetArchitecture() {
        if (!this.fCoinsOptions.isSet(COINS_TARGET_NAME_OPTION)) {
            this.fCoinsOptions.set(COINS_TARGET_NAME_OPTION, COINS_DEFAULT_TARGET_NAME);
            this.fCoinsOptions.set(COINS_TARGET_CONVENTION_OPTION, COINS_DEFAULT_TARGET_CONVENTION);
            this.fOptions.put("-b", "sparc-standard");
        }
        if (this.fCoinsOptions.isSet(COINS_TARGET_NAME_OPTION)) {
            String lArg = "__" + this.fCoinsOptions.getArg(COINS_TARGET_NAME_OPTION) + "__";
            this.fOptions.put("-D" + lArg, lArg);
            List<String> lList = this.fOptions.containsKey("-D") ? (List)this.fOptions.get("-D") : new ArrayList<String>();
            lList.add(lArg);
            this.fOptions.put("-D", lList);
        }
    }

    private void resolveEquivalentOptions(List lDuplicatedOptions, boolean oneway) {
        this.resolveTargetArchitectureOptions(this.fOptions, this.fCoinsOptions, lDuplicatedOptions, oneway);
    }

    private void warnUnknownOptions(List pList, Warning pWarning) {
        Iterator i = pList.iterator();
        while (i.hasNext()) {
            pWarning.warning("Driver", "Unknown option: " + i.next());
        }
    }

    private void warnDuplicatedOptions(List pList, Warning pWarning) {
        Iterator i = pList.iterator();
        while (i.hasNext()) {
            pWarning.warning("Driver", "Ignoring multiple specification: " + i.next());
        }
    }

    private void warnNoArgOptions(List pList, Warning pWarning) {
        Iterator i = pList.iterator();
        while (i.hasNext()) {
            pWarning.warning("Driver", "Missing argument: " + i.next());
        }
    }

    private CoinsOptions createCoinsOptions(List pList) {
        StringBuffer buffer = new StringBuffer();
        Iterator i = pList.iterator();
        if (i.hasNext()) {
            buffer.append(i.next());
            while (i.hasNext()) {
                buffer.append("," + i.next());
            }
        }
        return new CoinsOptions(buffer.toString());
    }

    private Trace createTrace(CoinsOptions pCoinsOptions, Warning pWarning) {
        if (pCoinsOptions.isSet("trace")) {
            return new Trace(System.out, pCoinsOptions.getArg("trace"), pWarning);
        }
        return new Trace(System.out, pWarning);
    }

    public CommandLine() {
        this.fArgs = new String[0];
        this.fLinkerOptions = new ArrayList();
        this.fWarning = this.createWarning(this.fOptions);
        this.fCoinsOptions = this.createCoinsOptions(new ArrayList());
        this.fCoinsOptions.readPropertyFile(this.fWarning);
        ArrayList lDuplicatedOptions = new ArrayList();
        this.resolveEquivalentOptions(lDuplicatedOptions, true);
        this.setTargetArchitecture();
        this.warnDuplicatedOptions(lDuplicatedOptions, this.fWarning);
        this.fTrace = this.createTrace(this.fCoinsOptions, this.fWarning);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommandLine(String[] args) throws ParseException {
        this.fArgs = args;
        this.fLinkerOptions = new ArrayList();
        int len = args.length;
        ArrayList<String> lCoinsArgumentList = new ArrayList<String>();
        ArrayList<String> lUnknownOptions = new ArrayList<String>();
        ArrayList<String> lDuplicatedOptions = new ArrayList<String>();
        ArrayList<String> lNoArgOptions = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            String lOptionArgument;
            if (args[i].equals("")) continue;
            if (this.isSimpleFlag(args[i])) {
                this.fOptions.put(args[i], "");
            } else if (this.isDuplicableOption(args[i])) {
                void var10_10;
                lOptionArgument = args[i].substring(2);
                if (lOptionArgument.length() == 0) {
                    if (!args[i].equals("-O")) throw new ParseException("No argument is found for a " + args[i].substring(0, 2) + " option.", i);
                    args[i] = "-O1";
                    lOptionArgument = "1";
                }
                this.fOptions.put(args[i], lOptionArgument);
                String lKey = args[i].substring(0, 2);
                if (this.fOptions.containsKey(lKey)) {
                    List list = (List)this.fOptions.get(lKey);
                } else {
                    ArrayList arrayList = new ArrayList();
                }
                var10_10.add(lOptionArgument);
                this.fOptions.put(lKey, var10_10);
            } else if (this.isCoins(args[i])) {
                lOptionArgument = args[i].substring(7);
                this.fOptions.put(args[i], lOptionArgument);
                lCoinsArgumentList.add(lOptionArgument);
                this.fOptions.put("-coins", lCoinsArgumentList);
            } else if (this.isSingleArgOption(args[i])) {
                if (this.fOptions.containsKey(args[i])) {
                    lDuplicatedOptions.add(args[i] + " " + args[i + 1]);
                    ++i;
                    continue;
                }
                if (args.length <= i + 1) throw new ParseException("No argument is found for a " + args[i] + " option.", i);
                this.fOptions.put(args[i], args[i + 1]);
                ++i;
            } else if (this.isTrailingArgOption(args[i])) {
                lOptionArgument = args[i].substring(2);
                if (lOptionArgument.length() == 0) {
                    lNoArgOptions.add(args[i]);
                    continue;
                }
                String lOptionName = args[i].substring(0, 2);
                if (this.fOptions.containsKey(lOptionName)) {
                    lDuplicatedOptions.add(args[i]);
                    continue;
                }
                this.fOptions.put(lOptionName, lOptionArgument);
            } else if (args[i].charAt(0) == '-') {
                lUnknownOptions.add(args[i]);
            } else {
                this.fSourceFiles.add(args[i]);
                this.fLinkerOptions.add(args[i]);
            }
            if (!this.isLinkerOption(args[i])) continue;
            this.fLinkerOptions.add(args[i]);
        }
        this.fWarning = this.createWarning(this.fOptions);
        this.fCoinsOptions = this.createCoinsOptions(lCoinsArgumentList);
        this.resolveEquivalentOptions(lDuplicatedOptions, false);
        this.fCoinsOptions.readPropertyFile(this.fWarning);
        this.resolveEquivalentOptions(lDuplicatedOptions, true);
        this.setTargetArchitecture();
        this.warnUnknownOptions(lUnknownOptions, this.fWarning);
        this.warnDuplicatedOptions(lDuplicatedOptions, this.fWarning);
        this.warnNoArgOptions(lNoArgOptions, this.fWarning);
        this.fTrace = this.createTrace(this.fCoinsOptions, this.fWarning);
    }

    public void showHelp(PrintStream out, CompilerImplementation driver) {
        String className = driver.getClass().getName();
        out.println("Usage: java " + className + " [options] file...");
        out.println("-help               Display this information");
        out.println("-E                  Stop after preprocessing");
        out.println("-S                  Stop after assembly code generation");
        out.println("-c                  Do not link");
        out.println("-o <file>           Set output file");
        out.println("-pipe               Use pipe instead of temporary files");
        out.println("-W<category>        Turn on warning messages of <category>");
        out.println("-Wno-<category>     Turn off warning messages of <category>");
        out.println("-Wall               Turn on all warning messages");
        out.println("-C                  Preserve comments in source file");
        out.println("-D<macro>[=<defn>]  Define a preprocessor macro");
        out.println("-I<path>            Specify an include path");
        out.println("-P                  Inhibit #line directive");
        out.println("-U<macro>           Undefine a preprocessor macro");
        out.println("-O<level>           Set optimization level");
        out.println("-g                  Preserve all symbols");
        out.println("-p                  Use performance monitor");
        out.println("-L<path>            Specify an archive search path");
        out.println("-dynamic            Use dynamic linkage");
        out.println("-l<archive>         Specify an archive");
        out.println("-static             Use static linkage");
    }

    public CoinsOptions getCoinsOptions() {
        return this.fCoinsOptions;
    }

    public synchronized void setObjectFile(String sourceFile, String objectFile) {
        int s = this.fLinkerOptions.size();
        for (int i = 0; i < s; ++i) {
            String arg = (String)this.fLinkerOptions.get(i);
            if (!arg.equals(sourceFile)) continue;
            this.fLinkerOptions.set(i, objectFile);
            return;
        }
        throw new Error("COINS driver API internal error: there is no file " + sourceFile + " in linker options");
    }

    public Trace getTrace() {
        return this.fTrace;
    }

    public Warning getWarning() {
        return this.fWarning;
    }

    public boolean isSet(String option) {
        return this.fOptions.containsKey(option);
    }

    public Object getArg(String option) {
        return this.fOptions.get(option);
    }

    public List getSourceFiles() {
        ArrayList ret = new ArrayList();
        ret.addAll(this.fSourceFiles);
        return ret;
    }

    public String toString() {
        int len = this.fArgs.length;
        if (len > 0) {
            StringBuffer buffer = new StringBuffer(this.fArgs[0]);
            for (int i = 1; i < len; ++i) {
                buffer.append(" " + this.fArgs[i]);
            }
            return buffer.toString();
        }
        return "";
    }

    public boolean isPreprocessorOption(String arg) {
        return arg.equals("-C") || arg.startsWith("-D") || arg.startsWith("-I") || arg.equals("-P") || arg.startsWith("-U");
    }

    private void addCollectionToList(List pList, String key, Collection pCollection) {
        Iterator lI = pCollection.iterator();
        while (lI.hasNext()) {
            pList.add(key + (String)lI.next());
        }
    }

    public List getPreprocessorOptions() {
        ArrayList<String> lList = new ArrayList<String>();
        if (this.fOptions.containsKey("-C")) {
            lList.add("-C");
        }
        if (this.fOptions.containsKey("-D")) {
            this.addCollectionToList(lList, "-D", (Collection)this.fOptions.get("-D"));
        }
        if (this.fOptions.containsKey("-I")) {
            this.addCollectionToList(lList, "-I", (Collection)this.fOptions.get("-I"));
        }
        if (this.fOptions.containsKey("-P")) {
            lList.add("-P");
        }
        if (this.fOptions.containsKey("-U")) {
            this.addCollectionToList(lList, "-U", (Collection)this.fOptions.get("-U"));
        }
        return lList;
    }

    public boolean isCompilerOption(String arg) {
        return arg.startsWith("-W") || arg.startsWith("-O") || arg.equals("-g") || arg.equals("-p");
    }

    public List getCompilerOptions() {
        ArrayList<String> lList = new ArrayList<String>();
        if (this.fOptions.containsKey("-W")) {
            this.addCollectionToList(lList, "-W", (Collection)this.fOptions.get("-W"));
        }
        if (this.fOptions.containsKey("-O")) {
            this.addCollectionToList(lList, "-O", (Collection)this.fOptions.get("-O"));
        }
        if (this.fOptions.containsKey("-g")) {
            lList.add("-g");
        }
        if (this.fOptions.containsKey("-p")) {
            lList.add("-p");
        }
        return lList;
    }

    public boolean isAssemblerOption(String arg) {
        return false;
    }

    public List getAssemblerOptions() {
        return new ArrayList();
    }

    public boolean isLinkerOption(String arg) {
        return arg.startsWith("-L") || arg.equals("-dynamic") || arg.equals("-static") || arg.startsWith("-l");
    }

    public synchronized List getLinkerOptions() {
        ArrayList ret = new ArrayList();
        ret.addAll(this.fLinkerOptions);
        return ret;
    }

    public Map commandLineOptions() {
        return this.fOptions;
    }
}

