/*
 * Decompiled with CFR 0.152.
 */
package coins.drivergen;

import coins.drivergen.process.ProcessManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Generator {
    protected static final String defaultDriverName = "MyDriver.java";
    protected static FileWriter out;
    protected static final String[] header;
    protected static final String[] classDecl;
    protected static final String[] compileHeader;
    protected static final String[] compileFooter;
    protected static final String[] footer1;
    protected static final String[] footer2;
    protected static final String[] footer3;
    protected String myName = "Generator";

    protected void generateCompile(File orderFile) throws FileNotFoundException, IOException {
        String line0;
        for (int i = 0; i < compileHeader.length; ++i) {
            out.write(compileHeader[i] + "\n");
        }
        BufferedReader br = new BufferedReader(new FileReader(orderFile));
        ProcessManager manager = new ProcessManager();
        String indent1 = new String("      ");
        String indent2 = new String("        ");
        int counter = 0;
        while ((line0 = br.readLine()) != null) {
            String line = line0.trim();
            if (line.startsWith("//") || line.length() == 0) continue;
            if (counter != 0) {
                out.write(",\n");
            }
            if (manager.getProcess(line) == null) {
                System.err.println("\nProcess " + line + " is not found");
                System.err.println("    Faild to make MyDriver.java");
                System.exit(1);
            }
            out.write(indent2 + "\"" + line + "\"");
            ++counter;
        }
        out.write("\n");
        br.close();
        for (int i = 0; i < compileFooter.length; ++i) {
            out.write(compileFooter[i] + "\n");
        }
    }

    protected void go(String[] args) throws FileNotFoundException, IOException {
        File output = args.length > 1 ? new File(args[1]) : new File(defaultDriverName);
        if (output == null) {
            System.err.println("Failed to open " + args[1]);
            System.exit(1);
        }
        String tmp = output.getName();
        String driverName = tmp.substring(0, tmp.lastIndexOf(".java"));
        File orderFile = new File(args[0]);
        if (orderFile.canRead()) {
            int i;
            out = new FileWriter(output);
            for (i = 0; i < header.length; ++i) {
                out.write(header[i] + "\n");
            }
            out.write(classDecl[0] + driverName + classDecl[1] + "\n");
            out.write("/*** Process order file [ " + args[0] + " ] ***/\n");
            this.generateCompile(orderFile);
            for (i = 0; i < footer1.length; ++i) {
                out.write(footer1[i] + "\n");
            }
            out.write(footer2[0] + driverName + footer2[1] + "\n");
            for (i = 0; i < footer3.length; ++i) {
                out.write(footer3[i] + "\n");
            }
            out.flush();
            out.close();
        } else {
            System.err.println("Process order file : " + args[0] + " is not readable");
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: processes order filename");
            System.exit(1);
        } else {
            try {
                new Generator().go(args);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
            System.exit(0);
        }
    }

    static {
        header = new String[]{"package coins.mydriver;", " ", "import coins.IoRoot;", "import coins.SymRoot;", "import coins.HirRoot;", "import coins.FlowRoot;", "import coins.driver.Driver;", "import coins.driver.Suffix;", "import coins.driver.CoinsOptions;", "import coins.driver.CommandLine;", "import coins.driver.CompileSpecification;", "import coins.driver.PassStopException;", "import coins.driver.StreamCopier;", "import coins.driver.Trace;", "import coins.FatalError;", "import coins.PassException;", " ", "import java.io.File;", "import java.io.InputStream;", "import java.io.InputStreamReader;", "import java.io.IOException;", "import java.io.ObjectInputStream;", "import java.io.ObjectOutputStream;", "import java.io.OutputStream;", "import java.io.OutputStreamWriter;", "import java.io.PrintStream;", "import java.io.PrintWriter;", "import java.util.ArrayList;", "import java.util.Iterator;", "import java.util.Properties;", "import java.util.List;", " ", "import coins.drivergen.Conditions;", "import coins.drivergen.InputIr;", "import coins.drivergen.Options;", "import coins.drivergen.process.ProcessManager;", "import coins.drivergen.ProcessException;", " ", "/**", " * A driver implementation using the COINS Compiler Driver API,", " * generated by the Generator with the Process Order File.", " **/"};
        classDecl = new String[]{"public class ", " extends Driver {"};
        compileHeader = new String[]{"/**", " * Compiler", " **/", "public void compile(File sourceFile,", "                  Suffix suffix,", "                  InputStream in,", "                  OutputStream out,", "                  IoRoot io)", "    throws IOException, PassException {", "", "    InputIr inputIr = new InputIr(io);", "    Options options = new Options(sourceFile, suffix, in, out, io);", "    int     condition = Conditions.SOURCE;", "    ProcessManager manager = new ProcessManager();", "", "    manager.init(inputIr, options);", "", "    try {", "      manager.go(new String[] {"};
        compileFooter = new String[]{"      });", "    } catch (PassException e) {", "      System.err.println(\"PassException :\");", "      System.err.println(e);", "    } catch (Exception e) {", "      System.err.println(e);", "    }", "  }"};
        footer1 = new String[]{"  /**", "   * A main function to invoke a driver instance.", "   *", "   * @param args a command line.", "   **/", "  public static void main(String[] args) {"};
        footer2 = new String[]{"    new ", "().go(args);"};
        footer3 = new String[]{"  }", "}"};
    }
}

