/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.ComplexExp;
import coins.ffront.DeclManager;
import coins.ffront.DoubleComplexExp;
import coins.ffront.ExecStmtManager;
import coins.ffront.FNumber;
import coins.ffront.FStmt;
import coins.ffront.FirToHir;
import coins.ffront.FortranCharacterExp;
import coins.ffront.HasConstValue;
import coins.ffront.HirUtility;
import coins.ffront.Node;
import coins.ffront.Pair;
import coins.ffront.TypeUtility;
import coins.ir.IrList;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.sym.Type;

public class BinaryNode
extends Pair
implements HasConstValue {
    private int op;
    HirUtility fHirUtil;
    TypeUtility fTypeUtil;
    DeclManager fDeclMgr;
    ExecStmtManager fESMgr;
    HIR hir;

    public BinaryNode(int op, Node left, Node right, FirToHir pfHir) {
        super(left, right, pfHir);
        this.op = op;
    }

    public void print(int level, String spaces) {
        this.fHir.debugPrint(level, spaces + "<binary:" + this.opString() + " " + this.left + " " + this.right + ">\n");
        super.print(level, spaces);
    }

    public String toString() {
        return "BinaryExp:" + this.opString();
    }

    public String opString() {
        switch (this.op) {
            case 38: {
                return "+";
            }
            case 46: {
                return ".AND.";
            }
            case 51: {
                return "==";
            }
            case 54: {
                return ">=";
            }
            case 53: {
                return ">";
            }
            case 56: {
                return "<=";
            }
            case 55: {
                return "<";
            }
            case 52: {
                return "!=";
            }
            case 42: {
                return "/";
            }
            case 77: {
                return ".AND.";
            }
            case 78: {
                return ".OR.";
            }
            case 41: {
                return "*";
            }
            case 39: {
                return "-";
            }
            case 48: {
                return ".XOR.";
            }
        }
        return "error";
    }

    public Exp makeExp() {
        this.hir = this.fHir.getHir();
        this.fHirUtil = this.fHir.getHirUtility();
        this.fDeclMgr = this.fHir.getDeclManager();
        this.fESMgr = this.fHir.getExecStmtManager();
        this.fTypeUtil = this.fHir.getTypeUtility();
        Exp lExp1 = this.left.makeExp();
        Exp lExp2 = this.right.makeExp();
        if (lExp1 instanceof ComplexExp || lExp2 instanceof ComplexExp) {
            Exp lExp1Real = null;
            Exp lExp1Imag = null;
            Exp lExp2Real = null;
            Exp lExp2Imag = null;
            Type ctype = lExp1 instanceof DoubleComplexExp || lExp2 instanceof DoubleComplexExp ? this.fTypeUtil.getDoubleType() : this.fTypeUtil.getRealType();
            if (lExp1 instanceof ComplexExp) {
                lExp1Real = this.fHirUtil.castIfNeeded(((ComplexExp)lExp1).getRealPart(), ctype);
                lExp1Imag = this.fHirUtil.castIfNeeded(((ComplexExp)lExp1).getImagPart(), ctype);
            }
            if (lExp2 instanceof ComplexExp) {
                lExp2Real = this.fHirUtil.castIfNeeded(((ComplexExp)lExp2).getRealPart(), ctype);
                lExp2Imag = this.fHirUtil.castIfNeeded(((ComplexExp)lExp2).getImagPart(), ctype);
            }
            if (lExp1Real == null) {
                lExp1Real = this.fHirUtil.castIfNeeded(lExp1, ctype);
                lExp1Imag = this.fHirUtil.makeTyped0Node(ctype);
            }
            if (lExp2Real == null) {
                lExp2Real = this.fHirUtil.castIfNeeded(lExp2, ctype);
                lExp2Imag = this.fHirUtil.makeTyped0Node(ctype);
            }
            lExp2Real = this.fHirUtil.castIfNeeded(lExp2Real, lExp1Real.getType());
            lExp2Imag = this.fHirUtil.castIfNeeded(lExp2Imag, lExp1Imag.getType());
            switch (this.op) {
                case 38: 
                case 39: {
                    return this.fHirUtil.makeComplexExpByType(this.hir.exp(this.op, lExp1Real, lExp2Real), this.hir.exp(this.op, lExp1Imag, lExp2Imag), ctype);
                }
                case 41: {
                    Exp realPart = this.hir.exp(39, this.hir.exp(41, lExp1Real, lExp2Real), this.hir.exp(41, lExp1Imag, lExp2Imag));
                    Exp imagPart = this.hir.exp(38, this.hir.exp(41, lExp1Real, lExp2Imag), this.hir.exp(41, lExp1Imag, lExp2Real));
                    return this.fHirUtil.makeComplexExpByType(realPart, imagPart, ctype);
                }
                case 42: {
                    Exp realPart = this.hir.exp(38, this.hir.exp(41, lExp1Real, lExp2Real), this.hir.exp(41, lExp1Imag, lExp2Imag));
                    Exp imagPart = this.hir.exp(39, this.hir.exp(41, lExp1Imag, lExp2Real), this.hir.exp(41, lExp1Real, lExp2Imag));
                    Exp divisor = this.hir.exp(38, this.hir.exp(41, lExp2Real, lExp2Real), this.hir.exp(41, lExp2Imag, lExp2Imag));
                    return this.fHirUtil.makeComplexExpByType(this.hir.exp(42, realPart, divisor), this.hir.exp(42, imagPart, divisor), ctype);
                }
                case 51: 
                case 52: {
                    Exp cmpExp = this.op == 51 ? this.fHirUtil.makeTrueConstNode() : this.fHirUtil.makeFalseConstNode();
                    return this.hir.exp(51, this.hir.exp(46, this.hir.exp(51, lExp1Real, lExp2Real), this.hir.exp(51, lExp1Imag, lExp2Imag)), cmpExp);
                }
                case 53: 
                case 54: 
                case 55: 
                case 56: {
                    this.fHir.printMsgFatal("Can not compare between complex variables");
                    return null;
                }
            }
            this.fHir.printMsgFatal("unkown complex operation:" + this.op);
            return null;
        }
        if (lExp1 instanceof FortranCharacterExp) {
            return this.character_operation((FortranCharacterExp)lExp1, (FortranCharacterExp)lExp2);
        }
        Type exp1Type = lExp1.getType();
        Type exp2Type = lExp2.getType();
        switch (this.op) {
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                int rank2;
                if (!exp1Type.isFloating() && !exp1Type.isInteger() || !exp2Type.isFloating() && !exp2Type.isInteger()) break;
                int rank1 = exp1Type.getTypeRank();
                if (rank1 > (rank2 = exp2Type.getTypeRank())) {
                    lExp2 = this.hir.convExp(exp1Type, lExp2);
                    break;
                }
                if (rank1 >= rank2) break;
                lExp1 = this.hir.convExp(exp2Type, lExp1);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 77: 
            case 78: {
                if (exp1Type.getTypeKind() != 1 || exp2Type.getTypeKind() != 1) {
                    this.fHir.printMsgRecovered("must be Logical");
                }
                FStmt currentStmt = this.fESMgr.getCurrentStmt();
                break;
            }
            default: {
                this.fHir.printMsgRecovered("unknown operation");
            }
        }
        return this.hir.exp(this.op, lExp1, lExp2);
    }

    Exp character_operation(FortranCharacterExp e1, FortranCharacterExp e2) {
        this.fHir.dp("character_operation: " + e1 + this.opString() + e2);
        Exp s_cmp = this.fHirUtil.makeSubpNode("s_cmp", 268, this.hir.irList(), 1);
        IrList args = this.hir.irList();
        args.add(this.hir.exp(64, e1.getBody()));
        args.add(this.hir.exp(64, e2.getBody()));
        args.add(e1.getLength());
        args.add(e2.getLength());
        return this.hir.exp(this.op, this.hir.functionExp(s_cmp, args), this.fHirUtil.makeConstInt0Node());
    }

    public Exp makeArgAddr(FStmt pCallStmt) {
        return this.fHir.getHirUtility().makeArgAddr(pCallStmt, this.makeExp());
    }

    public FNumber getConstValue() {
        FNumber li = null;
        FNumber ri = null;
        if (this.left instanceof HasConstValue) {
            li = ((HasConstValue)((Object)this.left)).getConstValue();
        }
        if (this.right instanceof HasConstValue) {
            ri = ((HasConstValue)((Object)this.right)).getConstValue();
        }
        if (li != null && ri != null) {
            switch (this.op) {
                case 38: {
                    return li.add(ri);
                }
                case 39: {
                    return li.sub(ri);
                }
                case 41: {
                    return li.mul(ri);
                }
                case 42: {
                    return li.div(ri);
                }
            }
        }
        return null;
    }
}

