/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.AssignOrFuncStmt;
import coins.ffront.CallStmt;
import coins.ffront.ConstManager;
import coins.ffront.EndStmt;
import coins.ffront.FStmt;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.HeaderStmt;
import coins.ffront.SubscrOrFunCallNode;
import coins.ffront.Token;
import coins.ir.hir.BlockStmt;
import coins.sym.Subp;
import coins.sym.Sym;

public class EntryStmt
extends FStmt {
    private Token fIdent;
    private FirList fArgs;
    private Token[] callArgs;
    private int fEntryCount;
    private boolean isFunctionEntry;

    public EntryStmt(Token pIdent, FirList pArgs, int line, FirToHir pfHir) {
        super(line, pfHir);
        this.fIdent = pIdent;
        this.fArgs = pArgs;
    }

    public void print(int level, String spaces) {
        super.print(level, spaces);
        this.dp("= EntryStmt" + this.fIdent + "\n");
    }

    public String toString() {
        return super.toString() + "Entry statement" + this.fIdent;
    }

    public String getIdent() {
        return this.fIdent.getLexem();
    }

    public Token getIdentToken() {
        return this.fIdent;
    }

    public void process() {
        this.preprocess();
        if (this.isFunctionEntry) {
            Sym lSym = this.fDeclMgr.search(this.getIdent());
            if (lSym != null) {
                lSym.remove();
            }
            this.fHir.getSymRoot().sym.defineVar(this.getIdent(), this.fTypeUtil.getEntryType());
        }
        this.stmt = this.hir.labeledStmt(this.fESMgr.makeLabel(this.getIdent()), null);
        super.process();
    }

    public void addParamTo(FirList paramList) {
        this.callArgs = new Token[this.fArgs.size() + paramList.size()];
        for (Token aToken : this.fArgs) {
            int i;
            String ident = aToken.getLexem();
            int pSize = paramList.size();
            for (i = 1; i < pSize; ++i) {
                if (ident != ((Token)paramList.get(i)).getLexem()) continue;
                this.callArgs[i] = aToken;
                break;
            }
            if (i != pSize) continue;
            this.callArgs[i] = aToken;
            paramList.addLast(aToken);
        }
    }

    public void makeSubp(int entryCount, FirList pArgs) {
        FStmt currentStmt;
        this.preprocess();
        this.fEntryCount = entryCount;
        HeaderStmt oHeader = this.fDeclMgr.getProgramHeader();
        this.isFunctionEntry = oHeader.isFunction();
        HeaderStmt eHeader = new HeaderStmt(this.fIdent, this.fArgs, this.isFunctionEntry, null, this.fLine, this.fHir);
        Subp lSubp = this.fDeclMgr.defineSubp(oHeader.getLexem(), this.fDeclMgr.getFunctionType(), 2, null);
        ConstManager oConstMgr = this.fDeclMgr.fConstMgr;
        this.fDeclMgr.fConstMgr = new ConstManager(this.fHir, this.fDeclMgr);
        this.fDeclMgr.setProgramHeader(eHeader);
        this.fDeclMgr.processProgramHeader();
        Token firstParam = new Token(0, String.valueOf(this.fEntryCount), 259, this.fHir);
        Token dummyParam = new Token(0, "dummy_".intern(), 261, this.fHir);
        FirList aParam = new FirList(firstParam, this.fHir);
        for (int i = 1; i < pArgs.size(); ++i) {
            aParam.addLast(this.callArgs[i] == null ? dummyParam : this.callArgs[i]);
        }
        BlockStmt blockStmt = this.hir.blockStmt(null);
        if (this.isFunctionEntry) {
            SubscrOrFunCallNode right = new SubscrOrFunCallNode(oHeader.getIdToken(), aParam, this.fHir);
            Token left = new Token(0, eHeader.getReturnVarString(), 261, this.fHir);
            currentStmt = new AssignOrFuncStmt(left, right, this.fLine, this.fHir);
        } else {
            currentStmt = new CallStmt(oHeader.getIdToken(), aParam, this.fLine, this.fHir);
        }
        this.fESMgr.setCurrentStmt(currentStmt);
        currentStmt.process();
        currentStmt.addResultTo(blockStmt);
        currentStmt = new EndStmt(this.fLine, this.fHir);
        this.fESMgr.setCurrentStmt(currentStmt);
        currentStmt.process();
        currentStmt.addResultTo(blockStmt);
        this.fDeclMgr.setHirBody(blockStmt);
        blockStmt.setSymTable(this.fDeclMgr.fSymTable);
        this.fDeclMgr.setProgramHeader(oHeader);
        this.fDeclMgr.fConstMgr = oConstMgr;
    }
}

