/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.BaseManager;
import coins.ffront.DeclManager;
import coins.ffront.FStmt;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.LabeledDoStmt;
import coins.ffront.Token;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.Stmt;
import coins.sym.Label;
import coins.sym.Type;
import coins.sym.Var;
import java.util.LinkedList;

public class ExecStmtManager
extends BaseManager {
    private int tempCount = 0;
    DeclManager fDeclMgr;
    FStmt currentStmt = null;
    private LinkedList doNestStack = new LinkedList();
    private int labelCount = 0;

    ExecStmtManager(FirToHir fth) {
        super(fth);
        this.fDeclMgr = fth.getDeclManager();
    }

    BlockStmt processExecStmt(FirList blockBody) {
        BlockStmt blockStmt = this.hir.blockStmt(null);
        for (FStmt currentStmt : blockBody) {
            if (currentStmt == null) continue;
            this.currentStmt = currentStmt;
            this.dp("program header: " + this.fDeclMgr.getProgramHeader());
            this.dp("# Current Stmt => " + currentStmt + " (line: " + currentStmt.fLine + ")");
            currentStmt.preprocess();
            currentStmt.process();
            currentStmt.addResultTo(blockStmt);
            if (currentStmt instanceof LabeledDoStmt) {
                blockStmt = this.doNestIn((LabeledDoStmt)currentStmt, blockStmt);
            }
            if (!this.isDoEndStmt(currentStmt)) continue;
            blockStmt = this.doNestOut(currentStmt, blockStmt);
        }
        return blockStmt;
    }

    public FStmt getCurrentStmt() {
        return this.currentStmt;
    }

    public void setCurrentStmt(FStmt pFStmt) {
        this.currentStmt = pFStmt;
    }

    public FirList getAssignList() {
        return this.fHir.f7Hir.assignList;
    }

    public void addStmt(Stmt stmt) {
        this.currentStmt.addGeneratedStmt(stmt);
    }

    private BlockStmt doNestIn(LabeledDoStmt fStmt, BlockStmt block) {
        if (this.doNestStack.size() == 0) {
            this.doNestStack.addLast(new DoInf(fStmt, block, 0));
        } else {
            DoInf prev = (DoInf)this.doNestStack.getLast();
            String stmtNumber = fStmt.getDoLabelString();
            if (stmtNumber == prev.stmtNumber) {
                this.doNestStack.addLast(new DoInf(fStmt, block, prev.subNumber + 1));
            } else {
                this.doNestStack.addLast(new DoInf(fStmt, block, 0));
            }
        }
        return this.hir.blockStmt(null);
    }

    private boolean isDoEndStmt(FStmt fStmt) {
        if (fStmt.hasNotLabel()) {
            return false;
        }
        if (this.doNestStack.size() == 0) {
            return false;
        }
        String fStmtLabel = fStmt.getLabelString();
        DoInf doInf = (DoInf)this.doNestStack.getLast();
        return fStmtLabel == doInf.stmtNumber;
    }

    private BlockStmt doNestOut(FStmt fStmt, BlockStmt block) {
        BlockStmt prevBlock;
        DoInf doInf;
        String fStmtLabel = fStmt.getLabelString();
        BlockStmt currentBlock = block;
        do {
            doInf = (DoInf)this.doNestStack.removeLast();
            prevBlock = doInf.prevBlock;
            prevBlock.addLastStmt(doInf.makeForStmt(currentBlock));
            currentBlock = prevBlock;
        } while (doInf.subNumber != 0);
        return prevBlock;
    }

    public Stmt makeGotoStmt(Token pLabel) {
        return this.hir.jumpStmt(this.makeLabel("" + Integer.parseInt(pLabel.getLexem())));
    }

    public Label makeLabel(String pString) {
        String ln = ("L_" + pString).intern();
        Label label = (Label)this.fDeclMgr.fSymTable.search(ln);
        if (label == null) {
            label = this.sym.defineLabel(ln);
        }
        this.dp("makeNewLabel: " + label);
        return label;
    }

    public Label makeNewLabel(String str) {
        String label = ("lab_" + str + this.labelCount++).intern();
        return this.makeLabel(label);
    }

    public Label makeNewLabel() {
        return this.makeNewLabel("");
    }

    public String getTempName() {
        return ("_temp_" + this.tempCount++).intern();
    }

    public String getTempName(String name) {
        return ("_" + name + "_" + this.tempCount++).intern();
    }

    public Var makeIntTemp() {
        return this.fDeclMgr.searchOrAddVar(this.getTempName("i_temp"), this.symRoot.typeInt);
    }

    public Var makeRealTemp() {
        return this.fDeclMgr.searchOrAddVar(this.getTempName("r_temp"), this.symRoot.typeFloat);
    }

    public Var makeDoubleTemp() {
        return this.fDeclMgr.searchOrAddVar(this.getTempName("d_temp"), this.symRoot.typeDouble);
    }

    public Var makeTempVar(Type pType) {
        if (pType.isInteger()) {
            return this.makeIntTemp();
        }
        int typeKind = pType.getTypeKind();
        if (typeKind == 16) {
            return this.makeRealTemp();
        }
        if (typeKind == 17) {
            return this.makeDoubleTemp();
        }
        this.printMsgFatal("unimplemented type temp\n");
        return null;
    }

    class DoInf {
        LabeledDoStmt doStmt;
        String stmtNumber;
        int subNumber;
        BlockStmt prevBlock;

        DoInf(LabeledDoStmt pStmt, BlockStmt block, int sNumber) {
            this.stmtNumber = pStmt.getDoLabelString();
            this.subNumber = sNumber;
            this.doStmt = pStmt;
            this.prevBlock = block;
        }

        Stmt makeForStmt(BlockStmt block) {
            Stmt initStmt = this.doStmt.makeInitStmt();
            Stmt stepStmt = this.doStmt.makeStepStmt();
            Exp condition = this.doStmt.makeCondExp();
            String labelString = this.stmtNumber + "_" + this.subNumber;
            Label loopBackLabel = ExecStmtManager.this.makeLabel("B_" + labelString);
            Label loopStepLabel = ExecStmtManager.this.makeLabel("S_" + labelString);
            Label loopEndLabel = ExecStmtManager.this.makeLabel("E_" + labelString);
            return (Stmt)ExecStmtManager.this.hir.forStmt(initStmt, loopBackLabel, condition, block, loopStepLabel, stepStmt, loopEndLabel).copyWithOperands();
        }
    }
}

