/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.FlowRoot;
import coins.flow.DefUseChain;
import coins.flow.SetRefRepr;
import coins.ir.IR;
import coins.sym.Sym;
import java.util.ArrayList;
import java.util.List;

public class DefUseChainImpl
implements DefUseChain {
    public final FlowRoot flowRoot;
    protected IR fDefNode = null;
    protected List fUseList = null;

    public DefUseChainImpl(FlowRoot pFlowRoot, IR pDefNode) {
        this.flowRoot = pFlowRoot;
        this.fDefNode = pDefNode;
        this.fUseList = new ArrayList();
        if (this.flowRoot.ioRoot.dbgFlow.getLevel() > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(6, "DefUseChainImpl", "def " + pDefNode.toStringShort());
        }
    }

    public IR getDefNode() {
        return this.fDefNode;
    }

    public List getUseList() {
        return this.fUseList;
    }

    public void addUseNode(IR pUseNode) {
        if (!this.fUseList.contains(pUseNode)) {
            this.fUseList.add(pUseNode);
        }
    }

    public Sym getDefSym() {
        Sym lSym = null;
        if (this.fDefNode == null) {
            return null;
        }
        SetRefRepr lSetRefRepr = this.flowRoot.fSubpFlow.getSetRefReprOfIR(this.fDefNode);
        if (lSetRefRepr != null) {
            lSym = lSetRefRepr.getDefSym();
        }
        if (lSym == null) {
            lSym = this.fDefNode.getSym();
        }
        return lSym;
    }

    public String toStringByName() {
        StringBuffer lBuffer = new StringBuffer();
        if (this.fDefNode != null) {
            Sym lDefSym = this.getDefSym();
            if (lDefSym != null) {
                lBuffer.append("def " + this.fDefNode.toStringShort() + " " + lDefSym.getName() + " use");
            } else {
                lBuffer.append("def " + this.fDefNode.toStringShort() + " use");
            }
            if (this.fUseList != null) {
                for (IR lNode : this.fUseList) {
                    if (lNode == null) continue;
                    lBuffer.append(" " + lNode.toStringShort());
                }
            }
        }
        return lBuffer.toString();
    }
}

