/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.FlowRoot;
import coins.IoRoot;
import coins.aflow.FlowResults;
import coins.flow.BBlock;
import coins.flow.SubpFlow;
import coins.flow.TreeStructure;
import coins.ir.hir.HIR;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FlowAdapter {
    public final FlowRoot flowRoot;
    protected IoRoot ioRoot;
    protected SubpFlow fSubpFlow;
    protected FlowResults fResults = null;
    public final HIR dummyUninitialization;
    public final HIR dummySettingByParam;
    TreeStructure fDominatorTree = null;
    TreeStructure fPostDominatorTree = null;
    List[] fDominatorListsOfSubp;
    List[] fPostDominatorListsOfSubp;

    public FlowAdapter(FlowRoot pFlowRoot) {
        this.flowRoot = pFlowRoot;
        this.ioRoot = this.flowRoot.ioRoot;
        this.fSubpFlow = this.flowRoot.fSubpFlow;
        this.dummyUninitialization = this.flowRoot.hirRoot.hir.nullNode();
        this.dummySettingByParam = this.flowRoot.hirRoot.hir.nullNode();
    }

    public List getDominators(BBlock pBBlock) {
        if (this.prepareDominators()) {
            return this.fDominatorListsOfSubp[pBBlock.getBBlockNumber()];
        }
        this.ioRoot.msgRecovered.put("getDominators return null.");
        return null;
    }

    public List getPostDominators(BBlock pBBlock) {
        if (this.preparePostDominators()) {
            return this.fPostDominatorListsOfSubp[pBBlock.getBBlockNumber()];
        }
        this.ioRoot.msgRecovered.put("getPostDominators return null.");
        return null;
    }

    public TreeStructure makeDominatorTreeFor(List pBBlocks, BBlock pEntry, boolean pIsDom) {
        boolean lChanged;
        List<BBlock> lDom;
        List[] lDomOrPostDomLists;
        TreeStructure lTree = new TreeStructure(pBBlocks);
        HashMap<BBlock, List<BBlock>> lDoms = new HashMap<BBlock, List<BBlock>>();
        if (pIsDom) {
            if (this.fDominatorListsOfSubp == null) {
                this.fDominatorListsOfSubp = new ArrayList[this.fSubpFlow.getNumberOfBBlocks() + 1];
            }
            lDomOrPostDomLists = this.fDominatorListsOfSubp;
        } else {
            if (this.fPostDominatorListsOfSubp == null) {
                this.fPostDominatorListsOfSubp = new ArrayList[this.fSubpFlow.getNumberOfBBlocks() + 1];
            }
            lDomOrPostDomLists = this.fPostDominatorListsOfSubp;
        }
        for (BBlock lBBlock : pBBlocks) {
            if (lBBlock == null) continue;
            List lPredList = this.getIn(lBBlock, pIsDom);
            lBBlock.setWork(new ArrayList());
            ((List)lBBlock.getWork()).addAll(lPredList);
            ((List)lBBlock.getWork()).retainAll(pBBlocks);
            lDom = new ArrayList();
            if (lBBlock == pEntry) {
                lDom.add(lBBlock);
            } else {
                lDom.addAll(pBBlocks);
            }
            lDoms.put(lBBlock, lDom);
        }
        lDom = new ArrayList();
        do {
            lChanged = false;
            for (BBlock lBBlock : pBBlocks) {
                if (lBBlock == null || lBBlock == pEntry) continue;
                lDom = new ArrayList();
                lDom.addAll(pBBlocks);
                for (BBlock lPredBBlock : (List)lBBlock.getWork()) {
                    lDom.retainAll((List)lDoms.get(lPredBBlock));
                }
                if (!lDom.contains(lBBlock)) {
                    lDom.add(lBBlock);
                }
                if (((Object)lDom).equals(lDoms.get(lBBlock))) continue;
                lChanged = true;
                lDoms.put(lBBlock, lDom);
            }
        } while (lChanged);
        block4: for (BBlock lBBlock : pBBlocks) {
            if (lBBlock == null) continue;
            lDom = (List)lDoms.get(lBBlock);
            int lSize = lDom.size();
            if (pIsDom) {
                this.fDominatorListsOfSubp[lBBlock.getBBlockNumber()] = lDom;
            } else {
                this.fPostDominatorListsOfSubp[lBBlock.getBBlockNumber()] = lDom;
            }
            for (BBlock lDomBBlock : lDom) {
                if (((List)lDoms.get(lDomBBlock)).size() != lSize - 1) continue;
                if (pIsDom) {
                    lDomBBlock.getDominatedChildren().add(lBBlock);
                    lBBlock.setImmediateDominator(lDomBBlock);
                    continue block4;
                }
                lDomBBlock.getPostDominatedChildren().add(lBBlock);
                lBBlock.setImmediatePostDominator(lDomBBlock);
                continue block4;
            }
        }
        return lTree;
    }

    private List getIn(BBlock pBBlock, boolean pIsDom) {
        return pIsDom ? pBBlock.getPredList() : pBBlock.getSuccList();
    }

    protected boolean prepareDominators() {
        if (this.fSubpFlow.isComputed(4)) {
            if (this.fDominatorTree == null) {
                this.fDominatorTree = this.makeDominatorTreeFor(this.fSubpFlow.getListOfBBlocksFromEntry(), this.fSubpFlow.getEntryBBlock(), true);
            }
            if (this.fDominatorListsOfSubp == null) {
                this.fDominatorListsOfSubp = new ArrayList[this.fSubpFlow.getNumberOfBBlocks() + 1];
                this.fDominatorListsOfSubp[0] = new ArrayList();
                for (int i = 1; i <= this.fSubpFlow.getNumberOfBBlocks(); ++i) {
                    BBlock lBBlock = this.fSubpFlow.getBBlock(i);
                    this.fDominatorListsOfSubp[i] = this.fDominatorTree.ancestorsOf(lBBlock);
                    this.fDominatorListsOfSubp[i].add(lBBlock);
                }
            }
            return true;
        }
        this.ioRoot.msgRecovered.put("controlFlowAnalysis() should be called before dominance analysis.");
        return false;
    }

    protected boolean preparePostDominators() {
        if (this.fSubpFlow.isComputed(4)) {
            if (this.fPostDominatorTree == null) {
                this.fPostDominatorTree = this.makeDominatorTreeFor(this.fSubpFlow.getListOfBBlocksFromEntry(), this.fSubpFlow.getEntryBBlock(), false);
            }
            if (this.fPostDominatorListsOfSubp == null) {
                this.fPostDominatorListsOfSubp = new ArrayList[this.fSubpFlow.getNumberOfBBlocks() + 1];
                this.fPostDominatorListsOfSubp[0] = new ArrayList();
                for (int i = 1; i <= this.fSubpFlow.getNumberOfBBlocks(); ++i) {
                    BBlock lBBlock = this.fSubpFlow.getBBlock(i);
                    this.fPostDominatorListsOfSubp[i] = this.fPostDominatorTree.ancestorsOf(lBBlock);
                    this.fPostDominatorListsOfSubp[i].add(lBBlock);
                }
            }
            return true;
        }
        this.ioRoot.msgRecovered.put("controlFlowAnalysis() should be called before dominance analysis.");
        return false;
    }

    public void setFlowResults(FlowResults pResults) {
        this.fResults = pResults;
    }

    public FlowResults getFlowResults() {
        return this.fResults;
    }
}

