/*
 * Decompiled with CFR 0.152.
 */
package coins.hir2c;

import coins.HirRoot;
import coins.SymRoot;
import coins.driver.Trace;
import coins.hir2c.AssociationList;
import coins.hir2c.HirBaseToC;
import coins.hir2c.KeyWords;
import coins.hir2c.LabelRef;
import coins.hir2c.PrintDef;
import coins.ir.IrList;
import coins.ir.hir.AsmStmt;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpListExp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.ForStmt;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirList;
import coins.ir.hir.HirSeq;
import coins.ir.hir.IfStmt;
import coins.ir.hir.LabelDef;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.PointedExp;
import coins.ir.hir.Program;
import coins.ir.hir.RepeatStmt;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubpNode;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.VarNode;
import coins.ir.hir.WhileStmt;
import coins.sym.BoolConst;
import coins.sym.Const;
import coins.sym.Elem;
import coins.sym.EnumType;
import coins.sym.Label;
import coins.sym.PointerType;
import coins.sym.StringConst;
import coins.sym.StructType;
import coins.sym.Subp;
import coins.sym.SubpType;
import coins.sym.Sym;
import coins.sym.SymIterator;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.UnionType;
import coins.sym.Var;
import coins.sym.VectorType;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class HirBaseToCImpl
implements HirBaseToC {
    protected String myName = "HIR2C";
    private HirRoot fhirRoot;
    private SymRoot fsymRoot;
    private boolean fFirstSearch;
    private KeyWords fKeyWord;
    private PrintDef fPrintDefine;
    private AssociationList fInf;
    private Label fContinueLabel;
    private LinkedList fInitSymList;
    private boolean fInitSym;
    private SymTable fInitSymTable;
    private LabelRef fLabelRef;
    private PrintWriter fprintOut;
    private StringBuffer fOutString;
    private LinkedList fTraceList;
    private int fTraceLevel;

    public HirBaseToCImpl(HirRoot phirRoot, SymRoot psymRoot, OutputStream pOut, Trace pTrace) {
        this.fhirRoot = phirRoot;
        this.fsymRoot = psymRoot;
        this.fprintOut = new PrintWriter(pOut, true);
        this.fContinueLabel = null;
        this.fOutString = new StringBuffer();
        this.fKeyWord = new KeyWords();
        this.fLabelRef = new LabelRef();
        this.fPrintDefine = new PrintDef(this.fprintOut);
        this.fInf = new AssociationList(this.fhirRoot, this.fprintOut);
        this.fTraceLevel = 0;
        this.fTraceList = new LinkedList();
        this.fTraceLevel = pTrace.getTraceLevel(this.myName);
        this.fInitSymList = new LinkedList();
        this.fInitSym = false;
    }

    public void Converter() {
        this.fFirstSearch = true;
        this.fPrintDefine.setDefList();
        this.ConvertHIR();
        this.fFirstSearch = false;
        this.fPrintDefine.Converter();
        this.ConvertHIR();
    }

    private void ConvertHIR() {
        this.ConvertSymTable(this.fsymRoot.symTableRoot, 0);
        IrList subpDefList = ((Program)this.fhirRoot.programRoot).getSubpDefinitionList();
        ListIterator subpDefIterator = subpDefList.iterator();
        while (subpDefIterator.hasNext()) {
            SubpDefinition subpDef = (SubpDefinition)subpDefIterator.next();
            this.ConvertSubpDefnision(subpDef);
        }
    }

    private void ConvertSubpDefnision(SubpDefinition pSubpDef) {
        Subp subpSym = pSubpDef.getSubpSym();
        Stmt hirBody = pSubpDef.getHirBody();
        Type ReturnType = subpSym.getReturnValueType();
        IrList ParamList = subpSym.getParamList();
        SymTable LocalSymTable = subpSym.getSymTable();
        SubpType subpType = (SubpType)subpSym.getSymType();
        int indentlevel = 0;
        StringBuffer tmpString = new StringBuffer();
        tmpString.setLength(0);
        if (this.fFirstSearch) {
            this.fLabelRef.initLabelRef(pSubpDef);
        }
        this.fInf.setAttribute(pSubpDef);
        String name = subpSym.getName();
        tmpString.append(subpSym.getName());
        tmpString.append("( ");
        if (subpType.getParamTypeList().size() == 0) {
            if (ParamList != null) {
                ListIterator Ite = ParamList.iterator();
                while (Ite.hasNext()) {
                    tmpString.append(((Sym)Ite.next()).getName());
                    if (!Ite.hasNext()) continue;
                    tmpString.append(", ");
                }
                tmpString.append(" )");
                this.fOutString.append(this.ConvertBaseType(ReturnType, tmpString.toString()));
                this.PrintLine(this.fOutString.toString(), indentlevel);
                if (ParamList != null) {
                    Ite = ParamList.iterator();
                    while (Ite.hasNext()) {
                        this.PrintLine(this.ConvertDECLARATION((Sym)Ite.next()) + ";", indentlevel);
                    }
                }
            }
        } else {
            if (ParamList != null) {
                boolean ParamExist = false;
                ListIterator It = ParamList.iterator();
                while (It.hasNext()) {
                    ParamExist = true;
                    tmpString.append(this.ConvertDECLARATION((Sym)It.next()));
                    tmpString.append(",");
                }
                if (subpType.hasOptionalParam() && ParamExist) {
                    tmpString.append(" ... ");
                }
            }
            tmpString.setLength(tmpString.length() - 1);
            tmpString.append(" )");
            this.fOutString.append(this.ConvertBaseType(ReturnType, tmpString.toString()));
            this.PrintLine(this.fOutString.toString(), indentlevel);
        }
        this.ConvertHirBody(hirBody);
    }

    private void ConvertHirBody(Stmt pTree) {
        this.ConvertStmt(pTree, 0);
    }

    private void ConvertStmt(Stmt pstmt, int indentlevel) {
        Stmt nextStmt = pstmt;
        block15: while (nextStmt != null) {
            int op = nextStmt.getOperator();
            this.fInf.setAttribute(nextStmt);
            this.Trace("[HIR STMT][" + indentlevel + "]" + "[op=" + op + "]" + nextStmt.toString(), 1);
            switch (op) {
                case 23: {
                    nextStmt = this.ConvertIF((IfStmt)nextStmt, indentlevel);
                    continue block15;
                }
                case 25: 
                case 27: {
                    nextStmt = this.ConvertFOR((ForStmt)nextStmt, indentlevel);
                    continue block15;
                }
                case 24: {
                    nextStmt = this.ConvertWHILE((WhileStmt)nextStmt, indentlevel);
                    continue block15;
                }
                case 26: {
                    nextStmt = this.ConvertREPEAT((RepeatStmt)nextStmt, indentlevel);
                    continue block15;
                }
                case 21: {
                    this.Trace("[HIR STMT][ConvertLABEL STRAT]", 1);
                    nextStmt = this.ConvertLABEL((LabeledStmt)nextStmt, indentlevel);
                    this.Trace("[HIR STMT][ConvertLABEL END]", 1);
                    continue block15;
                }
                case 28: {
                    nextStmt = this.ConvertGOTO(nextStmt, indentlevel);
                    continue block15;
                }
                case 32: {
                    nextStmt = this.ConvertSWITCH((SwitchStmt)nextStmt, indentlevel);
                    continue block15;
                }
                case 33: 
                case 36: {
                    nextStmt = this.ConvertEXPSTMT((ExpStmt)nextStmt, indentlevel);
                    continue block15;
                }
                case 35: {
                    nextStmt = this.ConvertBLOCK((BlockStmt)nextStmt, indentlevel);
                    continue block15;
                }
                case 22: {
                    nextStmt = this.ConvertASSIGN((AssignStmt)nextStmt, indentlevel);
                    continue block15;
                }
                case 34: {
                    nextStmt = this.ConvertReturn((ReturnStmt)nextStmt, indentlevel);
                    continue block15;
                }
                case 15: {
                    nextStmt = this.ConvertSEQ((HirSeq)((Object)nextStmt), indentlevel);
                    continue block15;
                }
                case 37: {
                    nextStmt = this.ConvertASMSTMT((AsmStmt)nextStmt, indentlevel);
                    continue block15;
                }
            }
            this.PrintLine("// OP Default", indentlevel);
            nextStmt = nextStmt.getNextStmt();
        }
        this.Trace("[HIR STMT][" + indentlevel + "]" + "--END--", 1);
    }

    private Stmt ConvertIF(IfStmt pstmt, int indentlevel) {
        LabeledStmt ThenStmt = pstmt.getThenPart();
        LabeledStmt ElseStmt = pstmt.getElsePart();
        Exp ConditionExp = pstmt.getIfCondition();
        this.fOutString.append(this.fKeyWord.getOpKeyWord(23));
        this.fOutString.append("(");
        this.fOutString.append(this.ConvertEXP(ConditionExp));
        this.fOutString.append(")");
        this.PrintLine(this.fOutString.toString(), indentlevel);
        boolean BlockPrint = this.IsBlockPrint(ThenStmt);
        if (BlockPrint) {
            this.PrintLine("{", indentlevel);
            this.ConvertStmt(ThenStmt, indentlevel + 1);
            this.PrintLine("}", indentlevel);
        } else {
            this.ConvertStmt(ThenStmt, indentlevel);
        }
        if (this.IsElsePrint(ElseStmt)) {
            this.PrintLine("else", indentlevel);
            BlockPrint = this.IsBlockPrint(ElseStmt);
            if (BlockPrint) {
                this.PrintLine("{", indentlevel);
                this.ConvertStmt(ElseStmt, indentlevel + 1);
                this.PrintLine("}", indentlevel);
            } else {
                this.ConvertStmt(ElseStmt, indentlevel);
            }
        }
        return pstmt.getNextStmt();
    }

    private Stmt ConvertFOR(ForStmt pstmt, int indentlevel) {
        Stmt InitStmt = pstmt.getLoopInitPart();
        Exp ConditionExp = pstmt.getLoopStartCondition();
        Stmt BodyStmt = pstmt.getLoopBodyPart();
        Stmt StepStmt = pstmt.getLoopStepPart();
        this.fContinueLabel = null;
        this.fContinueLabel = pstmt.getLoopStepLabel();
        this.ConvertStmt(pstmt.getConditionalInitPart(), indentlevel);
        this.fOutString.append(this.fKeyWord.getOpKeyWord(25));
        this.fOutString.append("( ");
        this.fOutString.append(this.ConvertPart(InitStmt));
        this.fOutString.setLength(this.fOutString.length() - 1);
        this.fOutString.append(";");
        this.fOutString.append(this.ConvertEXP(ConditionExp));
        this.fOutString.append("; ");
        this.fOutString.append(this.ConvertPart(StepStmt));
        this.fOutString.setLength(this.fOutString.length() - 1);
        this.fOutString.append(")");
        this.PrintLine(this.fOutString.toString(), indentlevel);
        boolean BlockPrint = this.IsBlockPrint(BodyStmt);
        if (BlockPrint) {
            this.PrintLine("{", indentlevel);
            this.ConvertStmt(BodyStmt, indentlevel + 1);
            this.PrintLine("}", indentlevel);
        } else {
            this.ConvertStmt(BodyStmt, indentlevel);
        }
        this.fOutString.append(pstmt.getLoopEndLabel().getName());
        this.fOutString.append(":;");
        this.PrintLine(this.fOutString.toString(), indentlevel);
        return pstmt.getNextStmt();
    }

    private Stmt ConvertWHILE(WhileStmt pstmt, int indentlevel) {
        Exp ConditionExp = pstmt.getLoopStartCondition();
        Stmt BodyStmt = pstmt.getLoopBodyPart();
        this.fContinueLabel = null;
        this.fContinueLabel = pstmt.getLoopStepLabel();
        this.fOutString.append(this.fKeyWord.getOpKeyWord(24));
        this.fOutString.append("(");
        this.fOutString.append(this.ConvertEXP(ConditionExp));
        this.fOutString.append(")");
        this.PrintLine(this.fOutString.toString(), indentlevel);
        boolean BlockPrint = this.IsBlockPrint(BodyStmt);
        if (BlockPrint) {
            this.PrintLine("{", indentlevel);
            this.ConvertStmt(BodyStmt, indentlevel + 1);
            this.PrintLine("}", indentlevel);
        } else {
            this.ConvertStmt(BodyStmt, indentlevel);
        }
        this.fOutString.append(pstmt.getLoopEndLabel().getName());
        this.fOutString.append(":;");
        this.PrintLine(this.fOutString.toString(), indentlevel);
        return pstmt.getNextStmt();
    }

    private Stmt ConvertREPEAT(RepeatStmt pstmt, int indentlevel) {
        Exp ConditionExp = pstmt.getLoopEndCondition();
        Stmt BodyStmt = pstmt.getLoopBodyPart();
        this.fContinueLabel = null;
        this.fContinueLabel = pstmt.getLoopStepLabel();
        this.PrintLine("do", indentlevel);
        boolean BlockPrint = this.IsBlockPrint(BodyStmt);
        if (BlockPrint) {
            this.PrintLine("{", indentlevel);
            this.ConvertStmt(BodyStmt, indentlevel + 1);
            this.PrintLine("}", indentlevel);
        } else {
            this.ConvertStmt(BodyStmt, indentlevel);
        }
        this.fOutString.append(this.fKeyWord.getOpKeyWord(24));
        this.fOutString.append("(");
        this.fOutString.append(this.ConvertEXP(ConditionExp));
        this.fOutString.append(") ;");
        this.PrintLine(this.fOutString.toString(), indentlevel);
        this.fOutString.append(pstmt.getLoopEndLabel().getName());
        this.fOutString.append(":;");
        this.PrintLine(this.fOutString.toString(), indentlevel);
        return pstmt.getNextStmt();
    }

    private String ConvertPart(Stmt pstmt) {
        StringBuffer tmpString = new StringBuffer();
        tmpString.setLength(0);
        Stmt nextStmt = pstmt;
        block6: while (nextStmt != null) {
            this.fInf.setAttribute(nextStmt);
            int op = nextStmt.getOperator();
            this.Trace("[HIR STMT][op=" + op + "]" + nextStmt.toString(), 1);
            switch (op) {
                case 21: {
                    nextStmt = ((LabeledStmt)nextStmt).getStmt();
                    continue block6;
                }
                case 35: {
                    tmpString.append(this.ConvertPart(((BlockStmt)nextStmt).getFirstStmt()));
                    nextStmt = pstmt.getNextStmt();
                    continue block6;
                }
                case 22: {
                    tmpString.append(this.ConvertEXP(((AssignStmt)nextStmt).getLeftSide()));
                    tmpString.append(this.fKeyWord.getOpKeyWord(22));
                    tmpString.append(this.ConvertEXP(((AssignStmt)nextStmt).getRightSide()));
                    nextStmt = nextStmt.getNextStmt();
                    tmpString.append(",");
                    continue block6;
                }
                case 33: 
                case 36: {
                    tmpString.append(this.ConvertEXP(((ExpStmt)nextStmt).getExp()));
                    tmpString.append(",");
                    nextStmt = nextStmt.getNextStmt();
                    continue block6;
                }
            }
            nextStmt = nextStmt.getNextStmt();
        }
        return tmpString.toString();
    }

    private Stmt ConvertLoop(ForStmt pstmt, int indentlevel) {
        boolean BlockPrint;
        Stmt InitStmt = pstmt.getLoopInitPart();
        Exp ConditionExp = pstmt.getLoopStartCondition();
        Stmt BodyStmt = pstmt.getLoopBodyPart();
        Stmt StepStmt = pstmt.getLoopStepPart();
        Label LoopBackLabel = pstmt.getLoopBackLabel();
        Label LoopStepLabel = pstmt.getLoopStepLabel();
        Label LoopEndLabel = pstmt.getLoopEndLabel();
        this.ConvertStmt(InitStmt, indentlevel);
        if (LoopBackLabel != null) {
            this.fOutString.append(LoopBackLabel.getName());
            this.fOutString.append(":");
            this.PrintLine(this.fOutString.toString(), indentlevel);
            this.fOutString.append(this.fKeyWord.getOpKeyWord(23));
        }
        if (ConditionExp != null) {
            this.fOutString.append(this.fKeyWord.getOpKeyWord(23));
            this.fOutString.append("(");
            this.fOutString.append(this.ConvertEXP(ConditionExp));
            this.fOutString.append(")");
            this.fOutString.append(this.fKeyWord.getOpKeyWord(28));
            this.fOutString.append(LoopEndLabel.getName());
            this.fOutString.append(";");
            this.PrintLine(this.fOutString.toString(), indentlevel);
        }
        if (BlockPrint = this.IsBlockPrint(BodyStmt)) {
            this.PrintLine("{", indentlevel);
            this.ConvertStmt(BodyStmt, indentlevel + 1);
            this.PrintLine("}", indentlevel);
        } else {
            this.ConvertStmt(BodyStmt, indentlevel);
        }
        this.PrintLine(this.fOutString.toString(), indentlevel);
        this.fOutString.append(LoopStepLabel.getName());
        this.fOutString.append(":;");
        this.PrintLine(this.fOutString.toString(), indentlevel);
        this.ConvertStmt(StepStmt, indentlevel);
        if (BlockPrint) {
            this.PrintLine("}", indentlevel);
        }
        this.fOutString.append(this.fKeyWord.getOpKeyWord(28));
        this.fOutString.append(LoopBackLabel.getName());
        this.fOutString.append(";");
        this.PrintLine(this.fOutString.toString(), indentlevel);
        this.fOutString.append(LoopEndLabel.getName());
        this.fOutString.append(":;");
        this.PrintLine(this.fOutString.toString(), indentlevel);
        return pstmt.getNextStmt();
    }

    private Stmt ConvertSWITCH(SwitchStmt pstmt, int indentlevel) {
        Exp SelectionExp = pstmt.getSelectionExp();
        Stmt Body = pstmt.getBodyStmt();
        Label EndLabel = pstmt.getEndLabel();
        this.fOutString.append(this.fKeyWord.getOpKeyWord(32));
        this.fOutString.append("(");
        this.fOutString.append(this.ConvertEXP(SelectionExp));
        this.fOutString.append(")");
        this.PrintLine(this.fOutString.toString(), indentlevel);
        this.ConvertStmt(Body, indentlevel);
        this.PrintLine(EndLabel.getName() + ":;", indentlevel);
        return pstmt.getNextStmt();
    }

    private Stmt ConvertSEQ(HirSeq pstmt, int indentlevel) {
        return pstmt.getNextStmt();
    }

    private Stmt ConvertGOTO(Stmt pstmt, int indentlevel) {
        Label label = pstmt.getLabel();
        if (this.fFirstSearch) {
            this.fLabelRef.putLabelRef(label);
        }
        this.fOutString.append(this.fKeyWord.getOpKeyWord(28));
        this.fOutString.append(label.getName());
        this.fOutString.append(";");
        this.PrintLine(this.fOutString.toString(), indentlevel);
        return pstmt.getNextStmt();
    }

    private Stmt ConvertASSIGN(AssignStmt pstmt, int indentlevel) {
        ConstNode sConstNode;
        Const sConstSym;
        Type sConstType;
        boolean bConstString = false;
        StringConst sConstString = null;
        int op = pstmt.getRightSide().getOperator();
        if (op == 5 && !(sConstType = (sConstSym = (sConstNode = (ConstNode)pstmt.getRightSide()).getConstSym()).getSymType()).isFloating() && !sConstType.isInteger()) {
            bConstString = true;
            sConstString = (StringConst)sConstSym;
        }
        if (bConstString) {
            String ConstStringValue = this.ConvertSTRING(sConstString.getStringBody());
            int size = sConstString.getLength();
            this.fOutString.append(this.fKeyWord.getHir2cKeyWord(2) + "(" + this.ConvertEXP(pstmt.getLeftSide()) + "," + ConstStringValue + "," + size + ")");
        } else {
            this.fOutString.append(this.ConvertEXP(pstmt.getLeftSide()));
            this.fOutString.append(this.fKeyWord.getOpKeyWord(22));
            this.fOutString.append(this.ConvertEXP(pstmt.getRightSide()));
        }
        this.fOutString.append(";");
        this.PrintLine(this.fOutString.toString(), indentlevel);
        return pstmt.getNextStmt();
    }

    private VectorType getArrayVarType(Exp pExp) {
        Exp ParentExp = pExp;
        int op = ParentExp.getOperator();
        while (op != 17) {
            ParentExp = (Exp)ParentExp.getParent();
            op = ParentExp.getOperator();
        }
        ParentExp = ParentExp.getExp1();
        return (VectorType)ParentExp.getType();
    }

    private String ConvertEXP(Exp pExp) {
        if (pExp == null) {
            return "";
        }
        StringBuffer tmpString = new StringBuffer();
        tmpString.setLength(0);
        int op = pExp.getOperator();
        String OpKeyWord = this.fKeyWord.getOpKeyWord(op);
        this.fInf.setAttribute(pExp);
        this.Trace("[HIR EXP ][op=" + op + "]" + pExp.toString(), 5);
        switch (op) {
            case 9: {
                SubpNode sNode = (SubpNode)pExp;
                Subp sSym = sNode.getSubp();
                if (this.fInitSym && this.fInitSymTable.searchTableHaving(sSym) == this.fInitSymTable) {
                    this.fInitSymList.add(sSym);
                }
                tmpString.append(sSym.getName());
                break;
            }
            case 7: {
                VarNode sVarNode = (VarNode)pExp;
                Var sVarSym = sVarNode.getVar();
                if (this.fInitSym && this.fInitSymTable.searchTableHaving(sVarSym) == this.fInitSymTable) {
                    this.fInitSymList.add(sVarSym);
                }
                tmpString.append(sVarSym.getName());
                break;
            }
            case 8: {
                VarNode sVarNode1 = (VarNode)pExp;
                Var sVarSym1 = sVarNode1.getVar();
                tmpString.append(sVarSym1.getName());
                break;
            }
            case 17: {
                tmpString.append(this.ConvertEXP(pExp.getArrayExp()));
                tmpString.append(this.ConvertSubscriptEXP(pExp.getSubscriptExp()));
                break;
            }
            case 5: {
                ConstNode sConstNode = (ConstNode)pExp;
                Const sConstSym = sConstNode.getConstSym();
                tmpString.append(this.ConvertCONST(sConstSym));
                break;
            }
            case 33: {
                FunctionExp fExp = (FunctionExp)pExp;
                IrList ParamList = fExp.getParamList();
                ParamList = fExp.getParamList();
                Exp ExpSpec = fExp.getFunctionSpec();
                tmpString.append(this.ConvertEXP(ExpSpec));
                tmpString.append("( ");
                ListIterator It = ParamList.iterator();
                while (It.hasNext()) {
                    tmpString.append(this.ConvertEXP((Exp)It.next()));
                    tmpString.append(",");
                }
                tmpString.setLength(tmpString.length() - 1);
                tmpString.append(")");
                break;
            }
            case 16: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 67: {
                tmpString.append(OpKeyWord);
                tmpString.append("(" + this.ConvertEXP(pExp.getExp1()));
                tmpString.append("," + this.ConvertEXP(pExp.getExp2()) + ")");
                break;
            }
            case 38: 
            case 39: {
                if (pExp.getType().getTypeKind() == 22) {
                    tmpString.append("(");
                    tmpString.append(this.ConvertBaseType(pExp.getType(), ""));
                    tmpString.append(")");
                }
                tmpString.append("(");
                tmpString.append(OpKeyWord);
                tmpString.append("(");
                if (pExp.getExp1().getType().getTypeKind() == 22) {
                    tmpString.append(this.fKeyWord.getHir2cKeyWord(3));
                    tmpString.append("(" + this.ConvertEXP(pExp.getExp1()) + ")");
                } else {
                    tmpString.append(this.ConvertEXP(pExp.getExp1()));
                }
                tmpString.append(",");
                if (pExp.getExp2().getType().getTypeKind() == 22) {
                    tmpString.append(this.fKeyWord.getHir2cKeyWord(3));
                    tmpString.append("(" + this.ConvertEXP(pExp.getExp2()) + ")");
                } else {
                    tmpString.append(this.ConvertEXP(pExp.getExp2()));
                }
                tmpString.append(")");
                tmpString.append(")");
                break;
            }
            case 41: {
                tmpString.append(OpKeyWord);
                tmpString.append("(" + this.ConvertEXP(pExp.getExp1()));
                tmpString.append("," + this.ConvertEXP(pExp.getExp2()) + ")");
                break;
            }
            case 65: {
                if (pExp.getType().getTypeKind() != 24) {
                    if (pExp.getType().getTypeKind() == 13) {
                        tmpString.append(this.ConvertBaseType(pExp.getType(), ""));
                    } else {
                        tmpString.append("(" + this.ConvertBaseType(pExp.getType(), "") + ")");
                    }
                }
                tmpString.append("(" + this.ConvertEXP(pExp.getExp1()) + ")");
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 66: {
                tmpString.append("(");
                tmpString.append(OpKeyWord);
                tmpString.append("(" + this.ConvertEXP(pExp.getExp1()) + ")");
                tmpString.append(")");
                break;
            }
            case 70: {
                tmpString.append(OpKeyWord);
                tmpString.append("(" + this.ConvertEXP(pExp.getExp1()) + ")");
                break;
            }
            case 68: {
                tmpString.append("(");
                tmpString.append(OpKeyWord);
                tmpString.append("(" + this.ConvertEXP(pExp.getExp1()) + ")");
                tmpString.append(")");
                break;
            }
            case 19: {
                tmpString.append(this.ConvertEXP(pExp.getQualifierExp()));
                tmpString.append(".");
                tmpString.append(pExp.getQualifiedElem().getName());
                break;
            }
            case 20: {
                PointedExp ptrExp = (PointedExp)pExp;
                tmpString.append("(");
                tmpString.append(this.ConvertEXP(ptrExp.getPointerExp()));
                tmpString.append(")");
                tmpString.append("->");
                Elem sElem = ptrExp.getPointedElem();
                tmpString.append(sElem.getName());
                break;
            }
            case 76: {
                break;
            }
            case 96: {
                ExpListExp listexp = (ExpListExp)pExp;
                tmpString.append("{ ");
                for (int i = 0; i < listexp.length(); ++i) {
                    if (i != 0) {
                        tmpString.append(", ");
                    }
                    if (listexp.getExp(i).getOperator() == 97) continue;
                    tmpString.append(this.ConvertEXP(listexp.getExp(i)));
                }
                tmpString.append(" }");
                break;
            }
            default: {
                tmpString.append(OpKeyWord);
            }
        }
        return tmpString.toString();
    }

    private String ConvertSubscriptEXP(Exp pExp) {
        StringBuffer tmpString = new StringBuffer();
        tmpString.setLength(0);
        tmpString.append("[");
        VectorType vType = this.getArrayVarType(pExp);
        Exp LowerBoundExp = vType == null ? null : vType.getLowerBoundExp();
        if (LowerBoundExp != null) {
            long LowerBound = vType.getLowerBound();
            if (LowerBound != 0L) {
                tmpString.append(this.fKeyWord.getHir2cKeyWord(1) + "(" + this.ConvertEXP(pExp) + "," + this.ConvertEXP(LowerBoundExp) + ")");
            } else {
                tmpString.append(this.ConvertEXP(pExp));
            }
        } else {
            tmpString.append(this.ConvertEXP(pExp));
        }
        tmpString.append("]");
        return tmpString.toString();
    }

    private boolean IsBinaryOP(Exp pExp) {
        if (pExp == null) {
            return false;
        }
        switch (pExp.getOperator()) {
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                return true;
            }
        }
        return false;
    }

    private Stmt ConvertReturn(ReturnStmt pstmt, int indentlevel) {
        this.fOutString.append(this.fKeyWord.getOpKeyWord(34));
        this.fOutString.append(this.ConvertEXP(pstmt.getReturnValue()));
        this.fOutString.append(";");
        this.PrintLine(this.fOutString.toString(), indentlevel);
        return pstmt.getNextStmt();
    }

    private Stmt ConvertBLOCK(BlockStmt pstmt, int indentlevel) {
        Label lContinue = this.fContinueLabel;
        this.fContinueLabel = null;
        this.PrintLine("{", indentlevel);
        this.ConvertSymTable(pstmt.getSymTable(), indentlevel + 1);
        this.ConvertStmt(pstmt.getFirstStmt(), indentlevel + 1);
        this.PrintLine("}", indentlevel);
        return pstmt.getNextStmt();
    }

    private Stmt ConvertEXPSTMT(ExpStmt pstmt, int indentlevel) {
        this.fOutString.append(this.ConvertEXP(pstmt.getExp()));
        this.PrintLine(this.fOutString.toString() + ";", indentlevel);
        return pstmt.getNextStmt();
    }

    private Stmt ConvertLABEL(LabeledStmt pstmt, int indentlevel) {
        IrList LabeledList = pstmt.getLabelDefList();
        ListIterator Ie = LabeledList.iterator();
        block0: while (Ie.hasNext()) {
            LabelDef labelDef = (LabelDef)Ie.next();
            Label label = labelDef.getLabel();
            this.fInf.setAttribute(labelDef);
            if (this.IsLabelPrint(label)) {
                this.PrintLine(label.getName() + ":;", 0);
                continue;
            }
            int LabelKind = label.getLabelKind();
            if (LabelKind == 11) {
                SwitchStmt Stmt2 = (SwitchStmt)label.getOriginHir();
                int caseCount = Stmt2.getCaseCount();
                for (int i = 0; i < caseCount; ++i) {
                    if (Stmt2.getCaseLabel(i) != label) continue;
                    Const caseConst = Stmt2.getCaseConst(i);
                    this.PrintLine("case " + this.ConvertCONST(caseConst) + ":", indentlevel);
                    continue block0;
                }
                continue;
            }
            if (LabelKind != 12) continue;
            this.PrintLine("default: ", indentlevel);
        }
        this.ConvertStmt(pstmt.getStmt(), indentlevel);
        Stmt nextStmt = pstmt.getNextStmt();
        return nextStmt;
    }

    private String ConvertCONST(Const sConst) {
        Type sConstType = sConst.getSymType();
        String ConstStringKey = "";
        String ConstStringValue = "";
        if (sConstType.getTypeKind() == 14) {
            ConstStringValue = Long.toString(sConst.longValue());
        } else if (sConstType.getTypeKind() == 2) {
            ConstStringValue = Long.toString(((BoolConst)sConst).longValue());
        } else if (sConstType.isFloating()) {
            ConstStringValue = "(" + this.ConvertBaseType(sConstType, "") + ")" + Double.toString(sConst.doubleValue());
        } else if (sConstType.isInteger()) {
            ConstStringValue = "(" + this.ConvertBaseType(sConstType, "") + ")" + Long.toString(sConst.longValue());
        } else {
            StringConst sconstString = (StringConst)sConst;
            if (sconstString != null) {
                ConstStringValue = this.ConvertSTRING(sconstString.getStringBody());
                return ConstStringValue;
            }
        }
        return ConstStringValue;
    }

    private String ConvertSTRING(String pCstring) {
        StringBuffer lString = new StringBuffer();
        if (pCstring == null) {
            return "\"\"";
        }
        lString.append("\"");
        block12: for (int i = 0; i < pCstring.length(); ++i) {
            char lChar = pCstring.charAt(i);
            switch (lChar) {
                case '\u0007': {
                    lString.append("\\a");
                    continue block12;
                }
                case '\u000b': {
                    lString.append("\\013");
                    continue block12;
                }
                case '\b': {
                    lString.append("\\b");
                    continue block12;
                }
                case '\f': {
                    lString.append("\\f");
                    continue block12;
                }
                case '\n': {
                    lString.append("\\n");
                    continue block12;
                }
                case '\r': {
                    lString.append("\\r");
                    continue block12;
                }
                case '\t': {
                    lString.append("\\t");
                    continue block12;
                }
                case '\\': {
                    lString.append("\\\\");
                    continue block12;
                }
                case '\'': {
                    lString.append("\\'");
                    continue block12;
                }
                case '\"': {
                    lString.append("\\\"");
                    continue block12;
                }
                default: {
                    char value = lChar;
                    if (value >= ' ' && value <= '~') {
                        lString.append(lChar);
                        continue block12;
                    }
                    lString.append("\\");
                    lString.append(Integer.toOctalString(value));
                }
            }
        }
        lString.append("\"");
        return lString.toString();
    }

    private String ChangeConstSTRING(String pCstring) {
        StringBuffer lString = new StringBuffer();
        block4: for (int i = 0; i < pCstring.length(); ++i) {
            char lChar = pCstring.charAt(i);
            switch (lChar) {
                case '-': {
                    lString.append("_SUB_");
                    continue block4;
                }
                case '.': {
                    lString.append("_POINT_");
                    continue block4;
                }
                default: {
                    lString.append(lChar);
                }
            }
        }
        return lString.toString();
    }

    private String ChangeTagName(String pCstring) {
        StringBuffer lString = new StringBuffer();
        block3: for (int i = 0; i < pCstring.length(); ++i) {
            char lChar = pCstring.charAt(i);
            switch (lChar) {
                case '#': {
                    lString.append("___");
                    continue block3;
                }
                default: {
                    lString.append(lChar);
                }
            }
        }
        return lString.toString();
    }

    private boolean IsLabelPrint(Label label) {
        this.Trace("[HIR DEBUG ][LabelKind]" + label.getLabelKind(), 1);
        this.Trace("[HIR DEBUG ][LabelRefCout]" + label.getHirRefCount(), 1);
        if (label == this.fContinueLabel) {
            this.fContinueLabel = null;
        }
        if (this.fLabelRef.IsLabelRef(label)) {
            return true;
        }
        return label.getLabelKind() == 0;
    }

    private boolean IsBlockPrint(Stmt Part) {
        if (Part == null) {
            return true;
        }
        Stmt nextStmt = ((LabeledStmt)Part).getStmt();
        if (nextStmt == null) {
            nextStmt = Part.getNextStmt();
        } else {
            IrList LabeledList = nextStmt.getLabelDefList();
            ListIterator Ie = LabeledList.iterator();
            while (Ie.hasNext()) {
                LabelDef labelDef = (LabelDef)Ie.next();
                Label label = labelDef.getLabel();
                if (!this.IsLabelPrint(label)) continue;
                return true;
            }
        }
        if (nextStmt == null) {
            return true;
        }
        return nextStmt.getOperator() != 35;
    }

    private boolean IsThenPrint(Stmt ThenPart) {
        if (ThenPart == null) {
            return false;
        }
        Stmt nextStmt = ((LabeledStmt)ThenPart).getStmt();
        if (nextStmt == null) {
            nextStmt = ThenPart.getNextStmt();
        }
        return nextStmt != null;
    }

    private boolean IsElsePrint(Stmt ElsePart) {
        if (ElsePart == null) {
            return false;
        }
        Stmt nextStmt = ((LabeledStmt)ElsePart).getStmt();
        if (nextStmt == null) {
            nextStmt = ElsePart.getNextStmt();
        }
        return nextStmt != null;
    }

    private void ConvertTAG(HashSet PutTag, Sym pSym, int indentlevel) {
        if (PutTag.contains(pSym)) {
            return;
        }
        LinkedList NestTagList = new LinkedList();
        this.getNestTagList(NestTagList, pSym);
        ListIterator Ie = NestTagList.listIterator();
        while (Ie.hasNext()) {
            Sym lSym = (Sym)Ie.next();
            if (lSym == null || lSym == pSym) continue;
            this.ConvertTAG(PutTag, lSym, indentlevel);
        }
        this.Trace("[HIR SYM (TAG)][kind=" + pSym.getSymKind() + "]" + pSym.toString(), 1);
        PutTag.add(pSym);
        this.ConvertSymELEM(pSym, indentlevel);
    }

    private void getNestTagList(LinkedList NestTagList, Sym symVar) {
        StringBuffer tmpString = new StringBuffer();
        tmpString.setLength(0);
        Type symType = symVar.getSymType();
        int TypeKind = symType.getTypeKind();
        Sym Tag2 = null;
        switch (TypeKind) {
            case 24: 
            case 25: {
                Elem lElem;
                IrList lElemList = symVar.getSymType().getElemList();
                ListIterator lElemIterator = lElemList.iterator();
                while (lElemIterator.hasNext() && (lElem = (Elem)lElemIterator.next()) != null) {
                    Type ESymType = lElem.getSymType();
                    int EType = ESymType.getTypeKind();
                    while (EType == 23) {
                        ESymType = ((VectorType)ESymType).getElemType();
                        EType = ESymType.getTypeKind();
                    }
                    switch (EType) {
                        case 24: {
                            Tag2 = ((StructType)ESymType).getTag();
                            break;
                        }
                        case 25: {
                            Tag2 = ((UnionType)ESymType).getTag();
                            break;
                        }
                        case 21: {
                            Tag2 = ((EnumType)ESymType).getTag();
                            break;
                        }
                        default: {
                            Tag2 = null;
                        }
                    }
                    if (Tag2 == null) continue;
                    NestTagList.add(Tag2);
                }
                break;
            }
        }
    }

    private void ConvertSymTable(SymTable sTable, int indentlevel) {
        int kind;
        Sym lSym;
        if (sTable == null) {
            return;
        }
        HashSet PutTag = new HashSet();
        SymIterator Ie = sTable.getSymIterator();
        while (Ie.hasNext()) {
            lSym = Ie.next();
            if (lSym.getSymKind() != 11) continue;
            this.ConvertTAG(PutTag, lSym, indentlevel);
        }
        this.fInitSym = true;
        this.fInitSymList.clear();
        this.fInitSymTable = sTable;
        Ie = sTable.getSymIterator();
        while (Ie.hasNext() && (lSym = Ie.next()) != null) {
            kind = lSym.getSymKind();
            if (kind != 8 || ((Var)lSym).getStorageClass() != 6) continue;
            String InitString = this.ConvertEXP(((Var)lSym).getInitialValue());
        }
        this.fInitSym = false;
        Iterator Ite = this.fInitSymList.iterator();
        while (Ite.hasNext() && (lSym = (Sym)Ite.next()) != null) {
            kind = lSym.getSymKind();
            if (kind == 11) continue;
            this.PrintSym(lSym, indentlevel);
        }
        Ie = sTable.getSymIterator();
        while (Ie.hasNext() && (lSym = Ie.next()) != null) {
            kind = lSym.getSymKind();
            if (kind == 11 || this.fInitSymList.contains(lSym)) continue;
            this.PrintSym(lSym, indentlevel);
        }
    }

    private void PrintSym(Sym pSym, int indentlevel) {
        Sym lSym = pSym;
        int kind = lSym.getSymKind();
        this.Trace("[HIR SYM Symbol][kind=" + kind + "]" + lSym.toString(), 1);
        switch (kind) {
            case 8: {
                Type lType = lSym.getSymType();
                String visibility = this.fKeyWord.getSymKeyWord(((Var)lSym).getVisibility());
                String StorageClass = "";
                if (((Var)lSym).getVisibility() != 1 && ((Var)lSym).getVisibility() != 2) {
                    StorageClass = this.fKeyWord.getSymKeyWord(((Var)lSym).getStorageClass());
                }
                String initializer = ((Var)lSym).getStorageClass() == 6 && ((Var)lSym).getInitialValue() != null ? " = " + this.ConvertEXP(((Var)lSym).getInitialValue()) : "";
                this.PrintLine(visibility + StorageClass + this.ConvertDECLARATION(lSym) + initializer + ";", indentlevel);
                break;
            }
            case 12: {
                String StorageClass = "";
                if (((Subp)lSym).getVisibility() == 5) {
                    StorageClass = this.fKeyWord.getSymKeyWord(6);
                }
                String visibility = this.fKeyWord.getSymKeyWord(((Subp)lSym).getVisibility());
                this.PrintLine(visibility + StorageClass + this.ConvertDECLARATION(lSym) + ";", indentlevel);
                break;
            }
        }
    }

    private String ConvertDECLARATION(Sym symVar) {
        Type nextType;
        StringBuffer tmpString = new StringBuffer();
        tmpString.setLength(0);
        Type symType = symVar.getSymType();
        int TypeKind = symType.getTypeKind();
        this.Trace("[HIR Decl][kind=" + TypeKind + "]" + symVar.toString(), 1);
        switch (TypeKind) {
            case 23: {
                nextType = symType;
                tmpString.append(symVar.getName());
                int dim = symType.getDimension();
                for (int i = 0; i < dim; ++i) {
                    tmpString.append("[");
                    long count = ((VectorType)nextType).getElemCount();
                    if (count > 0L) {
                        tmpString.append(((VectorType)nextType).getElemCount());
                    }
                    tmpString.append("]");
                    nextType = ((VectorType)nextType).getElemType();
                }
                break;
            }
            case 21: 
            case 24: 
            case 25: {
                nextType = symType;
                tmpString.append(symVar.getName());
                break;
            }
            case 27: {
                SubpType subpType = (SubpType)symType;
                nextType = subpType.getReturnType();
                IrList ParamList = subpType.getParamTypeList();
                tmpString.append(symVar.getName());
                tmpString.append(" ( ");
                if (ParamList != null) {
                    ListIterator It = ParamList.iterator();
                    boolean ParamExist = false;
                    while (It.hasNext()) {
                        ParamExist = true;
                        Type BaseType2 = ((Sym)It.next()).getSymType();
                        tmpString.append(this.ConvertBaseType(BaseType2, ""));
                        tmpString.append(",");
                    }
                    if (subpType.hasOptionalParam() && ParamExist) {
                        tmpString.append(" ... ");
                    }
                }
                tmpString.setLength(tmpString.length() - 1);
                tmpString.append(" ) ");
                break;
            }
            default: {
                nextType = symType;
                tmpString.append(symVar.getName());
            }
        }
        this.Trace("[HIR Decl]Name=" + tmpString.toString(), 1);
        return this.ConvertBaseType(nextType, tmpString.toString());
    }

    private void ConvertSymELEM(Sym symVar, int indentlevel) {
        StringBuffer tmpString = new StringBuffer();
        tmpString.setLength(0);
        Type symType = symVar.getSymType();
        int TypeKind = symType.getTypeKind();
        switch (TypeKind) {
            case 24: 
            case 25: {
                this.fOutString.append(this.fKeyWord.getTypeKeyWord(TypeKind));
                this.fOutString.append(this.ChangeTagName(symVar.getName()));
                IrList lElemList = symVar.getSymType().getElemList();
                if (lElemList.size() == 0) {
                    this.fOutString.append(" ;");
                } else {
                    this.fOutString.append(" { ");
                    this.PrintLine(this.fOutString.toString(), indentlevel);
                    ListIterator lElemIterator = lElemList.iterator();
                    while (lElemIterator.hasNext()) {
                        Elem lElem = (Elem)lElemIterator.next();
                        if (lElem == null) continue;
                        if (lElem.isBitField()) {
                            this.PrintLine(this.ConvertDECLARATION(lElem) + ":" + lElem.getBitSize() + ";", indentlevel);
                            continue;
                        }
                        this.PrintLine(this.ConvertDECLARATION(lElem) + ";", indentlevel);
                    }
                    this.fOutString.append(" };  ");
                }
                this.PrintLine(this.fOutString.toString(), indentlevel);
                break;
            }
            case 21: {
                this.fOutString.append(this.fKeyWord.getTypeKeyWord(TypeKind));
                this.fOutString.append(this.ChangeTagName(symVar.getName()));
                this.fOutString.append(" { ");
                this.PrintLine(this.fOutString.toString(), indentlevel);
                IrList List1 = symVar.getSymType().getElemList();
                ListIterator lElemIterator = List1.iterator();
                while (lElemIterator.hasNext()) {
                    IrList List2 = (IrList)lElemIterator.next();
                    if (List2 == null) continue;
                    ListIterator Ie = List2.iterator();
                    while (Ie.hasNext()) {
                        Object s = Ie.next();
                        if (s instanceof Integer) continue;
                        tmpString.append(((Sym)s).getName());
                        tmpString.append(",");
                    }
                }
                tmpString.setLength(tmpString.length() - 1);
                this.fOutString.append(tmpString.toString());
                this.fOutString.append(" };  ");
                this.PrintLine(this.fOutString.toString(), indentlevel);
                break;
            }
            case 28: {
                this.PrintLine("", indentlevel);
                break;
            }
            default: {
                this.PrintLine(this.ConvertDECLARATION(symVar) + ";", indentlevel);
            }
        }
    }

    private String ConvertBaseType(Type pType, String Var2) {
        StringBuffer tmpString = new StringBuffer();
        tmpString.setLength(0);
        if (pType.isConst()) {
            tmpString.append("const  ");
            pType = pType.getOrigin();
        }
        if (pType.isVolatile()) {
            tmpString.append("volatile ");
            pType = pType.getOrigin();
        }
        int BaseType2 = pType.getTypeKind();
        this.Trace("[HIR BaseType DEBUG ][BaseType=" + BaseType2 + "]" + pType.toStringDetail(), 1);
        this.Trace("[HIR BaseType DEBUG ][Base Var=" + Var2 + "]", 1);
        block0 : switch (BaseType2) {
            case 22: {
                PointerType ptrType = (PointerType)pType;
                Type PointedType = ptrType.getPointedType();
                int PointedKind = PointedType.getTypeKind();
                switch (PointedKind) {
                    case 23: {
                        int dim = ((VectorType)PointedType).getDimension();
                        Type ElementType = PointedType;
                        for (int i = 0; i < dim; ++i) {
                            ElementType = ((VectorType)ElementType).getElemType();
                        }
                        tmpString.append(this.ConvertBaseType(ElementType, "(" + this.fKeyWord.getTypeKeyWord(BaseType2) + " " + Var2 + ")" + this.ConvertBaseType(PointedType, "")));
                        break block0;
                    }
                    case 27: {
                        SubpType subpType = (SubpType)PointedType;
                        Type nextType = subpType.getReturnType();
                        tmpString.append(this.ConvertBaseType(nextType, "(" + this.fKeyWord.getTypeKeyWord(BaseType2) + " " + Var2 + ")" + this.ConvertBaseType(PointedType, "")));
                        break block0;
                    }
                    case 22: {
                        tmpString.append(this.ConvertBaseType(PointedType, this.fKeyWord.getTypeKeyWord(BaseType2) + " " + Var2));
                        break block0;
                    }
                }
                tmpString.append(this.ConvertBaseType(PointedType, ""));
                tmpString.append(this.fKeyWord.getTypeKeyWord(BaseType2));
                tmpString.append(" " + Var2);
                break;
            }
            case 24: {
                tmpString.append(this.fKeyWord.getTypeKeyWord(BaseType2));
                Sym tag = ((StructType)pType).getTag();
                tmpString.append(this.ChangeTagName(tag.getName()) + " ");
                tmpString.append(" " + Var2);
                break;
            }
            case 25: {
                tmpString.append(this.fKeyWord.getTypeKeyWord(BaseType2));
                Sym tag = ((UnionType)pType).getTag();
                tmpString.append(this.ChangeTagName(tag.getName()) + " ");
                tmpString.append(" " + Var2);
                break;
            }
            case 21: {
                tmpString.append(this.fKeyWord.getTypeKeyWord(BaseType2));
                Sym tag = ((EnumType)pType).getTag();
                tmpString.append(this.ChangeTagName(tag.getName()) + " ");
                tmpString.append(" " + Var2);
                break;
            }
            case 23: {
                long dim = pType.getDimension();
                Type nextType = pType;
                tmpString.append(Var2);
                for (long i = 0L; i < dim; ++i) {
                    tmpString.append("[");
                    long count = ((VectorType)nextType).getElemCount();
                    if (count != 0L) {
                        tmpString.append(Long.toString(count));
                    }
                    tmpString.append("]");
                    nextType = ((VectorType)nextType).getElemType();
                }
                break;
            }
            case 27: {
                SubpType subpType = (SubpType)pType;
                Type nextType = subpType.getReturnType();
                IrList ParamList = subpType.getParamTypeList();
                tmpString.append("( ");
                if (ParamList != null) {
                    ListIterator It = ParamList.iterator();
                    boolean ParamExist = false;
                    while (It.hasNext()) {
                        Type BaseTypes = ((Sym)It.next()).getSymType();
                        tmpString.append(this.ConvertBaseType(BaseTypes, ""));
                        tmpString.append(",");
                        ParamExist = true;
                    }
                    if (subpType.hasOptionalParam() && ParamExist) {
                        tmpString.append(" ... ");
                    }
                }
                tmpString.setLength(tmpString.length() - 1);
                tmpString.append(")");
                break;
            }
            case 13: {
                tmpString.append(this.fKeyWord.getTypeKeyWord(BaseType2) + " " + Var2);
                break;
            }
            default: {
                tmpString.append(this.fKeyWord.getTypeKeyWord(BaseType2) + " " + Var2);
            }
        }
        return tmpString.toString();
    }

    private Stmt ConvertASMSTMT(AsmStmt pStmt, int pIndentlevel) {
        this.fOutString.append(this.fKeyWord.getOpKeyWord(37));
        this.fOutString.append("(");
        this.fOutString.append(this.ConvertEXP((Exp)pStmt.getChild1()));
        ListIterator lIter = ((HirList)pStmt.getChild2()).iterator();
        while (lIter.hasNext()) {
            HIR lHir = (HIR)lIter.next();
            this.fOutString.append(", ");
            this.fOutString.append(this.ConvertEXP((Exp)lHir));
        }
        this.fOutString.append(")");
        this.PrintLine(this.fOutString.toString() + ";", pIndentlevel);
        return pStmt.getNextStmt();
    }

    private String ConvertHIRLIST(HirList pHirList) {
        StringBuffer tmpString = new StringBuffer();
        boolean lInsertComma = false;
        tmpString.append("(");
        ListIterator lIter = pHirList.iterator();
        while (lIter.hasNext()) {
            HIR lHir = (HIR)lIter.next();
            if (lInsertComma) {
                tmpString.append(", ");
            }
            tmpString.append(this.ConvertEXP((Exp)lHir));
        }
        tmpString.append(")");
        return tmpString.toString();
    }

    private String putDefListConst(String value, boolean isunsigned) {
        String Umark = isunsigned ? "U" : "";
        String name = this.fKeyWord.getOpKeyWord(5) + this.ChangeConstSTRING(value) + Umark + " ";
        if (this.fFirstSearch) {
            this.fPrintDefine.DefList.put(name, "(" + value + Umark + ")");
        }
        return name;
    }

    private void Trace(String s, int level) {
        if (level <= this.fTraceLevel) {
            this.fTraceList.add("//HIR2C:" + s);
        }
    }

    private void TraceDebug(String s, int level) {
        if (level <= this.fTraceLevel) {
            this.PrintOutln("//HIR2C[DEBUG]" + s);
        }
    }

    void PrintLine(String s, int indentlevel) {
        if (!this.fFirstSearch) {
            Iterator Ie = this.fTraceList.iterator();
            while (Ie.hasNext()) {
                this.PrintOutln((String)Ie.next());
            }
            this.fInf.PrintValue();
            for (int i = 0; i < indentlevel; ++i) {
                this.PrintOut("    ");
            }
            this.PrintOutln(s);
        }
        this.fTraceList.clear();
        this.fOutString.setLength(0);
        this.fInf.clear();
    }

    private void PrintOutln(String s) {
        this.fprintOut.println(s);
    }

    private void PrintOut(String s) {
        this.fprintOut.print(s);
    }
}

