/*
 * Decompiled with CFR 0.152.
 */
package coins.ir.hir;

import coins.HasStringObject;
import coins.HirRoot;
import coins.MachineParam;
import coins.SourceLanguage;
import coins.flow.SubpFlow;
import coins.ir.IR;
import coins.ir.IrList;
import coins.ir.hir.AsmStmt;
import coins.ir.hir.AsmStmtImpl;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.AssignStmtImpl;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.BlockStmtImpl;
import coins.ir.hir.ConstNode;
import coins.ir.hir.ConstNodeImpl;
import coins.ir.hir.ElemNode;
import coins.ir.hir.ElemNodeImpl;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpImpl;
import coins.ir.hir.ExpListExp;
import coins.ir.hir.ExpListExpImpl;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.ExpStmtImpl;
import coins.ir.hir.ForStmt;
import coins.ir.hir.ForStmtImpl;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.FunctionExpImpl;
import coins.ir.hir.HIR;
import coins.ir.hir.HirAnnex;
import coins.ir.hir.HirIterator;
import coins.ir.hir.HirIteratorImpl;
import coins.ir.hir.HirList;
import coins.ir.hir.HirListImpl;
import coins.ir.hir.HirSeq;
import coins.ir.hir.HirSeqImpl;
import coins.ir.hir.HirVisitor;
import coins.ir.hir.IfStmt;
import coins.ir.hir.IfStmtImpl;
import coins.ir.hir.IndexedLoopStmt;
import coins.ir.hir.IndexedLoopStmtImpl;
import coins.ir.hir.InfStmt;
import coins.ir.hir.InfStmtImpl;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.JumpStmtImpl;
import coins.ir.hir.LabelDef;
import coins.ir.hir.LabelDefImpl;
import coins.ir.hir.LabelNode;
import coins.ir.hir.LabelNodeImpl;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LabeledStmtImpl;
import coins.ir.hir.NullNode;
import coins.ir.hir.NullNodeImpl;
import coins.ir.hir.PhiExp;
import coins.ir.hir.PhiExpImpl;
import coins.ir.hir.PointedExp;
import coins.ir.hir.PointedExpImpl;
import coins.ir.hir.Program;
import coins.ir.hir.ProgramImpl;
import coins.ir.hir.QualifiedExp;
import coins.ir.hir.QualifiedExpImpl;
import coins.ir.hir.RepeatStmt;
import coins.ir.hir.RepeatStmtImpl;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.ReturnStmtImpl;
import coins.ir.hir.SetDataStmt;
import coins.ir.hir.SetDataStmtImpl;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubpDefinitionImpl;
import coins.ir.hir.SubpNode;
import coins.ir.hir.SubpNodeImpl;
import coins.ir.hir.SubscriptedExp;
import coins.ir.hir.SubscriptedExpImpl;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.SwitchStmtImpl;
import coins.ir.hir.SymNode;
import coins.ir.hir.SymNodeImpl;
import coins.ir.hir.TypeNode;
import coins.ir.hir.TypeNodeImpl;
import coins.ir.hir.VarNode;
import coins.ir.hir.VarNodeImpl;
import coins.ir.hir.WhileStmt;
import coins.ir.hir.WhileStmtImpl;
import coins.sym.Const;
import coins.sym.Elem;
import coins.sym.ExpId;
import coins.sym.FlagBox;
import coins.sym.FlowAnalSym;
import coins.sym.Label;
import coins.sym.PointerType;
import coins.sym.StringConst;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class HIR_Impl
implements HIR,
HasStringObject,
Cloneable {
    public final HirRoot hirRoot;
    protected int fOperator;
    protected IR fChildNode1;
    protected IR fChildNode2;
    protected IR[] fAdditionalChild = null;
    protected IR fParentNode;
    protected int fChildCount;
    protected HirAnnex fHirAnnex = null;
    protected Type fType = null;
    protected final int fDbgLevel;
    protected static MachineParam machineParam;
    protected static SourceLanguage sourceLanguage;
    static final int[] inversionTable;

    public HIR_Impl() {
        this.hirRoot = null;
        this.fOperator = 73;
        this.fDbgLevel = 0;
    }

    public HIR_Impl(HirRoot pHirRoot) {
        this.hirRoot = pHirRoot;
        this.fOperator = 73;
        this.fDbgLevel = this.hirRoot.ioRoot.dbgHir.getLevel();
    }

    protected HIR_Impl(HirRoot pHirRoot, int pOperator) {
        this.hirRoot = pHirRoot;
        this.fOperator = pOperator;
        this.fDbgLevel = this.hirRoot.ioRoot.dbgHir.getLevel();
    }

    public void setParameters(MachineParam pMachineParam, SourceLanguage pSourceLanguage) {
        machineParam = pMachineParam;
        sourceLanguage = pSourceLanguage;
    }

    public int getOperator() {
        return this.fOperator;
    }

    public IR getParent() {
        return this.fParentNode;
    }

    public void setParent(IR pParent) {
        this.fParentNode = pParent;
    }

    public int getChildCount() {
        return this.fChildCount;
    }

    public IR getChild1() {
        return this.fChildNode1;
    }

    public IR getChild2() {
        return this.fChildNode2;
    }

    public IR getChild(int pNumber) {
        if (pNumber < 1 || this.fChildCount < pNumber) {
            return null;
        }
        switch (pNumber) {
            case 1: {
                return this.fChildNode1;
            }
            case 2: {
                return this.fChildNode2;
            }
        }
        return this.fAdditionalChild[pNumber - 3];
    }

    public void setChild1(IR pChild) {
        this.fChildNode1 = pChild;
        if (pChild != null) {
            ((HIR_Impl)pChild).setParent(this);
        }
    }

    public void setChild2(IR pChild) {
        this.fChildNode2 = pChild;
        if (pChild != null) {
            ((HIR_Impl)pChild).setParent(this);
        }
    }

    public void setChild(int pNumber, IR pHir) {
        if (pNumber > 0 && pNumber <= this.fChildCount) {
            IR lChildNode = this.getChild(pNumber);
            switch (pNumber) {
                case 1: {
                    this.fChildNode1 = pHir;
                    break;
                }
                case 2: {
                    this.fChildNode2 = pHir;
                    break;
                }
                default: {
                    this.fAdditionalChild[pNumber - 3] = pHir;
                }
            }
            if (pHir != null) {
                ((HIR_Impl)pHir).setParent(this);
            }
        } else {
            this.hirRoot.ioRoot.msgRecovered.put(1001, "Too big child number in setChild ");
        }
    }

    public int getChildNumber() {
        int lChildNumber;
        if (this.fParentNode != null) {
            int lChildCount = this.fParentNode.getChildCount();
            for (lChildNumber = 1; lChildNumber <= lChildCount && this != this.fParentNode.getChild(lChildNumber); ++lChildNumber) {
            }
            if (lChildNumber > lChildCount) {
                lChildNumber = -1;
            }
        } else {
            lChildNumber = -1;
        }
        return lChildNumber;
    }

    public void addInf(String pInfKindInterned, Object pInfObject) {
        if (this.fHirAnnex == null) {
            this.fHirAnnex = new HirAnnex(this.hirRoot);
        }
        this.fHirAnnex.addInf(pInfKindInterned, pInfObject);
    }

    public Object getInf(String pInfKindInterned) {
        if (this.fHirAnnex == null) {
            return null;
        }
        return this.fHirAnnex.getInf(pInfKindInterned);
    }

    public void removeInf(String pInfKindInterned) {
        if (this.fHirAnnex != null) {
            this.fHirAnnex.removeInf(pInfKindInterned);
        }
    }

    public IrList getInfList() {
        if (this.fHirAnnex != null) {
            return this.fHirAnnex.getInfList();
        }
        return null;
    }

    public void copyInfListFrom(HIR pFromHir) {
        if (pFromHir == null) {
            return;
        }
        IrList lInfList = pFromHir.getInfList();
        if (lInfList != null) {
            ListIterator lListIt = lInfList.iterator();
            while (lListIt.hasNext()) {
                String lInfKind = (String)lListIt.next();
                Object lInfObj = lListIt.next();
                this.addInf(lInfKind, lInfObj);
            }
        }
    }

    public String getInfString() {
        if (this.fHirAnnex != null) {
            return this.fHirAnnex.toStringInf();
        }
        return "";
    }

    public boolean withInf() {
        return this.fHirAnnex != null && this.fHirAnnex.getInfList() != null;
    }

    public Object getWork() {
        if (this.fHirAnnex == null) {
            return null;
        }
        return this.fHirAnnex.getWork();
    }

    public void setWork(Object pWork) {
        if (pWork == null && this.fHirAnnex == null) {
            return;
        }
        if (this.fHirAnnex == null) {
            this.fHirAnnex = new HirAnnex(this.hirRoot);
        }
        this.fHirAnnex.setWork(pWork);
    }

    public int getIndex() {
        if (this.fHirAnnex == null) {
            return 0;
        }
        return this.fHirAnnex.getIndex();
    }

    public void setIndex(int pIndex) {
        if (this.fHirAnnex == null) {
            this.fHirAnnex = new HirAnnex(this.hirRoot);
        }
        this.fHirAnnex.setIndex(pIndex);
    }

    public boolean isStmt() {
        return this instanceof Stmt;
    }

    public Stmt getStmtContainingThisNode() {
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(5, "\n getStmtContainingThisNode for " + this.toStringShort());
        }
        Stmt lStmt = null;
        if (this instanceof Stmt) {
            lStmt = (Stmt)((Object)this);
        } else {
            for (HIR lNode = (HIR)this.fParentNode; lNode != null; lNode = (HIR)lNode.getParent()) {
                if (!(lNode instanceof Stmt)) continue;
                lStmt = (Stmt)lNode;
                break;
            }
        }
        if (lStmt != null && !(lStmt instanceof ExpStmt) && (lStmt.getParent() instanceof LabeledStmt || lStmt.getParent() instanceof ExpStmt)) {
            lStmt = (Stmt)lStmt.getParent();
        }
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(5, " return " + lStmt);
        }
        return lStmt;
    }

    public ExpId getExpId() {
        SubpFlow lRevisedSubpFlow;
        ExpId lExpId = null;
        if (this.hirRoot.getFlowRoot() != null && (lRevisedSubpFlow = this.hirRoot.getFlowRoot().fSubpFlow) != null && lRevisedSubpFlow.getSubpSym() == this.hirRoot.symRoot.subpCurrent) {
            lExpId = lRevisedSubpFlow.getExpId(this);
        }
        return lExpId;
    }

    public FlowAnalSym getSymOrExpId() {
        Sym lSym;
        if (this instanceof SymNode) {
            lSym = this.getSym();
            if (!(lSym instanceof FlowAnalSym)) {
                lSym = null;
            }
        } else {
            lSym = this.getExpId();
        }
        return (FlowAnalSym)lSym;
    }

    public FlowAnalSym getFlowAnalSym() {
        return this.getSymOrExpId();
    }

    public HIR getSourceNode1() {
        return (HIR)this.fChildNode1;
    }

    public HIR getSourceNode2() {
        return (HIR)this.fChildNode2;
    }

    public HIR getSourceNode(int pNumber) {
        if (pNumber <= 0 || this.fChildCount < pNumber) {
            return null;
        }
        if (pNumber == 1) {
            return (HIR)this.fChildNode1;
        }
        if (pNumber == 2) {
            return (HIR)this.fChildNode2;
        }
        return (HIR)this.fAdditionalChild[pNumber - 3];
    }

    public Sym getSym() {
        return null;
    }

    public Sym getResultOperand() {
        if (this.fOperator == 22 && this.fChildNode1 != null) {
            return this.fChildNode1.getSym();
        }
        return null;
    }

    public Sym getResultVar() {
        if (this.fOperator == 22 && this.fChildNode1 != null) {
            return this.fChildNode1.getSym();
        }
        return null;
    }

    public HIR replaceSource1(HIR pOperand) {
        HIR lResult = pOperand;
        if (this.fDbgLevel > 0) {
            this.hirRoot.ioRoot.dbgHir.print(4, " replaceSource1 " + this.toStringShort(), "to " + (pOperand == null ? "null" : pOperand.toStringShort()));
        }
        this.fChildNode1 = pOperand;
        if (pOperand != null) {
            ((HIR_Impl)pOperand).setParent(this);
            pOperand.checkLinkage("replaceSource1");
        }
        return lResult;
    }

    public HIR replaceSource2(HIR pOperand) {
        if (this.fDbgLevel > 0) {
            this.hirRoot.ioRoot.dbgHir.print(4, " replaceSource2 " + this.toStringShort(), "to " + (pOperand == null ? "null" : pOperand.toStringShort()));
        }
        this.fChildNode2 = pOperand;
        if (pOperand != null) {
            ((HIR_Impl)pOperand).setParent(this);
            pOperand.checkLinkage("replaceSource2");
        }
        return pOperand;
    }

    public HIR replaceSource(int pNumber, IR pOperand) {
        if (this.fDbgLevel > 0) {
            this.hirRoot.ioRoot.dbgHir.print(4, " replaceSource " + pNumber + " " + this.toStringShort(), "to " + (pOperand == null ? "null" : ((HIR)pOperand).toStringShort()));
        }
        HIR lResult = (HIR)pOperand;
        if (pNumber <= 0 || this.fChildCount < pNumber) {
            return lResult;
        }
        if (pNumber == 1) {
            this.fChildNode1 = pOperand;
        } else if (pNumber == 2) {
            this.fChildNode2 = pOperand;
        } else {
            this.fAdditionalChild[pNumber - 3] = pOperand;
        }
        if (pOperand != null) {
            ((HIR_Impl)pOperand).setParent(this);
            ((HIR)pOperand).checkLinkage("replaceSource:" + pNumber);
        }
        return lResult;
    }

    public void replaceResultOperand(HIR pOperand) {
    }

    public void replaceResultVar(HIR pOperand) {
    }

    public HIR replaceThisNode(HIR pNewNode) {
        HIR lParent;
        HIR lResult = pNewNode;
        if (this.fDbgLevel > 0) {
            this.hirRoot.ioRoot.dbgHir.print(3, "replaceThisNode " + this.toString(), "to " + pNewNode);
        }
        if (lResult != null) {
            lResult.cutParentLink();
        }
        if ((lParent = (HIR)this.getParent()) != null) {
            int lChildNumber = this.getChildNumber();
            if (this.fDbgLevel > 0) {
                this.hirRoot.ioRoot.dbgHir.print(4, "parent " + ((Object)lParent).toString() + " childNumber " + lChildNumber);
            }
            if (lParent instanceof BlockStmt) {
                if (this instanceof Stmt && pNewNode instanceof Stmt) {
                    lResult = ((Stmt)((Object)this)).replaceThisStmtWith((Stmt)pNewNode);
                } else {
                    this.hirRoot.ioRoot.msgRecovered.put(1111, "replaceThisNode expects Stmt in BlockStmt " + this.toString() + " " + ((Object)pNewNode).toString());
                }
            } else if (lChildNumber > 0) {
                lResult = lParent.replaceSource(lChildNumber, pNewNode);
            } else if (lParent instanceof HirList) {
                int lPosition = ((HirList)lParent).indexOf(this);
                if (lPosition >= 0) {
                    ((HirList)lParent).set(lPosition, pNewNode);
                } else {
                    this.hirRoot.ioRoot.msgRecovered.put(1111, "In replaceThisNode, HirList does not contain this node " + this.toString());
                }
            } else {
                this.hirRoot.ioRoot.msgRecovered.put(1111, "replaceThisNode expects HirList as 0-child parent " + ((Object)lParent).toString() + " of " + this.toString());
            }
        } else if (this.hirRoot.ioRoot.dbgHir.getLevel() > 0) {
            this.hirRoot.ioRoot.dbgHir.print(2, "replaceThisNode " + this.toString() + " has no parent");
        }
        if (pNewNode != null) {
            pNewNode.checkLinkage("replaceThisNode");
        }
        return lResult;
    }

    public void replaceOperator(int pOperator) {
        if (this.fDbgLevel > 0) {
            this.hirRoot.ioRoot.msgWarning.put(" Do not use replaceOperator. It is a deleted method.");
        }
        this.fOperator = pOperator;
    }

    public void cutParentLink() {
        HIR lParent = (HIR)this.getParent();
        if (lParent == null) {
            return;
        }
        int lChildNumber = this.getChildNumber();
        this.fParentNode = null;
        if (lChildNumber < 0) {
            return;
        }
        if (this.fDbgLevel > 0) {
            this.hirRoot.ioRoot.dbgHir.print(6, "cutParentLink of chld." + lChildNumber + " " + this.toStringShort() + " to " + lParent.toStringShort());
        }
        lParent.setChild(lChildNumber, null);
    }

    public void cutParentLink(int pChildNumber) {
        HIR lParent = (HIR)this.getParent();
        if (lParent == null) {
            return;
        }
        this.fParentNode = null;
        if (pChildNumber < 0) {
            return;
        }
        if (lParent.getChild(pChildNumber) != this) {
            return;
        }
        if (this.fDbgLevel > 0) {
            this.hirRoot.ioRoot.dbgHir.print(6, "cutParentLink of chld." + pChildNumber + " " + this.toStringShort() + " to " + lParent.toStringShort());
        }
        lParent.setChild(pChildNumber, null);
    }

    public boolean isSym() {
        return false;
    }

    public boolean isHIR() {
        return true;
    }

    public boolean isLIR() {
        return false;
    }

    public boolean isEmpty(HIR pHir) {
        return pHir == null || pHir instanceof NullNode || pHir.getOperator() == 73 || pHir instanceof LabeledStmt && pHir.isEmpty(((LabeledStmt)pHir).getStmt()) || pHir instanceof ExpStmt && pHir.isEmpty(((ExpStmt)pHir).getExp());
    }

    public boolean isTerminal() {
        if (this.fChildCount > 0) {
            return false;
        }
        return !(this instanceof IrList);
    }

    public boolean contains(HIR pSubtree) {
        if (pSubtree == null) {
            return false;
        }
        if (this.hirRoot.getFlowRoot() != null && this.hirRoot.getFlowRoot().fSubpFlow != null && this.hirRoot.getFlowRoot().fSubpFlow.isComputed(7)) {
            HirIterator lIterator = this.hirIterator(this);
            while (lIterator.hasNext()) {
                HIR lHir = lIterator.next();
                if (lHir == pSubtree) {
                    return true;
                }
                if (lHir.getExpId() == null || pSubtree.getExpId() == null || lHir.getExpId() != pSubtree.getExpId()) continue;
                return true;
            }
        } else {
            HirIterator lIterator = this.hirIterator(this);
            while (lIterator.hasNext()) {
                HIR lHir = lIterator.next();
                if (lHir != pSubtree) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        ExpId lExpId;
        String nodeString = HIR.OP_CODE_NAME[this.fOperator] + " " + this.getIndex();
        if (this.fType != null) {
            nodeString = nodeString + " " + this.fType.getName();
        }
        if (this.fDbgLevel >= 3 && this.hirRoot.ioRoot.dbgFlow.getLevel() > 0 && (lExpId = this.getExpId()) != null) {
            nodeString = nodeString + " " + lExpId.getName();
        }
        if (this.fDbgLevel >= 6) {
            nodeString = nodeString + " parent ";
            nodeString = this.getParent() != null ? nodeString + ((HIR)this.getParent()).toStringShort() : nodeString + "NULL";
        }
        return nodeString;
    }

    public String toStringShort() {
        String nodeString = HIR.OP_CODE_NAME_DENSE[this.fOperator] + " " + this.getIndex();
        return nodeString;
    }

    public String toStringDetail() {
        String nodeString = this.toString();
        if (!this.flagsAreAllFalse() && this.fDbgLevel >= 3) {
            nodeString = nodeString + ((Object)this.getFlagBox()).toString();
        }
        if (this.fHirAnnex != null && this.fHirAnnex.getInfList() != null && this.getOperator() != 4) {
            nodeString = nodeString + " " + this.fHirAnnex.toStringInf();
        }
        return nodeString;
    }

    public String toStringWithChildren() {
        StringBuffer lBuffer = new StringBuffer();
        if (this.fChildCount > 0) {
            lBuffer.append("(" + HIR.OP_CODE_NAME_DENSE[this.fOperator] + " ");
            if (this instanceof BlockStmt) {
                for (Stmt lStmt = ((BlockStmt)((Object)this)).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                    lBuffer.append(lStmt.toStringWithChildren());
                }
            } else {
                for (int i = 1; i <= this.fChildCount; ++i) {
                    HIR lChild = (HIR)this.getChild(i);
                    if (lChild != null) {
                        lBuffer.append(lChild.toStringWithChildren());
                        continue;
                    }
                    lBuffer.append("null");
                }
            }
            lBuffer.append(")");
        } else if (this instanceof SymNode) {
            lBuffer.append("<" + HIR.OP_CODE_NAME_DENSE[this.fOperator] + " ");
            lBuffer.append(((SymNode)((Object)this)).getSymNodeSym().getName() + ">");
        } else if (this instanceof IrList) {
            lBuffer.append("(" + HIR.OP_CODE_NAME_DENSE[this.fOperator] + " ");
            ListIterator listIterator = ((IrList)((Object)this)).iterator();
            while (listIterator.hasNext()) {
                Object lObject = listIterator.next();
                if (lObject instanceof HIR) {
                    lBuffer.append(((HIR)lObject).toStringWithChildren());
                    continue;
                }
                if (lObject instanceof Sym) {
                    lBuffer.append("<sym " + ((Sym)lObject).getName() + ">");
                    continue;
                }
                if (lObject == null) continue;
                lBuffer.append(lObject.toString() + " ");
            }
            lBuffer.append(")");
        } else if (this instanceof IrList) {
            lBuffer.append("(" + HIR.OP_CODE_NAME_DENSE[this.fOperator] + " ");
            ListIterator listIterator = ((IrList)((Object)this)).iterator();
            while (listIterator.hasNext()) {
                Object lObject = listIterator.next();
                if (lObject instanceof HIR) {
                    lBuffer.append(((HIR)lObject).toStringWithChildren());
                    continue;
                }
                if (lObject instanceof Sym) {
                    lBuffer.append("<sym " + ((Sym)lObject).getName() + ">");
                    continue;
                }
                if (lObject == null) continue;
                lBuffer.append(lObject.toString() + " ");
            }
            lBuffer.append(")");
        } else if (this instanceof LabelDef) {
            lBuffer.append("<" + HIR.OP_CODE_NAME_DENSE[this.fOperator] + " ");
            lBuffer.append(((LabelDef)((Object)this)).getLabel().getName() + ">");
        } else {
            lBuffer.append("<" + this.toStringShort() + ">");
        }
        return lBuffer.toString();
    }

    public String getIrName() {
        String nodeString = HIR.OP_CODE_NAME_DENSE[this.fOperator] + " " + this.getIndex();
        return nodeString;
    }

    public void print(int pIndent) {
        this.print(pIndent, false);
    }

    public void print(int pIndent, boolean pDetail) {
        String lSpace = this.hirRoot.hir.getIndentSpace(pIndent);
        String lineImage = pDetail ? (this.getChildCount() == 0 ? lSpace + "<" + this.toStringDetail() : (this instanceof HirSeq ? lSpace + "(seq " + this.getIndex() + " " + this.getType().toStringShort() : lSpace + "(" + this.toStringDetail())) : (this.getChildCount() == 0 ? lSpace + "<" + this.toString() : (this instanceof HirSeq ? lSpace + "(seq " + this.getIndex() : lSpace + "(" + this.toString()));
        if (this.getChildCount() == 0) {
            if (this instanceof HirList) {
                ((HirList)((Object)this)).print(pIndent, pDetail);
            } else {
                this.hirRoot.ioRoot.printOut.print("\n" + lineImage + ">");
            }
        } else {
            this.hirRoot.ioRoot.printOut.print("\n" + lineImage);
            if (this.fChildNode1 != null) {
                if (this instanceof BlockStmt) {
                    for (Stmt lStmt = ((BlockStmt)((Object)this)).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                        lStmt.print(pIndent + 1, pDetail);
                    }
                } else {
                    this.fChildNode1.print(pIndent + 1, pDetail);
                }
            } else {
                this.hirRoot.ioRoot.printOut.print("\n" + lSpace + "<null 0 void>");
            }
            if (this.fChildCount >= 2) {
                if (this.fChildNode2 != null) {
                    this.fChildNode2.print(pIndent + 1, pDetail);
                } else {
                    this.hirRoot.ioRoot.printOut.print("\n" + lSpace + "<null 0 void>");
                }
                for (int i = 2; i < this.fChildCount; ++i) {
                    if (this.fAdditionalChild[i - 2] != null) {
                        this.fAdditionalChild[i - 2].print(pIndent + 1, pDetail);
                        continue;
                    }
                    this.hirRoot.ioRoot.printOut.print("\n" + lSpace + "<null 0 void>");
                }
            }
            if (!(this instanceof HirList)) {
                this.hirRoot.ioRoot.printOut.print(")");
            }
        }
    }

    public String getIndentSpace(int pIndent) {
        StringBuffer lSpace = new StringBuffer();
        int localIndent = pIndent;
        lSpace.append(" ");
        if (localIndent < 0) {
            localIndent = 0;
        }
        localIndent %= 60;
        for (int i = 0; i < localIndent; ++i) {
            lSpace.append(" ");
        }
        return lSpace.toString();
    }

    public int setIndexNumberToAllNodes(int pStartNumber) {
        return this.setIndexNumberToAllNodes(pStartNumber, false);
    }

    public int setIndexNumberToAllNodes(int pStartNumber, boolean pResetSymIndex) {
        if (this.fDbgLevel > 0) {
            this.hirRoot.ioRoot.dbgHir.print(2, "setIndexNumberToAllNodes under ", this.toStringShort() + " starting value " + pStartNumber + " resetSymIndex " + pResetSymIndex);
        }
        if (this.hirRoot.getFlowRoot() != null && this.hirRoot.getFlowRoot().fSubpFlow != null) {
            SubpFlow cfr_ignored_0 = this.hirRoot.getFlowRoot().fSubpFlow;
            this.hirRoot.getFlowRoot().fSubpFlow.resetComputedFlag(2);
        }
        int lIndex = pStartNumber;
        if (this instanceof Program) {
            this.setIndex(lIndex);
            ++lIndex;
            if (this.getChild2() != null) {
                lIndex = ((HIR_Impl)this.getChild2()).setIndexNumberToAllNodes2(lIndex, pResetSymIndex);
            }
            IrList subpDefList = ((Program)this.hirRoot.programRoot).getSubpDefinitionList();
            ListIterator subpDefIterator = subpDefList.iterator();
            while (subpDefIterator.hasNext()) {
                SubpDefinition subpDef = (SubpDefinition)subpDefIterator.next();
                lIndex = subpDef.setIndexNumberToAllNodes(lIndex);
            }
        } else if (this instanceof SubpDefinition) {
            if (this.fDbgLevel > 0) {
                this.hirRoot.ioRoot.dbgHir.print(2, " " + ((SubpDefinition)((Object)this)).getSubpSym().getName());
            }
            ((SubpDefinitionImpl)this).fNodeIndexMin = pStartNumber;
            this.setIndex(lIndex);
            ((HIR)this.getChild1()).setIndex(++lIndex);
            ++lIndex;
            if (this.getChild2() != null) {
                lIndex = ((HIR_Impl)this.getChild2()).setIndexNumberToAllNodes2(lIndex, pResetSymIndex);
            }
            if (((SubpDefinition)((Object)this)).getHirBody() != null) {
                lIndex = ((HIR_Impl)((Object)((SubpDefinition)((Object)this)).getHirBody())).setIndexNumberToAllNodes2(lIndex, pResetSymIndex);
            }
            ((SubpDefinitionImpl)this).fNodeIndexMax = lIndex;
            if (this.fDbgLevel > 0) {
                this.hirRoot.ioRoot.dbgHir.print(3, "\nSubpDef min " + ((SubpDefinition)((Object)this)).getNodeIndexMin() + " max " + ((SubpDefinition)((Object)this)).getNodeIndexMax());
            }
        } else if (this.getOperator() != 73) {
            this.hirRoot.ioRoot.msgWarning.put(1220, "setIndexNumberToAllNodes should be specified for Program or SubpDefinition  given is " + this.toStringShort());
        }
        if (this.hirRoot.getFlowRoot() != null && this.hirRoot.getFlowRoot().fSubpFlow != null) {
            SubpFlow cfr_ignored_1 = this.hirRoot.getFlowRoot().fSubpFlow;
            this.hirRoot.getFlowRoot().fSubpFlow.setComputedFlag(2);
        }
        return lIndex;
    }

    public int setIndexNumberToAllNodes2(int pStartNumber, boolean pResetSymIndex) {
        int lIndex;
        block9: {
            block10: {
                Sym lSymNodeSym;
                block13: {
                    block12: {
                        block11: {
                            lIndex = pStartNumber;
                            if (this.fDbgLevel > 4) {
                                this.hirRoot.ioRoot.dbgHir.print(7, "setIndexNumberToAllNodes2 ", this.toStringShort() + " startValue " + pStartNumber);
                            }
                            this.setIndex(lIndex);
                            ++lIndex;
                            if (this.fChildCount != 0) break block10;
                            if (!(this instanceof HirList)) break block11;
                            HirList lHirList = (HirList)((Object)this);
                            int lListSize = lHirList.size();
                            int lListIndex = 0;
                            ListIterator lIteratorL1 = lHirList.iterator();
                            while (lIteratorL1.hasNext()) {
                                Object lObject = lIteratorL1.next();
                                if (!(lObject instanceof HIR)) continue;
                                HIR lElem = (HIR)lObject;
                                if (++lListIndex <= lListSize) {
                                    if (lElem == null) continue;
                                    lIndex = ((HIR_Impl)lElem).setIndexNumberToAllNodes2(lIndex, pResetSymIndex);
                                    continue;
                                }
                                break block9;
                            }
                            break block9;
                        }
                        if (!(this instanceof ExpListExp)) break block12;
                        ExpListExp lExpListExp = (ExpListExp)((Object)this);
                        ListIterator lIteratorL2 = lExpListExp.iterator();
                        while (lIteratorL2.hasNext()) {
                            HIR lElem = (HIR)lIteratorL2.next();
                            if (lElem == null) continue;
                            lIndex = ((HIR_Impl)lElem).setIndexNumberToAllNodes2(lIndex, pResetSymIndex);
                        }
                        break block9;
                    }
                    if (!(this instanceof LabelDef)) break block13;
                    Label lLabel = ((LabelDef)((Object)this)).getLabel();
                    if (!(this.getParent() instanceof IrList) || !(this.getParent().getParent() instanceof LabeledStmt)) break block9;
                    LabeledStmt lLabeledStmt = (LabeledStmt)this.getParent().getParent();
                    if (this.fDbgLevel > 0) {
                        this.hirRoot.ioRoot.dbgHir.print(5, " setHirPosition of", lLabel.getName() + " as " + this.toStringShort());
                    }
                    lLabel.setHirPosition(lLabeledStmt);
                    break block9;
                }
                if (!pResetSymIndex || !(this instanceof SymNode) || !((lSymNodeSym = ((SymNode)((Object)this)).getSymNodeSym()) instanceof FlowAnalSym)) break block9;
                ((FlowAnalSym)lSymNodeSym).resetFlowAnalInf();
                break block9;
            }
            if (this instanceof BlockStmt) {
                BlockStmt lBlockStmt = (BlockStmt)((Object)this);
                for (Stmt lStmt = lBlockStmt.getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                    lIndex = ((HIR_Impl)((Object)lStmt)).setIndexNumberToAllNodes2(lIndex, pResetSymIndex);
                }
            } else {
                for (int lChildNumber = 1; lChildNumber <= this.fChildCount; ++lChildNumber) {
                    HIR lChild = (HIR)this.getChild(lChildNumber);
                    if (lChild == null) continue;
                    lIndex = ((HIR_Impl)lChild).setIndexNumberToAllNodes2(lIndex, pResetSymIndex);
                }
            }
        }
        return lIndex;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean finishHir() {
        block23: {
            block28: {
                block24: {
                    block25: {
                        if (this.fDbgLevel > 0) {
                            if (this instanceof SubpDefinition) {
                                this.hirRoot.ioRoot.dbgHir.print(2, "\nfinishHir", ((SubpDefinition)this).getSubpSym().getName());
                            } else {
                                this.hirRoot.ioRoot.dbgHir.print(2, "\nfinishHir", this.toString());
                            }
                        }
                        if (!(this instanceof Program) && !(this instanceof SubpDefinition)) break block23;
                        lIndexStartNumber = this.getIndex();
                        if (lIndexStartNumber <= 0) {
                            lIndexStartNumber = 1;
                        }
                        this.setIndexNumberToAllNodes(lIndexStartNumber);
                        lTreeStructure = this.isTree();
                        if (lTreeStructure) {
                            this.hirRoot.ioRoot.dbgHir.print(2, "\n" + this.toString() + " does not violate tree structure.\n");
                        }
                        if (!(this instanceof Program)) break block24;
                        lModifyFunctionsWithoutSideEffect = false;
                        lProgInitPart = (HIR)((Program)this).getInitiationPart();
                        if (!(lProgInitPart instanceof BlockStmt)) break block25;
                        for (lStmt = ((BlockStmt)lProgInitPart).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                            lSubpList = null;
                            lWithSideEffect = true;
                            if (!(lStmt instanceof InfStmt) || ((InfStmt)lStmt).getInfKind() != "optControl") continue;
                            lInfStmt = (InfStmt)lStmt;
                            lOptionList = ((InfStmt)lStmt).getInfList("optControl");
                            lOptionName = ((InfStmt)lStmt).getInfSubkindOf("optControl");
                            this.hirRoot.ioRoot.dbgHir.print(4, " subkind " + lOptionName + " option list " + lOptionList + "\n");
                            if (lOptionName == null) {
                                this.hirRoot.ioRoot.dbgHir.print(1, "\nUnknown option subkind " + ((InfStmt)lStmt).toString() + "\n");
                                continue;
                            }
                            lToBeChanged = false;
                            if (lOptionName == "functionsWithoutSideEffect") {
                                lWithSideEffect = false;
                                lToBeChanged = true;
                            } else if (lOptionName == "functionsWithSideEffect") {
                                lWithSideEffect = true;
                                lToBeChanged = true;
                            }
                            if (!lToBeChanged) continue;
                            lIndex = 0;
                            lIt = lOptionList.iterator();
                            while (lIt.hasNext()) {
                                block26: {
                                    block27: {
                                        lSubp = lIt.next();
                                        if (lIndex <= 0) break block26;
                                        if (!(lSubp instanceof Sym)) break block27;
                                        lSubpName = ((Sym)lSubp).getName().intern();
                                        ** GOTO lbl52
                                    }
                                    if (!(lSubp instanceof String)) {
                                        this.hirRoot.ioRoot.dbgHir.print(2, "unexpected object " + lSubp + " " + lSubp.getClass());
                                    } else {
                                        lSubpName = ((String)lSubp).intern();
lbl52:
                                        // 2 sources

                                        if (lWithSideEffect) {
                                            if (this.hirRoot.symRoot.sourceLanguage.functionsWithoutSideEffect.contains(lSubpName)) {
                                                this.hirRoot.ioRoot.dbgHir.print(3, " remove " + lSubpName);
                                                this.hirRoot.symRoot.sourceLanguage.functionsWithoutSideEffect.remove(lSubpName);
                                                lModifyFunctionsWithoutSideEffect = true;
                                            }
                                        } else {
                                            this.hirRoot.ioRoot.dbgHir.print(3, " add " + lSubpName);
                                            this.hirRoot.symRoot.sourceLanguage.functionsWithoutSideEffect.add(lSubpName);
                                            lModifyFunctionsWithoutSideEffect = true;
                                        }
                                    }
                                }
                                ++lIndex;
                            }
                        }
                    }
                    if (lModifyFunctionsWithoutSideEffect) {
                        this.hirRoot.ioRoot.dbgHir.print(3, "functionsWithoutSideEffect " + this.hirRoot.symRoot.sourceLanguage.functionsWithoutSideEffect);
                    }
                    if (this.fDbgLevel > 0) {
                        for (Sym lSym : this.hirRoot.symRoot.safeArray) {
                            lOwner = lSym.getDefinedInName();
                            this.hirRoot.ioRoot.dbgHir.print(1, "safeArray:", lSym.getName() + " in " + lOwner);
                        }
                    }
                    lSubpIterator = ((Program)this).getSubpDefinitionList().iterator();
                    while (lSubpIterator.hasNext()) {
                        lSubpDef = (SubpDefinition)lSubpIterator.next();
                        lSubpDef.getSubpSym().buildLabelRefList();
                    }
                    break block28;
                }
                if (this instanceof SubpDefinition) {
                    ((SubpDefinition)this).getSubpSym().buildLabelRefList();
                }
            }
            if (this.fDbgLevel > 4) {
                System.out.print("\n Test getNextNode() \n");
                lNode /* !! */  = this;
                for (lCount = 0; lCount < 1000; ++lCount) {
                    System.out.print("\n" + lNode /* !! */ .toStringShort());
                    lNode /* !! */  = lNode /* !! */ .getNextNode();
                    if (lNode /* !! */  == null) break;
                }
            }
            return lTreeStructure;
        }
        this.hirRoot.ioRoot.msgWarning.put("\nfinishHir() should be called for Program or SubpDefinition, not for " + this.toString());
        return false;
    }

    public void warinig(int pId, String pMessage) {
        this.hirRoot.ioRoot.msgOut.println("\nWarning " + pId + pMessage);
    }

    public void slightError(int pId, String pMessage) {
        this.hirRoot.ioRoot.msgOut.println("\nSlight error " + pId + pMessage);
    }

    public void severeError(int pId, String pMessage) {
        this.hirRoot.ioRoot.msgOut.println("\nSevere error " + pId + pMessage);
    }

    public void fatalError(int pId, String pMessage) {
        this.hirRoot.ioRoot.msgOut.println("\nFatal error " + pId + pMessage);
    }

    public Program program(Sym pProgSym, SymTable pGlobalSymTable, IR pInitiationPart, IrList pSubpList) {
        if (this.hirRoot.programRoot == null) {
            this.hirRoot.programRoot = new ProgramImpl(this.hirRoot, pProgSym, pGlobalSymTable, pInitiationPart, pSubpList);
        } else {
            if (pProgSym != null) {
                ((HIR)this.hirRoot.programRoot).replaceSource1(this.hirRoot.hir.symNode(pProgSym));
            }
            if (pInitiationPart != null) {
                ((HIR)this.hirRoot.programRoot).replaceSource2((HIR)pInitiationPart);
            }
            if (pSubpList != null) {
                ((HIR)this.hirRoot.programRoot).replaceSource(3, (HIR)((Object)pSubpList));
            }
        }
        return (Program)this.hirRoot.programRoot;
    }

    public SubpDefinition subpDefinition(Subp pSubpSym, SymTable pLocalSymTable) {
        return new SubpDefinitionImpl(this.hirRoot, pSubpSym, pLocalSymTable, null, null);
    }

    public SubpDefinition subpDefinition(Subp pSubpSym) {
        return new SubpDefinitionImpl(this.hirRoot, pSubpSym, null, null, null);
    }

    public SubpDefinition subpDefinition(Subp pSubpSym, SymTable pLocalSymTable, BlockStmt pInitiationPart, BlockStmt pHIRbody) {
        return new SubpDefinitionImpl(this.hirRoot, pSubpSym, pLocalSymTable, pInitiationPart, null);
    }

    public IrList irList(LinkedList pList) {
        HirListImpl lHirList;
        HirListImpl lList = lHirList = new HirListImpl(this.hirRoot, pList);
        return lList;
    }

    public IrList irList() {
        HirListImpl lHirList;
        HirListImpl lList = lHirList = new HirListImpl(this.hirRoot);
        return lList;
    }

    public HirList hirList() {
        return new HirListImpl(this.hirRoot);
    }

    public InfStmt infStmt(String pInfKind, IrList pInfData) {
        return new InfStmtImpl(this.hirRoot, pInfKind, pInfData);
    }

    public InfStmt infStmt(String pInfKind, Object pInfData) {
        if (pInfData instanceof IrList) {
            return new InfStmtImpl(this.hirRoot, pInfKind, (IrList)pInfData);
        }
        IrList lList = this.irList();
        lList.add(pInfData);
        return new InfStmtImpl(this.hirRoot, pInfKind, lList);
    }

    public VarNode varNode(Var pVar) {
        return new VarNodeImpl(this.hirRoot, pVar);
    }

    public ElemNode elemNode(Elem pElem) {
        return new ElemNodeImpl(this.hirRoot, pElem);
    }

    public SubpNode subpNode(Subp pSubp) {
        return new SubpNodeImpl(this.hirRoot, pSubp);
    }

    public TypeNode typeNode(Type pType) {
        return new TypeNodeImpl(this.hirRoot, pType);
    }

    public LabelNode labelNode(Label pLabel) {
        return new LabelNodeImpl(this.hirRoot, pLabel);
    }

    public ConstNode constNode(Const pConst) {
        return new ConstNodeImpl(this.hirRoot, pConst);
    }

    public ConstNode intConstNode(int pIntValue) {
        return new ConstNodeImpl(this.hirRoot, this.hirRoot.symRoot.sym.intConst(pIntValue, this.hirRoot.symRoot.typeInt));
    }

    public ConstNode intConstNode(long pIntValue) {
        return new ConstNodeImpl(this.hirRoot, this.hirRoot.symRoot.sym.intConst(pIntValue, this.hirRoot.symRoot.typeInt));
    }

    public ConstNode offsetConstNode(long pIntValue) {
        ConstNode cn = this.intConstNode(pIntValue);
        cn.setType(this.hirRoot.symRoot.typeOffset);
        return cn;
    }

    public ConstNode trueNode() {
        return new ConstNodeImpl(this.hirRoot, this.hirRoot.symRoot.sym.boolConst(true));
    }

    public ConstNode falseNode() {
        return new ConstNodeImpl(this.hirRoot, this.hirRoot.symRoot.sym.boolConst(false));
    }

    public SymNode symNode(Sym pSym) {
        return new SymNodeImpl(this.hirRoot, pSym);
    }

    public NullNode nullNode() {
        return new NullNodeImpl(this.hirRoot);
    }

    public LabelDef labelDef(Label pLabel) {
        return new LabelDefImpl(this.hirRoot, pLabel);
    }

    public Exp exp(int pOperator, Exp pExp1) {
        return new ExpImpl(this.hirRoot, pOperator, pExp1);
    }

    public Exp exp(int pOperator, Exp pExp1, Exp pExp2) {
        if (pOperator == 33) {
            return this.functionExp(pExp1, (IrList)((Object)pExp2));
        }
        if (pOperator == 38 && pExp1.getType() instanceof VectorType) {
            Exp lExp1 = pExp1;
            while (lExp1.getType() instanceof VectorType) {
                lExp1 = this.decayExp(lExp1);
            }
            return new ExpImpl(this.hirRoot, pOperator, lExp1, pExp2);
        }
        return new ExpImpl(this.hirRoot, pOperator, pExp1, pExp2);
    }

    public Exp exp(int pOperator, Exp pExp1, Exp pExp2, Exp pExp3) {
        return new ExpImpl(this.hirRoot, pOperator, pExp1, pExp2, pExp3);
    }

    public Exp decayExp(Exp pExp) {
        Type lElemType;
        if (pExp == null) {
            return null;
        }
        ExpImpl lExp = new ExpImpl(this.hirRoot, 66, pExp);
        Type lType = pExp.getType();
        if (pExp instanceof ConstNode && ((ConstNode)pExp).getSymNodeSym() instanceof StringConst) {
            lElemType = this.hirRoot.ioRoot.machineParam.getStringElemType();
        } else if (lType instanceof VectorType) {
            lElemType = ((VectorType)lType).getElemType();
        } else {
            this.hirRoot.ioRoot.msgRecovered.put(1023, "Illegal decay operand " + pExp.toStringShort());
            lElemType = lType;
        }
        PointerType lPtrType = this.hirRoot.symRoot.sym.pointerType(lElemType);
        lExp.setType(lPtrType);
        return lExp;
    }

    public Exp undecayExp(Exp pPointerExp, ConstNode pElemCount) {
        Type lElemType;
        ExpImpl lUndecay = new ExpImpl(this.hirRoot, 67, pPointerExp, pElemCount);
        Type lPointerType = pPointerExp.getType();
        if (lPointerType instanceof PointerType) {
            lElemType = ((PointerType)lPointerType).getPointedType();
        } else {
            this.hirRoot.ioRoot.msgRecovered.put(1023, "Illegal undecay operand " + pPointerExp.toStringShort());
            lElemType = lPointerType;
        }
        VectorType lVectorType = this.hirRoot.symRoot.sym.vectorType(lElemType, pElemCount);
        lUndecay.setType(lVectorType);
        return lUndecay;
    }

    public Exp undecayExp(Exp pPointerExp, Exp pElemCount, Exp pLowerBound) {
        Type lElemType;
        ExpImpl lUndecay = new ExpImpl(this.hirRoot, 67, pPointerExp, pElemCount);
        Type lPointerType = pPointerExp.getType();
        if (lPointerType instanceof PointerType) {
            lElemType = ((PointerType)lPointerType).getPointedType();
        } else {
            this.hirRoot.ioRoot.msgRecovered.put(1023, "Illegal undecay operand " + pPointerExp.toStringShort());
            lElemType = lPointerType;
        }
        VectorType lVectorType = this.hirRoot.symRoot.sym.vectorType(null, lElemType, pElemCount, pLowerBound);
        lUndecay.setType(lVectorType);
        return lUndecay;
    }

    public Exp undecayExp(Exp pPointerExp, long pElemCount) {
        Type lElemType;
        ExpImpl lUndecay = new ExpImpl(this.hirRoot, 67, pPointerExp, this.intConstNode(pElemCount));
        Type lPointerType = pPointerExp.getType();
        if (lPointerType instanceof PointerType) {
            lElemType = ((PointerType)lPointerType).getPointedType();
        } else {
            this.hirRoot.ioRoot.msgRecovered.put(1023, "Illegal undecay operand " + pPointerExp.toStringShort());
            lElemType = lPointerType;
        }
        VectorType lVectorType = this.hirRoot.symRoot.sym.vectorType(lElemType, pElemCount);
        lUndecay.setType(lVectorType);
        return lUndecay;
    }

    public Exp undecayExp(Exp pPointerExp, long pElemCount, long pLowerBound) {
        Type lElemType;
        ExpImpl lUndecay = new ExpImpl(this.hirRoot, 67, pPointerExp, this.intConstNode(pElemCount));
        Type lPointerType = pPointerExp.getType();
        if (lPointerType instanceof PointerType) {
            lElemType = ((PointerType)lPointerType).getPointedType();
        } else {
            this.hirRoot.ioRoot.msgRecovered.put(1023, "Illegal undecay operand " + pPointerExp.toStringShort());
            lElemType = lPointerType;
        }
        VectorType lVectorType = this.hirRoot.symRoot.sym.vectorType(null, lElemType, pElemCount, pLowerBound);
        lUndecay.setType(lVectorType);
        return lUndecay;
    }

    public SubscriptedExp subscriptedExp(Exp pArrayExp, Exp pSubscript) {
        SubscriptedExpImpl lExp;
        VectorType lArrayType = (VectorType)pArrayExp.getType();
        Type lElemType = lArrayType.getElemType();
        if (lElemType.getSizeExp() != null) {
            lExp = new SubscriptedExpImpl(this.hirRoot, pArrayExp, pSubscript);
        } else {
            if (lElemType.getFlag(17)) {
                this.hirRoot.ioRoot.msgError.put("Element type is unfixed size for " + pArrayExp.toStringShort() + ". Use subscriptedExp(Exp pArrayExp, Exp pSubscrit, Exp pElemSize)");
            }
            lExp = new SubscriptedExpImpl(this.hirRoot, pArrayExp, pSubscript);
        }
        if (this.fDbgLevel > 0) {
            this.hirRoot.ioRoot.dbgHir.print(7, "subscriptedExp " + ((HIR)lExp.getChild1()).toStringShort() + " " + ((HIR)lExp.getChild2()).toStringShort());
        }
        return lExp;
    }

    public Exp subscriptedExp(Exp pArrayExp, Exp pSubscript, Exp pElemSize) {
        Exp lElemSize;
        VectorType lArrayType = (VectorType)pArrayExp.getType();
        Type lElemType = lArrayType.getElemType();
        if (pElemSize == null) {
            if (lElemType.getFlag(17)) {
                this.hirRoot.ioRoot.msgError.put("Element size is not given for unfixed size array " + pArrayExp.toStringShort() + "[" + pSubscript.toStringShort() + "]");
                return null;
            }
            return this.subscriptedExp(pArrayExp, pSubscript);
        }
        if (lElemType.getSizeExp() != null) {
            long lElemSizeByParam;
            long lElemSizeOfType = lElemType.getSizeExp().evaluateAsLong();
            if (lElemSizeOfType == (lElemSizeByParam = pElemSize.evaluateAsLong()) && lElemSizeOfType > 0L) {
                return this.subscriptedExp(pArrayExp, pSubscript);
            }
            if (lElemSizeOfType > 0L && lElemSizeByParam > 0L) {
                this.hirRoot.ioRoot.msgRecovered.put("Element size " + lElemSizeByParam + " does not match for " + pArrayExp.toStringShort());
            }
        }
        if ((lElemSize = pElemSize).getType() != this.hirRoot.symRoot.typeOffset) {
            lElemSize = this.hirRoot.hir.convExp(this.hirRoot.symRoot.typeOffset, lElemSize);
        }
        Exp lDisplacement = !lArrayType.getLowerBoundExp().isEvaluable() || lArrayType.getLowerBound() != 0L ? this.hirRoot.hir.exp(41, lElemSize, this.hirRoot.hir.exp(39, pSubscript, lArrayType.getLowerBoundExp())) : this.hirRoot.hir.exp(41, lElemSize, pSubscript);
        Exp lArrayAddress = pArrayExp.getOperator() == 68 && ((HIR)pArrayExp.getChild1()).getType() instanceof PointerType ? (Exp)pArrayExp.getChild1() : (pArrayExp.getType() instanceof PointerType ? pArrayExp : this.hirRoot.hir.addrExp(pArrayExp));
        Exp lElemAddress = this.hirRoot.hir.exp(38, lArrayAddress, lDisplacement);
        Exp lExp = this.hirRoot.hir.contentsExp(lElemAddress);
        if (lExp.getType() instanceof VectorType && ((VectorType)lExp.getType()).getElemType() instanceof VectorType) {
            lExp = this.hirRoot.hir.decayExp(lExp);
            lExp = this.hirRoot.hir.contentsExp(lExp);
        }
        return lExp;
    }

    public QualifiedExp qualifiedExp(Exp pStructUnionExp, ElemNode pElemNode) {
        return new QualifiedExpImpl(this.hirRoot, pStructUnionExp, pElemNode);
    }

    public PointedExp pointedExp(Exp pStructUnionExp, ElemNode pElemNode) {
        return new PointedExpImpl(this.hirRoot, pStructUnionExp, pElemNode);
    }

    public Exp contentsExp(Exp pPointerExp) {
        return new ExpImpl(this.hirRoot, 68, pPointerExp);
    }

    public Exp convExp(Type pType, Exp pExp) {
        if (pExp.getType() == pType) {
            return pExp;
        }
        ExpImpl lExp = new ExpImpl(this.hirRoot, 65, pExp);
        lExp.setType(pType);
        return lExp;
    }

    public Exp sizeofExp(Type pType) {
        if (pType.getSizeExp() != null) {
            return (Exp)pType.getSizeExp().copyWithOperands();
        }
        this.hirRoot.ioRoot.msgRecovered.put(1022, "Illegal sizeof-expression for type " + pType.getName());
        return this.intConstNode(machineParam.evaluateSize(4));
    }

    public Exp sizeofExp(Exp pExp) {
        if (pExp.getType() != null && pExp.getType().getSizeExp() != null) {
            return (Exp)pExp.getType().getSizeExp().copyWithOperands();
        }
        this.hirRoot.ioRoot.msgRecovered.put(1022, "Illegal sizeof-expression for node " + pExp.toString());
        return this.intConstNode(machineParam.evaluateSize(4));
    }

    public FunctionExp functionExp(Exp pFunctionSpec, IrList pActualParamList) {
        Subp lSubp = null;
        if (this.hirRoot.symRoot.subpCurrent != null) {
            if (pFunctionSpec instanceof SubpNode) {
                lSubp = (Subp)((SubpNode)pFunctionSpec).getSymNodeSym();
            } else if (pFunctionSpec.getChild1() instanceof SubpNode) {
                lSubp = (Subp)((SubpNode)pFunctionSpec.getChild1()).getSymNodeSym();
            }
            if (lSubp != null) {
                this.hirRoot.symRoot.subpCurrent.addToCallList(lSubp);
            }
        }
        return new FunctionExpImpl(this.hirRoot, pFunctionSpec, pActualParamList);
    }

    public Exp addrExp(Exp pExp) {
        return this.hirRoot.hir.exp(64, pExp);
    }

    public Exp conditionalExp1(Exp pExp) {
        int lOperator2;
        if (pExp == null) {
            return null;
        }
        int lOperator = pExp.getOperator();
        if (lOperator >= 51 && lOperator <= 56) {
            return pExp;
        }
        Exp lChild1 = (Exp)pExp.getChild1();
        if (lOperator == 62 && (lOperator2 = lChild1.getOperator()) >= 51 && lOperator2 <= 56) {
            return this.exp(inversionTable[lOperator2 - 51], (Exp)((Exp)lChild1.getChild1()).copyWithOperands(), (Exp)((Exp)lChild1.getChild2()).copyWithOperands());
        }
        return pExp;
    }

    public Exp conditionalExp(Exp pExp) {
        int lOperator2;
        if (pExp == null) {
            return null;
        }
        int lOperator = pExp.getOperator();
        if (lOperator >= 51 && lOperator <= 56) {
            return pExp;
        }
        Exp lChild1 = (Exp)pExp.getChild1();
        if (lOperator == 62 && (lOperator2 = lChild1.getOperator()) >= 51 && lOperator2 <= 56) {
            return this.exp(inversionTable[lOperator2 - 51], (Exp)((Exp)lChild1.getChild1()).copyWithOperands(), (Exp)((Exp)lChild1.getChild2()).copyWithOperands());
        }
        Exp lCondExp = (Exp)pExp.copyWithOperands();
        if (pExp.getType() != this.hirRoot.symRoot.typeInt) {
            lCondExp = this.hirRoot.hir.exp(65, lCondExp);
            lCondExp.setType(this.hirRoot.symRoot.typeInt);
        }
        Exp lCmpExp = this.hirRoot.hir.exp(52, lCondExp, this.hirRoot.hir.intConstNode(0));
        return lCmpExp;
    }

    public ExpStmt callStmt(Exp pSubpSpec, IrList pActualParamList) {
        return this.expStmt(this.functionExp(pSubpSpec, pActualParamList));
    }

    public AssignStmt assignStmt(Exp pLeft, Exp pRight) {
        return new AssignStmtImpl(this.hirRoot, pLeft, pRight);
    }

    public IfStmt ifStmt(Exp pCondition, Stmt pThenPart, Stmt pElsePart) {
        return new IfStmtImpl(this.hirRoot, pCondition, pThenPart, pElsePart);
    }

    public WhileStmt whileStmt(Exp pCondition, Stmt pLoopBody) {
        Label lLoopBackLabel = this.hirRoot.symRoot.symTableCurrentSubp.generateLabel();
        Label lLoopStepLabel = this.hirRoot.symRoot.symTableCurrentSubp.generateLabel();
        Label lLoopEndLabel = this.hirRoot.symRoot.symTableCurrentSubp.generateLabel();
        return new WhileStmtImpl(this.hirRoot, lLoopBackLabel, pCondition, pLoopBody, lLoopStepLabel, lLoopEndLabel);
    }

    public WhileStmt whileStmt(Label pLoopBackLabel, Exp pCondition, Stmt pLoopBody, Label pLoopStepLabel, Label pLoopEndLabel) {
        return new WhileStmtImpl(this.hirRoot, pLoopBackLabel, pCondition, pLoopBody, pLoopStepLabel, pLoopEndLabel);
    }

    public ForStmt forStmt(Stmt pInitStmt, Exp pCondition, Stmt pLoopBody, Stmt pStepPart) {
        Label lLoopBackLabel = this.hirRoot.symRoot.symTableCurrentSubp.generateLabel();
        Label lLoopStepLabel = this.hirRoot.symRoot.symTableCurrentSubp.generateLabel();
        Label lLoopEndLabel = this.hirRoot.symRoot.symTableCurrentSubp.generateLabel();
        return new ForStmtImpl(this.hirRoot, pInitStmt, lLoopBackLabel, pCondition, pLoopBody, lLoopStepLabel, pStepPart, lLoopEndLabel);
    }

    public ForStmt forStmt(Stmt pInitStmt, Label pLoopBackLabel, Exp pCondition, Stmt pLoopBody, Label pLoopStepLabel, Stmt pStepPart, Label pLoopEndLabel) {
        return new ForStmtImpl(this.hirRoot, pInitStmt, pLoopBackLabel, pCondition, pLoopBody, pLoopStepLabel, pStepPart, pLoopEndLabel);
    }

    public RepeatStmt repeatStmt(Stmt pLoopBody, Exp pCondition) {
        Label lLoopBackLabel = this.hirRoot.symRoot.symTableCurrentSubp.generateLabel();
        Label lLoopStepLabel = this.hirRoot.symRoot.symTableCurrentSubp.generateLabel();
        Label lLoopEndLabel = this.hirRoot.symRoot.symTableCurrentSubp.generateLabel();
        return new RepeatStmtImpl(this.hirRoot, lLoopBackLabel, pLoopBody, lLoopStepLabel, pCondition, lLoopEndLabel);
    }

    public RepeatStmt repeatStmt(Label pLoopBackLabel, Stmt pLoopBody, Label pLoopStepLabel, Exp pCondition, Label pLoopEndLabel) {
        return new RepeatStmtImpl(this.hirRoot, pLoopBackLabel, pLoopBody, pLoopStepLabel, pCondition, pLoopEndLabel);
    }

    public IndexedLoopStmt indexedLoopStmt(Var pLoopIndex, Exp pStartValue, Exp pEndValue, Exp pStepValue, Stmt pStmtBody) {
        return new IndexedLoopStmtImpl(this.hirRoot, pLoopIndex, pStartValue, pEndValue, pStepValue, true, pStmtBody);
    }

    public IndexedLoopStmt indexedLoopStmt(Var pLoopIndex, Exp pStartValue, Exp pEndValue, Exp pStepValue, boolean pUpward, Stmt pStmtBody) {
        return new IndexedLoopStmtImpl(this.hirRoot, pLoopIndex, pStartValue, pEndValue, pStepValue, pUpward, pStmtBody);
    }

    public LabeledStmt labeledStmt(Label pLabel, Stmt pStmt) {
        return new LabeledStmtImpl(this.hirRoot, pLabel, pStmt);
    }

    public BlockStmt blockStmt(Stmt pStmtSequence) {
        return new BlockStmtImpl(this.hirRoot, pStmtSequence);
    }

    public ReturnStmt returnStmt(Exp pReturnValue) {
        return new ReturnStmtImpl(this.hirRoot, pReturnValue);
    }

    public ReturnStmt returnStmt() {
        return new ReturnStmtImpl(this.hirRoot);
    }

    public JumpStmt jumpStmt(Label pLabelSym) {
        return new JumpStmtImpl(this.hirRoot, pLabelSym);
    }

    public SwitchStmt switchStmt(Exp pSelectExp, IrList pJumpList, Label pDefaultLabel, Stmt pSwitchBody, Label pEndLabel) {
        return new SwitchStmtImpl(this.hirRoot, pSelectExp, pJumpList, pDefaultLabel, pSwitchBody, pEndLabel);
    }

    public ExpStmt expStmt(Exp pExp) {
        return new ExpStmtImpl(this.hirRoot, pExp);
    }

    public Stmt nullStmt() {
        return this.expStmt(this.nullNode());
    }

    public PhiExp phiExp(Var pVar, Label pLabel) {
        return new PhiExpImpl(this.hirRoot, pVar, pLabel);
    }

    public HirSeq hirSeq(HIR pChild1) {
        return new HirSeqImpl(this.hirRoot, pChild1);
    }

    public HirSeq hirSeq(HIR pChild1, HIR pChild2) {
        return new HirSeqImpl(this.hirRoot, pChild1, pChild2);
    }

    public HirSeq hirSeq(HIR pChild1, HIR pChild2, HIR pChild3) {
        return new HirSeqImpl(this.hirRoot, pChild1, pChild2, pChild3);
    }

    public SetDataStmt setDataStmt(Exp pVariable, Exp pValueExp) {
        if (pVariable instanceof VarNode && pValueExp != null) {
            Var lVar = (Var)((VarNode)pVariable).getSymNodeSym();
            lVar.setInitialValue(pValueExp);
        }
        return new SetDataStmtImpl(this.hirRoot, pVariable, pValueExp);
    }

    public Exp expList(List pList) {
        return new ExpListExpImpl(this.hirRoot, pList);
    }

    public Exp expRepeat(Exp pValue, Exp pCount) {
        return this.exp(97, pValue, pCount);
    }

    public AsmStmt asmStmt(String pInstructions, HirList pActualParamList) {
        ConstNode lInstructions = this.constNode(this.hirRoot.symRoot.sym.stringConstFromQuotedString(pInstructions));
        return new AsmStmtImpl(this.hirRoot, lInstructions, pActualParamList);
    }

    public void setChildren(IR p1, IR p2) {
        this.fChildNode1 = p1;
        if (p1 != null) {
            ((HIR_Impl)p1).setParent(this);
        }
        this.fChildNode2 = p2;
        if (p2 != null) {
            ((HIR_Impl)p2).setParent(this);
        }
    }

    public void setChildren(IR p1, IR p2, IR p3) {
        this.fChildNode1 = p1;
        if (p1 != null) {
            ((HIR_Impl)p1).setParent(this);
        }
        this.fChildNode2 = p2;
        if (p2 != null) {
            ((HIR_Impl)p2).setParent(this);
        }
        this.setChild(3, p3);
    }

    public void setChildren(IR p1, IR p2, IR p3, IR p4) {
        this.setChild1(p1);
        this.setChild2(p2);
        this.setChild(3, p3);
        this.setChild(4, p4);
    }

    public void setChildren(IR p1, IR p2, IR p3, IR p4, IR p5) {
        this.setChild1(p1);
        this.setChild2(p2);
        this.setChild(3, p3);
        this.setChild(4, p4);
        this.setChild(5, p5);
    }

    public Type getType() {
        return this.fType;
    }

    public void setType(Type pType) {
        this.fType = pType;
    }

    public Stmt getNextStmt() {
        return null;
    }

    public HIR getNextNode() {
        HIR lNextNode = null;
        if (this.getChildCount() == 0) {
            if (this instanceof HirList) {
                HirList lHirList = (HirList)((Object)this);
                for (int lElemIndex = 0; lElemIndex < lHirList.size() && (lNextNode = (HIR)lHirList.get(lElemIndex)) == null; ++lElemIndex) {
                    if (this.fDbgLevel <= 3) continue;
                    this.hirRoot.ioRoot.dbgHir.print(5, " null elem " + lElemIndex);
                }
            }
        } else if (this instanceof BlockStmt) {
            BlockStmt lBlockStmt = (BlockStmt)((Object)this);
            lNextNode = ((BlockStmt)((Object)this)).getFirstStmt();
        } else {
            for (int lChildNumber = 1; lChildNumber <= this.getChildCount() && (lNextNode = (HIR)this.getChild(lChildNumber)) == null; ++lChildNumber) {
                if (this.fDbgLevel <= 3) continue;
                this.hirRoot.ioRoot.dbgHir.print(5, " null child " + lChildNumber);
            }
        }
        if (lNextNode == null) {
            lNextNode = this.getNextNodeSeeingAncestor(this);
        }
        return lNextNode;
    }

    protected HIR getNextNodeSeeingAncestor(HIR pHir) {
        if (this.fDbgLevel > 3) {
            this.hirRoot.ioRoot.dbgHir.print(5, " getNextNodeSeeingAncestor " + pHir.toStringShort());
        }
        HIR lNextNode = null;
        if (pHir instanceof Stmt) {
            lNextNode = ((Stmt)pHir).getNextStmt();
        }
        if (lNextNode != null) {
            return lNextNode;
        }
        HIR lParent = (HIR)pHir.getParent();
        if (lParent == null) {
            if (this.fDbgLevel > 3) {
                this.hirRoot.ioRoot.dbgHir.print(5, " null parent " + pHir.toStringShort());
            }
            return null;
        }
        if (lParent instanceof BlockStmt) {
            lNextNode = this.getNextNodeSeeingAncestor(lParent);
            return lNextNode;
        }
        int lChildNumber = pHir.getChildNumber();
        if (lChildNumber < lParent.getChildCount()) {
            ++lChildNumber;
            while (lChildNumber <= lParent.getChildCount()) {
                lNextNode = (HIR)lParent.getChild(lChildNumber);
                if (lNextNode != null) {
                    return lNextNode;
                }
                if (this.fDbgLevel > 3) {
                    this.hirRoot.ioRoot.dbgHir.print(5, " null child " + lChildNumber);
                }
                ++lChildNumber;
            }
        }
        if (lParent instanceof HirList) {
            int lElemNumber = ((HirList)lParent).indexOf(pHir);
            if (lElemNumber < 0) {
                return null;
            }
            while (lElemNumber + 1 < ((HirList)lParent).size()) {
                if ((lNextNode = (HIR)((HirList)lParent).get(++lElemNumber)) == null) continue;
                return lNextNode;
            }
        }
        if (lNextNode == null) {
            lNextNode = this.getNextNodeSeeingAncestor(lParent);
        }
        return lNextNode;
    }

    public boolean getFlag(int pFlagNumber) {
        if (this.fHirAnnex == null) {
            return false;
        }
        return this.fHirAnnex.getFlag(pFlagNumber);
    }

    public void setFlag(int pFlagNumber, boolean pYesNo) {
        if (this.fHirAnnex == null) {
            this.fHirAnnex = new HirAnnex(this.hirRoot);
        }
        this.fHirAnnex.setFlag(pFlagNumber, pYesNo);
    }

    public boolean flagsAreAllFalse() {
        if (this.fHirAnnex == null) {
            return true;
        }
        return this.fHirAnnex.flagsAreAllFalse();
    }

    public FlagBox getFlagBox() {
        if (this.fHirAnnex == null) {
            return null;
        }
        return this.fHirAnnex.getFlagBox();
    }

    public Object clone() throws CloneNotSupportedException {
        HIR_Impl lTree = (HIR_Impl)super.clone();
        if (this.fDbgLevel > 4) {
            this.hirRoot.ioRoot.dbgHir.print(6, "clone of " + lTree.toStringShort());
        }
        lTree.fOperator = this.fOperator;
        lTree.fChildCount = this.fChildCount;
        if (this.fChildCount > 0) {
            if (this.fChildNode1 != null) {
                lTree.setChild1(((HIR)this.fChildNode1).copyWithOperands());
                if (this.fDbgLevel > 4) {
                    this.hirRoot.ioRoot.dbgHir.print(6, " child1 " + ((HIR)lTree.getChild1()).toStringShort());
                }
            } else if (this.fDbgLevel > 4) {
                this.hirRoot.ioRoot.dbgHir.print(6, " child1  null");
            }
        }
        if (this.fChildCount >= 2) {
            if (this.fChildNode2 != null) {
                lTree.setChild2(((HIR)this.fChildNode2).copyWithOperands());
                if (this.fDbgLevel > 4) {
                    this.hirRoot.ioRoot.dbgHir.print(6, " child2 " + ((HIR)lTree.getChild2()).toStringShort());
                }
            } else if (this.fDbgLevel > 4) {
                this.hirRoot.ioRoot.dbgHir.print(6, " child2  null");
            }
        }
        if (this.fChildCount >= 3) {
            lTree.fAdditionalChild = new IR[this.fChildCount - 2];
            for (int lChild = 3; lChild <= this.fChildCount; ++lChild) {
                if (this.fAdditionalChild[lChild - 3] != null) {
                    if (this.fAdditionalChild[lChild - 3] instanceof HIR) {
                        lTree.setChild(lChild, ((HIR)this.fAdditionalChild[lChild - 3]).copyWithOperands());
                        if (this.fDbgLevel <= 4) continue;
                        this.hirRoot.ioRoot.dbgHir.print(6, " child" + lChild + " " + ((HIR)lTree.getChild(lChild)).toStringShort());
                        continue;
                    }
                    if (this.fDbgLevel <= 4) continue;
                    this.hirRoot.ioRoot.dbgHir.print(6, " child" + lChild + "  null");
                    continue;
                }
                lTree.fAdditionalChild[lChild - 3] = null;
            }
        }
        if (this.fHirAnnex != null) {
            lTree.fHirAnnex = (HirAnnex)this.fHirAnnex.clone();
            lTree.setWork(this.getWork());
        }
        lTree.fType = this.fType;
        return lTree;
    }

    public IR getClone() throws CloneNotSupportedException {
        return (HIR)this.clone();
    }

    public HIR hirClone() throws CloneNotSupportedException {
        return (HIR)this.clone();
    }

    public HIR copyWithOperands() {
        if (this.fDbgLevel > 0) {
            this.hirRoot.ioRoot.dbgHir.print(5, " copyWithOperands", this.toStringShort());
        }
        try {
            HIR lHir = (HIR)this.clone();
            ((HIR_Impl)lHir).setParent(null);
            return lHir;
        }
        catch (CloneNotSupportedException e) {
            this.hirRoot.ioRoot.msgRecovered.put(1100, "CloneNotSupportedException(HIR_Impl) " + this.toString());
            return null;
        }
    }

    public HIR copyWithOperandsChangingLabels(IrList pLabelCorrespondence) {
        if (this.fDbgLevel > 0) {
            this.hirRoot.ioRoot.dbgHir.print(5, " copyWithOperandsChangingLabels", this.toStringShort());
        }
        HIR lTree = this.copyWithOperands();
        IrList lLabelCorrespondence = pLabelCorrespondence == null ? this.hirRoot.hirModify.makeLabelCorrespondenceList(lTree) : pLabelCorrespondence;
        this.hirRoot.hirModify.changeLabelsInTree(lTree, lLabelCorrespondence);
        return lTree;
    }

    protected boolean isTree(Set pVisitedNodes, int pErrorCounter, Set pSetOfLabels) {
        boolean lInOrder;
        block15: {
            Set lSetOfLabels;
            Set lVisitedNodes;
            int lErrorLimit;
            int lErrorCounter;
            block13: {
                block14: {
                    lErrorCounter = pErrorCounter;
                    lErrorLimit = 100;
                    if (pErrorCounter > lErrorLimit) {
                        this.hirRoot.ioRoot.msgNote.put("Too many errors found in isTree()");
                        return false;
                    }
                    lInOrder = true;
                    lVisitedNodes = pVisitedNodes;
                    lSetOfLabels = pSetOfLabels;
                    if (lVisitedNodes.contains(this)) {
                        this.hirRoot.ioRoot.msgNote.put("HIR " + this.toStringDetail() + " violates tree structure. Duplicated node.");
                        lInOrder = false;
                        ++lErrorCounter;
                    } else {
                        lVisitedNodes.add(this);
                    }
                    if (this.getChildCount() != 0) break block13;
                    if (!(this instanceof HirList)) break block14;
                    ListIterator lIterator = ((HirList)((Object)this)).iterator();
                    while (lIterator.hasNext() && lErrorCounter <= lErrorLimit) {
                        HIR lNode1;
                        Object lObject = lIterator.next();
                        if (!(lObject instanceof HIR) || (lNode1 = (HIR)lObject) == null) continue;
                        if (lNode1.getParent() != this) {
                            this.hirRoot.ioRoot.msgNote.put("HIR " + this.toStringDetail() + " violates tree structure. Bad parent link for " + lNode1.toStringDetail());
                            lInOrder = false;
                            ++lErrorCounter;
                        }
                        if (((HIR_Impl)lNode1).isTree(lVisitedNodes, lErrorCounter, lSetOfLabels)) continue;
                        lInOrder = false;
                    }
                    break block15;
                }
                if (!(this instanceof LabelDef)) break block15;
                Label lDefinedLabel = ((LabelDef)((Object)this)).getLabel();
                if (lSetOfLabels.contains(lDefinedLabel)) {
                    this.hirRoot.ioRoot.msgNote.put("HIR " + this.toStringDetail() + " has duplicated label " + lDefinedLabel.getName());
                    lInOrder = false;
                } else {
                    lSetOfLabels.add(lDefinedLabel);
                }
                break block15;
            }
            if (this instanceof BlockStmt) {
                for (Stmt lStmt = ((BlockStmt)((Object)this)).getFirstStmt(); lStmt != null && lErrorCounter <= lErrorLimit; lStmt = lStmt.getNextStmt()) {
                    if (lStmt.getParent() != this) {
                        this.hirRoot.ioRoot.msgNote.put("HIR " + this.toStringDetail() + " violates tree structure. Bad parent link for " + lStmt.toStringDetail());
                        lInOrder = false;
                        ++lErrorCounter;
                    }
                    if (((HIR_Impl)((Object)lStmt)).isTree(lVisitedNodes, lErrorCounter, lSetOfLabels)) continue;
                    lInOrder = false;
                }
            } else {
                for (int i = 1; i <= this.fChildCount; ++i) {
                    HIR lNode = (HIR)this.getChild(i);
                    if (lNode == null) continue;
                    HIR lParent = (HIR)lNode.getParent();
                    if (lParent != this || lNode.getChildNumber() != i) {
                        lInOrder = false;
                        this.hirRoot.ioRoot.msgNote.put("HIR " + this.toStringDetail() + " violates tree structure. Bad parent link for " + lNode.toStringDetail());
                        ++lErrorCounter;
                    }
                    if (((HIR_Impl)lNode).isTree(lVisitedNodes, lErrorCounter, lSetOfLabels)) continue;
                    lInOrder = false;
                }
            }
        }
        return lInOrder;
    }

    public boolean isTree() {
        if (this.fDbgLevel > 0) {
            this.hirRoot.ioRoot.dbgHir.print(4, "\nisTree check for " + this.toString());
        }
        if (this.getIndex() == 0) {
            this.setIndexNumberToAllNodes(1);
        }
        HashSet lVisitedNodes = new HashSet();
        HashSet lSetOfLabels = new HashSet();
        return this.isTree(lVisitedNodes, 0, lSetOfLabels);
    }

    public boolean isSameAs(HIR pTree) {
        Sym lSym1;
        if (this == pTree) {
            return true;
        }
        if (pTree == null) {
            return false;
        }
        if (this.fDbgLevel > 0) {
            this.hirRoot.ioRoot.dbgHir.print(7, " isSameAs " + this.getIrName() + " " + pTree.getIrName());
        }
        if ((lSym1 = pTree.getSym()) != null) {
            return lSym1 == this.getSym();
        }
        int lChildCount = pTree.getChildCount();
        if (this.getOperator() != pTree.getOperator() || this.getChildCount() != lChildCount || this.getType() != pTree.getType()) {
            return false;
        }
        for (int lChild = 1; lChild <= lChildCount; ++lChild) {
            if (((HIR)this.getChild(lChild)).isSameAs((HIR)pTree.getChild(lChild))) continue;
            return false;
        }
        return true;
    }

    public void checkLinkage(String pHeader) {
        int lChildNum;
        HIR lParent;
        if (!(this.fDbgLevel < 1 || (lParent = (HIR)this.getParent()) == null || lParent instanceof BlockStmt || lParent instanceof HirList || lParent instanceof IrList || lParent.getChild(lChildNum = this.getChildNumber()) == this)) {
            this.hirRoot.ioRoot.msgWarning.put(" Bad parent-link in " + pHeader + " for " + this.toStringShort() + " parent " + lParent.toStringShort() + ":" + lChildNum);
            this.hirRoot.ioRoot.dbgHir.print(4, lParent.toStringWithChildren());
        }
    }

    public Iterator subpIterator() {
        IrList lSubpList = ((Program)this.hirRoot.programRoot).getSubpDefinitionList();
        if (lSubpList != null) {
            return lSubpList.iterator();
        }
        return this.hirRoot.emptyIterator();
    }

    public HirIterator hirIterator(IR pSubtree) {
        return new HirIteratorImpl(this.hirRoot, pSubtree, false);
    }

    public void accept(HirVisitor pVisitor) {
        if (this.fDbgLevel > 0) {
            this.hirRoot.ioRoot.dbgHir.print(3, "accept ", this.toStringShort());
        }
    }

    static {
        inversionTable = new int[]{52, 51, 56, 55, 54, 53};
    }
}

