/*
 * Decompiled with CFR 0.152.
 */
package coins.ir.hir;

import coins.HirRoot;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirVisitor;
import coins.ir.hir.IfStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LabeledStmtImpl;
import coins.ir.hir.Stmt;
import coins.ir.hir.StmtImpl;
import coins.sym.Label;

public class IfStmtImpl
extends StmtImpl
implements IfStmt {
    public IfStmtImpl(HirRoot pHirRoot, Exp pCondition, Stmt pThenPart, Stmt pElsePart) {
        super(pHirRoot);
        Label lElseLabel;
        Label lThenLabel;
        LabeledStmt lThenPart = null;
        LabeledStmt lElsePart = null;
        if (pThenPart != null) {
            lThenPart = pThenPart.getLabeledStmt();
        }
        if (lThenPart == null) {
            lThenLabel = this.hirRoot.symRoot.symTableCurrent.generateLabel();
            lThenPart = new LabeledStmtImpl(this.hirRoot, lThenLabel, pThenPart);
        } else {
            lThenLabel = lThenPart.getLabel();
            if (lThenLabel.getLabelKind() != 0) {
                lThenLabel = this.hirRoot.symRoot.symTableCurrent.generateLabel();
                lThenPart.attachLabelAsFirstOne(lThenLabel);
            }
        }
        lThenLabel.setLabelKind(2);
        lThenLabel.setOriginHir(this);
        if (pElsePart != null) {
            lElsePart = pElsePart.getLabeledStmt();
        }
        if (lElsePart == null) {
            lElseLabel = this.hirRoot.symRoot.symTableCurrent.generateLabel();
            lElsePart = new LabeledStmtImpl(this.hirRoot, lElseLabel, pElsePart);
        } else {
            lElseLabel = lElsePart.getLabel();
            if (lElseLabel.getLabelKind() != 0) {
                lElseLabel = this.hirRoot.symRoot.symTableCurrent.generateLabel();
                lElsePart.attachLabelAsFirstOne(lElseLabel);
            }
        }
        lElseLabel.setLabelKind(3);
        lElseLabel.setOriginHir(this);
        Label lEndIfLabel = this.hirRoot.symRoot.symTableCurrent.generateLabel();
        LabeledStmtImpl lEndIfPart = new LabeledStmtImpl(this.hirRoot, lEndIfLabel, null);
        lEndIfLabel.setLabelKind(20);
        lEndIfLabel.setOriginHir(this);
        this.fOperator = 23;
        this.fAdditionalChild = new HIR[2];
        this.fChildCount = 4;
        this.setChildren(pCondition, lThenPart, lElsePart, lEndIfPart);
        this.fMultiBlock = true;
        this.fType = this.hirRoot.symRoot.typeVoid;
    }

    public Exp getIfCondition() {
        return (Exp)this.fChildNode1;
    }

    public void setIfCondition(Exp pCondition) {
        this.setChild1(pCondition);
    }

    public LabeledStmt getThenPart() {
        return (LabeledStmt)this.fChildNode2;
    }

    public LabeledStmt getElsePart() {
        return (LabeledStmt)this.fAdditionalChild[0];
    }

    public Label getEndLabel() {
        return ((LabeledStmt)this.fAdditionalChild[1]).getLabel();
    }

    public void addToThenPart(Stmt pStmt, boolean pBeforeBranch) {
        Stmt lStmtBody = null;
        Stmt lNewBody = null;
        if (pStmt == null) {
            return;
        }
        LabeledStmt lThenPart = this.getThenPart();
        lStmtBody = lThenPart.getStmt();
        if (lStmtBody != null) {
            lNewBody = lStmtBody.combineStmt(pStmt, pBeforeBranch);
        }
        if (lNewBody != lStmtBody) {
            lThenPart.replaceSource2(lNewBody);
        }
    }

    public void addToElsePart(Stmt pStmt, boolean pBeforeBranch) {
        Stmt lStmtBody = null;
        Stmt lNewBody = null;
        if (pStmt == null) {
            return;
        }
        LabeledStmt lElsePart = this.getElsePart();
        lStmtBody = lElsePart.getStmt();
        if (lStmtBody != null) {
            lNewBody = lStmtBody.combineStmt(pStmt, pBeforeBranch);
        }
        if (lNewBody != lStmtBody) {
            lElsePart.replaceSource2(lNewBody);
        }
    }

    public void replaceThenPart(LabeledStmt pNewThenPart) {
        if (this.getThenPart() != null) {
            this.getThenPart().getLabel().setLabelKind(0);
        }
        Label lLabel = pNewThenPart.getLabel();
        this.replaceSource2(pNewThenPart);
        lLabel.setLabelKind(2);
        lLabel.setOriginHir(this);
    }

    public void replaceElsePart(LabeledStmt pNewElsePart) {
        if (this.getElsePart() != null) {
            this.getElsePart().getLabel().setLabelKind(0);
        }
        Label lLabel = pNewElsePart.getLabel();
        this.replaceSource(3, pNewElsePart);
        lLabel.setLabelKind(3);
        lLabel.setOriginHir(this);
    }

    public void combineWithConditionalExp(Stmt pStmt, HIR pCond) {
        this.hirRoot.ioRoot.dbgHir.print(4, "combineWithConditionalExp ", this.toStringShort() + " Stmt " + pStmt.toStringWithChildren() + " Cond " + pCond.toStringWithChildren());
        this.insertPreviousStmt(pStmt);
    }

    public void accept(HirVisitor pVisitor) {
        pVisitor.atIfStmt(this);
    }
}

