/*
 * Decompiled with CFR 0.152.
 */
package coins.lparallel;

import coins.ir.hir.AssignStmt;
import coins.ir.hir.VarNode;
import coins.lparallel.IndExp;
import coins.lparallel.LoopUtil;
import java.util.LinkedList;
import java.util.ListIterator;

public class BasicInduction {
    AssignStmt stmt;
    VarNode DefVarNode;
    VarNode UseVarNode;
    long inc;
    boolean InitConstFlag;
    VarNode InitConstNode;
    long InitConstValue;
    boolean LastConstFlag;
    long LastConstValue;
    boolean loop_ctr;
    LinkedList indExpList;
    LinkedList InitDefList;

    BasicInduction(AssignStmt pstmt, VarNode pDefVarNode, VarNode pUseVarNode, long pinc) {
        this.stmt = pstmt;
        this.DefVarNode = pDefVarNode;
        this.UseVarNode = pUseVarNode;
        this.InitConstFlag = false;
        this.LastConstFlag = false;
        this.inc = pinc;
        this.indExpList = new LinkedList();
        this.InitDefList = new LinkedList();
    }

    void DebugInduction(LoopUtil pUtil) {
        pUtil.Trace("-----DebugInduction------", 5);
        pUtil.Trace("DefVerNode=" + this.DefVarNode.toString(), 5);
        if (this.InitConstNode != null) {
            pUtil.Trace("InitVerNode=" + this.InitConstNode.toString(), 5);
        }
        pUtil.Trace("inc=" + this.inc, 5);
        pUtil.Trace("loop_ctr=" + this.loop_ctr, 5);
        pUtil.Trace("InitConstFlag=" + this.InitConstFlag, 5);
        pUtil.Trace("LastConstFlag=" + this.LastConstFlag, 5);
        pUtil.Trace("InitConstValue=" + this.InitConstValue, 5);
        pUtil.Trace("LastConstValue=" + this.LastConstValue, 5);
        pUtil.Trace("indExpSize=" + this.indExpList.size(), 5);
        for (IndExp Ind : this.indExpList) {
            Ind.DebugIndExp(pUtil);
        }
        pUtil.Trace("------------------", 5);
    }

    public void SetInductionLastData(long LastValue, LoopUtil pUtil) {
        pUtil.Trace("SetInduction LastData Var" + this.DefVarNode.toString(), 5);
        if (!this.InitConstFlag && Math.abs(this.inc) != 1L) {
            return;
        }
        if (this.InitConstFlag) {
            this.LastConstFlag = true;
            this.LastConstValue = LastValue * this.inc + this.InitConstValue;
        } else {
            this.LastConstFlag = true;
            this.LastConstValue = LastValue;
        }
        pUtil.Trace("Inductin LastData Value=" + this.LastConstValue, 5);
        ListIterator Ie = this.indExpList.listIterator();
        while (Ie.hasNext()) {
            IndExp indExpTable = (IndExp)Ie.next();
            pUtil.Trace("Inductin LastData (2)ind =" + indExpTable.ind_inc, 5);
            if (indExpTable.InitConst) {
                indExpTable.ind_last = LastValue * indExpTable.ind_inc + indExpTable.ind_init;
                indExpTable.valueConst = true;
                indExpTable.LastConst = true;
            } else {
                indExpTable.ind_last = LastValue * indExpTable.ind_inc + indExpTable.ind_init;
                indExpTable.LastConst = true;
                indExpTable.ind_init = 0L;
            }
            pUtil.Trace("Inductin LastData *LastValue =" + LastValue, 5);
            pUtil.Trace("Inductin LastData *ind_inc =" + indExpTable.ind_inc, 5);
            pUtil.Trace("Inductin LastData *ind_init =" + indExpTable.ind_init, 5);
            pUtil.Trace("Inductin LastData *ind_last =" + indExpTable.ind_last, 5);
        }
    }

    public VarNode getVarNode() {
        return this.DefVarNode;
    }
}

