/*
 * Decompiled with CFR 0.152.
 */
package coins.lparallel;

import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.PassException;
import coins.SymRoot;
import coins.driver.CoinsOptions;
import coins.driver.CompileSpecification;
import coins.driver.Suffix;
import coins.driver.Trace;
import coins.ffront.F77Scanner;
import coins.ffront.Parser;
import coins.ir.hir.HIR;
import coins.lparallel.LoopPara;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class F77LoopPara
extends LoopPara {
    private static final String HIR_OPT_OPTION = "hirOpt";
    private static final char OPT_OPTION_DELIMITER = '/';
    protected static final String LIBF2C_LOCATION = "libf2cLocation";
    protected static final String DEFAULT_OPENMP_NAME = "omcc";

    public void compile(File sourceFile, Suffix suffix, InputStream in, OutputStream out, IoRoot io) throws IOException, PassException {
        CoinsOptions coinsOptions = io.getCompileSpecification().getCoinsOptions();
        boolean hirAnal = coinsOptions.isSet("hirAnal");
        boolean hirOpt = coinsOptions.isSet(HIR_OPT_OPTION);
        this.fstophir2c = coinsOptions.isSet("hir2c");
        Trace trace = io.getCompileSpecification().getTrace();
        SymRoot symRoot = new SymRoot(io);
        HirRoot hirRoot = new HirRoot(symRoot);
        symRoot.attachHirRoot(hirRoot);
        symRoot.initiate();
        this.makeHirFromSource(sourceFile, hirRoot, suffix, in, io);
        if (hirOpt) {
            FlowRoot hirFlowRoot = new FlowRoot(hirRoot);
            this.optimizeHir(hirRoot, hirFlowRoot, symRoot, io);
        }
        this.LoopParallel(hirRoot, symRoot, io);
        trace.trace(this.myName, 5000, "compile(pass 4 -- HIR to C Source) ");
        if (this.makeCSourceFromHirBase("loop", hirRoot, symRoot, io)) {
            trace.trace(this.myName, 5000, "compile(pass 5 -- OpenMP Compile)");
            if (this.fstophir2c) {
                trace.trace(this.myName, 5000, "compile(PASSExcept)");
                throw new PassException("HIR to C", "Stop HIR TO C");
            }
            this.OpenMPCompile("loop", hirRoot, symRoot, out, io);
            trace.trace(this.myName, 5000, "compile(END)");
        }
    }

    protected void setDefaultLinkerOptions(CompileSpecification spec, List options) {
        super.setDefaultLinkerOptions(spec, options);
        String s = this.defaultSettings.getProperty(LIBF2C_LOCATION);
        if (s != null && !s.equals("")) {
            options.add("-L" + s);
        }
        options.add("-lf2c");
        options.add("-lm");
    }

    protected HIR makeHirFromFortranSource(File sourceFile, HirRoot hirRoot, InputStream in, IoRoot io) throws IOException, PassException {
        F77Scanner scanner = null;
        SymRoot symRoot = hirRoot.symRoot;
        try {
            scanner = new F77Scanner(in, io);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            io.msgError.put("syntax erorr: " + e.getMessage());
            throw new PassException(sourceFile, "FORTRAN preprocessor", "syntax error: " + e.getMessage());
        }
        Parser yyparser = new Parser(symRoot, hirRoot, io, scanner);
        try {
            yyparser.yyparse(scanner);
        }
        catch (Parser.yyException ye) {
            io.msgError.put("syntax error: " + ye.getMessage());
            throw new PassException(sourceFile, "FORTRAN parser", "syntax error: " + ye.getMessage());
        }
        if (io.getCompileSpecification().getCoinsOptions().isSet("printhir")) {
            hirRoot.programRoot.print(0);
            io.printOut.print("\n");
            symRoot.symTable.printSymTableAllDetail(symRoot.symTableRoot);
            symRoot.symTableConst.printSymTableDetail();
            io.printOut.print("\n");
        }
        return (HIR)hirRoot.programRoot;
    }

    protected void makeHirFromSource(File sourceFile, HirRoot hirRoot, Suffix suffix, InputStream in, IoRoot io) throws IOException, PassException {
        hirRoot.programRoot = this.makeHirFromFortranSource(sourceFile, hirRoot, in, io);
    }

    public static void main(String[] args) {
        new F77LoopPara().go(args);
    }
}

