/*
 * Decompiled with CFR 0.152.
 */
package coins.lparallel;

import coins.aflow.BBlock;
import coins.aflow.BBlockVector;
import coins.aflow.Flow;
import coins.aflow.FlowResults;
import coins.aflow.FlowUtil;
import coins.aflow.SetRefRepr;
import coins.aflow.SetRefReprList;
import coins.aflow.SubpFlow;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.VarNode;
import coins.lparallel.BasicInduction;
import coins.lparallel.LoopTable;
import coins.lparallel.Reduction;
import coins.lparallel.TmpVarManager;
import coins.sym.FlowAnalSym;
import coins.sym.Sym;
import coins.sym.Var;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class LoopUtil {
    public final FlowResults fResults;
    public final SubpFlow fSubpFlow;
    private Flow fFlow;
    private LinkedList DefVarList;
    private TmpVarManager fTmpVarManager;
    public boolean TraceFlag;
    public String TraceString;

    public LoopUtil(FlowResults pResults, SubpFlow pSubpFlow) {
        this.fResults = pResults;
        this.fSubpFlow = pSubpFlow;
        this.fFlow = pResults.flowRoot.aflow;
        this.DefVarList = new LinkedList();
        this.fTmpVarManager = new TmpVarManager(pSubpFlow, this);
        this.TraceFlag = true;
        this.TraceString = "";
    }

    boolean dom_check(BBlock pBBlock, BBlock pExitBlock) {
        List dom = pExitBlock.getDomForSubpFlow();
        return dom.contains(pBBlock);
    }

    boolean loop_body(LoopTable lTable, HIR node) {
        BBlock basicBlock = (BBlock)this.fResults.get("BBlockForNode", node);
        this.Trace("loop_body BBlock=" + basicBlock.getBBlockNumber(), 5);
        return lTable.BBlockList.contains(basicBlock);
    }

    boolean inner_loop_body(LoopTable lTable, HIR node) {
        BBlock basicBlock = (BBlock)this.fResults.get("BBlockForNode", node);
        this.Trace("loop_body BBlock=" + basicBlock.getBBlockNumber(), 5);
        return lTable.InnerBBlockList.contains(basicBlock);
    }

    void TraceBBlockList(LoopTable lTable) {
        this.Trace("-----TraceBBlockList-----", 5);
        for (BBlock basicBlock : lTable.BBlockList) {
            this.Trace(" BBlock=" + basicBlock.getBBlockNumber(), 5);
            this.Trace(" BBlock=" + basicBlock.getLabel().toString(), 5);
            for (BBlock Succ : basicBlock.getSuccList()) {
                this.Trace(" SuccBBlock=" + Succ.getBBlockNumber(), 5);
                this.Trace(" SuccBBlock=" + Succ.getLabel().toString(), 5);
            }
        }
        this.Trace("-----TraceInnerBBlockList-----", 5);
        for (BBlock basicBlock : lTable.InnerBBlockList) {
            this.Trace(" BBlock=" + basicBlock.getBBlockNumber(), 5);
        }
    }

    LoopTable getLoopTable(LoopTable pTable, BBlock pBlock) {
        if (pTable.InnerBBlockList.contains(pBlock)) {
            return pTable;
        }
        Iterator Ie = pTable.InnerLoopList.iterator();
        while (Ie.hasNext()) {
            LoopTable vTable = this.getLoopTable((LoopTable)Ie.next(), pBlock);
            if (vTable == null) continue;
            return vTable;
        }
        return null;
    }

    boolean IsInduction(LoopTable lTable, VarNode node) {
        for (BasicInduction IndTable : lTable.IndList) {
            if (!this.EQVar(node, IndTable.DefVarNode)) continue;
            return true;
        }
        return false;
    }

    boolean IsPrivate(LoopTable pTable, Var var) {
        for (VarNode vNode : pTable.Private) {
            this.Trace("IsPrivate=" + vNode.getVar().toString(), 5);
            if (var != vNode.getVar()) continue;
            return true;
        }
        return false;
    }

    boolean IsLastPrivate(LoopTable pTable, Var var) {
        for (VarNode vNode : pTable.LastPrivate) {
            this.Trace("IsPrivate=" + vNode.getVar().toString(), 5);
            if (var != vNode.getVar()) continue;
            return true;
        }
        return false;
    }

    boolean IsReduction(LoopTable lTable, Var var) {
        for (Reduction RedTable : lTable.ReductionADDList) {
            if (var != RedTable.DefVarNode.getVar()) continue;
            return true;
        }
        for (Reduction RedTable : lTable.ReductionMULList) {
            if (var != RedTable.DefVarNode.getVar()) continue;
            return true;
        }
        for (Reduction RedTable : lTable.ReductionSUBList) {
            if (var != RedTable.DefVarNode.getVar()) continue;
            return true;
        }
        return false;
    }

    int NodeOrder(Exp Node1, Exp Node2) {
        if (Node1 == Node2) {
            return 0;
        }
        if (!this.dom_check((BBlock)this.fResults.get("BBlockForNode", Node1), (BBlock)this.fResults.get("BBlockForNode", Node2))) {
            return -1;
        }
        if (this.fResults.get("BBlockForNode", Node1) != this.fResults.get("BBlockForNode", Node2)) {
            return 1;
        }
        SetRefReprList llist = (SetRefReprList)this.fResults.get("BBlockSetRefReprs", this.fResults.get("BBlockForNode", Node1));
        for (SetRefRepr lSetRefRepr : llist) {
            List StmSet = lSetRefRepr.useNodeList();
            if (StmSet.contains(Node1)) {
                return 1;
            }
            if (!StmSet.contains(Node2)) continue;
            return -1;
        }
        return 1;
    }

    Exp SkipConv(Exp exp) {
        Exp Curr = exp;
        while (Curr.getOperator() == 65) {
            Curr = Curr.getExp1();
        }
        return this.SkipCommonTag(Curr);
    }

    boolean IsAutoVarNode(HIR pNode) {
        HIR Curr = this.getTopVarNode(pNode);
        while (Curr.getChildCount() != 0) {
            Curr = (HIR)Curr.getChild1();
        }
        Var vSym = ((VarNode)Curr).getVar();
        int sClass = vSym.getStorageClass();
        boolean ret = sClass == 7 || sClass == 8;
        return ret;
    }

    HIR getParentASSIGN(HIR pNode) {
        HIR Curr = pNode;
        while (Curr.getOperator() != 22) {
            Curr = (HIR)Curr.getParent();
        }
        return Curr;
    }

    Exp SkipCommonTag(Exp exp) {
        Exp Curr = exp;
        if (Curr.getOperator() == 19) {
            Curr = Curr.getChild1().getOperator() == 17 ? (Exp)FlowUtil.getQualVarNode((Exp)Curr.getChild1()) : (Exp)FlowUtil.getQualVarNode(Curr);
        }
        return Curr;
    }

    TmpVarManager getTmpVarManager() {
        return this.fTmpVarManager;
    }

    HIR getTopVarNode(HIR pNode) {
        HIR Curr = pNode;
        while (Curr.getParent().getOperator() == 19) {
            Curr = (HIR)Curr.getParent();
        }
        return Curr;
    }

    boolean IsVarNode(HIR pNode) {
        Sym lSym = pNode.getSym();
        if (lSym == null) {
            return false;
        }
        return lSym instanceof FlowAnalSym;
    }

    boolean EQVar(Exp exp, VarNode var) {
        if (exp == null) {
            return false;
        }
        if (!this.IsVarNode(exp)) {
            return false;
        }
        return exp.getVar() == var.getVar();
    }

    public void getLoopBBlockList(LinkedList blist, BBlock head, BBlock tail, BBlock body) {
        this.Trace("---pass:getLoopBBlockList", 1);
        this.Trace("head=" + head, 5);
        this.Trace("tail=" + tail, 5);
        this.Trace("body=" + body, 5);
        BBlockVector markBit = this.fFlow.bblockVector(this.fSubpFlow);
        this.BBlockListSearch(markBit, head, head, tail, body);
        int maxBBlockNo = this.fSubpFlow.getNumberOfBBlocks();
        for (int i = 1; i <= maxBBlockNo; ++i) {
            if (markBit.getBit(i) != 1) continue;
            this.Trace("add BBlock =" + this.fSubpFlow.getBBlock(i).getBBlockNumber(), 5);
            blist.add(this.fSubpFlow.getBBlock(i));
        }
    }

    public void getLoopBBlockListXXXXX(LinkedList blist, BBlock head, BBlock tail, BBlock body) {
        this.Trace("---pass:getLoopBBlockList", 1);
        this.Trace("head=" + head.getBBlockNumber(), 5);
        this.Trace("tail=" + tail.getBBlockNumber(), 5);
        BBlockVector markBit = this.fFlow.bblockVector(this.fSubpFlow);
        boolean b = this.BBlockListSearchXXX(markBit, head, head, tail, blist);
        blist.add(head);
        blist.add(tail);
    }

    void getLoopInnerBBlockList(LoopTable pLoopTable) {
        Iterator Ie = pLoopTable.BBlockList.iterator();
        while (Ie.hasNext()) {
            pLoopTable.InnerBBlockList.add(Ie.next());
        }
        for (LoopTable lTable : pLoopTable.InnerLoopList) {
            for (BBlock b : lTable.BBlockList) {
                this.Trace("removeBBlock=" + b.getBBlockNumber(), 5);
                pLoopTable.InnerBBlockList.remove(b);
            }
        }
    }

    void BBlockListSearch(BBlockVector markBit, BBlock curr, BBlock head, BBlock tail, BBlock body) {
        this.Trace("BBlockListSearch---------------", 5);
        this.Trace("curr=" + curr, 5);
        this.Trace("head=" + head, 5);
        this.Trace("tail=" + tail, 5);
        this.Trace("body=" + body, 5);
        this.Trace("-------------------------------", 5);
        if (markBit.getBit(curr.getBBlockNumber()) == 1) {
            return;
        }
        markBit.setBit(curr.getBBlockNumber());
        List SuccList = curr.getSuccList();
        ListIterator Ie = SuccList.listIterator();
        while (Ie.hasNext()) {
            BBlock Succ = (BBlock)Ie.next();
            this.Trace("succ=" + Succ.getBBlockNumber(), 5);
            if (curr == head && Succ != body) continue;
            this.BBlockListSearch(markBit, Succ, head, tail, body);
        }
    }

    boolean BBlockListSearchXXX(BBlockVector markBit, BBlock curr, BBlock head, BBlock tail, LinkedList addList) {
        if (markBit.getBit(curr.getBBlockNumber()) == 1) {
            return addList.contains(curr);
        }
        markBit.setBit(curr.getBBlockNumber());
        List SuccList = curr.getSuccList();
        if (SuccList.size() == 0) {
            return false;
        }
        ListIterator Ie = SuccList.listIterator();
        while (Ie.hasNext()) {
            BBlock Succ = (BBlock)Ie.next();
            if (addList.contains(Succ)) continue;
            if (Succ == tail) {
                return true;
            }
            if (Succ == head) {
                return false;
            }
            if (!this.BBlockListSearchXXX(markBit, Succ, head, tail, addList)) continue;
            addList.add(Succ);
        }
        return true;
    }

    boolean IsScalar(HIR pNode) {
        boolean b = true;
        int op = pNode.getOperator();
        if (op == 17) {
            b = false;
        }
        return b;
    }

    boolean def_check(LoopTable lTable, AssignStmt AssignNode) {
        VarNode LeftVar = (VarNode)this.SkipConv(AssignNode.getLeftSide());
        int defCount = 0;
        this.Trace("def_check LeftVar =" + LeftVar.toString(), 5);
        for (VarNode Var2 : lTable.DefVarList) {
            this.Trace("def_check tVar =" + Var2.toString(), 5);
            if (!this.EQVar(Var2, LeftVar)) continue;
            ++defCount;
        }
        this.Trace("def_check count =" + defCount, 5);
        return defCount == 1;
    }

    public BBlock LoopNextBBlock(LoopTable lTable) {
        BBlock LoopBack = this.fResults.getBBlockForLabel(lTable.LoopStmt.getLoopBackLabel());
        BBlock Exit = this.fResults.getBBlockForLabel(lTable.LoopStmt.getLoopStepLabel());
        List SuccList = LoopBack.getSuccList();
        this.Trace("Loop NextLoopBack=" + LoopBack.getBBlockNumber(), 5);
        this.Trace("Loop NextExit=" + Exit.getBBlockNumber(), 5);
        ListIterator Ie = SuccList.listIterator();
        while (Ie.hasNext()) {
            BBlock Succ = (BBlock)Ie.next();
            if (lTable.BBlockList.contains(Succ)) continue;
            return Succ;
        }
        return null;
    }

    void Trace(String s, int n) {
        if (this.TraceFlag) {
            if (s.indexOf("pass") != -1) {
                this.fResults.flowRoot.hirRoot.ioRoot.dbgPara1.print(n, "//" + this.TraceString + "    " + s + "\n");
            } else {
                this.fResults.flowRoot.hirRoot.ioRoot.dbgPara1.print(n, "//    " + this.TraceString + "    " + s + "\n");
            }
        }
    }
}

