/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.HirRoot;
import coins.PassException;
import coins.SymRoot;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.VarNode;
import coins.mdf.MdfEnvironment;
import coins.sym.Label;
import coins.sym.Sym;
import coins.sym.SymIterator;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.Var;

class ReconstructHir {
    private final String exitName = "exit";
    private MdfEnvironment env;
    private HirRoot hirRoot;
    private SubpDefinition subpDef;
    private SymTable symTab;
    private SymRoot symRoot;
    private HIR hirFact;
    private Sym symFact;

    ReconstructHir(MdfEnvironment e, HirRoot hRoot, SubpDefinition subpDefinition) throws PassException {
        this.env = e;
        this.hirRoot = hRoot;
        this.symRoot = this.hirRoot.symRoot;
        this.subpDef = subpDefinition;
        this.symTab = this.subpDef.getSymTable();
        this.symFact = this.symRoot.sym;
        this.hirFact = this.hirRoot.hir;
        this.makeFlatStructure();
        this.canonicalForm();
        this.configBlk();
    }

    private void canonicalForm() throws PassException {
        Stmt node;
        BlockStmt blkStmt = null;
        Stmt root = this.subpDef.getHirBody();
        HirIterator ite = root.hirIterator(root);
        while (ite.hasNextStmt()) {
            Stmt node2 = ite.getNextStmt();
            if (blkStmt != null || !(node2 instanceof BlockStmt)) continue;
            blkStmt = (BlockStmt)node2;
            break;
        }
        Label lastLabel = this.symTab.generateLabel();
        Type subpType = this.subpDef.getSubpSym().getReturnValueType();
        Var returnStatus = null;
        if (subpType.getTypeKind() != 15) {
            returnStatus = this.symFact.defineVar("_mdf_return_status".intern(), subpType);
            returnStatus.setVisibility(4);
        }
        HirIterator ite2 = root.hirIterator(root);
        while (ite2.hasNextStmt()) {
            node = ite2.getNextStmt();
            if (!(node instanceof ReturnStmt)) continue;
            node.addNextStmt(this.hirFact.jumpStmt(lastLabel));
        }
        ite2 = root.hirIterator(root);
        while (ite2.hasNextStmt()) {
            node = ite2.getNextStmt();
            if (!(node instanceof ReturnStmt)) continue;
            if (returnStatus != null) {
                VarNode statusExp = this.hirFact.varNode(returnStatus);
                AssignStmt setStatus = this.hirFact.assignStmt(statusExp, (Exp)node.getChild(1));
                node.replaceThisStmtWith(setStatus);
                continue;
            }
            node.deleteThisStmt();
        }
        LabeledStmt labeledStmt = this.hirFact.labeledStmt(lastLabel, null);
        blkStmt.addLastStmt(labeledStmt);
        if (returnStatus == null) {
            blkStmt.addLastStmt(this.hirFact.returnStmt());
        } else {
            VarNode statusExp = this.hirFact.varNode(returnStatus);
            blkStmt.addLastStmt(this.hirFact.returnStmt(statusExp));
        }
    }

    private void configBlk() {
        Stmt root = this.subpDef.getHirBody();
        HirIterator ite = root.hirIterator(root);
        while (ite.hasNextStmt()) {
            Exp mayCall;
            Stmt node = ite.getNextStmt();
            if (node instanceof LoopStmt) {
                this.attachLabel(node);
                continue;
            }
            if (!(node instanceof ExpStmt) || (mayCall = ((ExpStmt)node).getExp()) == null || mayCall.getOperator() != 33) continue;
            this.attachLabel(node);
        }
    }

    private void attachLabel(Stmt stmt) {
        Stmt below;
        Stmt upper = stmt.getPreviousStmt();
        if (upper != null && !(upper instanceof LabeledStmt)) {
            Label newLab = this.symTab.generateLabel();
            LabeledStmt labeledStmt = this.hirFact.labeledStmt(newLab, null);
            stmt.insertPreviousStmt(labeledStmt);
        }
        if ((below = stmt.getNextStmt()) != null && !(below instanceof LabeledStmt)) {
            Label newLab = this.symTab.generateLabel();
            LabeledStmt labeledStmt = this.hirFact.labeledStmt(newLab, null);
            stmt.addNextStmt(labeledStmt);
        }
    }

    private void makeFlatStructure() {
        int count = 0;
        Stmt stmt = this.subpDef.getHirBody();
        HirIterator ite = stmt.hirIterator(stmt);
        while (ite.hasNext()) {
            SymTable localSymTab;
            HIR hir = ite.next();
            if (!(hir instanceof BlockStmt) || (localSymTab = ((BlockStmt)hir).getSymTable()) == null || this.symTab == localSymTab) continue;
            ++count;
            SymIterator site = localSymTab.getSymIterator();
            while (site.hasNext()) {
                Sym s = site.next();
                String newName = "_mdf_" + s.getName() + "_" + count;
                Sym newSym = this.symTab.defineUnique(newName, s.getSymKind(), null);
                newSym.setSymType(s.getSymType());
                this.replaceSymbol((BlockStmt)hir, s, newSym);
            }
        }
    }

    private void replaceSymbol(BlockStmt blkStmt, Sym orgSym, Sym newSym) {
        HirIterator ite = blkStmt.hirIterator(blkStmt);
        while (ite.hasNext()) {
            Sym s;
            HIR hir = ite.next();
            if (!(hir instanceof VarNode) || (s = ((VarNode)hir).getSymNodeSym()) != orgSym) continue;
            ((VarNode)hir).setSymNodeSym(newSym);
        }
    }
}

