/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.VarNode;
import coins.mdf.DeclareLocalVariables;
import coins.mdf.MacroFlowGraph;
import coins.mdf.MacroTask;
import coins.mdf.MdfEnvironment;
import coins.sym.Label;
import coins.sym.SymTable;
import java.util.LinkedList;

abstract class TreatNode {
    protected MdfEnvironment env;
    protected SymTable symTab;
    protected MacroFlowGraph mfg;
    protected LinkedList visited;
    protected Stmt root;

    protected TreatNode(MdfEnvironment e, MacroFlowGraph g, LinkedList list, Stmt rootStmt) {
        this.env = e;
        this.mfg = g;
        this.symTab = this.mfg.subpDef.getSubpSym().getSymTable();
        this.visited = list;
        this.root = rootStmt;
    }

    protected void replaceReturn(Label label, DeclareLocalVariables decLocal) {
        Stmt node;
        HIR hirFact = this.mfg.hirRoot.hir;
        HirIterator ite = this.root.hirIterator(this.root);
        while (ite.hasNextStmt()) {
            node = ite.getNextStmt();
            if (!(node instanceof ReturnStmt)) continue;
            node.addNextStmt(hirFact.jumpStmt(label));
        }
        ite = this.root.hirIterator(this.root);
        while (ite.hasNextStmt()) {
            node = ite.getNextStmt();
            if (!(node instanceof ReturnStmt)) continue;
            VarNode finishVar = hirFact.varNode(decLocal.allFinishVar);
            AssignStmt finishAssign = hirFact.assignStmt(finishVar, hirFact.intConstNode(1));
            node.addNextStmt(finishAssign);
        }
        ite = this.root.hirIterator(this.root);
        while (ite.hasNextStmt()) {
            node = ite.getNextStmt();
            if (!(node instanceof ReturnStmt)) continue;
            if (decLocal.returnStatus != null) {
                VarNode statusExp = hirFact.varNode(decLocal.returnStatus);
                AssignStmt setStatus = hirFact.assignStmt(statusExp, (Exp)node.getChild(1));
                node.replaceThisStmtWith(setStatus);
                continue;
            }
            node.deleteThisStmt();
        }
    }

    protected BlockStmt makeJumpBlk(Label label) {
        JumpStmt newJump = this.mfg.subpDef.jumpStmt(label);
        BlockStmt blkStmt = this.mfg.subpDef.blockStmt(newJump);
        return blkStmt;
    }

    protected boolean isChange(MacroTask mt, Label label) {
        MacroTask caseTask = this.mfg.macroTask(label);
        if (caseTask != mt) {
            return true;
        }
        LabeledStmt child = label.getHirPosition();
        HirIterator ite = child.hirIterator(child);
        while (ite.hasNext()) {
            Label l;
            HIR stmt = ite.next();
            if (stmt == null || !(stmt instanceof LabeledStmt) || this.visited.contains(l = ((LabeledStmt)stmt).getLabel())) continue;
            this.visited.add(l);
        }
        return false;
    }
}

