/*
 * Decompiled with CFR 0.152.
 */
package coins.mdf;

import coins.ir.hir.BlockStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HirList;
import coins.ir.hir.LabelNode;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.SwitchStmt;
import coins.mdf.MacroFlowGraph;
import coins.mdf.MacroTask;
import coins.mdf.MdfConditions;
import coins.mdf.MdfEnvironment;
import coins.mdf.TreatNode;
import coins.sym.Label;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;

class TreatSwitch
extends TreatNode {
    private SwitchStmt node;
    private BlockStmt switchBody;
    private Hashtable labelMap;
    private MdfConditions cond;

    TreatSwitch(MdfEnvironment e, MacroFlowGraph g, SwitchStmt stmt, LinkedList list, MdfConditions c) {
        super(e, g, list, stmt);
        this.node = stmt;
        this.cond = c;
        this.labelMap = new Hashtable();
        this.switchBody = this.mfg.subpDef.blockStmt(null);
        for (HIR body = (HIR)this.node.getBodyStmt().getChild(1); body != null; body = body.getNextStmt()) {
            Stmt nextStmt;
            if (!(body instanceof LabeledStmt) || (nextStmt = body.getNextStmt()) == null) continue;
            this.labelMap.put(((Stmt)body).getLabel(), body.getNextStmt());
        }
    }

    void replace(MacroTask mt, Label label) {
        HirList labLists = (HirList)this.node.getChild(2).getChild(1);
        ListIterator labIte = labLists.iterator();
        while (labIte.hasNext()) {
            HIR body;
            HIR child = (HIR)labIte.next();
            Label caseLabel = ((LabelNode)child.getChild(2)).getLabel();
            Label newCaseLabel = this.symTab.generateLabel();
            LabeledStmt newLabStmt = this.mfg.subpDef.labeledStmt(newCaseLabel, this.mfg.subpDef.nullStmt());
            this.switchBody.addLastStmt(newLabStmt);
            if (this.isChange(mt, caseLabel)) {
                body = this.replaceCase(mt, caseLabel, label);
                this.switchBody.addLastStmt((Stmt)body);
            } else {
                body = (HIR)this.labelMap.get(caseLabel);
                if (body != null) {
                    this.switchBody.addLastStmt((Stmt)body);
                }
            }
            newCaseLabel.setLabelKind(11);
            newCaseLabel.setOriginHir(this.node);
            child.setChild(2, this.mfg.subpDef.labelNode(newCaseLabel));
        }
        Label newDefaultLabel = this.symTab.generateLabel();
        LabeledStmt newDefaultLabStmt = this.mfg.subpDef.labeledStmt(newDefaultLabel, null);
        this.switchBody.addLastStmt(newDefaultLabStmt);
        Label defaultLabel = this.node.getDefaultLabel();
        if (defaultLabel != null) {
            HIR body;
            if (this.isChange(mt, defaultLabel)) {
                body = this.replaceCase(mt, defaultLabel, label);
                this.switchBody.addLastStmt((Stmt)body);
            } else {
                body = (HIR)this.labelMap.get(defaultLabel);
                if (body != null) {
                    this.switchBody.addLastStmt((Stmt)body);
                }
            }
        }
        newDefaultLabel.setLabelKind(12);
        newDefaultLabel.setOriginHir(this.node);
        this.node.getChild(2).setChild(2, this.mfg.subpDef.labelNode(newDefaultLabel));
        this.node.setChild(3, this.switchBody);
    }

    private HIR replaceCase(MacroTask src, Label caseLabel, Label endLabel) {
        BlockStmt blk = this.makeJumpBlk(endLabel);
        if (src.succList.size() > 1) {
            MacroTask dst = this.mfg.macroTask(caseLabel);
            Stmt assign = this.cond.finish.finishCond(src, dst);
            blk.addBeforeBranchStmt(assign);
        } else {
            Stmt assign = this.cond.finish.finishCond(src, null);
            blk.addBeforeBranchStmt(assign);
        }
        return blk;
    }
}

