/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.FlowRoot;
import coins.SymRoot;
import coins.flow.BBlock;
import coins.flow.FlowUtil;
import coins.flow.SetRefRepr;
import coins.flow.SetRefReprList;
import coins.flow.SubpFlow;
import coins.ir.IR;
import coins.ir.hir.HIR;
import coins.ir.hir.SubpDefinition;
import coins.opt.OptUtil;
import coins.sym.ExpId;
import coins.sym.FlowAnalSym;
import coins.sym.Sym;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public abstract class CommonSubexpElim {
    public final FlowRoot flowRoot;
    public final SymRoot symRoot;
    public final Sym sym;
    public final SubpFlow fSubpFlow;
    protected int fDbgLevel;

    public CommonSubexpElim(FlowRoot pFlowRoot) {
        this.flowRoot = pFlowRoot;
        this.symRoot = this.flowRoot.symRoot;
        this.sym = this.symRoot.sym;
        this.fSubpFlow = pFlowRoot.fSubpFlow;
        this.fDbgLevel = this.flowRoot.ioRoot.dbgOpt1.getLevel();
    }

    public boolean doBBlockLocal(SubpFlow pSubpFlow) {
        boolean lChanged = false;
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgOpt1.print(1, "\ndoBBlockLocal", pSubpFlow.getSubpSym().toString());
        }
        SubpDefinition lSubpDef = pSubpFlow.getSubpDefinition();
        if (this.flowRoot.flow.getFlowAnalStateLevel() < 4) {
            this.flowRoot.dataFlow = this.flowRoot.flow.dataFlowAnal(lSubpDef);
        }
        for (BBlock lBBlock : pSubpFlow.getBBlockTable()) {
            if (lBBlock == null || lBBlock.getBBlockNumber() <= 0) continue;
            lChanged = this.doBBlockLocal(lBBlock) | lChanged;
        }
        if (lChanged) {
            if (this.flowRoot.ioRoot.dbgOpt1.getLevel() > 2) {
                this.fSubpFlow.getSubpDefinition().printHir("Changed HIR");
            }
            lSubpDef.finishHir();
            this.fSubpFlow.setComputedFlag(2);
            pSubpFlow.setRestructureFlag();
        }
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgOpt1.print(1, "\n change by CommonSubexpElim of " + pSubpFlow.getSubpSym().toString() + " is " + lChanged);
        }
        return lChanged;
    }

    public boolean doBBlockLocal(BBlock pBBlock) {
        if (pBBlock == null || pBBlock.getBBlockNumber() == 0) {
            return false;
        }
        SetRefReprList lSetRefReprs = this.fSubpFlow.getSetRefReprList(pBBlock);
        HashMap<ExpId, IR> lCompoundToVarNode = new HashMap<ExpId, IR>();
        HashMap<Sym, ExpId> lVarToCompound = new HashMap<Sym, ExpId>();
        HashMap<ExpId, Object[]> lCompoundToNodeAndSetRefRepr = new HashMap<ExpId, Object[]>();
        HashMap lContainsMap = new HashMap();
        Set lAddressGrabbedSyms = null;
        Set lLHSSyms = null;
        boolean lElimed = false;
        HIR lElimedNode = null;
        Object lCallNode = null;
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgOpt1.print(2, "doBBlockLocal ", pBBlock.toString() + " lSetRefReprs " + lSetRefReprs.toString());
        }
        for (SetRefRepr lSetRefRepr : lSetRefReprs) {
            if (this.fDbgLevel > 0) {
                this.flowRoot.ioRoot.dbgOpt1.print(4, " lSetRefRepr ", ((Object)lSetRefRepr).toString());
            }
            boolean lRegisterLHSToRHS = false;
            HIR lTopUseNode = (HIR)lSetRefRepr.topUseNode();
            ListIterator lExpIt = lSetRefRepr.expListIterator(false, true);
            if (lSetRefRepr.sets()) {
                lAddressGrabbedSyms = lSetRefRepr.modSyms();
                lLHSSyms = lSetRefRepr.lhsSyms();
                if (this.fDbgLevel > 0) {
                    this.flowRoot.ioRoot.dbgOpt1.print(4, " lLHHSyms " + lLHSSyms.toString());
                }
            }
            while (lExpIt.hasNext()) {
                HIR lUseNode = (HIR)lExpIt.next();
                if (this.fDbgLevel > 0) {
                    this.flowRoot.ioRoot.dbgOpt1.print(4, " lUseNode " + ((Object)lUseNode).toString());
                }
                boolean lSimpleElimSuccess = false;
                if (lElimedNode != null && FlowUtil.isUnder(lElimedNode, lUseNode)) continue;
                if (OptUtil.isCall(lUseNode)) {
                    for (int lSymIndex = 0; lSymIndex < this.fSubpFlow.getSymExpCount(); ++lSymIndex) {
                        FlowAnalSym lModSym = this.fSubpFlow.getIndexedSym(lSymIndex);
                        if (lVarToCompound.containsKey(lModSym)) {
                            lCompoundToVarNode.remove(lVarToCompound.get(lModSym));
                            lVarToCompound.remove(lModSym);
                        }
                        if (!lContainsMap.containsKey(lModSym)) continue;
                        for (ExpId llCompound : (Set)lContainsMap.get(lModSym)) {
                            lCompoundToVarNode.remove(llCompound);
                            lCompoundToNodeAndSetRefRepr.remove(llCompound);
                        }
                    }
                }
                if (lUseNode.getChildCount() == 0) continue;
                ExpId lCompound = lUseNode.getExpId();
                if (this.fDbgLevel > 0) {
                    this.flowRoot.ioRoot.dbgOpt1.print(4, "Compound: ", lCompound.toString());
                    this.flowRoot.ioRoot.dbgOpt1.print(4, "CompoundToVarNode: ", ((Object)lCompoundToVarNode).toString());
                    this.flowRoot.ioRoot.dbgOpt1.print(4, "CompoundToNodeAndSetRefRepr: ", ((Object)lCompoundToNodeAndSetRefRepr).toString());
                }
                if (this.fSubpFlow.subtreesContainingCall().contains(lUseNode)) continue;
                if (lCompoundToVarNode.containsKey(lCompound)) {
                    boolean bl = lElimed = this.eliminateSimple(lUseNode, (HIR)lCompoundToVarNode.get(lCompound), pBBlock.getSubpFlow(), lAddressGrabbedSyms, FlowUtil.isUnder(lSetRefRepr.defNode(), lUseNode)) != null;
                    if (lElimed) {
                        lElimedNode = lUseNode;
                        lSimpleElimSuccess = true;
                    }
                }
                if (!lSimpleElimSuccess && lCompoundToNodeAndSetRefRepr.containsKey(lCompound)) {
                    SetRefRepr lPrevCalcSetRefRepr;
                    HIR lPrevCompoundNode = (HIR)((Object[])lCompoundToNodeAndSetRefRepr.get(lCompound))[0];
                    HIR lNewTempNode = this.eliminateComplex(lUseNode, lPrevCompoundNode, lPrevCalcSetRefRepr = (SetRefRepr)((Object[])lCompoundToNodeAndSetRefRepr.get(lCompound))[1], lSetRefReprs, lCompoundToNodeAndSetRefRepr, lContainsMap);
                    if (lNewTempNode == null) continue;
                    lCompoundToVarNode.put(lCompound, lNewTempNode);
                    lVarToCompound.put(lNewTempNode.getSym(), lCompound);
                    lElimed = true;
                    lElimedNode = lUseNode;
                    continue;
                }
                if (lTopUseNode == lUseNode && lSetRefRepr.sets() && this.fSubpFlow.getExpId(lTopUseNode).getNumberOfOperations() > this.fSubpFlow.getExpId(lSetRefRepr.defNode()).getNumberOfOperations()) {
                    lRegisterLHSToRHS = true;
                }
                lCompoundToNodeAndSetRefRepr.put(lCompound, new Object[]{lUseNode, lSetRefRepr});
                this.registerUseSyms(lUseNode, lContainsMap, lCompound);
            }
            if (!lSetRefRepr.sets()) continue;
            for (Sym lLHSSym : lLHSSyms) {
                if (lLHSSym.getSymType().getTypeKind() != 22) continue;
                lCompoundToNodeAndSetRefRepr.clear();
                lCompoundToVarNode.clear();
                lVarToCompound.clear();
                break;
            }
            boolean lIsDDef = lSetRefRepr.defSym() != null;
            lAddressGrabbedSyms = lSetRefRepr.modSyms();
            for (FlowAnalSym lModSym : lAddressGrabbedSyms) {
                if (lVarToCompound.containsKey(lModSym)) {
                    lCompoundToVarNode.remove(lVarToCompound.get(lModSym));
                    lVarToCompound.remove(lModSym);
                }
                if (lIsDDef && lRegisterLHSToRHS) {
                    lCompoundToVarNode.put(this.fSubpFlow.getExpId(lTopUseNode), lSetRefRepr.defNode());
                    lVarToCompound.put(lModSym, this.fSubpFlow.getExpId(lSetRefRepr.topUseNode()));
                }
                if (!lContainsMap.containsKey(lModSym)) continue;
                for (ExpId llCompound : (Set)lContainsMap.get(lModSym)) {
                    lCompoundToVarNode.remove(llCompound);
                    lCompoundToNodeAndSetRefRepr.remove(llCompound);
                }
            }
        }
        return lElimed;
    }

    abstract Set operandSet(Object var1);

    abstract HIR eliminateSimple(HIR var1, HIR var2, SubpFlow var3, Set var4, boolean var5);

    abstract HIR eliminateComplex(HIR var1, HIR var2, SetRefRepr var3, SetRefReprList var4, Map var5, Map var6);

    abstract void registerUseSyms(HIR var1, Map var2, Object var3);
}

