/*
 * Decompiled with CFR 0.152.
 */
package coins.opt;

import coins.FlowRoot;
import coins.flow.FlowUtil;
import coins.flow.SubpFlowImpl;
import coins.ir.IR;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.HIR;
import coins.ir.hir.HIR_Impl;
import coins.ir.hir.HirList;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Stmt;
import coins.opt.ConstFoldingHir;
import coins.opt.OptError;
import coins.sym.Sym;
import coins.sym.Type;
import coins.sym.TypeImpl;

public class OptUtil {
    public static void replaceNode(IR pOld, IR pNew) {
        if (pOld instanceof HIR) {
            if (pNew instanceof HIR) {
                ((HIR)pOld).replaceThisNode((HIR)pNew);
                ((SubpFlowImpl)((HIR_Impl)pNew).hirRoot.getFlowRoot().fSubpFlow).fIteratorInitiated = false;
            } else {
                HIR lParent = (HIR)pOld.getParent();
                if (lParent != null) {
                    if (lParent.getOperator() == 14) {
                        HirList lHirList = (HirList)lParent;
                        lHirList.set(lHirList.indexOf(pOld), pNew);
                        ((HIR_Impl)pNew).setParent(lHirList);
                    } else {
                        lParent.replaceSource(((HIR)pOld).getChildNumber(), pNew);
                    }
                }
            }
        } else {
            throw new OptError();
        }
    }

    public static void replaceStmt(Stmt pOldStmt, Stmt pNewStmt) {
        if (pOldStmt == null) {
            return;
        }
        pOldStmt.replaceThisStmtWith(pNewStmt);
        ((SubpFlowImpl)((HIR_Impl)((Object)pOldStmt)).hirRoot.getFlowRoot().fSubpFlow).fIteratorInitiated = false;
    }

    public static void addNextStmt(Stmt pCurrentStmt, Stmt pNewStmt) {
        if (pCurrentStmt == null) {
            return;
        }
        pCurrentStmt.addNextStmt(pNewStmt);
        ((SubpFlowImpl)((HIR_Impl)((Object)pNewStmt)).hirRoot.getFlowRoot().fSubpFlow).fIteratorInitiated = false;
    }

    public static void insertPreviousStmt(Stmt pCurrentStmt, Stmt pNewStmt) {
        if (pCurrentStmt == null) {
            return;
        }
        pCurrentStmt.insertPreviousStmt(pNewStmt);
        ((SubpFlowImpl)((HIR_Impl)((Object)pCurrentStmt)).hirRoot.getFlowRoot().fSubpFlow).fIteratorInitiated = false;
    }

    public static void deleteStmt(Stmt pStmt) {
        if (pStmt == null) {
            return;
        }
        pStmt.deleteThisStmt();
        ((SubpFlowImpl)((HIR_Impl)((Object)pStmt)).hirRoot.getFlowRoot().fSubpFlow).fIteratorInitiated = false;
    }

    public static void addFirstStmt(BlockStmt pBlock, Stmt pStmt) {
        if (pBlock == null || pStmt == null) {
            return;
        }
        pBlock.addFirstStmt(pStmt);
        ((SubpFlowImpl)((HIR_Impl)((Object)pStmt)).hirRoot.getFlowRoot().fSubpFlow).fIteratorInitiated = false;
    }

    public static void addLastStmt(BlockStmt pBlock, Stmt pStmt) {
        if (pBlock == null || pStmt == null) {
            return;
        }
        pBlock.addBeforeBranchStmt(pStmt);
        ((SubpFlowImpl)((HIR_Impl)((Object)pStmt)).hirRoot.getFlowRoot().fSubpFlow).fIteratorInitiated = false;
    }

    public static void setStmt(LabeledStmt pLabeledStmt, Stmt pStmt) {
        if (pLabeledStmt == null) {
            return;
        }
        pLabeledStmt.setStmt(pStmt);
        ((SubpFlowImpl)((HIR_Impl)((Object)pLabeledStmt)).hirRoot.getFlowRoot().fSubpFlow).fIteratorInitiated = false;
    }

    public static boolean isCall(IR pIR) {
        return pIR instanceof FunctionExp;
    }

    public static IR fold(IR pIR, FlowRoot pFlowRoot) {
        if (FlowUtil.getChildCount(pIR) == 1) {
            if (pFlowRoot.isHirAnalysis()) {
                return ConstFoldingHir.foldUnary((HIR)pIR, pFlowRoot);
            }
            throw new OptError();
        }
        if (FlowUtil.getChildCount(pIR) == 2) {
            if (pFlowRoot.isHirAnalysis()) {
                return ConstFoldingHir.foldBinary((HIR)pIR, pFlowRoot);
            }
            throw new OptError();
        }
        return pIR;
    }

    public static IR createConstNodeFromConstNode(IR pConstNode, FlowRoot pFlowRoot) {
        HIR hir = pFlowRoot.hirRoot.hir;
        Sym sym = pFlowRoot.symRoot.sym;
        if (pConstNode instanceof HIR) {
            int lTypeKind = ((ConstNode)pConstNode).getType().getTypeKind();
            ConstNode lNewConstNode = ((ConstNode)pConstNode).isTrueConstNode() ? hir.trueNode() : (((ConstNode)pConstNode).isFalseConstNode() ? hir.falseNode() : (lTypeKind <= 12 ? hir.constNode(sym.intConst(((ConstNode)pConstNode).getConstSym().longValue(), ((ConstNode)pConstNode).getType())) : (lTypeKind == 23 ? (ConstNode)((HIR)pConstNode).copyWithOperands() : hir.constNode(sym.floatConst(((ConstNode)pConstNode).getConstSym().doubleValue(), ((ConstNode)pConstNode).getType())))));
            int NewTypeKind = lNewConstNode.getType().getTypeKind();
            return lNewConstNode;
        }
        throw new OptError();
    }

    public static IR wrapCallNode(IR pCallNode, FlowRoot pFlowRoot) {
        if (pCallNode instanceof FunctionExp) {
            return pFlowRoot.hirRoot.hir.expStmt((FunctionExp)pCallNode);
        }
        return pCallNode;
    }

    public static ConstNode createConstNodeFromPrimitive(long pIntVal, Type pType, FlowRoot pFlowRoot) {
        int lTypeKind = pType.getTypeKind();
        HIR lhir = pFlowRoot.hirRoot.hir;
        Sym lsym = pFlowRoot.symRoot.sym;
        if (lTypeKind == 7 || lTypeKind == 8) {
            return lhir.constNode(lsym.charConst((char)pIntVal, pType));
        }
        return lhir.constNode(lsym.intConst(pIntVal, pType));
    }

    public static ConstNode createConstNodeFromPrimitive(double pFloatVal, Type pType, FlowRoot pFlowRoot) {
        return pFlowRoot.hirRoot.hir.constNode(pFlowRoot.symRoot.sym.floatConst(pFloatVal, pType));
    }

    public static boolean isOutOfValueRange(Type pType) {
        return ((TypeImpl)pType).symRoot.machineParam.evaluateSize(pType.getTypeKind()) > 8;
    }

    public static ConstNode create0ConstNode(Type pType, FlowRoot pFlowRoot) {
        HIR hir = pFlowRoot.hirRoot.hir;
        Sym sym = pFlowRoot.symRoot.sym;
        return pType.isInteger() ? hir.constNode(sym.intConst(0L, pType)) : hir.constNode(sym.floatConst(0.0, pType));
    }
}

