/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Function;
import coins.backend.SyntaxError;
import coins.backend.Type;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirBinOp;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNaryOp;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirUnaOp;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;
import coins.simd.Evaluation;

public class ConstantFolding {
    private int typeI8 = ConstantFolding.decode("I8");
    private int typeI16 = ConstantFolding.decode("I16");
    private int typeI32 = ConstantFolding.decode("I32");
    private int typeI64 = ConstantFolding.decode("I64");
    private int typeF32 = ConstantFolding.decode("F32");
    private int typeF64 = ConstantFolding.decode("F64");
    private LirFactory fact;

    public ConstantFolding(Function f) {
        this.fact = f.newLir;
    }

    public void invoke(BasicBlk blk) {
        if (!blk.instrList().isEmpty()) {
            BiLink lir = blk.instrList().first();
            while (!lir.atEnd()) {
                LirNode newins;
                LirNode ins = (LirNode)lir.elem();
                if (ins.opCode == 48 && (newins = this.constantFolding(ins)) != ins) {
                    lir.setElem(newins);
                }
                lir = lir.next();
            }
        }
    }

    private LirNode constantFolding(LirNode ins) {
        if (ins.opCode == 48) {
            LirNode s0 = this.constantFolding(ins.kid(0));
            LirNode s1 = this.constantFolding(ins.kid(1));
            if (s0 != ins.kid(0) && s1 != ins.kid(1)) {
                return this.fact.operator(ins.opCode, ins.type, s0, s1, ImList.Empty);
            }
            if (s0 != ins.kid(0) && s1 == ins.kid(1)) {
                return this.fact.operator(ins.opCode, ins.type, s0, ins.kid(1), ImList.Empty);
            }
            if (s0 == ins.kid(0) && s1 != ins.kid(1)) {
                return this.fact.operator(ins.opCode, ins.type, ins.kid(0), s1, ImList.Empty);
            }
            return ins;
        }
        if (this.isEvaluableOp(ins)) {
            LirNode s0 = this.constantFolding(ins.kid(0));
            LirNode s1 = this.constantFolding(ins.kid(1));
            if (this.isConst(s0) && this.isConst(s1)) {
                return this.evaluate(ins.opCode, ins.type, s0, s1);
            }
            if (s0 != ins.kid(0) && s1 == ins.kid(1)) {
                return this.fact.operator(ins.opCode, ins.type, s0, ins.kid(1).makeCopy(this.fact), ImList.Empty);
            }
            if (s0 == ins.kid(0) && s1 != ins.kid(1)) {
                return this.fact.operator(ins.opCode, ins.type, ins.kid(0).makeCopy(this.fact), s1, ImList.Empty);
            }
            if (s0 != ins.kid(0) && s1 != ins.kid(1)) {
                return this.fact.operator(ins.opCode, ins.type, s0, s1, ImList.Empty);
            }
            return ins;
        }
        if (ins instanceof LirIconst) {
            return ins;
        }
        if (ins instanceof LirFconst) {
            return ins;
        }
        if (ins instanceof LirUnaOp) {
            LirNode s0 = this.constantFolding(ins.kid(0));
            if (s0 != ins.kid(0)) {
                return this.fact.operator(ins.opCode, ins.type, s0, ImList.Empty);
            }
            return ins;
        }
        if (ins instanceof LirBinOp) {
            LirNode s0 = this.constantFolding(ins.kid(0));
            LirNode s1 = this.constantFolding(ins.kid(1));
            if (s0 != ins.kid(0) && s1 == ins.kid(1)) {
                return this.fact.operator(ins.opCode, ins.type, s0, ins.kid(1).makeCopy(this.fact), ImList.Empty);
            }
            if (s0 == ins.kid(0) && s1 != ins.kid(1)) {
                return this.fact.operator(ins.opCode, ins.type, ins.kid(0).makeCopy(this.fact), s1, ImList.Empty);
            }
            if (s0 != ins.kid(0) && s1 != ins.kid(1)) {
                return this.fact.operator(ins.opCode, ins.type, s0, s1, ImList.Empty);
            }
            return ins;
        }
        if (ins instanceof LirNaryOp) {
            int i;
            LirNode[] src = new LirNode[ins.nKids()];
            boolean changed = false;
            for (i = 0; i < ins.nKids(); ++i) {
                src[i] = this.constantFolding(ins.kid(i));
                if (src[i] == ins.kid(i)) continue;
                changed = true;
            }
            if (changed) {
                for (i = 0; i < ins.nKids(); ++i) {
                    if (src[i] != ins.kid(i)) continue;
                    src[i] = ins.kid(i).makeCopy(this.fact);
                }
                return this.fact.operator(ins.opCode, ins.type, src, ImList.Empty);
            }
            return ins;
        }
        return ins;
    }

    private boolean isConst(LirNode e) {
        if (e == null) {
            return false;
        }
        return e.opCode == 2 || e.opCode == 3;
    }

    private boolean isEvaluableOp(LirNode e) {
        return e.opCode == 10 || e.opCode == 11 || e.opCode == 12 || e.opCode == 13 || e.opCode == 14 || e.opCode == 15 || e.opCode == 16 || e.opCode == 27 || e.opCode == 28 || e.opCode == 29 || e.opCode == 31 || e.opCode == 32 || e.opCode == 33 || e.opCode == 34;
    }

    private LirNode evaluate(int op, int type, LirNode e1, LirNode e2) {
        if (type == this.typeI8 || type == this.typeI16 || type == this.typeI32 || type == this.typeI64) {
            LirIconst c1 = (LirIconst)e1;
            LirIconst c2 = (LirIconst)e2;
            Number r = Evaluation.calc(c1.value, c2.value, this.convOp(op));
            return this.fact.iconst(type, r.longValue(), ImList.Empty);
        }
        if (type == this.typeF32 || type == this.typeF64) {
            LirFconst c1 = (LirFconst)e1;
            LirFconst c2 = (LirFconst)e2;
            Number r = Evaluation.calc(c1.value, c2.value, this.convOp(op));
            return this.fact.fconst(type, r.doubleValue(), ImList.Empty);
        }
        return null;
    }

    private String convOp(int opCode) {
        String op = null;
        if (opCode == 9) {
            op = "-";
        } else if (opCode == 10) {
            op = "+";
        } else if (opCode == 11) {
            op = "-";
        } else if (opCode == 12) {
            op = "*";
        } else if (opCode == 13) {
            op = "/";
        } else if (opCode == 14) {
            op = "/";
        } else if (opCode == 14) {
            op = "/";
        } else if (opCode == 15) {
            op = "%";
        } else if (opCode == 16) {
            op = "%";
        } else if (opCode == 27) {
            op = "&";
        } else if (opCode == 29) {
            op = "^";
        } else if (opCode == 28) {
            op = "|";
        } else if (opCode == 31) {
            op = "<<";
        } else if (opCode == 32) {
            op = "<<";
        } else if (opCode == 33) {
            op = ">>";
        } else if (opCode == 34) {
            op = ">>";
        }
        return op;
    }

    private static int decode(String s) {
        try {
            return Type.decode(s);
        }
        catch (SyntaxError e) {
            return -1;
        }
    }
}

