/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.lir.LirNode;
import coins.simd.LirUtil;
import coins.simd.Relation;
import coins.simd.SimdOptException;
import java.util.Enumeration;
import java.util.Vector;

public class DefTable {
    private Relation defTable = new Relation();
    private Vector singletons = new Vector();

    DefTable() {
    }

    public void add(LirNode e) throws SimdOptException {
        switch (e.opCode) {
            case 56: {
                LirNode[] referents;
                LirNode ekid;
                int i;
                for (i = 0; i < e.nKids(); ++i) {
                    ekid = e.kid(i);
                    if (ekid.opCode != 48) continue;
                    referents = LirUtil.pickupDefReferent(ekid.kid(0));
                    for (int j = 0; j < referents.length; ++j) {
                        this.defTable.add(referents[j], e);
                    }
                }
                for (i = 0; i < e.nKids(); ++i) {
                    ekid = e.kid(i);
                    if (ekid.opCode != 48 || (referents = LirUtil.pickupReferent(ekid)) == null || referents.length == 0) continue;
                    return;
                }
                this.singletons.addElement(e);
                break;
            }
            case 48: {
                LirNode[] referents = LirUtil.pickupDefReferent(e.kid(0));
                for (int i = 0; i < referents.length; ++i) {
                    this.defTable.add(referents[i], e);
                }
                LirNode[] refereds = LirUtil.pickupReferent(e);
                if (refereds != null && refereds.length != 0) break;
                this.singletons.addElement(e);
                break;
            }
            case 8: 
            case 46: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                break;
            }
        }
    }

    public Vector getLirs(LirNode e) {
        return this.defTable.getRelated(e);
    }

    public LirNode getReferent(LirNode e) throws SimdOptException {
        Vector referent = this.defTable.getRevRelated(e);
        if (referent.size() != 1) {
            throw new SimdOptException("Multiple referents");
        }
        return (LirNode)referent.elementAt(0);
    }

    public Enumeration getAllReferent() {
        return this.defTable.dom();
    }

    public Vector getSingletons() {
        return this.singletons;
    }
}

