/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.lir.LirNode;
import coins.simd.DefTable;
import coins.simd.LirMemUtil;
import coins.simd.Relation;
import coins.simd.SimdOptException;
import coins.simd.UseTable;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class LirDefUseRel {
    private DefTable defTable = new DefTable();
    private UseTable useTable = new UseTable();
    private Relation defuseRel;

    public void mkDefUseRel(Vector lirs) throws SimdOptException {
        for (int i = 0; i < lirs.size(); ++i) {
            this.decompose((LirNode)lirs.elementAt(i));
        }
        this.build(lirs);
    }

    public Relation getRelation() {
        return this.defuseRel;
    }

    public void add(LirNode e1, LirNode e2) throws SimdOptException {
        this.defuseRel.add(e1, e2);
    }

    public void decompose(LirNode e) throws SimdOptException {
        this.defTable.add(e);
        this.useTable.add(e);
    }

    public void build(Vector lirs) throws SimdOptException {
        this.defuseRel = new Relation();
        this.mkDefUseForMem(lirs);
        Enumeration keys = this.defTable.getAllReferent();
        while (keys.hasMoreElements()) {
            LirNode k = (LirNode)keys.nextElement();
            if (k.opCode == 47) continue;
            Vector refered = this.defTable.getLirs(k);
            Vector refs = this.useTable.getLirs(k);
            this.defuseRel.append(refered, refs);
        }
    }

    public Vector getDefLirs(LirNode e) {
        if (e.opCode == 6) {
            return this.defTable.getLirs(e);
        }
        return null;
    }

    public Vector getUseLirs(LirNode e) {
        if (e.opCode == 6) {
            return this.useTable.getLirs(e);
        }
        return null;
    }

    public Vector getParents(LirNode e) {
        return this.defuseRel.getRevRelated(e);
    }

    public Vector getChildren(LirNode e) {
        return this.defuseRel.getRelated(e);
    }

    public void getRoots(List ls) {
        Vector singletons = this.defTable.getSingletons();
        for (int i = 0; i < singletons.size(); ++i) {
            ls.add(singletons.elementAt(i));
        }
        Enumeration dr = this.defTable.getAllReferent();
        while (dr.hasMoreElements()) {
            Object obj = dr.nextElement();
            if (!(obj instanceof LirNode)) continue;
            LirNode referent = (LirNode)obj;
            Vector v = this.defTable.getLirs(referent);
            for (int i = 0; i < v.size(); ++i) {
                LirNode e = (LirNode)v.elementAt(i);
                if (!this.isRoot(e) || ls.contains(e)) continue;
                ls.add(e);
            }
        }
    }

    private boolean isRoot(LirNode e) {
        Vector defs = this.defuseRel.getRevRelated(e);
        return defs == null || defs.size() == 0;
    }

    private void mkDefUseForMem(Vector lirs) throws SimdOptException {
        for (int i = 0; i < lirs.size(); ++i) {
            LirNode mem;
            LirNode inst = (LirNode)lirs.elementAt(i);
            if (!LirMemUtil.hasMemDef(inst) || (mem = LirMemUtil.getMemName(inst)) == null) continue;
            Vector use = new Vector();
            LirMemUtil.findMemUse(lirs, i + 1, mem, use);
            if (use.size() == 0) continue;
            Vector<LirNode> def = new Vector<LirNode>();
            def.addElement(inst);
            this.defuseRel.append(def, use);
        }
    }
}

