/*
 * Decompiled with CFR 0.152.
 */
package coins.simd;

import coins.backend.Type;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.simd.SimdOptException;
import java.util.Vector;

public class LirUtil {
    public static int typeNum(int typ) {
        String s = Type.toString(typ);
        String t = s.substring(1);
        return Integer.parseInt(t);
    }

    public static String typeKind(int typ) {
        String s = Type.toString(typ);
        return s.substring(0, 1);
    }

    public static Symbol basesymbol(LirNode exp) {
        if (exp.opCode == 47) {
            return LirUtil.basesymbolIn(exp.kid(0));
        }
        return null;
    }

    private static Symbol basesymbolIn(LirNode exp) {
        switch (exp.opCode) {
            case 4: 
            case 5: 
            case 6: {
                return ((LirSymRef)exp).symbol;
            }
            case 10: {
                if (exp.kid((int)1).opCode != 2) break;
                return LirUtil.basesymbolIn(exp.kid(0));
            }
        }
        return null;
    }

    public static long dispval(LirNode exp) {
        if (exp.opCode == 47) {
            return LirUtil.dispvalIn(exp.kid(0));
        }
        return 0L;
    }

    private static long dispvalIn(LirNode exp) {
        switch (exp.opCode) {
            case 2: {
                return ((LirIconst)exp).value;
            }
            case 10: {
                if (exp.kid((int)1).opCode == 2) {
                    return LirUtil.dispvalIn(exp.kid(1));
                }
                return 0L;
            }
        }
        return 0L;
    }

    public static long calcIncval(int type) {
        return (long)Type.bits(type) / 8L;
    }

    public static Vector imlistToVector(ImList xs) {
        Vector<Object> out = new Vector<Object>();
        while (!xs.atEnd()) {
            out.addElement(xs.elem());
            xs = xs.next();
        }
        return out;
    }

    public static int calcBoundary(int typ) {
        int boundary;
        switch (Type.bits(typ)) {
            case 8: {
                boundary = 1;
                break;
            }
            case 16: {
                boundary = 2;
                break;
            }
            case 32: {
                boundary = 4;
                break;
            }
            case 64: {
                boundary = 8;
                break;
            }
            case 128: {
                boundary = 16;
                break;
            }
            default: {
                boundary = 8;
            }
        }
        return boundary;
    }

    public static Vector btov(BiList b) {
        Vector<Object> v = new Vector<Object>();
        BiLink lk = b.first();
        while (!lk.atEnd()) {
            v.add(lk.elem());
            lk = lk.next();
        }
        return v;
    }

    public static BiList vtob(Vector v) {
        BiList b = new BiList();
        for (int i = 0; i < v.size(); ++i) {
            b.add(v.elementAt(i));
        }
        return b;
    }

    public static ImList btoim(BiList b) {
        ImList im = ImList.Empty;
        BiLink ln = b.first();
        while (!ln.atEnd()) {
            Object c = ln.elem();
            im = new ImList(c, im);
            ln = ln.next();
        }
        return im;
    }

    public static boolean contains(LirNode a, LirNode b) {
        if (a.equals(b)) {
            return true;
        }
        switch (a.opCode) {
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return false;
            }
        }
        for (int i = 0; i < a.nKids(); ++i) {
            if (!LirUtil.contains(a.kid(i), b)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUsed(LirNode a, LirNode b) {
        switch (b.opCode) {
            case 48: {
                return LirUtil.contains(b.kid(1), a);
            }
            case 56: {
                for (int i = 0; i < b.nKids(); ++i) {
                    if (!LirUtil.isUsed(a, b.kid(i))) continue;
                    return true;
                }
                return false;
            }
        }
        for (int i = 0; i < b.nKids(); ++i) {
            if (!LirUtil.contains(b.kid(i), a)) continue;
            return true;
        }
        return false;
    }

    public static LirNode[] pickupDefReferent(LirNode e) throws SimdOptException {
        Vector v = new Vector();
        LirUtil.pickupDefReferent(e, v);
        LirNode[] out = new LirNode[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            out[i] = (LirNode)v.elementAt(i);
        }
        return out;
    }

    public static void pickupDefReferent(LirNode e, Vector v) throws SimdOptException {
        switch (e.opCode) {
            case 6: 
            case 47: {
                v.addElement(e);
                break;
            }
            case 48: 
            case 56: 
            case 57: 
            case 58: {
                throw new SimdOptException("Unexpected operator");
            }
        }
    }

    public static LirNode[] pickupUseReferent(LirNode e) throws SimdOptException {
        Vector v = new Vector();
        LirUtil.pickupReferent(e, v);
        if (e.opCode == 47) {
            v.remove(e);
        }
        LirNode[] out = new LirNode[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            out[i] = (LirNode)v.elementAt(i);
        }
        return out;
    }

    public static LirNode[] pickupReferent(LirNode e) throws SimdOptException {
        Vector v = new Vector();
        LirUtil.pickupReferent(e, v);
        LirNode[] out = new LirNode[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            out[i] = (LirNode)v.elementAt(i);
        }
        return out;
    }

    public static void pickupReferent(LirNode e, Vector v) throws SimdOptException {
        switch (e.opCode) {
            case 2: 
            case 3: {
                break;
            }
            case 6: {
                v.addElement(e);
                break;
            }
            case 47: {
                v.addElement(e);
                for (int i = 0; i < e.nKids(); ++i) {
                    LirUtil.pickupReferent(e.kid(i), v);
                }
                break;
            }
            case 4: {
                break;
            }
            case 7: 
            case 57: 
            case 58: {
                throw new SimdOptException("Unexpected operator");
            }
            case 48: {
                LirUtil.pickupReferent(e.kid(1), v);
                LirUtil.pickupReferent(e.kid(0), v);
                break;
            }
            default: {
                for (int i = 0; i < e.nKids(); ++i) {
                    LirUtil.pickupReferent(e.kid(i), v);
                }
            }
        }
    }

    public static LirNode operator(LirFactory factory, int c, int t, LirNode[] srcs, ImList opt) {
        int size = srcs.length;
        if (size == 0) {
            throw new IllegalArgumentException("No children.");
        }
        if (size == 1) {
            return factory.operator(c, t, srcs[0], opt);
        }
        if (size == 2) {
            return factory.operator(c, t, srcs[0], srcs[1], opt);
        }
        return factory.operator(c, t, srcs, opt);
    }

    public static boolean isShiftOp(LirNode e) {
        return e.opCode == 31 || e.opCode == 32 || e.opCode == 33 || e.opCode == 34;
    }
}

