/*
 * Decompiled with CFR 0.152.
 */
package coins.snapshot;

import coins.FlowRoot;
import coins.HirRoot;
import coins.PassException;
import coins.aflow.Flow;
import coins.aflow.FlowResults;
import coins.aflow.RegisterFlowAnalClasses;
import coins.aflow.SubpFlow;
import coins.backend.Function;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.ir.hir.SubpDefinition;
import coins.mdf.MacroFlowGraph;
import coins.snapshot.DisplayNames;
import coins.snapshot.GraphTag;

class FunctionTag {
    private BiList graphs;
    private final int lineNumber;
    private final String functionName;

    FunctionTag(Function f) {
        this.lineNumber = f.sourceLineNo;
        this.functionName = f.symbol.name;
        this.graphs = new BiList();
        this.graphs.add(new GraphTag(DisplayNames.CFG, f.flowGraph()));
        this.graphs.add(new GraphTag(DisplayNames.DOMTREE, f.flowGraph()));
        this.graphs.add(new GraphTag(DisplayNames.PDOMTREE, f.flowGraph()));
    }

    FunctionTag(MacroFlowGraph mfg) throws PassException {
        this.lineNumber = mfg.subpDef.getHirBody().getLineNumber();
        this.functionName = mfg.subpDef.getSubpSym().getName();
        this.graphs = new BiList();
        this.graphs.add(new GraphTag(DisplayNames.MFG, mfg));
    }

    FunctionTag(HirRoot hirRoot, SubpDefinition subpDef) {
        this.lineNumber = subpDef.getHirBody().getLineNumber();
        this.functionName = subpDef.getSubpSym().getName();
        this.graphs = new BiList();
        FlowResults.putRegClasses(new RegisterFlowAnalClasses());
        FlowRoot flowRoot = hirRoot.getFlowRoot();
        if (flowRoot == null) {
            flowRoot = new FlowRoot(hirRoot);
        }
        Flow flow = flowRoot.aflow;
        FlowResults results = new FlowResults(flowRoot);
        SubpFlow subpFlow = flow.subpFlow(subpDef, results);
        flowRoot.aflow.setSubpFlow(subpFlow);
        subpFlow.controlFlowAnal();
        subpFlow.makeDominatorTree();
        subpFlow.makePostdominatorTree();
        this.graphs.add(new GraphTag(DisplayNames.CFG, subpFlow));
        this.graphs.add(new GraphTag(DisplayNames.DOMTREE, subpFlow));
        this.graphs.add(new GraphTag(DisplayNames.PDOMTREE, subpFlow));
    }

    private String lineNumber() {
        return "\"" + this.lineNumber + "\"";
    }

    private String functionName() {
        return "\"" + this.functionName + "\"";
    }

    public String toString(int space) {
        String ws = "";
        for (int i = 0; i < space; ++i) {
            ws = ws + "  ";
        }
        String str = "";
        str = str + ws + "<" + "function" + " " + "name" + "=" + this.functionName();
        str = str + " line=" + this.lineNumber() + ">\n";
        BiLink p = this.graphs.first();
        while (!p.atEnd()) {
            GraphTag gTag = (GraphTag)p.elem();
            str = str + gTag.toString(space + 1);
            p = p.next();
        }
        str = str + ws + "</" + "function" + ">\n";
        return str;
    }

    public String toString() {
        return this.toString(0);
    }
}

