/*
 * Decompiled with CFR 0.152.
 */
package coins.snapshot;

import coins.aflow.BBlock;
import coins.aflow.FlowAnalSymVector;
import coins.backend.ana.ControlDependences;
import coins.backend.ana.DominanceFrontiers;
import coins.backend.ana.Dominators;
import coins.backend.ana.LiveVariableAnalysis;
import coins.backend.ana.LiveVariableSlotwise;
import coins.backend.ana.Postdominators;
import coins.backend.cfg.BasicBlk;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.mdf.MacroTask;
import coins.snapshot.DisplayNames;
import coins.snapshot.LabelType;
import coins.snapshot.StringType;
import coins.sym.Sym;
import java.util.Iterator;
import java.util.List;

class InfoTag {
    private BiList labelList = new BiList();
    private BiList stringList = new BiList();

    InfoTag(BasicBlk blk) {
        StringType sType;
        LabelType lType = this.successor(blk);
        if (lType != null) {
            this.labelList.add(lType);
        }
        if ((lType = this.predecessor(blk)) != null) {
            this.labelList.add(lType);
        }
        if ((lType = this.dominator(blk)) != null) {
            this.labelList.add(lType);
        }
        if ((lType = this.dominatedChildren(blk)) != null) {
            this.labelList.add(lType);
        }
        if ((lType = this.dominanceFrontier(blk)) != null) {
            this.labelList.add(lType);
        }
        if ((lType = this.postdominator(blk)) != null) {
            this.labelList.add(lType);
        }
        if ((lType = this.postdominatedChildren(blk)) != null) {
            this.labelList.add(lType);
        }
        if ((lType = this.postdominanceFrontier(blk)) != null) {
            this.labelList.add(lType);
        }
        if ((sType = this.liveIn(blk)) != null) {
            this.stringList.add(sType);
        }
        if ((sType = this.liveOut(blk)) != null) {
            this.stringList.add(sType);
        }
    }

    InfoTag(BBlock blk) {
        StringType sType;
        LabelType lType = this.successor(blk);
        if (lType != null) {
            this.labelList.add(lType);
        }
        if ((lType = this.predecessor(blk)) != null) {
            this.labelList.add(lType);
        }
        if ((lType = this.dominator(blk)) != null) {
            this.labelList.add(lType);
        }
        if ((lType = this.dominatedChildren(blk)) != null) {
            this.labelList.add(lType);
        }
        if ((lType = this.postdominator(blk)) != null) {
            this.labelList.add(lType);
        }
        if ((lType = this.postdominatedChildren(blk)) != null) {
            this.labelList.add(lType);
        }
        if ((sType = this.liveIn(blk)) != null) {
            this.stringList.add(sType);
        }
        if ((sType = this.liveOut(blk)) != null) {
            this.stringList.add(sType);
        }
    }

    InfoTag(MacroTask mt) {
    }

    private LabelType successor(BasicBlk blk) {
        if (blk.succList().length() == 0) {
            return null;
        }
        return new LabelType(DisplayNames.SUCC, blk.succList());
    }

    private LabelType successor(BBlock blk) {
        if (blk.getSuccList().size() == 0) {
            return null;
        }
        BiList tmp = new BiList();
        Iterator ite = blk.getSuccList().iterator();
        while (ite.hasNext()) {
            tmp.add(ite.next());
        }
        return new LabelType(DisplayNames.SUCC, tmp);
    }

    private LabelType predecessor(BasicBlk blk) {
        if (blk.predList().length() == 0) {
            return null;
        }
        return new LabelType(DisplayNames.PRED, blk.predList());
    }

    private LabelType predecessor(BBlock blk) {
        if (blk.getPredList().size() == 0) {
            return null;
        }
        BiList tmp = new BiList();
        Iterator ite = blk.getPredList().iterator();
        while (ite.hasNext()) {
            tmp.add(ite.next());
        }
        return new LabelType(DisplayNames.PRED, tmp);
    }

    private LabelType dominator(BasicBlk blk) {
        Dominators dom = (Dominators)blk.flowGraph.function.require(Dominators.analyzer);
        if (dom.idom[blk.id] == null) {
            return null;
        }
        BiList tmp = new BiList();
        tmp.add(dom.idom[blk.id]);
        return new LabelType(DisplayNames.DOM, tmp);
    }

    private LabelType dominator(BBlock blk) {
        BBlock dom = blk.getImmediateDominatorForSubpFlow();
        if (dom == null) {
            return null;
        }
        BiList tmp = new BiList();
        tmp.add(dom);
        return new LabelType(DisplayNames.DOM, tmp);
    }

    private LabelType dominatedChildren(BasicBlk blk) {
        Dominators dom = (Dominators)blk.flowGraph.function.require(Dominators.analyzer);
        if (dom.kids[blk.id] == null) {
            return null;
        }
        if (dom.kids[blk.id].length() == 0) {
            return null;
        }
        return new LabelType(DisplayNames.DCHILD, dom.kids[blk.id]);
    }

    private LabelType dominatedChildren(BBlock blk) {
        List dchild = blk.getDominatedChildrenForSubpFlow();
        if (dchild == null) {
            return null;
        }
        if (dchild.size() == 0) {
            return null;
        }
        BiList tmp = new BiList();
        Iterator ite = dchild.iterator();
        while (ite.hasNext()) {
            tmp.add(ite.next());
        }
        return new LabelType(DisplayNames.DCHILD, tmp);
    }

    private LabelType postdominator(BasicBlk blk) {
        Postdominators pdom = (Postdominators)blk.flowGraph.function.require(Postdominators.analyzer);
        if (pdom.idom[blk.id] == null) {
            return null;
        }
        BiList tmp = new BiList();
        tmp.add(pdom.idom[blk.id]);
        return new LabelType(DisplayNames.PDOM, tmp);
    }

    private LabelType postdominator(BBlock blk) {
        BBlock pdom = blk.getImmediatePostdominatorForSubpFlow();
        if (pdom == null) {
            return null;
        }
        BiList tmp = new BiList();
        tmp.add(pdom);
        return new LabelType(DisplayNames.PDOM, tmp);
    }

    private LabelType postdominatedChildren(BasicBlk blk) {
        Postdominators pdom = (Postdominators)blk.flowGraph.function.require(Postdominators.analyzer);
        if (pdom.kids[blk.id] == null) {
            return null;
        }
        if (pdom.kids[blk.id].length() == 0) {
            return null;
        }
        return new LabelType(DisplayNames.PDCHILD, pdom.kids[blk.id]);
    }

    private LabelType postdominatedChildren(BBlock blk) {
        List pdchild = blk.getPostdominatedChildrenForSubpFlow();
        if (pdchild == null) {
            return null;
        }
        if (pdchild.size() == 0) {
            return null;
        }
        BiList tmp = new BiList();
        Iterator ite = pdchild.iterator();
        while (ite.hasNext()) {
            tmp.add(ite.next());
        }
        return new LabelType(DisplayNames.PDCHILD, tmp);
    }

    private LabelType dominanceFrontier(BasicBlk blk) {
        DominanceFrontiers df = (DominanceFrontiers)blk.flowGraph.function.require(DominanceFrontiers.analyzer);
        if (df.frontiers[blk.id] == null) {
            return null;
        }
        if (df.frontiers[blk.id].length() == 0) {
            return null;
        }
        return new LabelType(DisplayNames.DF, df.frontiers[blk.id]);
    }

    private LabelType postdominanceFrontier(BasicBlk blk) {
        ControlDependences cdep = (ControlDependences)blk.flowGraph.function.require(ControlDependences.analyzer);
        if (cdep.frontiers[blk.id] == null) {
            return null;
        }
        if (cdep.frontiers[blk.id].length() == 0) {
            return null;
        }
        return new LabelType(DisplayNames.CDEP, cdep.frontiers[blk.id]);
    }

    private StringType liveIn(BasicBlk blk) {
        LiveVariableAnalysis live = (LiveVariableAnalysis)blk.flowGraph.function.require(LiveVariableSlotwise.analyzer);
        BiList tmp = live.liveIn(blk);
        if (tmp.length() == 0) {
            return null;
        }
        BiList in = new BiList();
        BiLink p = tmp.first();
        while (!p.atEnd()) {
            Symbol s = (Symbol)p.elem();
            in.add(s.name);
            p = p.next();
        }
        return new StringType(DisplayNames.LIVEIN, in);
    }

    private StringType liveIn(BBlock blk) {
        FlowAnalSymVector live = blk.getPLiveIn();
        if (live.isZero()) {
            return null;
        }
        BiList tmp = new BiList();
        Iterator ite = live.flowAnalSyms().iterator();
        while (ite.hasNext()) {
            tmp.add(((Sym)ite.next()).getName());
        }
        return new StringType(DisplayNames.LIVEIN, tmp);
    }

    private StringType liveOut(BasicBlk blk) {
        LiveVariableAnalysis live = (LiveVariableAnalysis)blk.flowGraph.function.require(LiveVariableSlotwise.analyzer);
        BiList tmp = live.liveOut(blk);
        if (tmp.length() == 0) {
            return null;
        }
        BiList in = new BiList();
        BiLink p = tmp.first();
        while (!p.atEnd()) {
            Symbol s = (Symbol)p.elem();
            in.add(s.name);
            p = p.next();
        }
        return new StringType(DisplayNames.LIVEOUT, in);
    }

    private StringType liveOut(BBlock blk) {
        FlowAnalSymVector live = blk.getPLiveOut();
        if (live.isZero()) {
            return null;
        }
        BiList tmp = new BiList();
        Iterator ite = live.flowAnalSyms().iterator();
        while (ite.hasNext()) {
            tmp.add(((Sym)ite.next()).getName());
        }
        return new StringType(DisplayNames.LIVEOUT, tmp);
    }

    public String toString(int space) {
        String ws1 = "";
        for (int i = 0; i < space + 1; ++i) {
            ws1 = ws1 + "  ";
        }
        String ws = "";
        for (int i = 0; i < space; ++i) {
            ws = ws + "  ";
        }
        String str = ws + "<" + "info" + ">\n";
        BiLink p = this.labelList.first();
        while (!p.atEnd()) {
            LabelType lType = (LabelType)p.elem();
            str = str + ws1 + "<" + "labelList" + " " + "displayName" + "=";
            str = str + lType.displayName() + ">\n";
            str = str + lType.toString(space + 2);
            str = str + ws1 + "</" + "labelList" + ">\n";
            p = p.next();
        }
        p = this.stringList.first();
        while (!p.atEnd()) {
            StringType sType = (StringType)p.elem();
            str = str + ws1 + "<" + "stringList" + " " + "displayName" + "=";
            str = str + sType.displayName() + ">\n";
            str = str + sType.toString(space + 2);
            str = str + ws1 + "</" + "stringList" + ">\n";
            p = p.next();
        }
        str = str + ws + "</" + "info" + ">\n";
        return str;
    }

    public String toString() {
        return this.toString(0);
    }
}

